# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: SiSU information Structuring Universe, command line options
    parsing

=end
module SiSU_commandline
  require "pathname"
  require_relative 'sysenv'                             # sysenv.rb
  @@base_path=nil
  class Options
    attr_accessor :cmd,:mod,:act,:dir_structure_by,:f_pths,:files,:base_path,:base_stub,:sub_location,:paths,:lngs,:f_pth,:pth,:fns,:fnb,:fnc,:fncb,:lng,:lng_base,:what
    def initialize(a)
      @cmd,@f_pth,@pth,@fns,@fnb,@fnc,@fncb,@what,@lng,@lng_base,@base_path,@base_stub,@sub_location='','','','','','','','','','','','',''
      @f_pths,@files,@paths,@mod,@act=Array.new(5){[]}
      @env=SiSU_Env::Info_env.new
      @lng_base=@env.language_default_set
      @dir_structure_by=SiSU_Env::Env_call.new.output_dir_structure.by?
      @@base_path ||=Dir.pwd
      @base_path=@@base_path
      r=Px[:lng_lst].join('|')
      u=/.+?\/([^\/]+)(?:\/(?:#{r})$|$)/
      @base_stub=@base_path.gsub(u,'\1')
      @a=sisu_glob_rules(a)
      @a.freeze
      init
    end
    def find_all(find_flag,opt)
      if find_flag
        pwd_set=Dir.pwd
        x=Dir.glob('*.ss[tm]')
        Px[:lng_lst].each do |d|
          if FileTest.directory?(d)
            x << Dir.glob("#{d}/*.ss[tm]")
          end
        end
        opt + x.flatten!
      end
    end
    def find_select(find_flag,opt)
      if find_flag
        pwd_set=Dir.pwd
        x=[]
        if opt.inspect =~/"[a-zA-Z][a-zA-Z0-9._-]+?"/
          opt.each do |g|
            x <<=if g =~/.ss[tm]/
              Dir.glob("*#{g}")
            else
              Dir.glob("*#{g}*.ss[tm]")
            end
            Px[:lng_lst].each do |d|
              if FileTest.directory?(d)
                x <<=if g =~/.ss[tm]/
                  Dir.glob("#{d}/*#{g}")
                else
                  Dir.glob("#{d}/*#{g}*.ss[tm]")
                end
              end
            end
          end
        end
        x.flatten!
     end
    end
    def sisu_glob_rules(a)
      a=if a.inspect =~/"-[A-Za-z0-9]*[fG]/ \
      or a.inspect =~/"--find"|"--glob"/
        b,f=[],[]
        find_flag=false
        a.each do |y|
          if y =~ /^-/
            if y =~/^-/ \
            && y =~/[fG]|--find|--glob/
              find_flag=true
            end
            b << y
          end
          if find_flag \
          && y !~ /^-/ \
          && y =~ /\S+/
            if y !~/\//
              f << y
            else
              find_flag=false
              puts %{sub-directories "#{y}" cannot be provided for --find or --glob at this time}
            end
          end
        end
        r=Px[:lng_lst].join('|')
        r.gsub!(/\|#{@lng_base}\|/,'|')
        @lang_regx=%r{(?:#{r})}
        z=if find_flag
          (f.length > 0) \
          ? (b + find_select(find_flag,f))
          : find_all(find_flag,b)
        elsif a.inspect =~/"(?:-\S+?|--\S+?)"/ \
        && a.inspect =~/"#{@lang_regx}\/?"/ \
        && a.inspect =~/"#{@lng_base}\/\S+?\.ss[tm]"/
          init_selected_lang_dirs(a)
        else b
        end
      else a
      end
    end
    def init_selected_lang_dirs(a)
      @z=[]
      a.each do |y|
        if y =~/^#{@lng_base}\/(\S+?\.ss[tm])$/
          @fn=$1
          @z << y
        elsif y =~/^#{@lang_regx}\/?$/
          @z << "#{y}/#{@fn}"
        else @z << y
        end
      end
      @z
    end
    def init
      a=@a
      if a.length > 0
        s=expand_numeric_shortcuts(a)
        q=set_files_and_paths_and_general_extract(s)
        @cmd,@mod=opt_cmd_and_mod_adjust(q[:cmd],q[:mod])
        @what=q[:what] unless q[:what].empty?
        @paths = q[:paths]
        @files = q[:files]
        @f_pths = q[:f_pths]
        @lngs = q[:lngs]
        if @files.length > 0 \
        and @cmd.empty? \
        and @mod.length==0 #% if no other action called on filename given, default is sisu --v3 -0 [filename(s)] configured as flag default
          shortcut=SiSU_Env::Info_processing_flag.new
          @mod=['--v3']
          @cmd=shortcut.cf_0 + 'm'
        end
        SiSU_Screen::Ansi.new(@cmd,"\tsisu " + @cmd +  ' ' + @mod.join(' ') + ' ' + @files.join(' ') + "\n").print_brown if @cmd =~/[vVM]/
      end
#     @files.uniq!
      @act=opt_act
      @files
      self
    end
    def set_files_and_paths_and_general_extract(s)
      c,w='',''
      m,f,pth,z,lng,lngs=[],[],[],[],[],[]
      a=s.split(/\s+/)
      r_l=Px[:lng_lst].join('|')
      a.uniq.each do |x|
        if x =~/^-[a-z0-5]+/i \
        or x =~/^--\S+/
          if x =~/^-([a-z0-5]+)/i
            c << $1
          end
          if x =~/^--\S+/
            m << x
          end
        elsif x =~ /(?:\.(?:(?:-|ssm\.)?sst(?:\.xml)?|ssm|ssi|sx[sdn]\.xml|s[1-3]|kdi|ssp)|\S+?\.ss[mt]\.(?:txz|zip)|sisupod\.(?:txz|zip))$/
          if x =~/^(?:https?|file):\/\/\S+/ \
          and x =~/\S+?\.ss[mt]$/
            r_url=/(http:\/\/\S+?\/\S+?\/src(?:\/(?:#{r_l}))?)\//
            url_base = (x[r_url,1])
            url = x
            y=x.gsub(/http:\/\/\S+?\/\S+?\/src\//,'')
            t=/(#{r_l})\/[^\/]+?\.ss[tm]$/
            l_p = (y[t,1]) \
              ? y[t,1]
              : nil
            lng << l_p
            lngs << if l_p
              l_p
            elsif x =~/~(#{r_l})\.ss[tm]/
              $1
            else lng_base
            end
            r_f=/(?:#{r_l})\/([^\/]+?\.ss[tm])$/
            fn = (y[r_f,1]) \
              ? y[r_f,1]
              : y
            fn.gsub!(/\.((?:ssm\.)?sst)/,'.-\1')
            fullname=Dir.pwd + '/' + fn
            pt=Pathname.new(fullname)
            pth << Dir.pwd
            r_u=/.+?\/([^\/]+)(?:\/(?:#{r_l})$|$)/
            lng_is =if l_p
              l_p
            elsif x =~/~(#{r_l})\.ss[tm]/
              $1
            else lng_base
            end
            f_pths << {
              pth: pt.split[0].realpath.to_s,
              f: pt.split[1].to_s,
              pth_stub: pt.split[0].realpath.to_s[r_u,1],
              lng: (pt.split[0].realpath.to_s[t,1]) \
                ? pt.split[0].realpath.to_s[t,1]
                : nil,
              lng_is: lng_is,
              url_base: url_base,
              url: url
            }
            f << fn
          elsif x =~/^(?:https?|file):\/\/\S+/ \
          and x =~/\S+?\.ss[mt]\.(?:txz|zip)|sisupod\.(?:txz|zip)/
            x=x.gsub(/^file:\/\//,'')
            f << x
          elsif FileTest.file?(x)
### FIX
            pt=Pathname.new(x)
            pth << pt.split[0].realpath.to_s     #remove?
            f << pt.split[1].to_s                #remove?
            r_u=/.+?\/([^\/]+)(?:\/(?:#{r_l})$|$)/
            t=/.+\/(#{r_l})$/
            l_p = (pt.split[0].realpath.to_s[t,1]) \
              ? pt.split[0].realpath.to_s[t,1]
              : nil
            lng << l_p
            lngs << if l_p
              l_p
            elsif x =~/~(#{r_l})\.ss[tm]/
              $1
            else lng_base
            end
            lng_is =if l_p
              l_p
            elsif x =~/~(#{r_l})\.ss[tm]/
              $1
            else lng_base
            end
            f_pths << {
              pth: pt.split[0].realpath.to_s,
              f: pt.split[1].to_s,
              pth_stub: pt.split[0].realpath.to_s[r_u,1],
              lng: (pt.split[0].realpath.to_s[t,1]) \
                ? pt.split[0].realpath.to_s[t,1]
                : nil,
              lng_is: lng_is,
              url_base: nil,
              url: nil
            }
#           Dir.chdir(pt.split[0].realpath)
          else  puts "file not found: #{x}"
          end
        elsif x =~ /\.termsheet\.rb$/
          if FileTest.file?(x); f << x
          else  puts "file not found: #{x}"
          end
        else w=x
          puts "#{x} in #{a.join(' ')}?"
        end
      end
      { cmd: c, mod: m, what: w, paths: pth, files: f, f_pths: f_pths, lng: lng, lngs: lngs }
    end
    def expand_numeric_shortcuts(a)
      shortcut=SiSU_Env::Info_processing_flag.new
      s=''
      a.each do |x|
        y=case x
        when /0/
          (x=~/^-1\S+/) \
          ? x.gsub(/^-0(\S+)/,shortcut.cf_0 + ' -\1')
          : x.gsub(/^-0/,shortcut.cf_0 + ' ')
        when /1/
          (x=~/^-1\S+/) \
          ? x.gsub(/^-1(\S+)/,shortcut.cf_1 + ' -\1')
          : x.gsub(/^-1/,shortcut.cf_1 + ' ')
        when /2/
          (x=~/^-2\S+/) \
          ? x.gsub(/^-2(\S+)/,shortcut.cf_2 + ' -\1')
          : x.gsub(/^-2/,shortcut.cf_2 + ' ')
        when /3/
          (x=~/^-3\S+/) \
          ? x.gsub(/^-3(\S+)/,shortcut.cf_3 + ' -\1')
          : x.gsub(/^-3/,shortcut.cf_3 + ' ')
        when /4/
          (x=~/^-4\S+/) \
          ? x.gsub(/^-4(\S+)/,shortcut.cf_4 + ' -\1')
          : x.gsub(/^-4/,shortcut.cf_4 + ' ')
        when /5/
          (x=~/^-5\S+/) \
          ? x.gsub(/^-5(\S+)/,shortcut.cf_5 + ' -\1')
          : x.gsub(/^-5/,shortcut.cf_5 + ' ')
        when /6/
          (x=~/^-6\S+/) \
          ? x.gsub(/^-6(\S+)/,shortcut.cf_5 + ' -\1')
          : x.gsub(/^-6/,shortcut.cf_5 + ' ')
        else x
        end
        s << " #{y}" unless y.empty?
      end
      s.strip!
    end
    def opt_cmd_and_mod_adjust(c,m)
      cmd,mod,files=@cmd,@mod,@files
      unless m.empty?
        m.each do |m|
          case m
          when /^--(?:color-toggle)$/;                       c=c+'c'
          when /^--(?:configure)$/;                          c=c+'CC'
          when /^--(?:dal?|machine|abstraction|abs)$/;       c=c+'m'
          when /^--(?:txt|text|plaintext)$/;                 c=c+'t'
          when /^--(?:html)$/;                               c=c+'h'
          when /^--(?:epub)$/;                               c=c+'e'
          when /^--(?:od[ft])$/;                             c=c+'o'
          when /^--(?:pdf)$/;                                c=c+'p'
          when /^--(?:concordance|wordmap)$/;                c=c+'w'
          when /^--(?:manpage)$/;                            c=c+'i'
          when /^--(?:texinfo)$/;                            c=c+'I'
          when /^--(?:xhtml)$/;                              c=c+'b'
          when /^--(?:xml-sax)$/;                            c=c+'x'
          when /^--(?:xml-dom)$/;                            c=c+'X'
          when /^--(?:hash-digests)$/;                       c=c+'N'
          when /^--(?:po4a|pot?)$/;                          c=c+'P'
          when /^--(?:termsheet)$/;                          c=c+'T'
          when /^--(?:manifest)$/;                           c=c+'y'
          when /^--(?:qrcode)$/;                             c=c+'Q'
          when /^--(?:sqlite)$/;                             c=c+'d'
          when /^--(?:pg|pg?sql|postgresql)$/;               c=c+'D'
          when /^--(?:remote|rsync)$/;                       c=c+'R'
          when /^--(?:scp)$/;                                c=c+'r'
          when /^--(?:source)$/;                             c=c+'s'
          when /^--(?:sisupod|pod)$/;                        c=c+'S'
          when /^--(?:git)$/;                                c=c+'g'
          when /^--(?:urls)$/;                               c=c+'U'
          when /^--(?:zap|delete)$/;                         c=c+'Z'
          when /^--(?:sample-search-form)$/;                 c=c+'F'
          when /^--(?:webserv|webrick)$/;                    c=c+'W'
          when /^--(?:maintenance|keep-processing-files)$/;  c=c+'M'
          when /^--(?:verbose[=-]3)$/;                       c=c+'VM'
          when /^--(?:verbose[=-]2|Verbose|VERBOSE)$/;       c=c+'V'
          when /^--(?:verbose(?:[=-]1)?)$/;                  c=c+'v'
          when /^--(?:verbose[=-]0|quiet|silent)$/;          c=c+'q'
          else mod << m                                     #mod only contains command modifiers; commands converted to character
          end
        end
      end
      ca=[]
      unless c.empty?
        c.gsub!(/-/,'')
        c.scan(/CC|\S/) {|x| ca << x}
        cmd= '-' + ca.uniq.join
      end
      extra=''
      if cmd !~/[mn]/
        extra+=if cmd =~/[abegHhIiNOoPpTtwXxyz]/ \
        and cmd !~/[mn]/
          'm'                        #% add dal
        elsif ((cmd =~/[Dd]/ \
        or (mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/)) \
        and mod.inspect !~/(?:remove|(?:(?:re)?create(?:all)?|dropall|drop)$)/) \
        and cmd !~/[mn]/
          'm'                                                                          #% add dal
        else ''
        end
      end
      if cmd !~/y/
        extra+=if cmd =~/[abeHhIiNopsSstwXxz]/ \
        and cmd !~/y/
          'ym'            #% add manifest
        elsif (cmd =~/[Dd]/ \
        or mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/) \
        and files[0] !~/^remove$/ \
        and cmd !~/y/
          'ym' #% add manifest
        else ''
        end
      end
      cmd=cmd + extra
      cmds=cmd.scan(/CC|\S/)
      [cmds.uniq.join,mod]
    end
    def opt_act #note mod line commands have already been converted to command characters, cmd
      cmd,mod=@cmd,@mod
      act={}
      act[:license]=(cmd =~/L/ \
      || mod.inspect =~/"--license/) \
      ? { bool: true }
      : { bool: false }
      act[:site_init]=(cmd =~/C/ \
      || mod.inspect =~/"--init-site/) \
      ? { bool: true }
      : { bool: false }
      act[:rc]=if mod.inspect =~/"--rc=/
        x=Dir.pwd + '/' + mod.join.gsub(/--rc=/,'')
        { bool: true, inst: x  }
      else
        { bool: false, inst: '' }
      end
      act[:verbose]=(cmd =~/v/ \
      || mod.inspect =~/"--verbose"/) \
      ? { bool: true }
      : { bool: false }
      act[:quiet]=(cmd =~/q/ \
      || mod.inspect =~/"--quiet"/) \
      ? { bool: true }
      : { bool: false }
      act[:color_state]=if mod.inspect =~/"--color-on"|"--color"/
        { bool: true }
      elsif mod.inspect =~/"--color-off"/
        { bool: false }
      else { bool: true } #fix default color
      end
#     act[:color_toggle]=if cmd =~/c/ \
#     or mod.inspect =~/"--color-toggle"/
#       true
#     else false
#     end
      act[:maintenance]=(cmd =~/M/ \
      || mod.inspect =~/"--maintenance|--keep-processing-files"/) \
      ? { bool: true }
      : { bool: false }
      act[:ocn]=if mod.inspect =~/"--no-ocn"/
         { bool: false }
      else { bool: true }
      end
      act[:dal]=(cmd =~/m/ \
      || mod.inspect =~/"--dal"/) \
      ? { bool: true }
      : { bool: false }
      act[:html]=(cmd =~/h/ \
      || mod.inspect =~/"--html"/) \
      ? { bool: true }
      : { bool: false }
      act[:concordance]=(cmd =~/w/ \
      || mod.inspect =~/"--concordance"/) \
      ? { bool: true }
      : { bool: false }
      act[:pdf]=(cmd =~/p/ \
      || mod.inspect =~/"--pdf"/) \
      ? { bool: true }
      : { bool: false }
      act[:epub]=(cmd =~/e/ \
      || mod.inspect =~/"--epub"/) \
      ? { bool: true }
      : { bool: false }
      act[:odt]=(cmd =~/o/ \
      || mod.inspect =~/"--odf"/) \
      ? { bool: true }
      : { bool: false }
      act[:xml_sax]=(cmd =~/x/ \
      || mod.inspect =~/"--xml-sax"/) \
      ? { bool: true }
      : { bool: false }
      act[:xml_dom]=(cmd =~/X/ \
      || mod.inspect =~/"--xml-dom"/) \
      ? { bool: true }
      : { bool: false }
      act[:xhtml]=(cmd =~/b/ \
      || mod.inspect =~/"--xhtml"/) \
      ? { bool: true }
      : { bool: false }
      act[:txt]=(cmd =~/[at]/ \
      || mod.inspect =~/"--txt"/) \
      ? { bool: true }
      : { bool: false }
      act[:manpage]=(cmd =~/i/ \
      || mod.inspect =~/"--manpage"/) \
      ? { bool: true }
      : { bool: false }
      act[:texinfo]=(cmd =~/I/ \
      || mod.inspect =~/"--texinfo"/) \
      ? { bool: true }
      : { bool: false }
      act[:fictionbook]=(cmd =~/f/ \
      || mod.inspect =~/"--fictionbook"/) \
      ? { bool: true }
      : { bool: false }
      act[:psql]=(cmd =~/D/ \
      || mod.inspect =~/"--pg"|"--pgsql"/) \
      ? { bool: true }
      : { bool: false }
      act[:sqlite]=(cmd =~/d/ \
      || mod.inspect =~/"--sqlite"/) \
      ? { bool: true }
      : { bool: false }
      act[:harvest]=(mod.inspect =~/"--harvest"/) \
      ? { bool: true }
      : { bool: false }
      act[:po4a]=(cmd =~/P/ \
      || mod.inspect =~/"--po4a"|"--pot?"/) \
      ? { bool: true }
      : { bool: false }
      act[:git]=(cmd =~/g/ \
      || mod.inspect =~/"--git"/) \
      ? { bool: true }
      : { bool: false }
      act[:hash_digests]=(cmd =~/N/ \
      || mod.inspect =~/"--hash-digests"/) \
      ? { bool: true }
      : { bool: false }
      act[:sample_search_form]=(cmd =~/F/ \
      || mod.inspect =~/"--sample-search-form"/) \
      ? { bool: true }
      : { bool: false }
      act[:webrick]=(cmd =~/W/ \
      || mod.inspect =~/"--webrick"/) \
      ? { bool: true }
      : { bool: false }
      act[:share_source]=(cmd =~/s/ \
      || mod.inspect =~/"--source"/) \
      ? { bool: true }
      : { bool: false }
      act[:sisupod]=(cmd =~/S/ \
      || mod.inspect =~/"--sisupod"/) \
      ? { bool: true }
      : { bool: false }
      act[:scp]=(cmd =~/r/ \
      || mod.inspect =~/"--scp"/) \
      ? { bool: true }
      : { bool: false }
      act[:rsync]=(cmd =~/R/ \
      || mod.inspect =~/"--rsync"/) \
      ? { bool: true }
      : { bool: false }
      act[:delete_output]=(cmd =~/z/ \
      || mod.inspect =~/"--delete"|"--zap"/) \
      ? { bool: true }
      : { bool: false }
      act[:urls_all]=(cmd =~/U/ \
      || mod.inspect =~/"--urls-all"/) \
      ? { bool: true }
      : { bool: false }
      act[:urls_seleted]=(cmd =~/u/ \
      || mod.inspect =~/"--urls"/) \
      ? { bool: true }
      : { bool: false }
      act[:sitemap]=(cmd =~/Y/ \
      || mod.inspect =~/"--sitemap"/) \
      ? { bool: true }
      : { bool: false }
      act[:qrcode]=(cmd =~/Q/ \
      || mod.inspect =~/"--qrcode"/) \
      ? { bool: true }
      : { bool: false }
      act[:manifest]=(cmd =~/y/ \
      || mod.inspect =~/"--manifest"/) \
      ? { bool: true }
      : { bool: false }
      act[:help]=(mod.inspect =~/"--help/) \
      ? { bool: true }
      : { bool: false }
      @act=act
    end
    def cmd
      @cmd
    end
    def mod
      @mod
    end
    def act
      @act
    end
    def f_pth
      @f_pth
    end
    def pth
      @pth
    end
    def sub_location
      pth.gsub(/#{base_path}/,'')
    end
    def lng
      @lng
    end
    def lng_base
      @lng_base
    end
    def fns
      @fns
    end
    def what
      @what
    end
    def fnb
      unless fns.empty?
        fns[/(.+?)\.(?:(?:-|ssm\.)?sst|ssm)$/,1]
      end
    end
    def fnc
      @fnc=if @fns =~/\.(?:ssm\.sst|ssm)$/; fnb + '.ssm.sst'
      else @fns
      end
    end
    def fncb
      @fncb=if @fns =~/(?:\~\S{2,3})?\.(?:ssm\.sst|ssm)$/; fnb + '.ssm.sst'
      else @fns.gsub(/(?:\~\S{2,3})?(\.sst)$/,'\1')
      end
    end
  end
end
__END__
note usually named @opt
is carried in Param usually as @md
@opt is a subset of @md
where @md is passed, contents of @opt are available
passing @opt as well is duplication
check for fns & fnb
