# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: internationalisation

=end
module SiSU_i18n
  @@language_table,@@language_list=nil,nil
  class Languages
    def language
      def table
        @@language_table ||= {
          am:    { c: 'am',    n: 'Amharic',           t: 'Amharic',                     xlp: 'amharic'          },
          bg:    { c: 'bg',    n: 'Bulgarian',         t: 'Български (Bəlgarski)',       xlp: 'bulgarian'        },
          bn:    { c: 'bn',    n: 'Bengali',           t: 'Bengali',                     xlp: 'bengali'          },
          br:    { c: 'br',    n: 'Breton',            t: 'Breton',                      xlp: 'breton'           },
          ca:    { c: 'ca',    n: 'Catalan',           t: 'catalan',                     xlp: 'catalan'          },
          cs:    { c: 'cs',    n: 'Czech',             t: 'česky',                       xlp: 'czech'            },
          cy:    { c: 'cy',    n: 'Welsh',             t: 'Welsh',                       xlp: 'welsh'            },
          da:    { c: 'da',    n: 'Danish',            t: 'dansk',                       xlp: 'danish'           },
          de:    { c: 'de',    n: 'German',            t: 'Deutsch',                     xlp: 'german'           },
          el:    { c: 'el',    n: 'Greek',             t: 'Ελληνικά (Ellinika)',         xlp: 'greek'            },
          en:    { c: 'en',    n: 'English',           t: 'English',                     xlp: 'english'          },
          eo:    { c: 'eo',    n: 'Esperanto',         t: 'Esperanto',                   xlp: 'esperanto'        },
          es:    { c: 'es',    n: 'Spanish',           t: 'español',                     xlp: 'spanish'          },
          et:    { c: 'et',    n: 'Estonian',          t: 'Estonian',                    xlp: 'estonian'         },
          eu:    { c: 'eu',    n: 'Basque',            t: 'basque',                      xlp: 'basque'           },
          fi:    { c: 'fi',    n: 'Finnish',           t: 'suomi',                       xlp: 'finnish'          },
          fr:    { c: 'fr',    n: 'French',            t: 'français',                    xlp: 'french'           },
          ga:    { c: 'ga',    n: 'Irish',             t: 'Irish',                       xlp: 'irish'            },
          gl:    { c: 'gl',    n: 'Galician',          t: 'Galician',                    xlp: 'galician'         },
          he:    { c: 'he',    n: 'Hebrew',            t: 'Hebrew',                      xlp: 'hebrew'           },
          hi:    { c: 'hi',    n: 'Hindi',             t: 'Hindi',                       xlp: 'hindi'            },
          hr:    { c: 'hr',    n: 'Croatian',          t: 'Croatian',                    xlp: 'croatian'         },
          hy:    { c: 'hy',    n: 'Armenian',          t: 'Armenian',                    xlp: 'armenian'         },
          ia:    { c: 'ia',    n: 'Interlingua',       t: 'Interlingua',                 xlp: 'interlingua'      },
          is:    { c: 'is',    n: 'Icelandic',         t: 'Icelandic',                   xlp: 'icelandic'        },
          it:    { c: 'it',    n: 'Italian',           t: 'Italiano',                    xlp: 'italian'          },
          la:    { c: 'la',    n: 'Latin',             t: 'Latin',                       xlp: 'latin'            },
          lo:    { c: 'lo',    n: 'Lao',               t: 'Lao',                         xlp: 'lao'              },
          lt:    { c: 'lt',    n: 'Lithuanian',        t: 'Lithuanian',                  xlp: 'lithuanian'       },
          lv:    { c: 'lv',    n: 'Latvian',           t: 'Latvian',                     xlp: 'latvian'          },
          ml:    { c: 'ml',    n: 'Malayalam',         t: 'Malayalam',                   xlp: 'malayalam'        },
          mr:    { c: 'mr',    n: 'Marathi',           t: 'Marathi',                     xlp: 'marathi'          },
          nl:    { c: 'nl',    n: 'Dutch',             t: 'Nederlands',                  xlp: 'dutch'            },
          no:    { c: 'no',    n: 'Norwegian',         t: 'norsk',                       xlp: 'norsk'            },
          nn:    { c: 'nn',    n: 'Norwegian Nynorsk', t: 'nynorsk',                     xlp: 'nynorsk'          },
          oc:    { c: 'oc',    n: 'Occitan',           t: 'Occitan',                     xlp: 'occitan'          },
          pl:    { c: 'pl',    n: 'Polish',            t: 'polski',                      xlp: 'polish'           },
          pt:    { c: 'pt',    n: 'Portuguese',        t: 'Português',                   xlp: 'portuges'         },
          pt_BR: { c: 'pt_BR', n: 'Portuguese Brazil', t: 'Brazilian Português',         xlp: 'brazilian'        },
          ro:    { c: 'ro',    n: 'Romanian',          t: 'română',                      xlp: 'romanian'         },
          ru:    { c: 'ru',    n: 'Russian',           t: 'Русский (Russkij)',           xlp: 'russian'          },
          sa:    { c: 'sa',    n: 'Sanskrit',          t: 'Sanskrit',                    xlp: 'sanskrit'         },
          se:    { c: 'se',    n: 'Sami',              t: 'Samin',                       xlp: 'samin'            },
          sk:    { c: 'sk',    n: 'Slovak',            t: 'slovensky',                   xlp: 'slovak'           },
          sl:    { c: 'sl',    n: 'Slovenian',         t: 'Slovenian',                   xlp: 'slovenian'        },
          sq:    { c: 'sq',    n: 'Albanian',          t: 'Albanian',                    xlp: 'albanian'         },
          sr:    { c: 'sr',    n: 'Serbian',           t: 'Serbian',                     xlp: 'serbian'          },
          sv:    { c: 'sv',    n: 'Swedish',           t: 'svenska',                     xlp: 'swedish'          },
          ta:    { c: 'ta',    n: 'Tamil',             t: 'Tamil',                       xlp: 'tamil'            },
          te:    { c: 'te',    n: 'Telugu',            t: 'Telugu',                      xlp: 'telugu'           },
          th:    { c: 'th',    n: 'Thai',              t: 'Thai',                        xlp: 'thai'             },
          tk:    { c: 'tk',    n: 'Turkmen',           t: 'Turkmen',                     xlp: 'turkmen'          },
          tr:    { c: 'tr',    n: 'Turkish',           t: 'Türkçe',                      xlp: 'turkish'          },
          uk:    { c: 'uk',    n: 'Ukranian',          t: 'українська (ukrajins\'ka)',   xlp: 'ukrainian'        },
          ur:    { c: 'ur',    n: 'Urdu',              t: 'Urdu',                        xlp: 'urdu'             },
          us:    { c: 'en',    n: 'English (American)',t: 'English',                     xlp: 'english'          },
          vi:    { c: 'vi',    n: 'Vietnamese',        t: 'Vietnamese',                  xlp: 'vietnamese'       },
          en:    { c: 'en',    n: 'English',           t: 'English',                     xlp: 'english'          },
          xx:    { c: 'xx',    n: 'Default',           t: 'English',                     xlp: 'english'          },
        }
      end
      def list
        @@language_list ||= {
          'am'    => table[:am],
          'bg'    => table[:bg],
          'bn'    => table[:bn],
          'br'    => table[:br],
          'ca'    => table[:ca],
          'cs'    => table[:cs],
          'cy'    => table[:cy],
          'da'    => table[:da],
          'de'    => table[:de],
          'el'    => table[:el],
          'en'    => table[:en],
          'eo'    => table[:eo],
          'es'    => table[:es],
          'et'    => table[:et],
          'eu'    => table[:eu],
          'fi'    => table[:fi],
          'fr'    => table[:fr],
          'ga'    => table[:ga],
          'gl'    => table[:gl],
          'he'    => table[:he],
          'hi'    => table[:hi],
          'hr'    => table[:hr],
          'hy'    => table[:hy],
          'ia'    => table[:ia],
          'is'    => table[:is],
          'it'    => table[:it],
          'la'    => table[:la],
          'lo'    => table[:lo],
          'lt'    => table[:lt],
          'lv'    => table[:lv],
          'ml'    => table[:ml],
          'mr'    => table[:mr],
          'nl'    => table[:nl],
          'no'    => table[:no],
          'nn'    => table[:nn],
          'oc'    => table[:oc],
          'pl'    => table[:pl],
          'pt'    => table[:pt],
          'pt_BR' => table[:pt_BR],
          'ro'    => table[:ro],
          'ru'    => table[:ru],
          'sa'    => table[:sa],
          'se'    => table[:se],
          'sk'    => table[:sk],
          'sl'    => table[:sl],
          'sq'    => table[:sq],
          'sr'    => table[:sr],
          'sv'    => table[:sv],
          'ta'    => table[:ta],
          'te'    => table[:te],
          'th'    => table[:th],
          'tk'    => table[:tk],
          'tr'    => table[:tr],
          'uk'    => table[:uk],
          'ur'    => table[:ur],
          'us'    => table[:en],
          'vi'    => table[:vi],
          'en'    => table[:en],
          'xx'    => table[:en]
        }
      end
      self
    end
  end
  class Alphabet
    def initialize(lng_code)
      @lng_code=lng_code
    end
    def hash_arrays
      @alph=case @lng_code
      when /en/                                                              #english
        {
          u: %w[A B C D E F G H I J K L M N O P Q R S T U V W X Y Z],
          l: %w[a b c d e f g h i j k l m n o p q r s t u v w x y z]
        }
      when /da|no|nn/                                                        #danish, norwegian
        {
          u: %w[A B C D E F G H I J K L M N O P Q R S T U V W X Y Z Å Æ Ø],
          l: %w[a b c d e f g h i j k l m n o p q r s t u v w x y z å æ ø]
          #u: %W[A B C D E F G H I J K L M N O P Q R S T U V W X Y Z Æ Ø Å],
          #l: %w[a b c d e f g h i j k l m n o p q r s t u v w x y z æ ø å]
        }
      when /sv/                                                              #swedish
        {
          u: %w[A B C D E F G H I J K L M N O P Q R S T U V W X Y Z Å Ä Ö],
          l: %w[a b c d e f g h i j k l m n o p q r s t u v w x y z å ä ö]
        }
      else                                                                   #english default
        {
          u: %w[A B C D E F G H I J K L M N O P Q R S T U V W X Y Z],
          l: %w[a b c d e f g h i j k l m n o p q r s t u v w x y z]
        }
      end
    end
    def hash_strings
      { u: hash_arrays[:u].join, l: hash_arrays[:l].join }
    end
  end
end
__END__
Language Lists
* po4a c:
  <http://www.debian.org/international/l10n/po/>
  Px[:lng_lst]=%w[am bg bn br ca cs cy da de el en eo es et eu fi fr ga gl he hi hr hy ia is it la lo lt lv ml mr nl nn no oc pl pt pt_BR ro ru sa se sk sl sq sr sv ta te th tk tr uk ur us vi]
* polyglossia xlp:
  <http://mirrors.ctan.org/macros/xetex/latex/polyglossia/polyglossia.pdf>
  missing from (:c) list:
    arabic asturian bahasai bahasam coptic divehi farsi lsorbian magyar scottish syriac usorbian
note ISO_639-1
  <http://en.wikipedia.org/wiki/ISO_639-1>
  <http://en.wikipedia.org/wiki/List_of_ISO_639-1_codes>
also note ISO_639-2
  <http://en.wikipedia.org/wiki/ISO_639-2>
  <http://en.wikipedia.org/wiki/List_of_ISO_639-2_codes>

Px[:lng_lst] # constants.rb

module SiSU_text_translation
  class Language
    def initialize(md)
      @md=md
    end
    def tex_name(char)
      @lang=if char
        case char
        when 'sq';    'albanian'
        when 'am';    'amharic'
       #when 'ar';    'arabic'         # see polyglossia
        when 'hy';    'armenian'
       #when '';      'asturian'       # polyglossia
       #when '';      'bahasai'        # polyglossia
       #when '';      'bahasam'        # polyglossia
        when 'eu';    'basque'
        when 'bn';    'bengali'
        when 'pt_BR'; 'brazilian'
        when 'br';    'breton'
        when 'bg';    'bulgarian'
        when 'ca';    'catalan'        # see polyglossia
       #when '';      'coptic'         # polyglossia
        when 'hr';    'croatian'
        when 'cs';    'czech'
        when 'da';    'danish'
       #when '';      'divehi'         # polyglossia
        when 'nl';    'dutch'          # see polyglossia
        when 'en';    'english'        # see polyglossia
        when 'eo';    'esperanto'      # see polyglossia
        when 'et';    'estonian'
        when 'gl';    'galician'
        when 'de';    'german'
        when 'el';    'greek'          #gl ?
        when 'he';    'hebrew'
        when 'hi';    'hindi'
        when 'is';    'icelandic'
        when 'ia';    'interlingua'
        when 'ga';    'irish'
        when 'it';    'italian'
       #when '';      'farsi'          # polyglossia
        when 'fi';    'finnish'
        when 'fr';    'french'
        when 'lo';    'lao'
        when 'la';    'latin'
        when 'lv';    'latvian'
        when 'lt';    'lithuanian'
       #when '';      'lsorbian'       # polyglossia
       #when '';      'magyar'         # polyglossia
        when 'ml';    'malayalam'
        when 'mr';    'marathi'
       #when 'hu';    'magyar'
        when 'no';    'norske'
        when 'nn';    'nynorsk'
        when 'oc';    'occitan'
        when 'pl';    'polish'
        when 'pt';    'portuges'
        when 'ro';    'romanian'
        when 'ru';    'russian'
        when 'se';    'samin'          #(check sami?)
        when 'sa';    'sanskrit'
        when 'sr';    'serbian'
       #when '';      'scottish'       # polyglossia  (gd (Gaelic (Scots)))
        when 'sk';    'slovak'
        when 'sl';    'slovenian'
        when 'es';    'spanish'
        when 'sv';    'swedish'
        when 'ta';    'tamil'
        when 'te';    'telugu'
        when 'th';    'thai'
        when 'tr';    'turkish'
        when 'tk';    'turkmen'
        when 'uk';    'ukrainian'
        when 'ur';    'urdu'
       #when '';      'usorbian'       # polyglossia
        when 'vi';    'vietnamese'
        when 'cy';    'welsh'
        when 'us';    'USenglish'      # depreciated, see iso-639-2
        else          'english'
        end
      else            'english'
      end
    end
  end
end
#% Language List po4a
http://www.debian.org/international/l10n/po/
see polyglossia for subset
* CSB (Unknown language)
* KAB (Unknown language)
* TLH (Unknown language)
* aa (Afar)
* ab (Abkhazian)
* af (Afrikaans)
* af_ZA (Afrikaans, as spoken in South Africa)
* am (Amharic)
* an (Unknown language)
* ang (Unknown language)
* ar (Arabic)
* ar_AR (Arabic, as spoken in Argentina)
* ar_EG (Arabic, as spoken in Egypt)
* ar_OM (Arabic, as spoken in Oman)
* ar_PS (Arabic, as spoken in Palestinian Territory, Occupied)
* ar_SA (Arabic, as spoken in Saudi Arabia)
* ar_SY (Arabic, as spoken in Syrian Arab Republic)
* as (Assamese)
* ast (Unknown language)
* ay (Aymara)
* az (Azerbaijani)
* az_IR (Azerbaijani, as spoken in Iran)
* be (Belarusian)
* be@latin (Unknown language)
* be@tarask (Unknown language)
* bem (Unknown language)
* bg (Bulgarian)
* bg_BG (Bulgarian, as spoken in Bulgaria)
* bi (Bislama)
* bn (Bengali)
* bn_BD (Bengali, as spoken in Bangladesh)
* bn_IN (Bengali, as spoken in India)
* bo (Tibetan)
* br (Breton)
* bs (Bosnian)
* bs_BA (Bosnian, as spoken in Bosnia and Herzegovina)
* bs_BS (Bosnian, as spoken in Bahamas)
* byn (Unknown language)
* ca (Catalan)
* ca@valencia (Unknown language)
* ca_AD (Catalan, as spoken in Andorra)
* ca_ES (Catalan, as spoken in Spain)
* ca_ES@valencia (Unknown language)
* ca_FR (Catalan, as spoken in France)
* ca_IT (Catalan, as spoken in Italy)
* co (Corsican)
* crh (Unknown language)
* cs (Czech)
* cs_CZ (Czech, as spoken in Czech Republic)
* csb (Unknown language)
* cy (Welsh)
* cy_GB (Welsh, as spoken in Great Britain)
* cz (Unknown language)
* da (Danish)
* da_DK (Danish, as spoken in Denmark)
* de (German)
* de_AT (German, as spoken in Austria)
* de_CH (German, as spoken in Switzerland)
* de_DE (German, as spoken in Germany)
* dk (Unknown language)
* dz (Dzongkha)
* el (Greek)
* el_GR (Greek, as spoken in Greece)
* en (English)
* en@boldquot (Unknown language)
* en@quot (Unknown language)
* en@shaw (Unknown language)
* en_AU (English, as spoken in Australia)
* en_CA (English, as spoken in Canada)
* en_GB (English, as spoken in Great Britain)
* en_NZ (English, as spoken in New Zealand)
* en_US (English, as spoken in United States)
* en_US@piglatin (Unknown language)
* en_ZA (English, as spoken in South Africa)
* eo (Esperanto)
* es (Spanish)
* es_AR (Spanish, as spoken in Argentina)
* es_CL (Spanish, as spoken in Chile)
* es_CO (Spanish, as spoken in Colombia)
* es_CR (Spanish, as spoken in Costa Rica)
* es_DO (Spanish, as spoken in Dominican Republic)
* es_EC (Spanish, as spoken in Ecuador)
* es_ES (Spanish, as spoken in Spain)
* es_GA (Spanish, as spoken in Gabon)
* es_GT (Spanish, as spoken in Guatemala)
* es_HN (Spanish, as spoken in Honduras)
* es_LA (Spanish, as spoken in Lao People''s Democratic Republic)
* es_MX (Spanish, as spoken in Mexico)
* es_NI (Spanish, as spoken in Nicaragua)
* es_PA (Spanish, as spoken in Panama)
* es_PE (Spanish, as spoken in Peru)
* es_PR (Spanish, as spoken in Puerto Rico)
* es_SV (Spanish, as spoken in El Salvador)
* es_UY (Spanish, as spoken in Uruguay)
* es_VE (Spanish, as spoken in Venezuela)
* et (Estonian)
* et_EE (Estonian, as spoken in Estonia)
* eu (Basque)
* eu_ES (Basque, as spoken in Spain)
* fa (Persian)
* fa_AF (Persian, as spoken in Afghanistan)
* fa_IR (Persian, as spoken in Iran)
* fi (Finnish)
* fi_FI (Finnish, as spoken in Finland)
* fil (Unknown language)
* fo (Faeroese)
* fo_FO (Faeroese, as spoken in Faroe Islands)
* fr (French)
* fr_BE (French, as spoken in Belgium)
* fr_CA (French, as spoken in Canada)
* fr_CH (French, as spoken in Switzerland)
* fr_FR (French, as spoken in France)
* fr_FX (French, as spoken in France, Metropolitan)
* fr_LU (French, as spoken in Luxembourg)
* frp (Unknown language)
* fur (Unknown language)
* fy (Frisian)
* fy_NL (Frisian, as spoken in Netherlands)
* ga (Irish)
* gd (Gaelic (Scots))
* gez (Unknown language)
* gl (Galician)
* gl_ES (Galician, as spoken in Spain)
* gn (Guarani)
* gu (Gujarati)
* gv (Manx)
* ha (Hausa)
* he (Hebrew)
* he_IL (Hebrew, as spoken in Israel)
* hi (Hindi)
* hne (Unknown language)
* hr (Croatian)
* hr_HR (Croatian, as spoken in Croatia)
* ht (Unknown language)
* hu (Hungarian)
* hu_HU (Hungarian, as spoken in Hungary)
* hy (Armenian)
* ia (Interlingua)
* id (Indonesian)
* id_ID (Indonesian, as spoken in Indonesia)
* ig (Unknown language)
* io (Unknown language)
* is (Icelandic)
* is_IS (Icelandic, as spoken in Iceland)
* it (Italian)
* it_CH (Italian, as spoken in Switzerland)
* it_IT (Italian, as spoken in Italy)
* iu (Inuktitut)
* ja (Japanese)
* ja_JP (Japanese, as spoken in Japan)
* jv (Unknown language)
* jv_ID (Unknown language)
* ka (Georgian)
* kab (Unknown language)
* kk (Kazakh)
* kl (Kalaallisut)
* km (Khmer)
* km_KH (Khmer, as spoken in Cambodia)
* kn (Kannada)
* ko (Korean)
* ko_KR (Korean, as spoken in Korea)
* ks (Kashmiri)
* ku (Kurdish)
* kw (Cornish)
* ky (Kirghiz)
* la (Latin)
* lb (Letzeburgesch)
* lg (Unknown language)
* li (Unknown language)
* ln (Lingala)
* lo (Lao)
* lt (Lithuanian)
* lt_LT (Lithuanian, as spoken in Lithuania)
* lv (Latvian)
* lv_LV (Latvian, as spoken in Latvia)
* mai (Unknown language)
* mal (Unknown language)
* mg (Malagasy)
* mi (Maori)
* mk (Macedonian)
* mk_MK (Macedonian, as spoken in Macedonia, the Former Yugoslav Republic of)
* ml (Malayalam)
* ml_IN (Malayalam, as spoken in India)
* ml_ML (Malayalam, as spoken in Mali)
* mn (Mongolian)
* mr (Marathi)
* ms (Malay)
* ms_MY (Malay, as spoken in Malaysia)
* mt (Maltese)
* my (Burmese)
* my_MM (Burmese, as spoken in Myanmar)
* na (Nauru)
* nb (Norwegian Bokmål)
* nb_NO (Norwegian Bokmål, as spoken in Norway)
* nds (Unknown language)
* ne (Nepali)
* new (Unknown language)
* nl (Dutch)
* nl_BE (Dutch, as spoken in Belgium)
* nl_NL (Dutch, as spoken in Netherlands)
* nn (Norwegian Nynorsk)
* nn_NO (Norwegian Nynorsk, as spoken in Norway)
* no (Norwegian)
* no_NO (Norwegian, as spoken in Norway)
* nr (Ndebele, South)
* nso (Unknown language)
* oc (Occitan (post 1500))
* oc_FR (Occitan (post 1500), as spoken in France)
* om (Oromo)
* or (Oriya)
* pa (Panjabi)
* pl (Polish)
* pl_PL (Polish, as spoken in Poland)
* pms (Unknown language)
* ps (Pushto)
* pt (Portuguese)
* pt_BR (Portuguese, as spoken in Brazil)
* pt_PT (Portuguese, as spoken in Portugal)
* qu (Quechua)
* rm (Rhaeto-Romance)
* ro (Romanian)
* ro_RO (Romanian, as spoken in Romania)
* ru (Russian)
* ru_RU (Russian, as spoken in Russia)
* rw (Kinyarwanda)
* sa (Sanskrit)
* sc (Sardinian)
* sd (Sindhi)
* se (Sami)
* se_NO (Sami, as spoken in Norway)
* si (Sinhalese)
* si_LK (Sinhalese, as spoken in Sri Lanka)
* si_SI (Sinhalese, as spoken in Slovenia)
* sk (Slovak)
* sk_SK (Slovak, as spoken in Slovakia)
* sl (Slovenian)
* sl_SI (Slovenian, as spoken in Slovenia)
* sl_SL (Slovenian, as spoken in Sierra Leone)
* so (Somali)
* sp (Unknown language)
* sq (Albanian)
* sq_AL (Albanian, as spoken in Albania)
* sr (Serbian)
* sr@Latn (Unknown language)
* sr@ije (Unknown language)
* sr@ijekavian (Unknown language)
* sr@ijekavianlatin (Unknown language)
* sr@latin (Unknown language)
* sr_SR (Serbian, as spoken in Suriname)
* sr_YU (Serbian, as spoken in Yugoslavia)
* st (Sotho)
* su (Sundanese)
* su_ID (Sundanese, as spoken in Indonesia)
* sv (Swedish)
* sv_SE (Swedish, as spoken in Sweden)
* sw (Swahili)
* ta (Tamil)
* ta_LK (Tamil, as spoken in Sri Lanka)
* te (Telugu)
* tg (Tajik)
* th (Thai)
* th_TH (Thai, as spoken in Thailand)
* ti (Tigrinya)
* tig (Unknown language)
* tk (Turkmen)
* tl (Tagalog)
* tlh (Unknown language)
* to (Tonga)
* tr (Turkish)
* tr_TR (Turkish, as spoken in Turkey)
* tt (Tatar)
* ug (Uighur)
* ug_CN (Uighur, as spoken in China)
* uk (Ukrainian)
* uk_UA (Ukrainian, as spoken in Ukraine)
* ur (Urdu)
* ur_PK (Urdu, as spoken in Pakistan)
* uz (Uzbek)
* uz@cyrillic (Unknown language)
* ve (Unknown language)
* vi (Vietnamese)
* vi_AR (Vietnamese, as spoken in Argentina)
* vi_DE (Vietnamese, as spoken in Germany)
* vi_PL (Vietnamese, as spoken in Poland)
* vi_TR (Vietnamese, as spoken in Turkey)
* vi_VN (Vietnamese, as spoken in Vietnam)
* wa (Unknown language)
* wal (Unknown language)
* wo (Wolof)
* xh (Xhosa)
* yi (Yiddish)
* yo (Yoruba)
* zh (Chinese)
* zh_CN (Chinese, as spoken in China)
* zh_HK (Chinese, as spoken in Hong Kong)
* zh_TW (Chinese, as spoken in Taiwan)
* zu (Zulu)

 'sq';    'albanian'
 'am';    'amharic'
#'ar';    'arabic'         # see polyglossia
 'hy';    'armenian'
#'';      'asturian'       # polyglossia
#'';      'bahasai'        # polyglossia
#'';      'bahasam'        # polyglossia
 'eu';    'basque'
 'bn';    'bengali'
 'pt_BR'; 'brazilian'
 'br';    'breton'
 'bg';    'bulgarian'
 'ca';    'catalan'        # see polyglossia
#'';      'coptic'         # polyglossia
 'hr';    'croatian'
 'cs';    'czech'
 'da';    'danish'
#'';      'divehi'         # polyglossia
 'nl';    'dutch'          # see polyglossia
 'en';    'english'        # see polyglossia
 'eo';    'esperanto'      # see polyglossia
 'et';    'estonian'
 'gl';    'galician'
 'de';    'german'
 'el';    'greek'          #gl ?
 'he';    'hebrew'
 'hi';    'hindi'
 'is';    'icelandic'
 'ia';    'interlingua'
 'ga';    'irish'
 'it';    'italian'
#'';      'farsi'          # polyglossia
 'fi';    'finnish'
 'fr';    'french'
 'lo';    'lao'
 'la';    'latin'
 'lv';    'latvian'
 'lt';    'lithuanian'
#'';      'lsorbian'       # polyglossia
#'';      'magyar'         # polyglossia
 'ml';    'malayalam'
 'mr';    'marathi'
#'hu';    'magyar'
 'no';    'norske'
 'nn';    'nynorsk'
 'oc';    'occitan'
 'pl';    'polish'
 'pt';    'portuges'
 'ro';    'romanian'
 'ru';    'russian'
 'se';    'samin'          #(check sami?)
 'sa';    'sanskrit'
 'sr';    'serbian'
#'';      'scottish'       # polyglossia  (gd (Gaelic (Scots)))
 'sk';    'slovak'
 'sl';    'slovenian'
 'es';    'spanish'
 'sv';    'swedish'
 'ta';    'tamil'
 'te';    'telugu'
 'th';    'thai'
 'tr';    'turkish'
 'tk';    'turkmen'
 'uk';    'ukrainian'
 'ur';    'urdu'
#'';      'usorbian'       # polyglossia
 'vi';    'vietnamese'
 'cy';    'welsh'
 'us';    'USenglish'      # depreciated, see iso-639-2
