# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: html scroll generation, processing

=end
module SiSU_HTML_scroll
  require_relative 'shared_html'                        # shared_html.rb
  require_relative 'html'                               # html.rb
  require_relative 'shared_metadata'                    # shared_metadata.rb
  require_relative 'html_promo'                         # html_promo.rb
  class Scroll
    def initialize(md='',data='',endnotes='')
      @md,@data,@endnotes=md,data,endnotes
      @vz=SiSU_Env::Get_init.instance.skin
    end
    def songsheet
      begin
        scr=Scroll.new(@md,@data,@endnotes).markup
        scr[:tails]=Scroll.new(@md).tails
        scr
      rescue; SiSU_Errors::Info_error.new($!,$@,@md.opt.cmd,@md.fns).error
      ensure
      end
    end
  protected
    def markup
      data=@data
      @rcdc=false
      @scr={ body: [], metadata: [], owner_details: [] }
      data.each do |dob|
        dob.obj.gsub!(/#{@md.file.output_path.html_seg.rel_image}/m,@md.file.output_path.html_scroll.rel_image)
        if defined? dob.name and dob.name =~/^meta/ \
        and dob.obj =~/Document Information/
          dob.obj.gsub!(/(Document Information(?: \(metadata\))?)/,'\1<a name="docinfo"></a>')
        end
        if dob.obj =~/^Metadata$/ \
        and dob.lv =='B'
          dob.obj.gsub!(/Metadata/,'')
        end
        if defined? dob.name \
        and dob.name =~/^metadata/ \
        and dob.lv =='1' \
        and dob.obj =~/SiSU Metadata, document information/
          @rcdc=true
        end
        dob.obj.gsub!(/href="[a-z0-9._-]+(#\S+?")/m,'href="\1') # internal document links
        dob.obj.gsub!(/href="#{Xx[:segment]}/m,'href="')
        dob.obj.gsub!(/(?:\s*#{Mx[:br_page]}\s*|\s*#{Mx[:br_page_new]}\s*)+/m,'<p><hr width=90% /></p>')
        if dob.obj !~/(^#{Rx[:meta]}|#{Mx[:br_eof]})/
          unless dob.is =~/^code/; dob.obj.gsub!(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
          end
          if defined? dob.ocn
            @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,dob.ocn)
          end
          sto=SiSU_HTML_Format::Format_text_object.new(@md,dob)
          para_html=if dob.is=='heading'
            x=if dob.ln==1
              sto.heading_body1
            elsif dob.ln==2
              sto.heading_body2
            elsif dob.ln==3
              sto.heading_body3
            elsif dob.ln==4
              sto.heading_body4
            elsif dob.ln==5
              sto.heading_body5
            elsif dob.ln==6
              sto.heading_body6
            end
          elsif dob.is=='heading_insert'
            x=if dob.ln==1
              sto.heading_body1
            elsif dob.ln==2
              sto.heading_body2
            elsif dob.ln==3
              sto.heading_body3
            elsif dob.ln==4 \
            and dob.obj !~/^(?:Endnotes|Index|Metadata|Manifest)$/
              sto.heading_body4
            elsif dob.ln==4 \
            and dob.obj=='Endnotes'
              sto.heading_body4
              @endnotes.join("\n")
            elsif dob.ln==4 \
            and dob.obj=='Index'
              sto.heading_body4
              book_idx=SiSU_Particulars::Combined_singleton.instance.get_idx_html(@md.opt).html_idx
              book_idx.each do |x| #takes book index prepared for segments and strips segment identifying info
                x.gsub!(/<a href="\S+?\.html#(\d+)">(\1(?:-\d+)?)<\/a>/,'<a href="#\1">\2</a>')
              end
              book_idx.join("\n")
            #elsif dob.ln==4 \
            #and dob.obj=~/Meta/
            #p __LINE__
            ##and dob.obj=='Metadata'
            #metadata=Metadata::Summary.new(@md).xhtml.metadata
            elsif dob.ln==5
              sto.heading_body5
            elsif dob.ln==6
              sto.heading_body6
            end
          elsif dob.is=='para'
            if dob.indent \
            and dob.hang \
            and dob.indent =~/[0-9]/ \
            and dob.hang =~/[0-9]/
              if dob.bullet_
                if dob.indent =~/[1-9]/
                  sto.format('li',"i#{dob.indent}")
                else
                  sto.format('li','bullet')
                end
              elsif dob.indent == dob.hang
                sto.format('p',"i#{dob.indent}")
              elsif dob.indent != dob.hang
                sto.format('p',"h#{dob.hang}i#{dob.indent}")
              else sto.para
              end
            else sto.para
            end
          elsif dob.is=='block'
            sto.block
          elsif dob.is=='group'
            sto.group
          elsif dob.is=='alt'
            sto.alt
          elsif dob.is=='verse'
            sto.verse
          elsif dob.is=='code'
            sto.code
          elsif dob.is=='table'
            sto.table
          elsif dob.is=='break'
            sto.break
          end
          if dob =~/<a name="n\d+">/ \
          and dob =~/^(?:\^~\d+\s|<!e[:_]\d+!>)/ # hmmm re-adjusted 200507, for alt endnote which should again be matched ^~ ... not in response to problem though
            dob=''
          end
          unless @rcdc; @scr[:body] << para_html unless para_html =~/\A\s*\Z/
          else          #@scr[:metadata] << dob.obj
          end
        end
      end
      @scr
    end
    def tails
      scr_tail=[]
      format_head_scroll=SiSU_HTML_Format::Head_toc.new(@md)
      ads=SiSU_HTML_promo::Ad.new(@md)
      scr_tail << format_head_scroll.scroll_tail << ads.div.close << ads.display << format_head_scroll.html_close
      scr_tail
    end
  end
end
__END__
