# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: generates naive cgi search form for search of sisu database (pgsql sqlite)

=end
module SiSU_CGI_sql
  class SiSU_CGI_common
    def initialize(webserv,opt,image_src,dir)
      @webserv,@opt,@image_src,@env=webserv,opt,image_src,dir
      @cmd=opt.cmd
    end
    def about
      <<-'WOK_SQL'
 * Name: SiSU information Structuring Universe
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
      WOK_SQL
    end
    def gpl
      <<-'WOK_SQL'
 * Name: SiSU generated sample cgi search form

 * Description: generated sample cgi search form for SiSU
   (SiSU is a framework for document structuring, publishing and search)

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>
   <http://www.jus.uio.no/sisu/gpl.fsf>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>
      WOK_SQL
    end
    def header1
      <<-'WOK_SQL'
#Common TOP
      @@offset=0
      @base="#{@hosturl_db}/cgi-bin/#{@version}.cgi"
      @@canned_search_url=@base
      @color_heading='#DDFFAA'
      @color_match='#ffff48'
      class Form
        def initialize(base,search_field,selected_db,result_type,checked_sql_limit,checked_tip,checked_stats,checked_searched,checked_url,checked_case,checked_echo,checked_sql,checked_all,checked_none,checked_selected,checked_default,search_note,the_can='')
          search_note='' if checked_searched !~/\S/
          the_can='' if checked_url !~/\S/
          search_field='' if checked_echo !~/\S/
          @base,@search_field,@selected_db,@result_type,@checked_sql_limit,@checked_tip,@checked_stats,@checked_searched,@checked_url,@checked_case,@checked_echo,@checked_sql,@checked_all,@checked_none,@checked_selected,@checked_default,@search_note,@the_can=base,search_field,selected_db,result_type,checked_sql_limit,checked_tip,checked_stats,checked_searched,checked_url,checked_case,checked_echo,checked_sql,checked_all,checked_none,checked_selected,checked_default,search_note,the_can
          @tip=if checked_tip =~/\S/
            '<font size="2" color="#666666">text:__; fulltxt:__; keywords:__; title:__; author:__; topic_register:__; subject:__; description:__; publisher:__; editor:__; contributor:__; date:__; type:__; format:__; identifier:__; source:__; language:__; relation:__; coverage:__; rights:__; comment:__; abstract:__; filename:__;</font><br />'
          else ''
          end
        end
        def submission_form
            search_form=<<-WOK
      WOK_SQL
    end
    def header_desc
      <<-WOK_SQL
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
    <title>
    SiSU search form (sample): SiSU information Structuring Universe
    </title>
    <meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
    <meta name="sourcefile" content="SiSU._sst" />
    <link rel="generator" href="http://www.jus.uio.no/sisu" />
    <link rel="shortcut icon" href="#{@image_src}/rb7.ico" />
    <link rel="stylesheet" href="../_sisu/css/html.css" type="text/css" />
    </head>
    <body bgcolor="#ffffff" text="#000000" link="#003090" lang="en" xml:lang="en">
    <table summary="band" border="0" cellpadding="3" cellspacing="0">
    <tr><td align="left" bgcolor="#ffffff"><a href="http://www.jus.uio.no/sisu/" target="_top"><img border="0" src="#{@image_src}/sisu.png" alt="SiSU --&gt;" /></a></td><td>
<!--    <p class="tiny"><a href="http://www.jus.uio.no/sisu/SiSU/">&nbsp;http://www.jus.uio.no/sisu/SiSU/</a></p> -->
      <label for="find"><b>#{@env.sample_search_form_title}</b></label>
    </td></tr>
    </table>
      WOK_SQL
    end
    def header2
      <<-'WOK_SQL'
    <form action="#{@base}" id="Test Form" method="post">
      <table cellpadding="2">
      <tr><td valign=\"top\">
          <textarea id="find" name="find" type="text" rows="6" cols="40" maxlength="256">#{@search_field}</textarea>
      </td>
      <td valign=\"top\">
        #{@tip}
        #{@search_note}
        #{@the_can}
      </td></tr></table>
      <td valign=\"top\"><tr><td>
        <!input type="text" id="find" name="find" value="#{@search_field}" />
        <!input type="text" id="find" name="find" value="" />
        <font size="2" color="#222222">
        <b>to search:</b> select which database to search (drop-down menu below); enter your search query (in the form above); and <b>click on the search button</b> (below)
        <br />
        <select name="db" size="1">
          #{@selected_db}
      WOK_SQL
    end
    def buttons1
      <<-'WOK_SQL'
        </select>
        <input type="submit" value="SiSU search" />
        <input type="radio" name="view" value="index" #{@result_type[:index]}> index
        <input type="radio" name="view" value="text" #{@result_type[:text]}> text / grep
      WOK_SQL
    end
    def buttons2
      <<-'WOK_SQL'
        <br />
          match limit:
          <input type="radio" name="sql_match_limit" value="1000" #{@checked_sql_limit[:l1000]}> 1,000
          <input type="radio" name="sql_match_limit" value="2500" #{@checked_sql_limit[:l2500]}> 2,500
        <br />
          <input type="checkbox" name="echo" #{@checked_echo}> echo query
          <input type="checkbox" name="stats" #{@checked_stats}> result stats
          <input type="checkbox" name="url" #{@checked_url}> search url
          <input type="checkbox" name="searched" #{@checked_searched}> searched
          <input type="checkbox" name="tip" #{@checked_tip}> available fields
          <input type="checkbox" name="sql" #{@checked_sql}> sql statement
        <br />
          checks:
          <input type="radio" name="checks" value="check_default" #{@checked_default}> default
          <input type="radio" name="checks" value="check_selected" #{@checked_selected}> selected
          <input type="radio" name="checks" value="check_all" #{@checked_all}> all
          <input type="radio" name="checks" value="check_none" #{@checked_none}> none
          </font>
      </td></tr>
      </table>
    </form>
      WOK
        end
      end
      WOK_SQL
    end
    def search_request
      <<-'WOK_SQL'
      class Search_request                                                       #% search_for
        attr_accessor :text1,:fulltext,:keywords,:title,:author,:topic_register,:subject,:description,:publisher,:editor,:contributor,:date,:type,:format,:identifier,:source,:language,:relation,:coverage,:rights,:comment,:abstract,:owner,:date_created,:date_issued,:date_modified,:date_available,:date_valid,:filename
        def initialize(search_field='',q='')
          @search_field,@q=search_field,q
          @text1=@fulltext=@keywords=@title=@author=@topic_register=@subject=@description=@publisher=@editor=@contributor=@date=@type=@format=@identifier=@source=@language=@relation=@coverage=@rights=@comment=@abstract=@owner=@date_created=@date_issued=@date_modified=@date_available=@date_valid=@filename=''
          if @search_field=~/\S/
            @text1=text_to_match('text:')
            @fulltext=text_to_match('fulltxt:')
            @topic_register=text_to_match('topic_register:')
            @title=text_to_match('title:')                  # DublinCore 1  - title
            @author=text_to_match('(?:author|creator)s?:')  # DublinCore 2  - creator/author
            @subject=text_to_match('subj(?:ect)?:')         # DublinCore 3  - subject
            @description=text_to_match('description:')      # DublinCore 4  - description
            @publisher=text_to_match('pub(?:lisher)?:')     # DublinCore 5  - publisher
            @editor=text_to_match('editor:')
            @contributor=text_to_match('contributor:')      # DublinCore 6  - contributor
            @date=text_to_match('date:')                    # DublinCore 7  - date dd-mm-yy
            @type=text_to_match('type:')                    # DublinCore 8  - type
            @format=text_to_match('format:')                # DublinCore 9  - format
            @identifier=text_to_match('identifier:')        # DublinCore 10 - identifier
            @source=text_to_match('source:')                # DublinCore 11 - source
            @language=text_to_match('language:')            # DublinCore 12 - language
            @relation=text_to_match('relation:')            # DublinCore 13 - relation
            @coverage=text_to_match('coverage:')            # DublinCore 14 - coverage
            @rights=text_to_match('rights:')                # DublinCore 15 - rights
            @keywords=text_to_match('key(?:words?)?:')
            @comment=text_to_match('comment:')
            @abstract=text_to_match('abs(?:tract)?:')
            @owner=text_to_match('owner:')
            @date_created=text_to_match('date_created:')
            @date_issued=text_to_match('date_issued:')
            @date_modified=text_to_match('date_modified:')
            @date_available=text_to_match('date_available:')
            @date_valid=text_to_match('date_valid:')
            @filename=text_to_match('filename:')
            @text1=text_to_match unless @keywords or @author or @title or @text1 or @fulltext or @comment or @abstract or @rights or @subject or @publisher or @date or @filename or @topic_register
          else
            @text1=q['s1'] if q['s1']=~/\S/
            @fulltext=q['ft'] if q['ft']=~/\S/
            @keywords=q['key'] if q['key']=~/\S/
            @title=q['ti'] if q['ti']=~/\S/
            @author=q['au'] if q['au']=~/\S/
            @topic_register=q['tr'] if q['tr']=~/\S/
            @subject=q['sj'] if q['sj']=~/\S/
            @description=q['dsc'] if q['dsc']=~/\S/
            @publisher=q['pb'] if q['pb']=~/\S/
            @editor=q['cntr'] if q['cntr']=~/\S/
            @contributor=q['cntr'] if q['cntr']=~/\S/
            @date=q['dt'] if q['dt']=~/\S/
            @type=q['ty'] if q['ty']=~/\S/
            @identifier=q['id'] if q['id']=~/\S/
            @source=q['src'] if q['src']=~/\S/
            @language=q['lang'] if q['lang']=~/\S/
            @relation=q['rel'] if q['rel']=~/\S/
            @coverage=q['cov'] if q['cov']=~/\S/
            @rights=q['cr'] if q['cr']=~/\S/
            @comment=q['co'] if q['co']=~/\S/
            @abstract=q['ab'] if q['ab']=~/\S/
            @date_created=q['dtc'] if q['dtc']=~/\S/
            @date_issued=q['dti'] if q['dti']=~/\S/
            @date_modified=q['dtm'] if q['dtm']=~/\S/
            @date_available=q['dta'] if q['dta']=~/\S/
            @date_valid=q['dtv'] if q['dtv']=~/\S/
            @filename=if q['doc'] and q['search'] !~/search db/; q['doc']
            elsif q['fns']=~/\S/; q['fns']
            end
            @@limit=q['ltd'] if q['ltd']=~/\d+/  # 1000
            @@offset=q['off'] if q['off']=~/\d+/ # 0
          end
        end
        def text_to_match(identifier='')
          m={
            :string => /#{identifier}\s*(.+?)/,
            :string => /#{identifier}\s*(.+?)(?:;|\n|\r|$)/,
            :word => /#{identifier}[\s(]*(\S+)/
          }
          search_string=if @search_field =~m[:word]
            search_string=if @search_field =~m[:braces]; m[:braces].match(@search_field)[1]
            elsif @search_field =~m[:string];            m[:string].match(@search_field)[1]
            else
              str=m[:word].match(@search_field)[1]
              str.gsub!(/[()]/,'')
              str
            end
            search_string.strip!
            search_string.gsub!(/\s+/,'+')
            search_string
          #else
          #  "__"
          end
        end
      end
      WOK_SQL
    end
    def search_statement_common
      <<-'WOK_SQL'
      class Dbi_search_statement
        attr_reader :text_search_flag,:sql_select_body_format,:sql_select_endnotes_format,:sql_offset,:sql_limit
        def initialize(conn,search_for,q,c)
          @conn=conn
          @text_search_flag=false
          @sql_statement={ :body => '', :endnotes => '', :range => '' }
          #@offset||=@@offset
          #@offset+=@@limit
          search={ :text => [], :endnotes => [] }
          cse=(c =~/\S/) ? true : false
          st=Dbi_search_string.new('doc_objects.clean',search_for.text1,q['s1'],cse).string
          se=Dbi_search_string.new('endnotes.clean',search_for.text1,q['s1'],cse).string
          @text_search_flag=st[:flag]
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << se[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.fulltext',search_for.fulltext,q['ft'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.classify_keywords',search_for.keywords,q['key'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.title',search_for.title,q['ti'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.creator_author',search_for.author,q['au'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.classify_topic_register',search_for.topic_register,q['tr'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.classify_subject',search_for.subject,q['sj'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.notes_description',search_for.description,q['dsc'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.publisher',search_for.publisher,q['pb'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.creator_editor',search_for.editor,q['cntr'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.creator_contributor',search_for.contributor,q['cntr'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.date_published',search_for.date,q['dt'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.classify_type',search_for.type,q['ty'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.classify_identifier',search_for.identifier,q['id'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.original_source',search_for.source,q['src'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.language_document_char',search_for.language,q['lang'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.classify_relation',search_for.relation,q['rel'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.classify_coverage',search_for.coverage,q['cov'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.rights_all',search_for.rights,q['cr'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.notes_comment',search_for.comment,q['co'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.notes_abstract',search_for.abstract,q['ab'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata_and_text.src_filename',search_for.filename,q['fns'],cse).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          @@limit=q['ltd'] if q['ltd']=~/\d+/  # 1000
          @@offset=q['off'] if q['off']=~/\d+/ # 0
      WOK_SQL
    end
    def pages
      <<-'WOK_SQL'
        def sql_offset
          @@offset
        end
        def sql_match_limit
          @@limit
        end
        def sql_canned_search
          @offset_next=sql_offset.to_i + sql_match_limit.to_i
          @offset_previous=sql_offset.to_i - sql_match_limit.to_i
          def current
            @@canned_search_url.to_s + '&ltd=' + sql_match_limit.to_s + '&off=' + sql_offset.to_s
          end
          def next
            @@canned_search_url.to_s + '&ltd=' + sql_match_limit.to_s + '&off=' + @offset_next.to_s
          end
          def previous
            @offset_previous >= 0 \
            ? (@@canned_search_url.to_s + '&ltd=' + sql_match_limit.to_s + '&off=' + @offset_previous.to_s)
            : ''
          end
          def start
            @@canned_search_url.to_s + '&ltd=' + sql_match_limit.to_s + '&off=' + 0.to_s
          end
          self
        end
        def pre_next(beyond_limit,img)
          can=sql_canned_search
          page=(sql_offset.to_i + sql_match_limit.to_i)/sql_match_limit.to_i
          if beyond_limit
            if page.to_s =~ /^1$/
              %{<br /><center>
              pg. #{page.to_s}
              <a href="#{can.next}">
                <img border="0" width="22" height="22" src="#{img}/arrow_next_red.png" alt="&nbsp;&gt;&gt;" />
              </a>
              </center>}
            elsif page.to_s =~ /^2$/
              %{<br /><center>
              <a href="#{can.previous}">
                <img border="0" width="22" height="22" src="#{img}/arrow_prev_red.png" alt="&lt;&lt;&nbsp;" />
              </a>
              pg. #{page.to_s}
              <a href="#{can.next}">
                <img border="0" width="22" height="22" src="#{img}/arrow_next_red.png" alt="&nbsp;&gt;&gt;" />
              </a>
              </center>}
            else
              %{<br /><center>
              <a href="#{can.start}">
                <img border="0" width="22" height="22" src="#{img}/arrow_prev_red.png" alt="|&lt;&nbsp;" />
              </a>
              <a href="#{can.previous}">
                <img border="0" width="22" height="22" src="#{img}/arrow_prev_red.png" alt="&lt;&lt;&nbsp;" />
              </a>
              pg. #{page.to_s}
              <a href="#{can.next}">
                <img border="0" width="22" height="22" src="#{img}/arrow_next_red.png" alt="&nbsp;&gt;&gt;" />
              </a>
              </center>}
            end
          else
            if page.to_s =~ /^1$/; ''
            elsif page.to_s =~ /^2$/
              %{<br /><center>
              <a href="#{can.previous}">
                <img border="0" width="22" height="22" src="#{img}/arrow_prev_red.png" alt="&lt;&lt;&nbsp;" />
              </a>
              pg. #{page.to_s}
              </center>}
            else
              %{<br /><center>
              <a href="#{can.start}">
                <img border="0" width="22" height="22" src="#{img}/arrow_prev_red.png" alt="|&lt;&nbsp;" />
              </a>
              <a href="#{can.previous}">
                <img border="0" width="22" height="22" src="#{img}/arrow_prev_red.png" alt="&lt;&lt;&nbsp;" />
              </a>
              pg. #{page.to_s}
              </center>}
            end
          end
        end
      WOK_SQL
    end
    def tail
      v=SiSU_Env::Info_version.instance.get_version
      <<-WOK_SQL
      def tail
        <<-'WOK'
    <br /><hr /><br />
<table summary="SiSU summary" bgcolor="#ffffff" cellpadding="2" border="0">
  <!-- widget sisu -->
<tr><td valign="top" width="10%">
  <p class="tiny_left"><font color="#666666" size="2">
    <a href="http://www.jus.uio.no/sisu" >
      <img border="0" src="#{@image_src}/sisu.png" alt="SiSU" width="120" height="39" />
    </a>
  </font></p>
</td><td valign="top" width="45%">
<!-- SiSU Rights -->
  <p class="tiny_left"><font color="#666666" size="2">
    Generated by
    <a href="http://www.jus.uio.no/sisu" >
      #{v[:project]}</a> #{v[:version]} #{v[:date]} (#{v[:date_stamp]})
    <br />
    <a href="http://www.jus.uio.no/sisu" >
    <b>#{v[:project]}</b></a> <sup>&copy;</sup> Ralph Amissah
    1993, current 2012.
    All Rights Reserved.
    <br />
    <a href="http://www.jus.uio.no/sisu" >
      #{v[:project]}</a>
    is software for document structuring, publishing and search,
    <br />
    <a href="http://www.jus.uio.no/sisu" >
      www.jus.uio.no/sisu
    </a>
    and
    <a href="http://www.sisudoc.org" >
      www.sisudoc.org
    </a>
  <br />
    <i>w3 since October 3 1993</i>
    <a href="mailto:ralph@amissah.com" >
      ralph@amissah.com
    </a>
  <br />
    mailing list subscription
    <a href="http://lists.sisudoc.org/listinfo/sisu" >
      http://lists.sisudoc.org/listinfo/sisu
    </a>
  <br />
    <a href="mailto:sisu@lists.sisudoc.org" >
      sisu@lists.sisudoc.org
    </a>
  </font></p>
</td><td valign="top" width="45%">
  <p class="tiny_left"><font color="#666666" size="2">
    #{v[:project]} using:
    <br />Standard SiSU markup syntax,
    <br />Standard SiSU meta-markup syntax, and the
    <br />Standard SiSU <u>object citation numbering</u> and system, (object/text positioning system)
  <br />
    <sup>&copy;</sup> Ralph Amissah 1997, current 2012.
    All Rights Reserved.
  </font></p>
</td></tr>
  <!-- widget way better -->
<tr><td valign="top" width="10%">
  <p class="tiny_left"><font color="#666666" size="2">
    <a href="http://www.gnu.org/licenses/gpl.html">
      <img border="0" src="#{@image_src}/gplv3_free_software.png" alt="GPLv3" width="127" height="51" />
    </a>
  </font></p>
</td><td valign="top" width="45%">
  <p class="tiny_left"><font color="#666666" size="2">
    SiSU is released under
    <a href="http://www.gnu.org/licenses/gpl.html">GPL&nbsp;v3</a>
    or later,
    <a href="http://www.gnu.org/licenses/gpl.html">
      http://www.gnu.org/licenses/gpl.html
    </a>
  </font></p>
</td><td valign="top" width="45%">
  <p class="tiny_left"><font color="#666666" size="2">
    #{v[:project]}, developed using
    <a href="http://www.ruby-lang.org/en/">
      Ruby
    </a>
    on
    <a href="http://www.debian.org/">
      Debian/Gnu/Linux
    </a>
    software infrastructure,
    with the usual GPL (or OSS) suspects.
  <br />
    Better - "performance, reliability, scalability, security  &amp; total cost of ownership"
    [not to mention flexibility &amp; choice] use of and adherence to open standards (where practical and fair) and it is software libré.
  <br />
    Get With the Future
    <a href="http://www.jus.uio.no/sisu/">
      Way Better!
    </a>
  </font></p>
</td></tr>
</table>
    <a name="bottom" id="bottom"></a><a name="down" id="down"></a><a name="end" id="end"></a><a name="finish" id="finish"></a><a name="stop" id="stop"></a><a name="credits" id="credits"></a>
    </body></html>
    WOK
      end
      WOK_SQL
    end
    def main1
      <<-'WOK_SQL'
      @tail=tail
      @counter_txt_doc,@counter_txt_ocn,@counter_endn_doc,@counter_endn_ocn=0,0,0,0
      @counters_txt,@counters_endn,@sql_select_body,@sql_select_endnotes='','','',''
      FCGI.each_cgi do |cgi|
        begin # all code goes in begin section
          @search={ :text => [], :endnotes => [] }
          q=CGI.new
          @db=if cgi['db'] =~/\S+/;
            @stub=/#{@db_name_prefix}(\S+)/.match(cgi['db'])[1]
            cgi['db']
          else
            @stub='sisu'
            "#{@db_name_prefix}#{@stub}"
          end
          checked_url,checked_stats,checked_searched,checked_tip,checked_case,checked_echo,checked_sql,checked_all,checked_none,checked_selected,checked_default,selected_db='','','','','','','','',''
          result_type=(cgi['view']=~/text/) \
          ? result_type={ :index => '', :text => 'checked'}
          : result_type={ :index => 'checked', :text => ''}
          @@limit=if cgi['sql_match_limit'].to_s=~/2500/
            checked_sql_limit={ :l1000 => '', :l2500 => 'checked'}
            '2500'
          else
            checked_sql_limit={ :l1000 => 'checked', :l2500 => ''}
            '1000'
          end
          checked_echo='checked' if cgi['echo'] =~/\S/
          checked_stats='checked' if cgi['stats'] =~/\S/
          checked_url='checked' if cgi['url'] =~/\S/ or cgi['u'].to_i==1
          checked_searched='checked' if cgi['searched'] =~/\S/
          checked_tip='checked' if cgi['tip'] =~/\S/
          checked_case='checked' if cgi['casesense'] =~/\S/
          checked_sql='checked' if cgi['sql'] =~/\S/
          if cgi['checks'] =~/check_all/ or cgi['check_all'] =~/\S/ or cgi['a'].to_i==1
            checked_all='checked'
            checked_echo=checked_stats=checked_url=checked_searched=checked_tip=checked_sql='checked'
            checked_none=''
          elsif cgi['checks'] =~/check_none/
            checked_none='checked'
            checked_all=checked_url=checked_stats=checked_searched=checked_tip=checked_echo=checked_sql=''
          elsif cgi['checks'] =~/check_selected/
            checked_selected='checked'
          elsif cgi['checks'] =~/check_default/
            checked_default='checked'
            checked_echo=checked_stats=checked_url='checked'
            checked_searched=checked_tip=checked_case=checked_sql=''
          else
            checked_selected='checked'
            checked_echo=checked_stats=checked_url='checked'
            checked_searched=checked_tip=checked_case=checked_sql=''
          end
      WOK_SQL
    end
    def main2
      <<-'WOK_SQL'
          search_field=cgi['find'] if cgi['find'] # =~/\S+/
          @search_for=Search_request.new(search_field,q) #.analyze               #% search_for
                                                                                 #% searches
          #Canned_search.new(@base,@search_for.text1,cgi)
          if @search_for.text1=~/\S+/ or @search_for.fulltext=~/\S+/ or @search_for.author=~/\S+/ or @search_for.topic_register=~/\S+/  #and search_field =~/\S/
            s1='s1=' + CGI.escape(@search_for.text1) if @search_for.text1=~/\S/
            ft='&ft=' + CGI.escape(@search_for.fulltext) if @search_for.fulltext=~/\S/
            key='key=' + CGI.escape(@search_for.keywords) if @search_for.keywords=~/\S/
            ti='&ti=' + CGI.escape(@search_for.title) if @search_for.title=~/\S/
            au='&au=' + CGI.escape(@search_for.author) if @search_for.author=~/\S/
            tr='&tr=' + CGI.escape(@search_for.topic_register) if @search_for.topic_register=~/\S/
            sj='&sj=' + CGI.escape(@search_for.subject) if @search_for.subject=~/\S/
            dsc='&dsc=' + CGI.escape(@search_for.description) if @search_for.description=~/\S/
            pb='&pb=' + CGI.escape(@search_for.publisher) if @search_for.publisher=~/\S/
            edt='&edt=' + CGI.escape(@search_for.editor) if @search_for.editor=~/\S/
            cntr='&cntr=' + CGI.escape(@search_for.contributor) if @search_for.contributor=~/\S/
            dt='&dt=' + CGI.escape(@search_for.date) if @search_for.date=~/\S/
            ty='&ty=' + CGI.escape(@search_for.type) if @search_for.type=~/\S/
            id='&id=' + CGI.escape(@search_for.identifier) if @search_for.identifier=~/\S/
            src='&src=' + CGI.escape(@search_for.source) if @search_for.source=~/\S/
            lang='&lang=' + CGI.escape(@search_for.language) if @search_for.language=~/\S/
            rel='&rel=' + CGI.escape(@search_for.relation) if @search_for.relation=~/\S/
            cov='&cov=' + CGI.escape(@search_for.coverage) if @search_for.coverage=~/\S/
            cr='&cr=' + CGI.escape(@search_for.rights) if @search_for.rights=~/\S/
            co='&co=' + CGI.escape(@search_for.comment) if @search_for.comment=~/\S/
            ab='&ab=' + CGI.escape(@search_for.abstract) if @search_for.abstract=~/\S/
            dtc='&dtc=' + CGI.escape(@search_for.date_created) if @search_for.date_created=~/\S/
            dti='&dti=' + CGI.escape(@search_for.date_issued) if @search_for.date_issued=~/\S/
            dtm='&dtm=' + CGI.escape(@search_for.date_modified) if @search_for.date_modified=~/\S/
            dta='&dta=' + CGI.escape(@search_for.date_available) if @search_for.date_available=~/\S/
            dtv='&dtv=' + CGI.escape(@search_for.date_valid) if @search_for.date_valid=~/\S/
            fns='&fns=' + CGI.escape(@search_for.filename) if @search_for.filename=~/\S/
            @@canned_search_url=(checked_all =~/checked/) \
            ? "#{@base}?#{s1}#{ft}#{key}#{ti}#{au}#{tr}#{sj}#{dsc}#{pb}#{edt}#{cntr}#{dt}#{ty}#{id}#{src}#{lang}#{rel}#{cov}#{cr}#{co}#{ab}#{dtc}#{dti}#{dtm}#{dta}#{dtv}#{fns}&db=#{cgi['db']}&view=#{cgi['view']}&a=1"
            : "#{@base}?#{s1}#{ft}#{key}#{ti}#{au}#{tr}#{sj}#{dsc}#{pb}#{edt}#{cntr}#{dt}#{ty}#{id}#{src}#{lang}#{rel}#{cov}#{cr}#{co}#{ab}#{dtc}#{dti}#{dtm}#{dta}#{dtv}#{fns}&db=#{cgi['db']}&view=#{cgi['view']}"
            mod=ft=~/\S+/ ? (ft.gsub(/ft/,'s1')) : s1
            @canned_base_url="#{@base}?#{mod}&db=#{cgi['db']}"
            if checked_case=~/\S/
              @search[:text][1]=%{doc_objects.clean~'#{@search_for.text1}'} #s1
              @search[:endnotes][1]=%{endnotes.clean~'#{@search_for.text1}'} #s1
            else
              @search[:text][1]=%{doc_objects.clean~*'#{@search_for.text1}'} #s1
              @search[:endnotes][1]=%{endnotes.clean~*'#{@search_for.text1}'} #s1
            end
            canned_note='search url:'
          else
            @@canned_search_url="#{@base}?db=#{@db}&view=index"
            canned_note='search url example:'
          end
          if search_field =~/\S+/
            analyze_format=search_field.gsub(/\s*\n/,'; ')
          elsif checked_all =~/checked/ or checked_url =~/checked/
            canned_search=@@canned_search_url.scan(/(?:s1|ft|au|ti|fns|tr)=[^&]+/)
            af=canned_search.join('; ')
            af.gsub!(/s1=/,'text: ')
            af.gsub!(/ft=/,'fulltxt: ')
            af.gsub!(/au=/,'author: ')
            af.gsub!(/ti=/,'title: ')
            af.gsub!(/fns=/,'filename: ')
            af.gsub!(/tr=/,'topic_register: ')
            af.gsub!(/%2B/,' ')
            analyze_format=af
            st=af.split(/\s*;\s*/)
            search_field=st.join("\n")
          end
          green=%{<font size="2" color="#004000">}
          canned_search_url_txt=CGI.escapeHTML(@@canned_search_url)
          the_can=%{<font size="2" color="#666666">#{canned_note} <a href="#{@@canned_search_url}">#{canned_search_url_txt}</a></font><br />}
          p_text=p_fulltext=p_keywords=p_title=p_author=p_topic_register=p_subject=p_description=p_publisher=p_editor=p_contributor=p_date=p_type=p_format=p_identifier=p_source=p_language=p_relation=p_coverage=p_rights=p_comment=p_abstract=p_filename=''
          p_filename=%{filename: #{green}#{@search_for.filename}</font><br />} if @search_for.filename =~/\S+/
          p_text=%{text: #{green}#{@search_for.text1}</font><br />} if @search_for.text1 =~/\S+/
          p_fulltext=%{fulltxt: #{green}#{@search_for.fulltext}</font><br />} if @search_for.fulltext =~/\S+/
          p_title=%{title: #{green}#{@search_for.title}</font><br />} if @search_for.title =~/\S+/
          p_author=%{author: #{green}#{@search_for.author}</font><br />} if @search_for.author =~/\S+/
          p_editor=%{editor: #{green}#{@search_for.editor}</font><br />} if @search_for.editor=~/\S+/
          p_contributor=%{contributor: #{green}#{@search_for.contributor}</font><br />} if @search_for.contributor =~/\S+/
          p_date=%{date: #{green}#{@search_for.date}</font><br />} if @search_for.date =~/\S+/
          p_rights=%{rights: #{green}#{@search_for.rights}</font><br />} if @search_for.rights =~/\S+/
          p_topic_register=%{topic_register: #{green}#{@search_for.topic_register}</font><br />} if @search_for.topic_register =~/\S+/
          p_subject=%{subject: #{green}#{@search_for.subject}</font><br />} if @search_for.subject =~/\S+/
          p_keywords=%{keywords: #{green}#{@search_for.keywords}</font><br />} if @search_for.keywords =~/\S+/
          p_identifier=%{identifier: #{green}#{@search_for.identifier}</font><br />} if @search_for.identifier =~/\S+/
          p_type=%{type: #{green}#{@search_for.type}</font><br />} if @search_for.type =~/\S+/
          p_format=%{format: #{green}#{@search_for.format}</font><br />} if @search_for.format =~/\S+/
          p_relation=%{relation: #{green}#{@search_for.relation}</font><br />} if @search_for.relation =~/\S+/
          p_coverage=%{coverage: #{green}#{@search_for.coverage}</font><br />} if @search_for.coverage =~/\S+/
          p_description=%{description: #{green}#{@search_for.description}</font><br />} if @search_for.description =~/\S+/
          p_abstract=%{abstract: #{green}#{@search_for.abstract}</font><br />} if @search_for.abstract =~/\S+/
          p_comment=%{comment: #{green}#{@search_for.comment}</font><br />} if @search_for.comment =~/\S+/
          p_publisher=%{publisher: #{green}#{@search_for.publisher}</font><br />} if @search_for.publisher =~/\S+/
          p_source=%{source: #{green}#{@search_for.source}</font><br />} if @search_for.source =~/\S+/
          p_language=%{language: #{green}#{@search_for.language}</font><br />} if @search_for.language =~/\S+/
          search_note=<<-WOK
      <font size="2" color="#666666">
      <b>database:</b> #{green}#{@db}</font>; <b>selected view:</b> #{green}#{cgi['view']}</font>
      <b>search string:</b> "#{green}#{analyze_format}</font>"<br />
      #{p_text} #{p_fulltext} #{p_keywords} #{p_title} #{p_author} #{p_topic_register} #{p_subject} #{p_description} #{p_publisher} #{p_editor} #{p_contributor} #{p_date} #{p_type} #{p_format} #{p_identifier} #{p_source} #{p_language} #{p_relation} #{p_coverage} #{p_rights} #{p_comment} #{p_abstract} #{p_filename}
      </font>
      WOK
        #eg = %{canned search e.g.:<br /> <a href="#{url}">#{url}</a><br />find: #{analyze}<br />database: #{database}}
        #% dbi_canning
        @header=Form.new(@base,search_field,selected_db,result_type,checked_sql_limit,checked_tip,checked_stats,checked_searched,checked_url,checked_case,checked_echo,checked_sql,checked_all,checked_none,checked_selected,checked_default,search_note,the_can).submission_form #% form
        unless q['s1'] =~/\S/ or q['au'] =~/\S/ or @search[:text][1] =~/\S/
          print "Content-type: text/html\n\n"
          puts (@header+@tail)
        else #% searches
          s1=(@search_for.text1 =~/\S/) \
          ? @search_for.text1
          : 'Unavailable'
          if checked_case=~/\S/
            @search[:text]<<%{doc_objects.clean~'#{CGI.unescape(s1)}'}
            @search[:endnotes]<<%{endnotes.clean~'#{CGI.unescape(s1)}'}
          else
            @search[:text]<<%{doc_objects.clean~*'#{CGI.unescape(s1)}'}
            @search[:endnotes]<<%{endnotes.clean~*'#{CGI.unescape(s1)}'}
          end
          #% dbi_request
          dbi_statement=Dbi_search_statement.new(@conn,@search_for,q,checked_case)
          @text_search_flag=false
          @text_search_flag=dbi_statement.text_search_flag
          s_contents=dbi_statement.contents
          s_endnotes=dbi_statement.endnotes
          @body_main,@endnotes='',''
          @search_regx=nil
          oldtid=0
          if @text_search_flag
            if checked_sql =~/\S/
              sql_select_body=dbi_statement.sql_select_body_format
              sql_select_endnotes=dbi_statement.sql_select_endnotes_format
            else sql_select_body,sql_select_endnotes='',''
            end
            @body_main << '<p><hr><br /><b>Main Text:</b><br />' << sql_select_body
            @endnotes  << '<p><hr><br /><b>Endnotes:</b><br />'  << sql_select_endnotes
          else
          end
          @hostpath="#{@hosturl_files}/#{@stub}"
          @ln='en'
      WOK_SQL
    end
    def dir_structure
      case @opt.dir_structure_by
      when /language/
        <<-'WOK_SQL'
          def path_manifest(fn,ln=nil)
            "#{@hostpath}/#{ln}/manifest/#{fn}.html"
          end
          def path_html_seg(fn,ln=nil)
            "#{@hostpath}/#{ln}/html/#{fn}"
          end
          def path_toc(fn,ln=nil)
            "#{path_html_seg(fn,ln)}/toc.html"
          end
          def path_filename(fn,seg,ln=nil)
            "#{path_html_seg(fn,ln)}/#{seg}.html"
          end
          def path_endnotes(fn,ln=nil)
            "#{path_html_seg(fn,ln)}/endnotes.html"
          end
          def path_html_doc(fn,ln=nil)
            "#{@hostpath}/#{ln}/html/#{fn}.html"
          end
        WOK_SQL
      when /filetype/
        <<-'WOK_SQL'
          def path_manifest(fn,ln=nil)
            "#{@hostpath}/manifest/#{fn}.#{ln}.html"
          end
          def path_html_seg(fn,ln=nil)
            "#{@hostpath}/html/#{fn}"
          end
          def path_toc(fn,ln=nil)
            "#{path_html_seg(fn,ln)}/toc.#{ln}.html"
          end
          def path_filename(fn,seg,ln=nil)
            "#{path_html_seg(fn,ln)}/#{seg}.#{ln}.html"
          end
          def path_endnotes(fn,ln=nil)
            "#{path_html_seg(fn,ln)}/endnotes.#{ln}.html"
          end
          def path_html_doc(fn,ln=nil)
            "#{@hostpath}/html/#{fn}.#{ln}.html"
          end
        WOK_SQL
      else
        <<-'WOK_SQL'
          def path_manifest(fn,ln=nil)
            "#{@hostpath}/#{fn}/sisu_manifest.#{ln}.html"
          end
          def path_html_seg(fn,ln=nil)
            "#{@hostpath}/#{fn}"
          end
          def path_toc(fn,ln=nil)
            "#{path_html_seg(fn,ln)}/toc.#{ln}.html"
          end
          def path_filename(fn,seg,ln=nil)
            "#{path_html_seg(fn,ln)}/#{seg}.#{ln}.html"
          end
          def path_endnotes(fn,ln=nil)
            "#{path_html_seg(fn,ln)}/endnotes.#{ln}.html"
          end
          def path_html_doc(fn,ln=nil)
            "#{path_html_seg(fn,ln)}/scroll.#{ln}.html"
          end
        WOK_SQL
      end
    end
    def main3
      <<-'WOK_SQL'
                    #% text_objects_body
          s_contents.each do |c|                                               #% text body
            location=c['src_filename'][/(.+?)\.(?:ssm\.sst|sst)$/,1]
            file_suffix=c['src_filename'][/.+?\.(_?sst|ssm)$/,1]
            lang=if location =~ /\S+?~(\S\S\S?)$/
              l=location[/\S+?~(\S\S\S?)$/,1]
              location.gsub!(/(\S+?)~\S\S\S?/,'\1')
              l=".#{l}"
            else ''
            end
          #% metadata_found_body
            if c['tid'].to_i != oldtid.to_i
              ti=c['title']
              can_txt_srch=(cgi['view']=~/index/) \
              ? %{<a href="#{@canned_base_url}&fns=#{c['src_filename']}&lang=#{c['language_document_char']}&view=text"><img border="0" width="24" height="16" src="#{@image_src}/b_search.png" alt="search"></a>&nbsp;}
              : %{<a href="#{@canned_base_url}&fns=#{c['src_filename']}&lang=#{c['language_document_char']}&view=index"><img border="0" width="24" height="16" src="#{@image_src}/b_search.png" alt="search"></a>&nbsp;}
              title=%{<span style="background-color: #{@color_heading}"><a href="#{path_toc(location,c['language_document_char'])}"><img border="0" width="15" height="18" src="#{@image_src}/b_toc.png" alt="toc html">&nbsp;#{ti}</a></span> [#{c['language_document_char']}] by #{c['creator_author']} #{can_txt_srch}<a href="#{path_toc(location,c['language_document_char'])}"><img border="0" width="15" height="18" src="#{@image_src}/b_toc.png" alt="toc html"></a>&nbsp;<a href="#{path_manifest(location,c['language_document_char'])}"><img border="0" width="15" height="15" src="#{@image_src}/b_info.png" alt="manifest"></a><br />}  if file_suffix=~/s/ #hmm watch file_suffix
              title=@text_search_flag \
              ? '<br /><hr>'+title
              : '<br />'+title
              @counter_txt_doc+=1
              oldtid=c['tid'].to_i
            else                    title=''
            end
            if @text_search_flag
              if cgi['view']=~/text/ \
              or (cgi['view']!~/index/ and cgi['search'] !~/search db/)      #% txt body
                text=if c['suffix'] !~/1/ #seg
                  if @search_for.text1 =~/\S+/ \
                  or q['s1'] =~/\S+/                         #% only this branch is working !!
                    unescaped_search=if @search_for.text1 =~/\S+/
                      CGI.unescape(@search_for.text1)
                    elsif q['s1'] =~/\S+/
                      CGI.unescape(q['s1'])
                    else nil
                    end
                    @search_regx=if unescaped_search                                     #check
                      search_regex=[]
                      build=unescaped_search.scan(/\S+/).each do |g|
                         (g.to_s =~/(AND|OR)/) \
                         ? (search_regex << '|')
                         : (search_regex << %{#{g.to_s}})
                      end
                      search_regex=search_regex.join(' ')
                      search_regex=search_regex.gsub(/\s*\|\s*/,'|')
                      Regexp.new(search_regex, Regexp::IGNORECASE)
                    else nil
                    end
                  else nil
                  end
                  matched_para=(@search_regx.to_s.class==String && @search_regx.to_s=~/\S\S+/) \
                  ? (c['body'].gsub(/(<a\s+href="https?:\/\/[^><\s]+#{@search_regx}[^>]+?>|#{@search_regx})/mi,%{<span style="background-color: #{@color_match}">\\1</span>}))
                  : c['body']
                  %{<hr><p><font size="2">ocn <b><a href="#{path_filename(location,c['seg'],@ln)}##{c['ocn']}">#{c['ocn']}</a></b>:</font></p>#{matched_para}}
                elsif c['suffix'] =~/1/ #doc
                  %{#{title}<hr><p><font size="2">ocn #{c['ocn']}:#{c['body']}}
                end
                @counter_txt_ocn+=1
                output=title+text
              else #elsif cgi['view']=~/index/                                #% idx body
                if c['suffix'] !~/1/ #seg
                  index=%{<a href="#{path_filename(location,c['seg'],@ln)}##{c['ocn']}">#{c['ocn']}</a>, } if @text_search_flag
                elsif c['suffix'] =~/1/ #doc #FIX
                  index=%{<a href="#{path_html_doc(location,@ln)}##{c['ocn']}">#{c['ocn']}</a>, }
                end
                if c['seg'] =~/\S+/
                  if @text_search_flag
                    @counter_txt_ocn+=1
                    output=title+index
                  end
                else
                  @counter_txt_ocn+=1
                  output=c['suffix'] !~/1/ \
                  ? title+index
                  : %{#{title}#{c['ocn'].sort}, }
                end
              end
            else output=title
            end
            @counters_txt=if @counter_txt_doc > 0
              if checked_stats =~/\S/
                @@lt_t=(@counter_txt_ocn==dbi_statement.sql_match_limit.to_i) ? true : false
                start=(@@offset.to_i+1).to_s
                range=(@@offset.to_i+@counter_txt_ocn.to_i).to_s
                %{<hr /><font size="2" color="#666666">Found #{@counter_txt_ocn} times in the main body of #{@counter_txt_doc} documents [ matches #{start} to #{range} ]</font><br />}
              else ''
              end
            else ''
            end
            @body_main << output #+ details
          end
          #text_objects_endnote
          oldtid = 0
          s_endnotes.each do |e|                                               #% endnotes
            location=e['src_filename'][/(.+?)\.(?:ssm\.sst|sst)$/,1]
            file_suffix=e['src_filename'][/.+?\.(_?sst|ssm)$/,1]
            lang=if location =~ /\S+?~(\S\S\S?)$/
              l=location[/\S+?~(\S\S\S?)$/,1]
              location.gsub!(/(\S+?)~\S\S\S?/,'\1')
              l=".#{l}"
            else ''
            end
            #metadata_found_endnotes
            if @text_search_flag
              if e['metadata_tid'].to_i != oldtid.to_i
                ti=e['title']
                can_txt_srch=(cgi['view']=~/index/) \
                ? %{<a href="#{@canned_base_url}&fns=#{e['src_filename']}&lang=#{e['language_document_char']}&view=text"><img border="0" width="24" height="16" src="#{@image_src}/b_search.png" alt="search"></a>&nbsp;}
                : %{<a href="#{@canned_base_url}&fns=#{e['src_filename']}&lang=#{e['language_document_char']}&view=index"><img border="0" width="24" height="16" src="#{@image_src}/b_search.png" alt="search"></a>&nbsp;}
                title=%{<br /><hr><span style="background-color: #{@color_heading}"><a href="#{path_toc(location,@ln)}"><img border="0" width="15" height="18" src="#{@image_src}/b_toc.png" alt="toc html">&nbsp;#{ti}</a></span> [#{e['language_document_char']}] by #{e['creator_author']} #{can_txt_srch}<a href="#{path_toc(location,@ln)}"><img border="0" width="15" height="18" src="#{@image_src}/b_toc.png" alt="toc html"></a>&nbsp;<a href="#{path_manifest(location,@ln)}"><img border="0" width="15" height="15" src="#{@image_src}/b_info.png" alt="manifest"></a><br />}  if file_suffix=~/s/
                @counter_endn_doc+=1
                oldtid=e['metadata_tid'].to_i
              else title = ''
              end
              if cgi['view']=~/text/ \
              or (cgi['view']!~/index/ and cgi['search'] !~/search db/)      #% txt endnotes
                @counter_endn_ocn+=1
                matched_endnote=(@search_regx.to_s.class==String && @search_regx.to_s=~/\S\S+/) \
                ? matched=e['body'].gsub(/(<a\s+href="https?:\/\/[^><\s]+#{@search_regx}[^>]+?>|#{@search_regx})/mi,%{<span style="background-color: #{@color_match}">\\1</span>})
                : e['body']
                output=%{#{title}<hr><font size="2">note <b><a href="#{path_endnotes(location,@ln)}#_#{e['nr']}">#{e['nr']}</a></b> referred to from ocn <a href="#{path_html_doc(location,@ln)}##{e['ocn']}">#{e['ocn']}</a>:</font> #{matched_endnote}}
              else #elsif cgi['view']=~/index/      #doc #FIX                           #% idx endnotes
                @counter_endn_ocn+=1
                output=%{#{title}<a href="#{path_endnotes(location,@ln)}#_#{e['nr']}">#{e['nr']}</a> [&sect; <a href="#{path_html_doc(location,@ln)}##{e['ocn']}">#{e['ocn']}</a>], }
              end
              @counters_endn=if @counter_endn_doc > 0
                if checked_stats =~/\S/
                  @@lt_e=@counter_endn_ocn==dbi_statement.sql_match_limit.to_i \
                  ? true
                  : false
                  start=(@@offset.to_i+1).to_s
                  range=(@@offset.to_i+@counter_endn_ocn.to_i).to_s
                  %{<font size="2" color="#666666">Found #{@counter_endn_ocn} times in the endnotes of #{@counter_endn_doc} documents [ matches #{start} to #{range} ]</font><br />}
                else ''
                end
              end
              @endnotes << output #+ details
            else @endnotes='' #does not take out yet
            end
          end
          offset=dbi_statement.sql_offset.to_s
          limit=dbi_statement.sql_match_limit.to_s
          @@lt_t ||=false; @@lt_e ||=false
          canned=(@@lt_t or @@lt_e) \
          ? dbi_statement.pre_next(true,@image_src).to_s
          : dbi_statement.pre_next(false,@image_src).to_s
          limit=dbi_statement.sql_match_limit.to_s
          cgi.out{@header.force_encoding("UTF-8") + @counters_txt.force_encoding("UTF-8") + @counters_endn.force_encoding("UTF-8") + canned.force_encoding("UTF-8") + @body_main.force_encoding("UTF-8") + @endnotes.force_encoding("UTF-8") + canned.force_encoding("UTF-8") + @tail.force_encoding("UTF-8")} #% print cgi_output_header+counters+body+endnotes
        end
        rescue Exception => e
          s='<pre>' + CGI::escapeHTML(e.backtrace.reverse.join("\n"))
          s << CGI::escapeHTML(e.message) + '</pre>'
          cgi.out{s}
          next
        ensure # eg. disconnect from server
          @conn.disconnect if @conn
        end
      end
      WOK_SQL
    end
  end
end
__END__
