# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: shared html parts

=end
module SiSU_XHTML_Table
  require_relative 'defaults'                           # defaults.rb
  class TableXHTML
    @@tablehead=0
    @@tablefoot=[] #watch
    def initialize(table)
      @table_obj,@vz=table,SiSU_Env::GetInit.instance.skin
    end
    def table
      table_obj=@table_obj
      if table_obj.obj !~/^<table\s/m
        table_obj=table_rows_and_columns_array(table_obj)
      else p __LINE__; p caller
      end
      table_obj
    end
    def table_rows_and_columns_array(table_obj) # provides basic (x)html table
      table_rows,nr=[],0
      table_obj.obj.split(Mx[:tc_c]).each do |table_row|
        table_row_with_columns=table_row.split(Mx[:tc_p])
        trc,nc=[],0
        table_row_with_columns.each do |c|
          c.gsub!(/^~$/,'') # tilde / empty cell
          c.gsub!(/<:br>/,'<br />')
          trc <<= if table_obj.head_ and nr==0; %{<th width="#{table_obj.widths[nc]}%">#{c}</th>}
          else %{<td width="#{table_obj.widths[nc]}%">#{c}</td>}
          end
          nc+=1
        end
        trc=trc.class==Array ? trc.flatten.join : trc
        trc="      <tr>#{trc}</tr>\n"
        nr+=1
        table_rows << trc
      end
      table_rows=table_rows.flatten.join
      table_obj.obj=%{<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">\n#{table_rows}    </table>}
      table_obj
    end
  end
end
__END__
