# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: plaintext formatting template

=end
module SiSU_PlaintextFormat
  require_relative 'param'                              # param.rb
    include SiSU_Param
  include SiSU_Viz
  class ParagraphNumber
    def initialize(paranum)
      @paranum=/(\d+)/m.match(paranum.to_s)[1]
    end
    def display
      @paranum.gsub(/(\d+)/,"\n[\\1]")
    end
    def name #unused
      @paranum.gsub(/(\d+)/,'\1')
    end
    def goto #unused
      @paranum.gsub(/(\d+)/,'"#\1"')
    end
  end
  class FormatTextObject
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      if t_o.class==Hash
        @txt =t_o[:txt]            || nil
        @lnk_url =t_o[:lnk_url]    || nil
        @lnk_txt =t_o[:lnk_txt]    || nil
      else
        p t_o.class
        p caller
      end
      rgx=/^#{Rx[:lv]}/
      @txt.gsub!(rgx,'') if @txt =~rgx
      rgx=/#{Mx[:en_a_o]}[\d*+]+\s+(.+?)#{Mx[:en_a_c]}/
      @txt.gsub!(rgx,'\1') if @txt =~rgx
      @vz=SiSU_Env::GetInit.instance.skin
    end
    def scr_endnote_body
      "<endnote>#{@txt}</endnote> "
    end
    def heading_body1
    end
    def heading_body2
    end
    def heading_body3
    end
    def heading_body4
    end
    def heading_body5
    end
    def heading_body6
    end
  end
  class XML
  end
end
__END__
