#!/usr/bin/env ruby
# encoding: utf-8
=begin

 * Name: modify.rb

 * Description: A conversion script for canned substitutions,
   a fairly generic simple tool that can be used to store other canned conversions,
   (used here for altering SiSU markup or the SiSU program)

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

 * Packaged with: SiSU a framework for document structuring, publishing & search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

=end
module SiSU_Modify
  class Operations
    def initialize(cf,files)
      @cf,@files=cf,files
      @description="This is a script that contains canned text conversions for reuse"
      pwd=Dir.pwd
      @mod_inst='modify_instructions.rb'
      @modify_instructions_script="#{pwd}/#{@mod_inst}"
      if FileTest.file?(@modify_instructions_script) ==true
        puts <<-WOK
  autoload script: "#{@modify_instructions_script}"
  used by "ruby  #{__FILE__} --convert" if
  "Extracted.new.modify.modules_and_classes" is used
  (see "matches_and_replaces")
  EDIT this file manually
  [to rebuild run: "ruby #{__FILE__} --build-gsub"]

           WOK
      else
        puts <<-WOK
  autoload script does not exist: "#{@modify_instructions_script}"
  needed for "ruby  #{__FILE__} --convert" if
  "Extracted.new.modify.modules_and_classes" is used
  (see "matches_and_replaces")
  try run: "ruby #{__FILE__} --build-gsub"

           WOK
      end
      autoload :Extracted, "./#{@mod_inst}"
    end
    def matches_and_replaces #edit manually
      [
       #Extracted.new.modify.modules_and_classes,
       #Extracted.new.modify.modules,
       #Extracted.new.modify.classes,
       #modify.dates,
       #modify.modules,
       #modify.classes,
       #modify.misc,
      ]
    end
    def message(text)
      response=''
      while response !~/yes/
        print %{
    #{text}
    To continue type "yes" [to exit type "no" or "quit"]: }
        response=File.new('/dev/tty').gets.strip
        exit if response =~/^(?:quit|no)$/
      end
    end
    def help
    print <<WOK

#{@description}

note converting twice in a single direction will result
in markup inconsistency

modify.rb --convert
  performs the current conversion that is set in method "matches_and_replaces",
  this needs to be edited manually, as do the substitutions to be made on the
  files matched in the settings [handle with care]

modify.rb --report
  reports on the names of modules and classes in each file requested
  (the defalt is all)

modify.rb --build-gsub
  creates modify_instructions.rb methods for substitutions of methods and
  classes for editing

WOK
      exit
    end
    #%% substitutions to be made
    #   [//,                                                                   ''],
    #def rename_default
    #  message(%q{rename SiSU modules, classes, date})
    #  [
    #    [/1997\s+-\s+2012/,                                                    '1997 - 2012'],
    #  ]
    #end
    def modify
      def misc
        [
          #[//,                                                                  ''],
        ]
      end
      def dates
        [
          [/1997\s+-\s+2011/,                                                    '1997 - 2012'],
        ]
      end
      def modules
        [
         #[//,                                                                   ''],
        ]
      end
      def classes
        [
         #[//,                                                                   ''],
        ]
      end
      self
    end
    def convert
      message("WARNING, proceed at your own risk,\npermanent changes requested for the above named files\n  best that you check (manually) what this file is set to do\n  conversions set are at the top of the file")
      if matches_and_replaces.length > 0
        @files.each do |i|
          @new,@matched,@empty1,@empty2=true,false,false,false
          file=File.open(i,'r')
          cont=file.readlines
          file.close
          @file=File.new(i,'w')
          cont.each do |t|
            matches_and_replaces.each do |match_and_replace|
              match_and_replace.each do |m,r|
                if t =~m
                  p m.to_s + ' -> ' + r
                  puts "in:  #{t}"
                  t.gsub!(m,r) if m and r
                  puts "out: #{t}"
                end
              end
            end
            if t=~/^\s*$/; @empty1=true
            else           @empty1=false
            end
            @file.puts t unless (@empty1==true and @empty2==true)
            if t=~/^\s*$/; @empty2=true
            else           @empty2=false
            end
          end
          @file.close
        end
      end
    end
    def report_modules_and_classes
      @f=nil
      @structure={}
      @arr={mod: [], cl: []}
      @files.each do |f|
        @new,@matched,@empty1,@empty2=true,false,false,false
        file=File.open(f,'r')
        cont=file.readlines
        file.close
        cont.each do |t|
          if f != @f
            @f=f
            @mod=nil
            #puts "---\n#{@f}"
            @structure[@f]={}
          end
          if t =~/^\s*module\s+\S+/
            @mod=t.match(/^\s*module\s+(\S+)/)[1]
            #puts '  ' +   @mod
            @arr[:mod] << @mod
            @structure[@f].store(@mod,[])
            #@structure[@f] = {@mod => []}
          end
          if t =~/^\s*class\s+\S+/
            cl=t.match(/^\s*class\s+(\S+)/)[1]
            #puts '    ' + cl
            @arr[:cl] << cl
            @structure[@f][@mod] << cl
          end
        end
      end
      @structure.sort.each do |fl,modules|
         puts "---\n" + fl
         modules.sort.each do |mod,classes|
           puts '  ' + mod
           classes.sort.each do |cl|
             puts '    ' + cl
           end
         end
      end
      puts '---'
      puts 'number of modules: ' + @arr[:mod].length.to_s + ', unique: ' + @arr[:mod].uniq.length.to_s
      puts 'number of classes: ' + @arr[:cl].length.to_s + ', unique: ' + @arr[:cl].uniq.length.to_s
    end
    def build_search_and_replace_method_for_modules_and_classes
      @f=nil
      @structure={}
      @arr={mod: [], cl: []}
      @files.each do |f|
        @new,@matched,@empty1,@empty2=true,false,false,false
        file=File.open(f,'r')
        cont=file.readlines
        file.close
        cont.each do |t|
          if f != @f
            @f=f
            @mod=nil
            #puts "---\n#{@f}"
            @structure[@f]={}
          end
          if t =~/^\s*module\s+\S+/
            @mod=t.match(/^\s*module\s+(\S+)/)[1]
            #puts '  ' +   @mod
            @arr[:mod] << @mod
            @structure[@f].store(@mod,[])
            #@structure[@f] = {@mod => []}
          end
          if t =~/^\s*class\s+\S+/
            cl=t.match(/^\s*class\s+(\S+)/)[1]
            #puts '    ' + cl
            @arr[:cl] << cl
            @structure[@f][@mod] << cl
          end
        end
      end
      puts 'number of modules: ' + @arr[:mod].length.to_s + ', unique: ' + @arr[:mod].uniq.length.to_s
      puts 'number of classes: ' + @arr[:cl].length.to_s + ', unique: ' + @arr[:cl].uniq.length.to_s
      method_modules_and_classes=[]
      method_modules_and_classes <<<<-WOK
#module SiSU_MC
  class Extracted
    def modify
      WOK
      #% modules_and_classes
      method_modules_and_classes <<<<-WOK
      def modules_and_classes
        [
      WOK
      @structure.sort.each do |fl,modules|
         method_modules_and_classes << ' '*8 +  "##% -- " + fl
         modules.sort.each do |mod,classes|
           method_modules_and_classes << ' '*8 + '# ' + "[/#{mod}/," + ' '*(67 - mod.length) + "'#{mod}'],"
           classes.uniq.sort.each do |cl|
             method_modules_and_classes << ' '*8 + '#   ' + "[/#{cl}/," + ' '*(65 - cl.length) + "'#{cl}'],"
           end
         end
      end
      method_modules_and_classes <<<<-WOK
        ]
      end
      WOK
      #% modules
      method_modules_and_classes <<<<-WOK
      def modules
        [
      WOK
      method_modules_and_classes << ' '*8 + '# ' + 'number of modules: ' + @arr[:mod].length.to_s +
        ', unique: ' + @arr[:mod].uniq.length.to_s
      @arr[:mod].uniq.sort.each do |mod|
        method_modules_and_classes << ' '*8 + '# ' + "[/#{mod}/," + ' '*(67 - mod.length) + "'#{mod}'],"
      end
      method_modules_and_classes <<<<-WOK
        ]
      end
      WOK
      #% classes
      method_modules_and_classes <<<<-WOK
      def classes
        [
      WOK
      method_modules_and_classes << ' '*8 + '# ' + 'number of classes: ' + @arr[:cl].length.to_s +
        ', unique: ' + @arr[:cl].uniq.length.to_s
      @arr[:cl].uniq.sort.each do |cl|
        method_modules_and_classes << ' '*8 + '# ' + "[/#{cl}/," + ' '*(67 - cl.length) + "'#{cl}'],"
      end
      method_modules_and_classes <<<<-WOK
        ]
      end
      WOK
      method_modules_and_classes <<<<-WOK
      self
    end
  end
#end
      WOK
      #method_modules_and_classes.each{|x| puts x}
      if FileTest.file?(@modify_instructions_script) ==true
        message("WARNING << #{@mod_inst} >> exists (and may have been edited). The existing << #{@mod_inst} >> will be overwritten if you proceed.")
      end
      instructs=File.new(@modify_instructions_script,'w')
      method_modules_and_classes.each do |x|
        puts x
        instructs.puts x
      end
      instructs.close
    end
    def action
      if @files and @files.length > 0
        p @files
        mr=nil
        #%% changes to make m match, r replace      -------------------------->
        if @cf =~/--help/; help
        else
          case @cf
          when /--convert/;    convert
          when /--report/;     report_modules_and_classes
          when /--build-gsub/; build_search_and_replace_method_for_modules_and_classes
          else help
          end
          #act
        end
      else puts "this routine makes permanent changes to the contents of the files matched, as instructed within [no matches]"
      end
    end
  end
end
#% files to match for this conversion set  ------------------------->
f=$* #; p $*
cf=f[0].to_s
f.shift
match_and_replace=Array.new
unless f.length > 0
  f=if cf == '--report' \
  or cf == '--build-gsub'
    Dir.glob("[a-zA-Z]*.rb")  #restrict to ruby files
  else
    Dir.glob("[a-zA-Z]*")
  end
  f=f.sort.delete_if { |x| x == __FILE__ or x == 'modify_instructions.rb' }
end
SiSU_Modify::Operations.new(cf,f).action
__END__
#f=Dir.glob("{bin,conf,data,lib}/**/*.rb")     #sisu development
#f=Dir.glob("[^_]/**/*")                       #all files subdirectories beneath pwd except those starting with _
