# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, error screen reporting

=end
module SiSU_Errors
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  include SiSU_Screen
  class Info_error <Create_file
    def initialize(error,errorlist,cmd,fns='')
      @fns,@cmd,@error,@errorlist=fns,cmd,error,errorlist
      @cmd=if cmd and cmd =~/c/; 'Vc'
      else                       'V'
      end
    end
    def error                                                                    #creates file errorlog.sisu in pwd of last error reported
      file=if @fns; SiSU_Env::Create_file.new(@cmd,@fns).file_error
      else          File.new('/tmp/errorlog.sisu','w+')
      end
      file << @fns << "\n" << @error << "\n" << @errorlist
      file.close
      if @cmd=~/[vVM]/; STDERR.puts SiSU_Screen::Ansi.new('',$!,$@).rescue
      else             SiSU_Screen::Ansi.new('',"rescued, exception reaised, silenced").puts_grey
      end
    end
  end
end

