# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_book_index
  class Book_index
    def initialize(md,data,env=nil)
      @md,@data,@env=md,data,env
      @rgx_idx=/#{Mx[:idx_o]}(?:.+?)#{Mx[:idx_c]}\s*/
      #@rgx_idx=/\s*#{Mx[:idx_o]}(?:.+?)#{Mx[:idx_c]}\s*/
      @rgx_idx_ocn_init=/#{Mx[:idx_o]}(.+?)#{Mx[:idx_c]}\s*#{Mx[:id_o]}~(\d+)\S+?#{Mx[:id_c]}/
      @rgx_idx_ocn_seg=/(.+?)~(\d+)~(\S+)/
      @rgx_idx_ocn=/(.+?)~(\d+)/
      @rxp_lv1=/^#{Mx[:lv_o]}1:/
      @rxp_lv2=/^#{Mx[:lv_o]}2:/
      @rxp_lv3=/^#{Mx[:lv_o]}3:/
      @rxp_seg=/^#{Mx[:lv_o]}4:(\S+?)#{Mx[:lv_c]}/
      @rxp_to=Regexp.new("#{Mx[:id_o]}~(\\d+);(?:[oh]|[0-6]:)\\d+;\\w\\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}|#{Mx[:id_o]}\S+?#{Mx[:id_c]}$")
      @env ||=SiSU_Env::Info_env.new(@md.fns)
    end
    def indexing_song
      data=@data
      data,sisu_markup_idx,html_idx=extract_book_index(data)
      data=clean_and_insert_index(data,sisu_markup_idx)
      [data,sisu_markup_idx,html_idx]
    end
    def extract_book_index(data)
      tuned_file=[]
      idx_array=[]
      data.each do |para|
        if para =~@rxp_seg; @seg=para[@rxp_seg,1]
        end
        idx_array << @rgx_idx_ocn_init.match(para)[0].gsub(@rgx_idx_ocn_init,"\\1~\\2~#{@seg}") if para =~ @rgx_idx_ocn_init
        tuned_file << para if para
      end
      idx_array=construct_idx_array(idx_array) if idx_array.length > 0
      if idx_array.length > 0
        the_idx=construct_book_index(idx_array)
        #screen_print(the_idx) if @md.cmd.inspect =~/V/
        sisu_markup_idx,html_idx=nil,nil
        if @md.book_idx
          idx=index(the_idx)
          output_html_idx(idx[:html])
          html_idx=idx[:html]
          sisu_markup_idx=idx[:sst]
        end
      end
      [tuned_file,sisu_markup_idx,html_idx]
    end
    def construct_idx_array(idx_array)
      idx_lst=[]
      idx_array.each do |idx|
        idx_list,ocn,seg=@rgx_idx_ocn_seg.match(idx)[1..3]
        idx_lst <<=if idx_list =~/;/
          g=idx_list.scan(/[^;]+/)
          idxl=[]
          g.each do |i|
            i.strip!
            idxl << { :rough_idx => i, :ocn => ocn, :seg => seg }
          end
          idxl
        else { :rough_idx => idx_list, :ocn => ocn, :seg => seg }
        end
      end
      idx_lst.flatten!
      idx_lst
    end
    def construct_book_index(idx_array)
      @the_idx={}
      idx_array.each do |idx|
        idx_lst=idx[:rough_idx].scan(/[^|:]+/)
        idx_lst[0].strip!
        if idx_lst[0] =~/.+?\+\d+/
          use,plus=/(.+?)\+(\d+)/.match(idx_lst[0])[1,2]
        else use=idx_lst[0]
        end
        use=use[0].chr.capitalize + use[1,use.length]
        @the_idx[use]={} unless @the_idx[use] and defined? @the_idx[use]
        idx_lst.each do |i|
          i.strip!
          i,r=/(.+?)\+(\d+)/.match(i)[1,2] if i =~/.+?\+\d+/
          x=if idx_lst.length == 1 or idx_lst[0].gsub(/\+\d+/,'') == i
            @the_idx[use]['term_node_lev1']=[] unless @the_idx[use]['term_node_lev1'] and defined? @the_idx[use]['term_node_lev1']
            x=if r
              @the_idx[use]['term_node_lev1'] << { :ocn => idx[:ocn], :range => "#{idx[:ocn]}-#{idx[:ocn].to_i+r.to_i}", :seg => idx[:seg] }
              "#{i} #{idx[:ocn]}-#{idx[:ocn].to_i+r.to_i}"
            else
              @the_idx[use]['term_node_lev1'] << { :ocn => idx[:ocn], :seg => idx[:seg] }
              "#{i} #{idx[:ocn]}"
            end
          else
            @the_idx[use]['term_node_lev2']={} unless @the_idx[use]['term_node_lev2'] and defined? @the_idx[use]['term_node_lev2']
            @the_idx[use]['term_node_lev2'][i]=[] unless @the_idx[use]['term_node_lev2'][i] and defined? @the_idx[use]['term_node_lev2'][i]
            x=if r
              @the_idx[use]['term_node_lev2'][i] << { :ocn => idx[:ocn], :range => "#{idx[:ocn]}-#{idx[:ocn].to_i+r.to_i}", :seg => idx[:seg] }
              "#{idx_lst[0]}:#{i} #{idx[:ocn]}-#{idx[:ocn].to_i+r.to_i}"
            else
              @the_idx[use]['term_node_lev2'][i] << { :ocn => idx[:ocn], :seg => idx[:seg] }
              "#{idx_lst[0]}:#{i} #{idx[:ocn]}"
            end
          end
        end
      end
      the_idx=@the_idx.sort
      #p the_idx; p '-----'
      the_idx
    end
    def index(the_idx)
      @x=1
      @idx={}
      @idx[:sst],@idx[:html]=[],[]
      @idx[:sst] << "\n\n#{Mx[:br_page_new]}"
      @idx[:sst] << "\n\n#{Mx[:lv_o]}2:#{Mx[:lv_c]}Index #{Mx[:id_o]}~0;0:0;x0#{Mx[:id_c]}"
      @idx[:sst] << "\n\n#{Mx[:lv_o]}4:idx#{Mx[:lv_c]} [Index] #{Mx[:pa_non_object_dummy_heading]} #{Mx[:id_o]}~0;0:0;x0#{Mx[:id_c]}"
      alph=%W[9 A B C D E F G H I J K L M N O P Q R S T U V W X Y Z]
      @idx[:html] << '<p>'
      alph.each do |x|
        @idx[:html] << if x =~/[0-9]/; ''
        else
          %{<a href="##{x}">#{x}</a>,&nbsp;}
        end
      end
      @idx[:html] << '</p>'
      letter=alph.shift
      @idx[:html] << %{\n<p class="book_index_lev1"><a name="numeral"></a></p>}
      the_idx.each do |i|
        i.each do |x|
          if x.class == String
            f=/^(\S)/.match(x)[1]
            if letter < f
              while letter < f
                if alph.length > 0
                  letter=alph.shift
                  @idx[:html] << %{\n<p class="letter"><a name="#{letter}">#{letter}</a></p><p class="book_index_lev1"><a name="#{letter.downcase}"> </a></p>}
                else break
                end
              end
            end
            @idx[:sst] << %{\n\n#{Mx[:fa_bold_o]}#{x},#{Mx[:fa_bold_c]} }
            aname=x.gsub(/\s+/,'_')
            @idx[:html] << %{\n<p class="book_index_lev1"><a name="#{aname}"><b>#{x}</b></a>, }
            @o=@idx[:sst].index(@idx[:sst].last) #@o=@idx[:sst].length - 1
            @q=@idx[:html].index(@idx[:html].last) #@o=@idx[:html].length - 1
            print "\n" + x + ', ' if @md.cmd =~/V/
          elsif x.class == Array
            p 'array error? -->'
            print x
          elsif x.class == Hash
            if x['term_node_lev1'].class == Array
              x['term_node_lev1'].each do |a|
                if a[:range]
                  @idx[:sst][@o]=@idx[:sst][@o] + %{#{Mx[:lnk_o]}#{a[:range]}#{Mx[:lnk_c]}#{@env.url.root}/#{@md.fnb}/#{a[:seg]}.html##{a[:ocn]}, }
                  @idx[:html][@q]=@idx[:html][@q] + %{<a href="#{a[:seg]}.html##{a[:ocn]}">#{a[:range]}</a>, }
                  print a[:range] + ', ' if @md.cmd =~/V/
                elsif a[:ocn]
                  @idx[:sst][@o]=@idx[:sst][@o] + %{#{Mx[:lnk_o]}#{a[:ocn]}#{Mx[:lnk_c]}#{@env.url.root}/#{@md.fnb}/#{a[:seg]}.html##{a[:ocn]}, }
                  @idx[:html][@q]=@idx[:html][@q] + %{<a href="#{a[:seg]}.html##{a[:ocn]}">#{a[:ocn]}</a>, }
                  print a[:ocn] + ', ' if @md.cmd =~/V/
                else p 'error'
                end
              end
              @idx[:html][@q]=@idx[:html][@q] + '</p>'
            end
            if x['term_node_lev2']
              m=x['term_node_lev2']
              m=m.sort
              m.each do |k,y|
                if k !~/term_node_lev1/
                  @idx[:sst][@o]=@idx[:sst][@o] + %{#{k}, }
                  @idx[:html][@q]=@idx[:html][@q] + %{\n<p class="book_index_lev2">#{k}, }
                  print "\n\t" + k + ', ' if @md.cmd =~/V/
                  y.each do |z|
                    if z[:range]
                      @idx[:sst][@o]=@idx[:sst][@o] + %{#{Mx[:lnk_o]}#{z[:range]}#{Mx[:lnk_c]}#{@env.url.root}/#{@md.fnb}/#{z[:seg]}.html##{z[:ocn]}, }
                      @idx[:html][@q]=@idx[:html][@q] + %{<a href="#{z[:seg]}.html##{z[:ocn]}">#{z[:range]}</a>, }
                      print z[:range] + ', ' if @md.cmd =~/V/
                    elsif z[:ocn]
                      @idx[:sst][@o]=@idx[:sst][@o] + %{#{Mx[:lnk_o]}#{z[:ocn]}#{Mx[:lnk_c]}#{@env.url.root}/#{@md.fnb}/#{z[:seg]}.html##{z[:ocn]}, }
                      @idx[:html][@q]=@idx[:html][@q] + %{<a href="#{z[:seg]}.html##{z[:ocn]}">#{z[:ocn]}</a>, }
                      print z[:ocn] + ', ' if @md.cmd =~/V/
                    else p 'error'
                    end
                  end
                  @idx[:html][@q]=@idx[:html][@q] + '</p>'
                end
              end
            end
            @idx[:sst][@o]=@idx[:sst][@o] + " #{Mx[:id_o]}~0;0:0;x#{@x}#{Mx[:id_c]}"
            @x +=1
          end
        end
      end
      print "\n" if @md.cmd =~/V/
      @idx
    end
    def screen_print(the_idx)
      the_idx.each do |i|
        i.each do |x|
          if x.class == String
            print "\n" + x + ', '
          elsif x.class == Array
            p 'array error? -->'
            print x
          elsif x.class == Hash
            if x['term_node_lev1'].class == Array
              x['term_node_lev1'].each do |a|
                if a[:range]
                  print a[:range] + ', '
                elsif a[:ocn]
                  print a[:ocn] + ', '
                else p 'error'
                end
              end
            end
            if x['term_node_lev2']
              m=x['term_node_lev2']
              m=m.sort
              m.each do |k,y|
                if k !~/term_node_lev1/
                  print "\n\t" + k + ', '
                  #p y
                  y.each do |z|
                    if z[:range]
                      print z[:range] + ', '
                    elsif z[:ocn]
                      print z[:ocn] + ', '
                    else p 'error'
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
    def output_html_idx(html_idx)
      if @md.book_idx
        path="#{@env.path.output}/#{@md.fnb}"
        Dir.mkdir(path) unless FileTest.directory?(path)
        html_index_file=File.new("#{path}/#{@md.fn[:book_idx_html]}",'w')
        html_idx.each {|x| html_index_file << x }
        html_index_file.close
      end
    end
    def clean_and_insert_index(data,sisu_markup_idx)
      tuned_file=[]
      data.each do |para|
        para.gsub!(/\n*#{@rgx_idx}/m,'')
        tuned_file << para
        if para =~/#{Mx[:br_endnotes]}/ and sisu_markup_idx
          sisu_markup_idx.each do |idx|
            tuned_file << idx
          end
        end
      end
      tuned_file
    end
    def clean_index(data)
      tuned_file=[]
      data.each do |para|
        para.gsub!(/\n*#{@rgx_idx}/m,'')
        tuned_file << para
      end
      tuned_file
    end
  end
end
__END__
