# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: texinfo formatting template

=end
module TexInfoFormat
  @@table_pg_break_counter=1
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  class Texinfo
    @@tex_backslash="\\\\"
    @@tex_1='\\\\~' #?? debug
    @@tabular="{tabular}"
    @@tex_pattern_margin_number="\\\\marginpar.+?\s+"
    @@dp=nil
    def initialize(data=nil,md=nil,three=nil)
      @para=@one=data
      @md=md
      @vz=SiSU_Env::Get_init.instance.skin
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
    end
    def head
      t=Time.now
      year=t.year
      filename=%{#{@md.fns}}[/(.+?)\.\w\w\d\d$/,1]
      title=Texinfo.new(@md.title).spec_char
      title=title.gsub(/<(br|p|i)>|<\/\s*(br|p|i)>|<(br|p)\s*\/>/," #{@@tex_backslash*2} ")
      title.gsub!(/\$/,"\\$")
      title.gsub!(/[,]\s*/,' - ')
      if @md.subtitle
        subtitle=Texinfo.new(@md.subtitle).spec_char
        subtitle=subtitle.gsub(/<(br|p|i)>|<\/\s*(br|p|i)>|<(br|p)\s*\/>/," #{@@tex_backslash*2} ")
        subtitle.gsub!(/\$/,"\\$")
        subtitle.gsub!(/[,]\s*/,' - ')
        subtitle="@subtitle @value{VERSION}, @value{UPDATED}\n" #bugwatch
      end
      subtitle ||=''
      author=@md.dc_creator if @md.dc_creator
      author ||=''
      author.gsub!(/[\*]/,'') #if author
      v=SiSU_Env::Info_version.new.get_version
      #(version @value{VERSION} #{v[:version]}, @value{UPDATED} #{v[:date]})
      head =<<WOK
\\input texinfo   @c -*-texinfo-*-
@comment $Id$
@comment %**start of header
@setfilename #{@md.fnb}.info
@settitle #{title} @value{VERSION}
@syncodeindex pg cp
@comment %**end of header
@c %% 2
@copying
SiSU texinfo of #{title}

Copyright @copyright{} #{year} #{author}.

@quotation
Copyright #{author}, generated by ``SiSU''
@end quotation
@end copying

@dircategory SiSU Texinfo
@direntry
* sisu: SiSU texinfo file.
@end direntry
WOK
      if @md.subtitle
        titlepage=<<WOK
@c %% 3
@titlepage
@title #{title} #{subtitle}
@author #{author}
@page
@vskip 0pt plus 1filll
@insertcopying
@end titlepage
@contents
WOK
      else
        titlepage=<<WOK
@c %% 3
@titlepage
@title #{title}
@value{VERSION}, @value{UPDATED}
@author #{author}
@page
@vskip 0pt plus 1filll
@insertcopying
@end titlepage

@contents
WOK
      end
      "#{head}#{titlepage}"
    end
    def topnode
      @one=Texinfo.new(@one).spec_char
      @one=@one.gsub(/<(br|p|i)>|<\/\s*(br|p|i)>|<(br|p)\s*\/>/," #{@@tex_backslash*2} ")
      @one.gsub!(/\$/,"\\$")
      @one.gsub!(/[,]\s*/,' - ')
      "@c %% 4\n" +
        "@ifnottex\n" +
        "@node Top\n" +
        "@top #@one\n\n" +
        "@insertcopying\n" +
        "@end ifnottex\n\n" +
        "@menu\n"
    end
    def dublincore
      title=Texinfo.new(@md.title).spec_char if @md.title
      subtitle=Texinfo.new(@md.subtitle).spec_char if @md.subtitle
      dc_title="#{title} - #{subtitle}"
      dc_creator=Texinfo.new(@md.dc_creator).spec_char if @md.dc_creator
      dc_subject=Texinfo.new(@md.dc_subject).spec_char if @md.dc_subject
      dc_description=Texinfo.new(@md.dc_description).spec_char if @md.dc_description
      dc_publisher=Texinfo.new(@md.dc_publisher).spec_char if @md.dc_publisher
      dc_contributor=Texinfo.new(@md.dc_contributor).spec_char if @md.dc_contributor
      dc_date=Texinfo.new(@md.dc_date).spec_char if @md.dc_date
      dc_date_created=Texinfo.new(@md.dc_date_created).spec_char if @md.dc_date_created
      dc_date_issued=Texinfo.new(@md.dc_date_issued).spec_char if @md.dc_date_issued
      dc_date_available=Texinfo.new(@md.dc_date_available).spec_char if @md.dc_date_available
      dc_date_valid=Texinfo.new(@md.dc_date_valid).spec_char if @md.dc_date_valid
      dc_date_modified=Texinfo.new(@md.dc_date_modified).spec_char if @md.dc_date_modified
      dc_type=Texinfo.new(@md.dc_type).spec_char if @md.dc_type
      dc_format=Texinfo.new(@md.dc_format).spec_char if @md.dc_format
      dc_identifier=Texinfo.new(@md.dc_identifier).spec_char if @md.dc_identifier
      dc_source=Texinfo.new(@md.dc_source).spec_char if @md.dc_source
      dc_language=Texinfo.new(@md.dc_language[:name]).spec_char if @md.dc_language[:name]
      #language_original=Texinfo.new(@md.language_original[:name]).spec_char if @md.language_original[:name]
      dc_relation=Texinfo.new(@md.dc_relation).spec_char if @md.dc_relation
      dc_coverage=Texinfo.new(@md.dc_coverage).spec_char if @md.dc_coverage
      dc_rights=Texinfo.new(@md.dc_rights).spec_char if @md.dc_rights
      dc_title="Title: #{dc_title}\n\n" if dc_title
      dc_creator="Creator: #{dc_creator}\n\n" if dc_creator
      dc_subject="Subject: #{dc_subject}\n\n" if dc_subject
      dc_description="Description: #{dc_description}\n\n" if dc_description
      dc_publisher="Publisher: #{dc_publisher}\n\n" if dc_publisher
      dc_contributor="Contributor: #{dc_contributor}\n\n" if dc_contributor
      dc_date="Date: #{dc_date}\n\n" if dc_date
      dc_date_created="Date Created: #{dc_date_created}\n\n" if dc_date_created
      dc_date_issued="Date Issued: #{dc_date_issued}\n\n" if dc_date_issued
      dc_date_available="Date Available: #{dc_date_available}\n\n" if dc_date_available
      dc_date_valid="Date Valid: #{dc_date_valid}\n\n" if dc_date_valid
      dc_date_modified="Date Modified: #{dc_date_modified}\n\n" if dc_date_modified
      dc_format="Format: #{dc_format}\n\n" if dc_format
      dc_identifier="Identifier: #{dc_identifier}\n\n" if dc_identifier #watch
      dc_source="Source: #{dc_source}\n\n" if dc_source
      dc_language="Language: #{dc_language}\n\n" if dc_language
      dc_relation="Relation: #{dc_relation}\n\n" if dc_relation
      dc_coverage="Coverage: #{dc_coverage}\n\n" if dc_coverage
      dc_rights="Rights: #{dc_rights}\n\n" if dc_rights
      "@node Dublin Core\n" +
        "@unnumbered Dublin Core\n" +
        "@cindex chapter, Dublin Core\n\n" +
        "#{dc_title}" +
        "#{dc_creator}" +
        "#{dc_subject}" +
        "#{dc_description}" +
        "#{dc_publisher}" +
        "#{dc_contributor}" +
        "#{dc_date}" +
        "#{dc_date_created}" +
        "#{dc_date_issued}" +
        "#{dc_date_available}" +
        "#{dc_date_valid}" +
        "#{dc_date_modified}" +
        "#{dc_format}" +
        "#{dc_identifier}" +
        "#{dc_source}" +
        "#{dc_language}" +
        "#{dc_relation}" +
        "#{dc_coverage}" +
        "#{dc_rights}" +
        "\n\n"
    end
    def tail
     "@c %% 6\n" +
      "@node Index\n" +
      "@unnumbered Index\n" +
      "@printindex cp\n\n" +
      "@bye"
    end
    def clean(para)
      para.gsub!(/#{Mx[:id_o]}\\~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/,'<\1>')
      para.gsub!(/\s*[,:]\s*/,' - ')
      para.gsub!(/<:#>/,'')
      para.strip!
      para
    end
    def menu
      para=clean(@para)
      para=para.gsub(/@footnote\{.+?\}\s+/,'')
      "* #{para}::"
    end
    def level1
      @para.gsub!(/#{Mx[:lv_o]}1:\S*?#{Mx[:lv_c]}\s*/,'')
      para=clean(@para)
      nd=para.gsub(/@footnote\{.+?\}\s+/,'')
      para="@node #{nd}\n@unnumbered #{para}\n@cindex chapter, #{nd}\n"
      @para.gsub!(/.+/,"#{para}")
    end
    def level2
      @para.gsub!(/#{Mx[:lv_o]}2:\S*?#{Mx[:lv_c]}\s*/,'')
      para=clean(@para)
      nd=para.gsub(/@footnote\{.+?\}\s+/,'')
      para="@node #{nd}\n@unnumbered #{para}\n@cindex chapter, #{nd}\n"
      @para.gsub!(/.+/,"#{para}")
    end
    def level3
      @para.gsub!(/#{Mx[:lv_o]}3:\S*?#{Mx[:lv_c]}\s*/,'')
      para=clean(@para)
      nd=para.gsub(/@footnote\{.+?\}\s+/,'')
      #para=para.gsub(/(.+?)\s*(@footnote\{.+?\})\s*(.+)$/,"\\1 \\3\n\\2")
      #para=para.gsub(/(.+?)\s*(@footnote\{.+?\})\s*(.+)$/,'\1 \3 \2')
      para="@node #{nd}\n@unnumbered #{para}\n@cindex chapter, #{nd}\n"
      @para.gsub!(/.+/,"#{para}")
    end
    def level4
      @para.gsub!(/#{Mx[:lv_o]}4:\S+?#{Mx[:lv_c]}\s*/,'')
      para=clean(@para)
      nd=para.gsub(/@footnote\{.+?\}\s+/,'')
      para="@node #{nd}\n@unnumbered #{para}\n@cindex chapter, #{nd}\n"
      @para.gsub!(/.+/,"#{para}")
    end
    def level5
      @para.gsub!(/#{Mx[:lv_o]}5:\S*?#{Mx[:lv_c]}\s*/,'')
      para=clean(@para)
      nd=para.gsub(/@footnote\{.+?\}\s+/,'')
      para="@node #{nd}\n@unnumbered #{para}\n@cindex chapter, #{nd}\n"
      @para.gsub!(/.+/,"#{para}")
    end
    def level6
      @para.gsub!(/#{Mx[:lv_o]}6:\S*?#{Mx[:lv_c]}\s*/,'')
      para=clean(@para)
      nd=para.gsub(/@footnote\{.+?\}\s+/,'')
      para="@node #{nd}\n@unnumbered #{para}\n@cindex chapter, #{nd}\n"
      @para.gsub!(/.+/,"#{para}")
    end
    def submenu
      @para=@para.join("\n")
      @para.gsub!(/[5]\\+~\S+/,'')
      para=clean(@para)
      para="@menu\n#{para}\n@end menu\n\n"
      @para.gsub!(/.+/m,"#{para}")
    end
    def subsubmenu
      @para=@para.join("\n")
      @para.gsub!(/[6]\\+~\S+/,'')
      para=clean(@para)
      para="@menu\n#{para}\n@end menu\n\n"
      @para.gsub!(/.+/m,"#{para}")
    end
    def indent1
      @para.gsub!(/<:i1>(.*)/,'\1')
    end
    def indent2
      @para.gsub!(/<:i2>(.*)/,'\1')
    end
    def spec_char # special characters
      @para.gsub!(/#{Mx[:br_eof]}/i,'')
      @para.gsub!(/#{Mx[:gl_o]}#169#{Mx[:gl_c]}/,'(c)')
      @para.gsub!(/#{Mx[:gl_o]}#(?:lt|060)#{Mx[:gl_c]}/,'<'); @para.gsub!(/#{Mx[:gl_o]}(gt|#062)#{Mx[:gl_c]}/,'>')
      @para.gsub!(/#{Mx[:gl_o]}#123#{Mx[:gl_c]}/,'{'); @para.gsub!(/#{Mx[:gl_o]}#125#{Mx[:gl_c]}/,'}')
      @para.gsub!(/#{Mx[:gl_o]}#(?:126|152)#{Mx[:gl_c]}/i,'~')
      @para.gsub!(/#{Mx[:gl_o]}#033#{Mx[:gl_c]}/,'!')
      @para.gsub!(/#{Mx[:gl_o]}#035#{Mx[:gl_c]}/,'#')
      @para.gsub!(/#{Mx[:gl_o]}#042#{Mx[:gl_c]}/,'*')
      @para.gsub!(/#{Mx[:gl_o]}#047#{Mx[:gl_c]}/,'/')
      @para.gsub!(/#{Mx[:gl_o]}#095#{Mx[:gl_c]}/,'_')
      @para.gsub!(/<sup><font face=symbol>&atild;<\/font><\/sup>/,' ')
      @para.gsub!(/\\/,'\\backslash ')
      @para.gsub!(/<:pb>/,'\\newpage')
      @para.gsub!(/\\backslash copyright/,'\\copyright ')
      @para.gsub!(/\^/,'\\wedge ')
      @para.gsub!(/(\$)/,"\\$")
      @para.gsub!(/\~/,'\\~')
      @para.gsub!(/%/,"\\%")
      #if @para !~ /^\s*<:image|\}:image\s/
      #  @para.gsub!(/_/,'\_')
      #end
      @para.gsub!(/_(https?:\/\/)/,'\1')
      @para.gsub!(/§/i,'\S')
      @para.gsub!(/£/i,'\pounds')
      @para.gsub!(/å/i,'\aa')
      @para.gsub!(/æ/i,'\ae')
      @para.gsub!(/ø/i,'\o')
      @para.gsub!(/Å/i,'\AA')
      @para.gsub!(/Æ/i,'\AE')
      @para.gsub!(/Ø/i,'\O')
      @para.gsub!(/<a href=".+?">/i,' ')
      @para.gsub!(/<\/a>/i,' ')
      @para.gsub!(/<:ee>/i,'')
      @para.gsub!(/<!>/i,' ')
      @para.gsub!(/<b>(.+?)<\/b>/,'\*\1\*')
      @para.gsub!(/<i>(.+?)<\/i>/,'\/\1\/')
      @para.gsub!(/<u>(.+?)<\/u>/,'\_\1\_')
      @para.gsub!(/@/i,'@@')
      @para.gsub!(/\{/,'@{'); @para.gsub!(/\}/,'@}')
      #@para.gsub!(/(^|[\s*!\/#_-])\{/,'\1@{'); @para.gsub!(/\}([\s*!\/#_-]|$)/,'@}\1')
      @para.gsub!(/&nbsp;&nbsp;/,' ')  # ~ character for hardspace
      @para.gsub!(/&nbsp;/,' ')        # ~ character for hardspace
      @para.gsub!(/&(\S+?);/,' ')
      @para.gsub!(/&/,'<=and>')
      @para.gsub!(/(\s+&\s+)/,' and ')
      @para.gsub!(/(\&)/,"\\&")
      @para.gsub!(/"(.+?)"/,"`\\1'")                                        # open & close "
      @para.gsub!(/\s+"/," `")                                              # open "
      @para.gsub!(/^([1-6-]\\+(?:~\S+)?|<.+?>)?\s*"/,'\1`')       # open "
      @para.gsub!(/"(\s|\.|,|:|;)/,"'\\1")                                  # close "
      @para.gsub!(/"([1-6-]\\+(?:~\S+)?|<.+?>)?\s*$/,"'\\1")       # close "
      @para.gsub!(/"(\.|,)/,"'")                                            # close "
      @para.gsub!(/\s+'/," `")                                              # open '
      @para.gsub!(/^([1-6-]\\+(?:~\S+)?|<.+?>)?\s*'/,'\1`')       # open '
      @para.gsub!(/(<font.*?>|<\/font>)/,'')
      @para.gsub!(/\s*<sup>(\S+?)<\/sup>/,'^\1')
      @para.gsub!(/(<sup>|<\/sup>)/,'')
      @para
    end
    def longtable
      @end_table="\\end{longtable}"
      @row_break='\\\\\\'
      if @para[/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c(\d+);(.+?)#{Mx[:gr_c]}/ui] #CHECK !> closure
        no_of_cols,cols_width=$1,$2
        @@tableheader=1 if @para =~ /#{Mx[:gr_o]}Th/i
        @w=cols_width.split(/;\s+/)
        @@number_of_cols=no_of_cols
        @colW=[]
        @colW << '{'
        @w.each  do |x|
          col_w=x.gsub(/.+/,'l\|') #unless x.nil?
          @colW << "#{col_w}" if col_w
        end
        @colW << '}'
        @colW=@colW.join
        @@start_table="\\setlength{\\LTleft}{0pt}\n\\setlength{\\LTright}{\\fill}\n" +
          "\\begin{longtable}[hb]#@colW\n"
        @para.gsub!(/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c\d+?;.+#{Mx[:gr_c]}/u,"#{@@start_table}")
      end
      if @para =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
        @para.gsub!(/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/," #@end_table")
      end
      @para.gsub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}/u,'')
      if @@tableheader==1
        if @para =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u
          tablefoot=para[/\<!f(.+?)!\>/,1]
          @para.gsub!(/\<!f(.+?)!\>/,'')
          @para.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u,
          "{\\begin{tiny} {\\bfseries \\1}\\end{tiny}}&")
          @para.gsub!(/&>\s*$/,
          " #@row_break \\hline\\endhead #@row_break")
          @para="#@para \\multicolumn{#{@@number_of_cols}}{l}{\\tiny #{tablefoot}} \\\\ \\hline\n\\endfoot\n\\hline\n" if tablefoot
          @@tableheader=0
          @@number_of_cols=0
        end
      else
        if @para =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u
          @para.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u,"\\begin{tiny}\\1\\end{tiny}&")
          @para.gsub!(/&>\s*$/," #@row_break")
        end
      end
      @para
    end
    def scopedtable
      # some features related to headers have been incorporated in longtable
      # that are not included yet here, so until synced is broken on some
      # input files, work needs to be done if is to work as before
      @end_table="\\end{tabular}"
      @row_break='\\\\\\\\'
      @break_page="#@row_break\n#@row_break \n"
      if @para[/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c(\d+);(.+?)#{Mx[:gr_c]}/ui]
        no_of_cols,cols_width=$1,$2
        @w=cols_width.split(/;\s+/)
        @colW=[]
        @w.each  do |x|
          col_w=((x.to_i*12)/100.00).to_s #unless x.nil?
          @colW << "p{#{col_w}cm}" if col_w
        end
        @@start_table="\\begin{tabular}{#@colW}\n"
        @para.gsub!(/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c\d+?;.+#{Mx[:gr_c]}/u,"#{@@start_table}")
      end
      if @para =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
        @para.gsub!(/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/,"#@end_table")
        @@table_pg_break_counter=1
      end
      if @para =~/#{Mx[:tc_o]}#{Mx[:tc_p]}/u
        if @@table_pg_break_counter==28 # taken from 34 ideal for portrait to 28 which suits landscape
          @para =
            "\n\n#@end_table \n" +
            "#@break_page" +
            "#{@@start_table}\n"
          @@table_pg_break_counter=1
        else
          @para.gsub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}/u,'')
          @@table_pg_break_counter+=1
          tablefoot=@para[/\<!f(.+?)!\>/]
          @para.gsub!(/\<!f(.+?)!\>/,'')
        end
      end
      if @para =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u
      @para.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u,"\\begin{tiny}\\1\\end{tiny}&")
      @para.gsub!(/&>\s*$/,"#@row_break")
      end
      @para
    end
    def graphics
      dir=SiSU_Env::Info_env.new(@md.fns)
      @para.gsub!(/<::\s+(\S+?)\s+>/i, #watch
        "\\includegraphics*[width=11pt]{#{dir.path.image_source_tex}/c_\\1.png}")
    end
    def image
      dir=SiSU_Env::Info_env.new(@md.fns)
      width="100"
      width=@para[/<:image.+?width=``(\d+)''.+?>/im,1]
      width=width.to_i*0.4
      @para.gsub!(/<:image\s+((?:https?|file|ftp)\S+)\s+(\S+)\s+.+\s+?>/i,
        "\\href{\\1}{\\includegraphics*[width=#{width}pt]{#{dir.path.image_source_tex}/\\2}}")
      @para.gsub!(/<:image\s+(\S+)\s+.+\s+?>/i,
        "\\includegraphics*[width=#{width}pt]{#{dir.path.image_source_tex}/\\1}")
    end
    def png
      # very messy clean up ! - work area, testing
      z=@para[/\\\{(.+?)\}(?:image|png)/,1] # match operator for z \\ fragile !
      image,w,x,y=z.scan(/\S+/)
      image.gsub!(/\\/,'')
      @para.gsub!(/\\\{\S+\.(png|jpg|gif).+?\}(image|png)/,"<image #{image} not available>")  # fragile match operator\\ fragile !
    end
    def http
      # very messy clean up ! - work area, testing
      z=@para[/\\\{(.+?)\}(?:https?|file|ftp):\/\//,1] # match operator for z \\ fragile !
      url=@para[/((?:https?|file|ftp):\S+)/im,1]
      if @para =~/\.(png|jpg|gif)/
        image,w,x,y=z.scan(/\S+/)
        image.gsub!(/\\/,'')
        width=200
        width=z[/w=(\d+)/im,1] if z =~/w=(\d+)/
        width=width.to_i*0.8
        width=400 if width > 400
        c=z[/``(.+?)''/im,1]
        caption="{\\\\\\\ \n\\begin{scriptsize}#{c}\\end{scriptsize}&}" if c
      end
      if image
        dir=SiSU_Env::Info_env.new(@md.fns)
        @para.gsub!(/\{\S+\.(png|jpg|gif).+?\}(?:https?|file|ftp):\/\/\S+/, # fragile match operator\\ fragile !
          "\n\\href{#{url}}{\\includegraphics*[width=#{width}pt]{#{dir.path.image_source_tex}/#{image}}}#{caption}")
      else
        link=z[/(.+?)\\/im,1]
        @para.gsub!(/\{.+?\}(?:https?|file|ftp):\/\/\S+/,"\n\\noindent\\href{#{url}}{#{link}}")  # fragile match operator\\ fragile !
      end
    end
  end
end
__END__

