# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: simple xml representation (dom style)

=end
module SiSU_simple_xml_model_dom
  require "#{SiSU_lib}/particulars"
  include SiSU_Particulars
  require "#{SiSU_lib}/defaults"
  include SiSU_Viz
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  require "#{SiSU_lib}/dal_doc_str"
  require "#{SiSU_lib}/shared_xml"
  require "#{SiSU_lib}/shared_sem"
  require "#{SiSU_lib}/xml_format"
  include SiSU_XML_format
  include SiSU_XML_munge
  require "#{SiSU_lib}/rexml"
  include SiSU_Rexml
  @@alt_id_count,@@tablehead,@@number_of_cols=0,0,0
  @@tablefoot=''
  class Convert
    @@fns=nil
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::Combined_singleton.instance.get_env_md(opt)
    end
    def read
      begin
        @env,@md=@particulars.env,@particulars.md #bug, md relies on info persistence, assumes -m has previously been run
        path=@env.path.output_tell
        loc=@env.url.output_tell
        tool=if @opt.cmd =~/[MV]/; "#{Dir.pwd}/#{@md.fn[:sxd]}\n\t#{@env.program.xml_viewer} #{path}/#{@md.fnb}/#{@md.fn[:sxd]}"
        elsif @opt.cmd =~/v/; "#{@env.program.web_browser} #{Dir.pwd}/#{@md.fn[:sxd]}"
        else ''
        end
        SiSU_Screen::Ansi.new(@opt.cmd,'invert','XML DOM',"#{@md.fns} -> #{@md.fn[:sxd]}").colorize unless @opt.cmd =~/q/
        tell=SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{Dir.pwd}/#{@md.fn[:sxd]}")
        tell.flow if @opt.cmd =~/[MV]/
        unless @@fns==@opt.fns
          @@fns=@opt.fns
          @@fns_array=[]
        end
        @fns_array=if @@fns_array.empty?; read_fnm
        else @@fns_array.dup # check
        end
        SiSU_simple_xml_model_dom::Convert::Songsheet.new(@fns_array,@particulars).songsheet
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure #file closed in songsheet
      end
    end
    def read_fnm
      dal=[]
      if FileTest.file?("#{Dir.pwd}/#{@opt.fns}")
        dal=IO.readlines("#{Dir.pwd}/#{@opt.fns}","\n\n")
      else  puts 'Error'
      end
    end
    private
    class Songsheet
      def initialize(data,particulars)
        @data,@particulars,@env,@md=data,particulars,particulars.env,particulars.md
      end
      def songsheet
        begin
          SiSU_simple_xml_model_dom::Convert::Scroll.new(@data,@particulars).songsheet
          SiSU_simple_xml_model_dom::Convert::Tidy.new(@md,@env).xml if @md.cmd =~/[vVM]/ # test wellformedness, comment out when not in use
          SiSU_Rexml::Rexml.new(@md,@md.fn[:sxd]).xml if @md.cmd =~/M/ # test rexml parsing, comment out when not in use #debug
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        ensure
        end
      end
    end
    class Scroll
      require "#{SiSU_lib}/shared_txt"
      require "#{SiSU_lib}/css"
      include SiSU_text_utils
      @@xml={ :body=>[],:open=>[],:close=>[],:head=>[] }
      def initialize(data='',particulars='')
        @data,@env,@md=data,particulars.env,particulars.md
        @vz=SiSU_Env::Get_init.instance.skin
        @regx=/^(?:#{Mx[:mk_o]}:p[bn]#{Mx[:mk_c]}\s*)?(?:#{Mx[:lv_o]}[1-9]:(\S*)#{Mx[:lv_c]})?(.+)/
        @tab="\t"
        if @md
          @trans=SiSU_XML_munge::Trans.new(@md)
        end
        @sys=SiSU_Env::System_call.new
      end
      def songsheet
        pre
        markup
        post
        publish
      end
    protected
      def embedded_endnotes(para='')
        para.gsub!(/~\{(.+?)\}~/,
          '<endnote><note>\1</note></endnote> ')
        para.gsub!(/~\[([*+])\s+(.+?)\]~/,
          '<endnote><symbol>\1</symbol><note>\2</note></endnote> ')
      end
      def xml_clean(para='')
        para.gsub!(/~\[([*+])\s+(.+?)\]~/,
          '<endnote><symbol>\1</symbol><note>\2</note></endnote> ')
        para.gsub!(/~\{([*+]+)\s+(.+?)\}~/,
          '<endnote><symbol>\1</symbol><note>\2</note></endnote> ')
        para.gsub!(/~\{(.+?)\}~/,
          '<endnote><note>\1</note></endnote> ')
        para.gsub!(/#{Mx[:lv_o]}[1-9]:\S*?#{Mx[:lv_c]}/,'') #Danger, watch
      end
      def xml_head(meta)
        txt=meta.text
        txt.gsub!(/\/{(.+?)}\//,'<i>\1</i>')
        txt.gsub!(/[*!]{(.+?)}[*!]/,'<b>\1</b>')
        txt.gsub!(/_{(.+?)}_/,'<u>\1</u>')
        txt.gsub!(/-{(.+?)}-/,'<del>\1</del>')
        txt.gsub!(/<br(?: \/)?>/,'<br />')
        txt.gsub!(/ & /,' and ')
        @@xml[:head] <<<<WOK
#{@tab}<header class="#{meta.attrib}">
#{@tab*2}<#{meta.el}>
#{@tab*3}#{txt}
#{@tab*2}</#{meta.el}>
#{@tab}</header>
WOK
      end
      def xml_sc(md='')
        sc=if @md.sc_info
          <<WOK
    <source_control>
      <sc class="sourcefile">
        #{@md.sc_filename}
      </sc>
      <sc class="number">
        #{@md.sc_number}
      </sc>
      <sc class="date">
        #{@md.sc_date}
      </sc>
    </source_control>
WOK
        else ''
        end
        @@xml[:sc]=sc
      end
      def xml_element(lv='',para='',hname='',tag='',xml_element='',xml_content='')
        lv=lv.to_i
        n=lv - 1
        n1=lv
        n2=lv + 1
        n3=lv + 2
        v=lv - 3
        tag=''
        tag="\n#{@tab*n3}<nametag>#{hname}</nametag>\n" if hname
        @@xml[:body] <<<<WOK
#{@tab*n}#{xml_element}
#{@tab*n1}<heading>
#{@tab*n2}<object>
#{@tab*n3}<text>#{para[@regx,2]}</text>
#{@tab*n2}</object>
#{@tab*n1}</heading>#{xml_content}
WOK
        if lv == 4
          @copen[1]=true
          @copen[2]=@copen[3]=false
        elsif lv == 5
          @copen[2]=true
          @copen[3]=false
        elsif lv == 6
          @copen[3]=true
        end
      end
      def xml_structure(lv='',para='',hname='' )
        puts lv if @md.cmd =~/[VM]/
        lv=lv.to_i
        n=lv - 1
        n1=lv
        n2=lv + 1
        n3=lv + 2
        v=lv - 3
        tag=''
        tag="\n#{@tab*n3}<nametag>#{hname}</nametag>\n" if hname !=nil
        case lv
        when 1..3
          xml_element="<heading#{lv}>"
          3.downto(lv) do |x|
            y=x - 1
            if @cont[1] \
            or @cont[2] \
            or @cont[3]
              @@xml[:body] << "#{@tab*5}</content>\n"
            end
            @cont[1]=false if @cont[1]
            @cont[2]=false if @cont[2]
            @cont[3]=false if @cont[3]
            ####### attempt to close contents
            if @copen[3] # 6{
              [3,2,1].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
              @copen[1]=@copen[2]=@copen[3]=false
            elsif @copen[2] # 5{
              [2,1].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
              @copen[1]=@copen[2]=@copen[3]=false
            elsif @copen[1] # 4{
              [1].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
              @copen[1]=@copen[2]=@copen[3]=false
            end
            @@xml[:body] << "#{@tab*y}</heading#{x}>\n" if @level[x]
            @level[x]=false
          end
        when 4..6
          6.downto(lv) do |x|
            y=x - 1
            if @level[x] == true
              u=x - 3;
              @xml_contents_close[x]=''
            end
          end
          cv=lv - 3
          xml_element="<contents#{cv}>"
          xml_content="\n#{@tab*5}<content>"
          case lv
          when 4
            @@xml[:body] << "#{@tab*5}</content>\n" if @cont[1]
            if @copen[3] == true # 6{
              [3,2,1].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
            elsif @copen[2] == true # 5{
              [2,1].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
            elsif @copen[1] == true # 4{
              [1].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
            end
            @cont[1]=true
          when 5
            if @cont[2] \
            or @cont[1]
              @@xml[:body] << "#{@tab*5}</content>\n"
            end
            if @copen[3] == true  #6{
              [3,2].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
            elsif @copen[2] == true #5{
              [2].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
            end
            @cont[2]=true
          when 6
            if @cont[3] \
            or @cont[2] \
            or @cont[1]
              @@xml[:body] << "#{@tab*5}</content>\n"
            end
            [3].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" } if @copen[3]
            @cont[3]=true
          end
        end
        xml_element(lv,para,hname,tag,xml_element,xml_content)
        @level[lv]=true
        ((lv+1)..6).each { |x| @level[x]=false }
      end
      def group_structure(para='')
        para.gsub!(/<:group(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*6}<object>} << "\n"
        @@xml[:body] << %{#{@tab*7}<text class="group">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*8}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*7}</text>\n}
        @@xml[:body] << "#{@tab*6}</object>" << "\n"
      end
      def poem_structure(para='')
        para.gsub!(/<:verse(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*6}<object>} << "\n"
        @@xml[:body] << %{#{@tab*7}<text class="verse">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*8}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*7}</text>\n}
        @@xml[:body] << "#{@tab*6}</object>" << "\n"
      end
      def code_structure(para='')
        para.gsub!(/<:code(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*6}<object>} << "\n"
        @@xml[:body] << %{#{@tab*7}<text class="code">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*8}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*7}</text>\n}
        @@xml[:body] << "#{@tab*6}</object>" << "\n"
      end
      def table_structure(table='')
        @@xml[:body] << %{#{@tab*0}<object>} << "\n"
        @@xml[:body] << %{#{@tab*1}#{table}\n#{@tab*1}\n}
        @@xml[:body] << "#{@tab*0}</object>" << "\n"
        @endnotes=[]
      end
      def tidywords(wordlist)
        wordlist.each do |x|
          x.gsub!(/&/,'&amp;') unless x =~/&\S+;/
        end
      end
      def markup
        data=@data
        dir=SiSU_Env::Info_env.new(@md.fns)
        xml_sc(@md)
        @rcdc=false
        @level,@cont,@copen,@xml_contents_close=[],[],[],[]
        (0..6).each { |x| @cont[x]=@level[x]=false }
        (4..6).each { |x| @xml_contents_close[x]='' }
        data.each do |para|
          #para=SiSU_sem::Tags.new(para,@md).rm.all
          wordlist=para.scan(/\S+|\n/) #\n needed for tables, check though added 2005w17
          para=tidywords(wordlist).join(' ').strip
          para.gsub!(/<[-~]#>/,'')
          para.gsub!(/<br\/?>/,'<br />')
          para.gsub!(/<:pb>\s*/,'')
          para.gsub!(/\{(\S+?\.(?:png|jpg|gif)) .+?\}(?:(?:https?|file|ftp):\/\/\S+|image)/,
            "<image.path>#{dir.url.images_local}/\\1</image.path>")
          para.gsub!(/&nbsp;/,' ')
          para=SiSU_document_structure::Structure.new(@md,para).structure
          @trans.char_enc.utf8(para) if @sys.locale =~/utf-?8/i #% utf8
          para.gsub!(/^0~(\S+)/,"#{Mx[:lv_o]}@\\1#{Mx[:lv_c]}")
          para.gsub!(/^@(\S+?):/,"#{Mx[:lv_o]}@\\1#{Mx[:lv_c]}")
          if para =~/\A#{Mx[:lv_o]}@(\S+?)#{Mx[:lv_c]}\s*(.+?)\Z/m # for headers
            d_meta=SiSU_text_utils::Header_scan.new(@md,para).meta
            if d_meta; xml_head(d_meta)
            end
          end
          para='' if para=~/#{Mx[:lv_o]}@\S+?#{Mx[:lv_c]}/
          if @rcdc==false \
          and (para =~/~metadata/ or para =~/^1~meta\s+Document Information/)
            @rcdc=true
          end
          if para !~/(^0~|^@\S+?:|<ENDNOTES>|<EOF>)/
            @sto=SiSU_text_parts::Split_text_object.new(@md,para).lev_segname_para
            unless @rcdc
              if para !~/^(?:%\s|0~|@\S+?:)/
                format_scroll=SiSU_XML_format::Format_scroll.new(@md,@sto.text) if @sto.format =~/i[12]|null/
                case @sto.format
                when /^(1):(\S*)/
                  xml_clean(para)
                  xml_structure($1,para,$2)
                  para=@sto.lev_para_ocn.heading_body1
                when /^(2):(\S*)/
                  xml_clean(para)
                  xml_structure($1,para,$2)
                  para=@sto.lev_para_ocn.heading_body2
                when /^(3):(\S*)/
                  xml_clean(para)
                  xml_structure($1,para,$2)
                  para=@sto.lev_para_ocn.heading_body3
                when /^(4):(\S*)/
                  xml_clean(para)
                  xml_structure($1,para,$2)
                  para=@sto.lev_para_ocn.heading_body4
                when /^(5):(\S*)/
                  xml_clean(para)
                  xml_structure($1,para,$2)
                  para=@sto.lev_para_ocn.heading_body5
                when /^(6):(\S*)?/
                  xml_clean(para)
                  xml_structure($1,para,$2)
                  para=@sto.lev_para_ocn.heading_body6
                #when /^(i1)$/i
                #  #format_scroll.gsubBody
                #  #para=@sto.lev_para_ocn.scrIndent1
                #when /^(i2)$/i
                #  format_scroll.gsubBody
                #  para=@sto.lev_para_ocn.scrIndent2
                #when /^(center)$/i
                #  para.gsub!(/(.+)/,
                #    %{<center>(\\1)</center>})
                #  para=@sto.lev_para_ocn.scrPara
                #when /^(b|bold)$/i
                #  para.gsub!(/(.+)/,
                #    %{<b>(\\1)</b>})
                #  para=@sto.lev_para_ocn.scrPara
                #when /null/ # see whether u can improve
                #    if (para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/)
                #      #format_scroll.gsubBody
                #      #para=@sto.lev_para_ocn.scrPara
                #    end
                else
                  if para =~ /<:verse>/
                    para=poem_structure(para)
                  elsif para =~ /<:group>/
                    para=group_structure(para)
                  elsif para =~ /<:code>/
                    para.gsub!(/</,'&lt;')
                    para.gsub!(/>/,'&gt;')
                    para=code_structure(para)
                  elsif para =~/<!Th?.+/ # tables come as single block #work area 2005w13
                  #elsif para =~/#{Mx[:gr_o]}Th?.+/ # tables come as single block #work area 2005w13
                    table=SiSU_Tables::Table_xml.new(para)
                    para=table.table_split
                    @@xml[:body] << table_structure(para)
                  else #xml_structure
                    xml_clean(para)
                    if para[@regx] \
                    and para[@regx,2]
                      @@xml[:body] << %{#{@tab*6}<object>} << "\n"
                    end
                    @@xml[:body] << "#{@tab*7}<text>#{para[@regx,2]}</text>\n" if para[@regx,2] # main text, contents, body KEEP
                    @@xml[:body] << "#{@tab*6}</object>" << "\n" if para[@regx]
                  end
                end
              elsif para =~/(Note|Endnotes?)/
              elsif para =~/(MetaData)/ \
              and para =~/#{Mx[:id_o]}~\d+;[m]\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@@dp}:#{@@dp}#{Mx[:id_c]}$/ #debug 2003w46 add rc info
                format_scroll=Format_scroll.new(@md,'<br /><a name="metadata">MetaData</a>')
                para=format_scroll.bold_para
              elsif para =~/(Owner Details)/ \
              and para !~/#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@@dp}:#{@@dp}#{Mx[:id_c]}$/
                format_scroll=Format_scroll.new(@md,'<br /><a name="owner.details">Owner Details</a>')
                @@xml[:owner_details]=format_scroll.bold_para
                para=''
              elsif para =~/(.*)<:#>(.*)/
                one,two=$1,$2
                format_text=Format_text_object.new(one,two)
                para=format_text.seg_no_paranum
              end
              if para =~/<a name="n\d+">/ \
              and para =~/^(-\{{2}~\d+|<!e[:_]\d+!>)/ # -endnote
                para=''
              end
              if para =~/.*<:#>.*$/
                para=case para
                when /<:i1>/
                  format_text=Format_text_object.new(para,'')
                  format_text.scr_inden_ocn_e_no_paranum
                when /<:i2>/
                  format_text=Format_text_object.new(para,'')
                  format_text.scr_inden_ocn_e_no_paranum
                end
              end
              if para !~/#{@vz.margin_txt_0}|#{@vz.margin_txt_1}|#{@vz.margin_txt_2}/ # where condition for no paranum
              end
              if para =~/<:center>/
                one,two=/(.*)<:center>(.*)/.match(para)[1,2]
                format_text=Format_text_object.new(one,two)
                para=format_text.center
              end
            end
            para.gsub!(/<:\S+?>/,'')
            para.gsub!(/<!.+!>/,' ')
            para
          end
        end
        @content_flag=true
        6.downto(4) do |x|
          y=x - 1; v=x - 3
          if @level[x] == true
            if @content_flag==true
              @@xml[:body] << "#{@tab*5}</content>\n#{@tab*y}</contents#{v}>\n"
              @content_flag=false
            else
              @@xml[:body] << "\n#{@tab*y}</contents#{v}>\n"
            end
          end
        end
        3.downto(1) do |x|
          y=x - 1
          @@xml[:body] << "#{@tab*y}</heading#{x}>\n" if @level[x] == true
        end
        #6.downto(1) { |x| y=x - 1; @@xml[:body] << "#{@tab*y}</level #{x}>\n" if @level[x] == true }
      end
      def pre
        rdf=SiSU_XML_tags::RDF.new(@md)
        dir=SiSU_Env::Info_env.new
        @@xml[:head],@@xml[:body]=[],[]
        css=SiSU_Env::CSS_select.new(@md).xml_sax
        encoding=if @sys.locale =~/utf-?8/i; '<?xml version="1.0" encoding="UTF-8" standalone="no"?>'
        else                                 '<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>'
        end
        @@xml[:open] =<<WOK
#{encoding}
<?xml-stylesheet type="text/css" href="../#{dir.path.style}/#{css}"?>
#{rdf.comment_xml_dom}
<document>
WOK
        @@xml[:head] << "<head>\n"
        @@xml[:body] << "<body>\n"
      end
      def post
        @@xml[:head] << @@xml[:sc]
        @@xml[:head] << "</head>\n"
        @@xml[:body] << "</body>\n"
        @@xml[:close] = "</document>\n"
      end
      def publish
        content=[]
        data=@data
        content << @@xml[:open] << @@xml[:head] << @@xml[:body] << @@xml[:metadata]
        content << @@xml[:owner_details] if @md.stmp =~/\w\w/
        content << @@xml[:tail] << @@xml[:close]
        Output.new(content.join,@md).xml
        @@xml={}
      end
    end
    class Output
      def initialize(data,md)
        @data,@md=data,md
        @trans=SiSU_XML_munge::Trans.new(@md)
      end
      def xml
        @sisu=[]
        @data.each do |para|
          if para !~/^\s*(?:%+ |<:code>)/
            if @md.sem_tag and para =~/[:;]\{|\}[:;]/
              para=@trans.xml_semantic_tags(para)
            end
            if para =~/[:;]\{|\}[:;]/
              para=SiSU_sem::Tags.new(para,@md).rm.all
            end
          end
          para.gsub!(/\/\{(.+?)\}\//,'<italic>\1</italic>')
          para.gsub!(/\*\{(.+?)\}\*/,'<bold>\1</bold>')
          para.gsub!(/!\{(.+?)\}!/,'<bold>\1</bold>')
          para.gsub!(/_\{(.+?)\}_/,'<underscore>\1</underscore>')
          para.gsub!(/-\{(.+?)\}-/,'<strike>\1</strike>')
          # do { links }http://url
          #para.gsub!(/#{Mx[:gl_o]}\S+?#{Mx[:gl_c]}/,'') #Danger, watch
          para.gsub!(/<:\S+?>/,'')
          para.gsub!(/<!.+?!>/,'')
          para="#{para}\n" unless para.empty?
          @sisu << para
        end
        new_file_data=@sisu.join
        @sisu=new_file_data.scan(/.+/)
        SiSU_Env::SiSU_file.new(@md).mkdir
        filename_sxm=SiSU_Env::SiSU_file.new(@md,@md.fn[:sxd]).mkfile_pwd
        if filename_sxm.class == File
          @sisu.each {|para| filename_sxm.puts para}
          filename_sxm.close
        else puts 'file not created, is directory writable?'
        end
      end
    end
    class Tidy
      def initialize(md,dir)
        @md,@env=md,dir
        @prog=SiSU_Env::Info_program.new
      end
      def xml
        if @prog.tidy !=false #note values can be other than true
          if @md.cmd =~/[VM]/
            tell=SiSU_Screen::Ansi.new(@md.cmd,'invert','Using XML Tidy','check document structure')
            tell.colorize unless @md.cmd =~/q/
            tell.grey_open unless @md.cmd =~/q/
            tidyfile='/dev/null' #don't want one or screen output, check for alternative flags
            tidy =SiSU_Env::System_call.new("#{Dir.pwd}/#{@md.fn[:sxd]}",tidyfile)
            tidy.well_formed?
            tell.p_off unless @md.cmd =~/q/
          end
        end
      end
    end
  end
end
__END__
