// $Id: gcd0_l.tst,v 1.3 2005/04/22 15:07:15 Singular Exp $

//
// gcd0_l.tst - long tests for gcd calculations in Z.
//
// All univariate non-trivial examples come from gcdUniv0Std.fex or
// gcdUniv0Alpha.fex.
//
// The examples in variables `u' and `v' came from `coprasse(2/0/1)'
// in stdMultiv0Gcd.in.
//
// To Do:
//
// o multivariate gcd calculations with parameters
// o algrebraic extensions of char 0 not implemented yet.
//   And no long tests existent so far.
//

LIB "tst.lib";
tst_init();
tst_ignore("CVS ID  : $Id: gcd0_l.tst,v 1.3 2005/04/22 15:07:15 Singular Exp $");

//
// - ring r1=0,u,dp.
//

tst_ignore( "ring r1=0,u,dp;" );
ring r1=0,u,dp;

poly f;
poly g;

f=(365512435574712719686204706836828913664000000000000000*u^14-5966972768266545186249625394382961516216320000000000000*u^13+33207380594194580794259027781588874845394329600000000000*u^12-63149105962828029709921970865207568408167339648000000000*u^11-8632197662712938796830589730609030046177157700800000000*u^10+8635315398839695565987482947041502266378608409835000000*u^9+174695815217213658510614128457753849811499477573733625000*u^8+544060812136097315756114153963954170526186756098355700000*u^7-807044722482194734874580261780250691531077502789889675000*u^6+612171341177190302283862500466811317230667828193054880000*u^5-5336400297322072110950519255483692106606883530298934761000*u^4+1729874085740489450715411122064651305174357689532087004000*u^3+8272981567193404784433105163787752006525672631514520539000*u^2-1971130156102017784912843164329530533613391923163054030400*u-395501445823413950361283904050327359718180347841427804160);

g=(36308020193592719584566412430527835909652480000000000000*u^12-652678905697617921708515934325057504729576243200000000000*u^11+4741565809974554313621915501846202911562811572224000000000*u^10-20331926652527898168121875937514448369027354098073600000000*u^9+70914514412768274411212638033163552299079827725557760000000*u^8-218905543289554941995662273460274913872844287638781432000000*u^7+505458416298021364668314269672510578782755005819354101400000*u^6-865686032122308992376414330268136718656501334396058977120000*u^5+1218668321013381866059141618330265697857172968640951876624000*u^4-1205615753528169373586966273566248512043306417914992983648000*u^3+597499875585461645022051018581200517302063555836214528632000*u^2-188276232046415140439193089697605848616903654637756427430400*u+136429387116678157348594042510522681953927734292414213488640);

gcd(f, g);
poly gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(-38164721206634603686215000000000000*u^13+563562627933113346017638912500000000*u^12-2380204388370499854923392427390625000*u^11+132938578324254539103737956101562500*u^10+16446108329194229780063630492177437500*u^9-28675226971413337187691237195091603125*u^8+62119331918314812139350307572814432500*u^7-135924138888790629382790136033022003125*u^6+62995064114158019396283971984502595500*u^5-35160967881587641671589349900510881875*u^4+205835749693336500528320251692104594700*u^3+411880410679153390884991415237992547625*u^2-481600030048785678486316437413359409520*u-104936254580165696098298219396227976640);

g=(-16830652310477991612000000000000*u^13+206010300544669105439130000000000*u^12-336489698151712026158710162500000*u^11-4037927815741877784066590904375000*u^10+16117147126710181077961128619218750*u^9-17095408681136120329203957086400000*u^8+22828352866611710372466627733650000*u^7-10317871089816590123991592468567500*u^6-128752884841221487722240031488251250*u^5+90229584476058164485099521170337000*u^4-78796131320855420312890169498338500*u^3+296764520895779021133104588780107500*u^2-15235617919937157777158860657262400*u+14548841960596809461123754422649600);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(24*u^42-120*u^41-30*u^40+1086*u^39-1878*u^38-1230*u^37+8460*u^36-7242*u^35-11562*u^34+19356*u^33+12666*u^32-45954*u^31-21678*u^30+122952*u^29-50052*u^28-151902*u^27+152826*u^26+172032*u^25-170616*u^24-208938*u^23+353880*u^22+155676*u^21-284454*u^20-422694*u^19+524574*u^18+234072*u^17-921906*u^16+292320*u^15-212760*u^14+402030*u^13-62100*u^12-762372*u^11+667926*u^10+307800*u^9-295488*u^8+95256*u^7+169128*u^6+34992*u^5);

g=(96*u^43-624*u^42+840*u^41+2532*u^40-8472*u^39+3606*u^38+22272*u^37-32286*u^36-31830*u^35+89916*u^34+30168*u^33-261192*u^32+118464*u^31+497034*u^30-589254*u^29-353814*u^28+1153806*u^27+15384*u^26-1389042*u^25+474726*u^24+1519896*u^23-862326*u^22-1734018*u^21+630282*u^20+2343186*u^19-2714274*u^18-1719000*u^17+3687318*u^16-2321298*u^15-162306*u^14+2032020*u^13-2256444*u^12+1195992*u^11+1660986*u^10-1168506*u^9-10530*u^8+670680*u^7-41796*u^6-174960*u^5-34992*u^4);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(1152*u^112-28224*u^111+284256*u^110-1350576*u^109+1129824*u^108+21499920*u^107-113212080*u^106+151116912*u^105+726524712*u^104-3555634968*u^103+3618784080*u^102+16529297184*u^101-59245344720*u^100+23228193744*u^99+274712038776*u^98-599271365016*u^97-292978030896*u^96+3116992895424*u^95-3520532080656*u^94-7117880436432*u^93+22958068033296*u^92-5556186953496*u^91-69149442420000*u^90+100241540526168*u^89+95469943519728*u^88-395539684713360*u^87+141251797007784*u^86+938934443424168*u^85-1284774012242280*u^84-1187725193588952*u^83+4237649935756416*u^82-877392924216624*u^81-8965128397378032*u^80+9030326150604528*u^79+12638965632285528*u^78-28450424938359168*u^77-6161918355232632*u^76+62701956687076056*u^75-31612676143184280*u^74-99142265883104928*u^73+125148117320950968*u^72+96767769137845248*u^71-275407661389840200*u^70-3030975337939560*u^69+455063787892441008*u^68-240073760950873416*u^67-593291694081649464*u^66+681337391248624752*u^65+533780245308171816*u^64-1250454866830744104*u^63-125898749719492176*u^62+1716913091466276840*u^61-605535605057396016*u^60-1824584255588584728*u^59+1383799755211042248*u^58+1563977049215144688*u^57-1904017109191627320*u^56-1294418117548263888*u^55+2419825521609254520*u^54+867803709564251136*u^53-3029942247123609936*u^52+424858962449141424*u^51+2375803463561603424*u^50-1412590162944512088*u^49-132611040919301688*u^48-205624209333492000*u^47-680870698451910360*u^46+3070738808535680568*u^45-1737343757894819184*u^44-3223812032758317888*u^43+4290843544395293952*u^42+406010822407523928*u^41-3641338655094706920*u^40+1758454462883507976*u^39+826553073397277448*u^38-1224945043490279520*u^37+1116252038211883416*u^36-645821981754925680*u^35-1123408474248078072*u^34+1843199376860260944*u^33+211282466468535792*u^32-1840578546687846552*u^31+478866522602639808*u^30+1233715794854504544*u^29-623334961023363288*u^28-630254993020748568*u^27+462760319332414656*u^26+268478794103664528*u^25-251561503044571824*u^24-102170392732653840*u^23+107769764817718416*u^22+36097286556027456*u^21-39769300733260032*u^20-15764709909266064*u^19+9104845889945016*u^18+4093092856176480*u^17-2718593411015232*u^16-2099397216816144*u^15-194784113498112*u^14+274553515303488*u^13+129566837532096*u^12+23376257653824*u^11+500554121472*u^10-514914838272*u^9-83624721408*u^8-4353564672*u^7);

g=(7488*u^108-193248*u^107+2128464*u^106-12348360*u^105+33068664*u^104+32601312*u^103-553530168*u^102+1578304800*u^101+113109768*u^100-11929233528*u^99+25683837408*u^98+19387249128*u^97-171699500160*u^96+177623760600*u^95+549672915600*u^94-1589077746648*u^93-140321864880*u^92+6557504817600*u^91-7987642740864*u^90-12978791038656*u^89+41333288356296*u^88-6238575977400*u^87-112660879180104*u^86+127599140019024*u^85+176914454231160*u^84-477951406139880*u^83-18073045503936*u^82+1110971396342808*u^81-828943710651000*u^80-1663936105566744*u^79+2694499417555200*u^78+1471138198134552*u^77-5469929046242352*u^76-299906751803616*u^75+9696119648834736*u^74-2685349487544192*u^73-16238868314239152*u^72+9443382567353856*u^71+25458505826902920*u^70-21360158286617304*u^69-42632502532633728*u^68+49925534599432512*u^67+68539321717702848*u^66-122876754354447264*u^65-69626380681419336*u^64+245725374923339040*u^63-10054681242482520*u^62-363643295033192976*u^61+183615611234984064*u^60+389159435467905840*u^59-359241788789025192*u^58-333393751003675824*u^57+438859758255452496*u^56+362410722222083352*u^55-579937915859373144*u^54-421167784251793248*u^53+932588327622301056*u^52+125789733147015216*u^51-1059623646830631216*u^50+394878114811433088*u^49+538392082103836488*u^48-357882542782611336*u^47+64912811516147160*u^46-400059343720182312*u^45+105052934527416720*u^44+983164450300827696*u^43-868235401870531488*u^42-686883620667249432*u^41+1243787361037157016*u^40-63605226704647680*u^39-783311766165800424*u^38+388731499176768840*u^37+29154436047579240*u^36-69037587961757208*u^35+331176318284293488*u^34-404138109077190216*u^33-215842021206722856*u^32+586657239314310216*u^31-30907311911368848*u^30-473621827680066600*u^29+150890749240628016*u^28+270358631316357984*u^27-140196460787218872*u^26-123534788188831344*u^25+81238615568955432*u^24+48164146806430080*u^23-34951027876093800*u^22-17163244807298496*u^21+12337595837817912*u^20+7165328074520904*u^19-1891749742731936*u^18-1342737475867224*u^17+888118416254592*u^16+992674910533536*u^15+384132450673440*u^14+71055703693152*u^13+2960064959040*u^12-1374713627904*u^11-283556132352*u^10-21677124096*u^9-544195584*u^8);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

//
// - ring r2=(0,v),u,dp; minpoly=v^4+v^3+v^2+v+1.
//
// The examples from r2 are those from r3 with transcendental
// parameters changed to ring variables.
//

tst_ignore( "ring r2=(0,v),u,dp;" );
ring r2=(0,v),u,dp;
minpoly=v^4+v^3+v^2+v+1;

poly f;
poly g;
poly gg;

f=(573440*u^11*v^2-1421312*u^10*v^3+294912*u^10*v^2+1720320*u^10*v+1370112*u^9*v^4-868352*u^9*v^3-2781184*u^9*v^2+884736*u^9*v-693760*u^8*v^5+1046528*u^8*v^4+2174976*u^8*v^3-1662976*u^8*v^2-712704*u^8*v+203200*u^7*v^6-688128*u^7*v^5-1131008*u^7*v^4+1275904*u^7*v^3+1115136*u^7*v^2+172032*u^7*v-34800*u^6*v^7+273280*u^6*v^6+430400*u^6*v^5-505344*u^6*v^4-744192*u^6*v^3-258048*u^6*v^2+9216*u^6*v+3248*u^5*v^8-67648*u^5*v^7-118320*u^5*v^6+103040*u^5*v^5+274560*u^5*v^4+161280*u^5*v^3-11520*u^5*v^2-128*u^4*v^9+10248*u^4*v^8+22216*u^4*v^7-6944*u^4*v^6-60480*u^4*v^5-53760*u^4*v^4+5760*u^4*v^3-872*u^3*v^9-2644*u^3*v^8-1176*u^3*v^7+7956*u^3*v^6+10080*u^3*v^5-1440*u^3*v^4+32*u^2*v^10+177*u^2*v^9+254*u^2*v^8-579*u^2*v^7-1008*u^2*v^6+180*u^2*v^5-5*u*v^10-14*u*v^9+18*u*v^8+42*u*v^7-9*u*v^6);

g=(65536*u^11*v^3-147456*u^10*v^4+196608*u^10*v^2+122880*u^9*v^5+16384*u^9*v^4-262144*u^9*v^3-65536*u^9*v^2-51200*u^8*v^6-36864*u^8*v^5+159744*u^8*v^4+196608*u^8*v^3-49152*u^8*v^2-196608*u^8*v+11520*u^7*v^7+30720*u^7*v^6-61440*u^7*v^5-184320*u^7*v^4+61440*u^7*v^3+245760*u^7*v^2-1344*u^6*v^8-12800*u^6*v^7+16640*u^6*v^6+81920*u^6*v^5-30720*u^6*v^4-122880*u^6*v^3+64*u^5*v^9+2880*u^5*v^8-3072*u^5*v^7-19200*u^5*v^6+7680*u^5*v^5+30720*u^5*v^4-336*u^4*v^9+336*u^4*v^8+2304*u^4*v^7-960*u^4*v^6-3840*u^4*v^5+16*u^3*v^10-16*u^3*v^9-112*u^3*v^8+48*u^3*v^7+192*u^3*v^6);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(-587202560*u^22*v^6+1308622848*u^21*v^7-301989888*u^21*v^6+1174405120*u^21*v^5-1296039936*u^20*v^8+666894336*u^20*v^7-2227175424*u^20*v^6+1191182336*u^20*v^5-587202560*u^20*v^4+748683264*u^19*v^9-654311424*u^19*v^8+1627389952*u^19*v^7-2625634304*u^19*v^6+830472192*u^19*v^5-1476395008*u^19*v^4-278003712*u^18*v^10+374341632*u^18*v^9-387973120*u^18*v^8+2594177024*u^18*v^7-244318208*u^18*v^6+3007315968*u^18*v^5-213909504*u^18*v^4+587202560*u^18*v^3+68812800*u^17*v^11-137625600*u^17*v^10-231997440*u^17*v^9-1524629504*u^17*v^8-356515840*u^17*v^7-2648702976*u^17*v^6+849346560*u^17*v^5-805306368*u^17*v^4+301989888*u^17*v^3-11354112*u^16*v^12+33718272*u^16*v^11+248217600*u^16*v^10+601227264*u^16*v^9+481689600*u^16*v^8+1310457856*u^16*v^7-1249116160*u^16*v^6+135266304*u^16*v^5-995098624*u^16*v^4-243269632*u^16*v^3+1204224*u^15*v^13-5505024*u^15*v^12-114229248*u^15*v^11-172818432*u^15*v^10-319488000*u^15*v^9-399507456*u^15*v^8+975175680*u^15*v^7+449314816*u^15*v^6+1376256000*u^15*v^5+570425344*u^15*v^4+58720256*u^15*v^3-74496*u^14*v^14+577536*u^14*v^13+33460224*u^14*v^12+39223296*u^14*v^11+142270464*u^14*v^10+82083840*u^14*v^9-456622080*u^14*v^8-448659456*u^14*v^7-1077411840*u^14*v^6-603193344*u^14*v^5-131334144*u^14*v^4+3145728*u^14*v^3+2048*u^13*v^15-35328*u^13*v^14-6750720*u^13*v^13-7520256*u^13*v^12-45244416*u^13*v^11-15482880*u^13*v^10+131776512*u^13*v^9+216662016*u^13*v^8+534773760*u^13*v^7+379060224*u^13*v^6+130547712*u^13*v^5-6291456*u^13*v^4+960*u^12*v^15+944960*u^12*v^14+1226496*u^12*v^13+10287360*u^12*v^12+4061184*u^12*v^11-21719040*u^12*v^10-63823872*u^12*v^9-176676864*u^12*v^8-156893184*u^12*v^7-75694080*u^12*v^6+5505024*u^12*v^5-88320*u^11*v^15-158336*u^11*v^14-1628800*u^11*v^13-1081344*u^11*v^12+1136640*u^11*v^11+11956224*u^11*v^10+39309312*u^11*v^9+44728320*u^11*v^8+28213248*u^11*v^7-2752512*u^11*v^6+4976*u^10*v^16+14432*u^10*v^15+170160*u^10*v^14+199744*u^10*v^13+290880*u^10*v^12-1353984*u^10*v^11-5760000*u^10*v^10-8902656*u^10*v^9-7010304*u^10*v^8+860160*u^10*v^7-128*u^9*v^17-800*u^9*v^16-10528*u^9*v^15-22752*u^9*v^14-67680*u^9*v^13+70144*u^9*v^12+514560*u^9*v^11+1222656*u^9*v^10+1161216*u^9*v^9-172032*u^9*v^8+20*u^8*v^17+292*u^8*v^16+1452*u^8*v^15+5916*u^8*v^14+2256*u^8*v^13-21840*u^8*v^12-110976*u^8*v^11-123648*u^8*v^10+21504*u^8*v^9-40*u^7*v^16-200*u^7*v^15-504*u^7*v^14-152*u^7*v^13+6016*u^7*v^12+7680*u^7*v^11-1536*u^7*v^10+20*u^6*v^15+36*u^6*v^14-148*u^6*v^13-212*u^6*v^12+48*u^6*v^11);

g=(-47185920*u^21*v^7+301989888*u^21*v^6+135266304*u^20*v^8-761266176*u^20*v^7+163577856*u^20*v^6-301989888*u^20*v^5-159842304*u^19*v^9+873201664*u^19*v^8-570163200*u^19*v^7+813694976*u^19*v^6+59768832*u^19*v^5-402653184*u^19*v^4+105086976*u^18*v^10-605421568*u^18*v^9+767819776*u^18*v^8-1006895104*u^18*v^7+294125568*u^18*v^6+912261120*u^18*v^5-713031680*u^18*v^4+402653184*u^18*v^3-42971136*u^17*v^11+283197440*u^17*v^10-566050816*u^17*v^9+780664832*u^17*v^8-733544448*u^17*v^7-944504832*u^17*v^6+1355546624*u^17*v^5-973078528*u^17*v^4+483393536*u^17*v^3+100663296*u^17*v^2+11427840*u^16*v^12-93995008*u^16*v^11+261398528*u^16*v^10-424591360*u^16*v^9+700252160*u^16*v^8+504627200*u^16*v^7-1089601536*u^16*v^6+1263796224*u^16*v^5-1270874112*u^16*v^4-346030080*u^16*v^3+398458880*u^16*v^2-100663296*u^16*v-1986816*u^15*v^13+22541312*u^15*v^12-80757760*u^15*v^11+167518208*u^15*v^10-378572800*u^15*v^9-99500032*u^15*v^8+484917248*u^15*v^7-954859520*u^15*v^6+1386676224*u^15*v^5+139722752*u^15*v^4-593756160*u^15*v^3+461373440*u^15*v^2-344981504*u^15*v+218496*u^14*v^14-3882496*u^14*v^13+17297408*u^14*v^12-47684608*u^14*v^11+131680256*u^14*v^10-37199872*u^14*v^9-133611520*u^14*v^8+413188096*u^14*v^7-874545152*u^14*v^6+178388992*u^14*v^5+430440448*u^14*v^4-490471424*u^14*v^3+581435392*u^14*v^2-106954752*u^14*v-13824*u^13*v^15+466112*u^13*v^14-2624704*u^13*v^13+9552896*u^13*v^12-31446784*u^13*v^11+30632960*u^13*v^10+24998912*u^13*v^9-91848704*u^13*v^8+374026240*u^13*v^7-195117056*u^13*v^6-218021888*u^13*v^5+207880192*u^13*v^4-482803712*u^13*v^3+158072832*u^13*v^2+68419584*u^13*v+384*u^12*v^16-36640*u^12*v^15+286304*u^12*v^14-1292608*u^12*v^13+5391872*u^12*v^12-9428992*u^12*v^11-3314176*u^12*v^10+2993152*u^12*v^9-119730176*u^12*v^8+81559552*u^12*v^7+81043456*u^12*v^6-20922368*u^12*v^5+279445504*u^12*v^4-100663296*u^12*v^3-119144448*u^12*v^2+7077888*u^12*v+1664*u^11*v^16-22432*u^11*v^15+110240*u^11*v^14-686080*u^11*v^13+1616960*u^11*v^12+115904*u^11*v^11+3771904*u^11*v^10+29638912*u^11*v^9-17306624*u^11*v^8-17865728*u^11*v^7-14606336*u^11*v^6-124448768*u^11*v^5+37109760*u^11*v^4+88915968*u^11*v^3-10616832*u^11*v^2-32*u^10*v^17+1184*u^10*v^16-5184*u^10*v^15+64640*u^10*v^14-159232*u^10*v^13+103808*u^10*v^12-1016000*u^10*v^11-5419136*u^10*v^10+1618432*u^10*v^9+517120*u^10*v^8+6691840*u^10*v^7+41076736*u^10*v^6-9216000*u^10*v^5-36864000*u^10*v^4+6635520*u^10*v^3-32*u^9*v^17+96*u^9*v^16-4096*u^9*v^15+8192*u^9*v^14-30080*u^9*v^13+122176*u^9*v^12+654208*u^9*v^11+46912*u^9*v^10+849088*u^9*v^9-1347584*u^9*v^8-9337088*u^9*v^7+1717248*u^9*v^6+9169920*u^9*v^5-2211840*u^9*v^4+128*u^8*v^16-160*u^8*v^15+3552*u^8*v^14-7168*u^8*v^13-41920*u^8*v^12-25376*u^8*v^11-228128*u^8*v^10+154432*u^8*v^9+1355008*u^8*v^8-242688*u^8*v^7-1368576*u^8*v^6+414720*u^8*v^5-160*u^7*v^15+160*u^7*v^14+448*u^7*v^13+2176*u^7*v^12+25376*u^7*v^11-10208*u^7*v^10-112256*u^7*v^9+22464*u^7*v^8+113472*u^7*v^7-41472*u^7*v^6+64*u^6*v^14-64*u^6*v^13-1088*u^6*v^12+320*u^6*v^11+4032*u^6*v^10-960*u^6*v^9-4032*u^6*v^8+1728*u^6*v^7);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(16384*u^14*v^3-24576*u^13*v^4-32768*u^13*v^2+15360*u^12*v^5+49152*u^12*v^3+16384*u^12*v-5120*u^11*v^6-30720*u^11*v^4-24576*u^11*v^2+960*u^10*v^7+10240*u^10*v^5+15360*u^10*v^3-96*u^9*v^8-1920*u^9*v^6-5120*u^9*v^4+4*u^8*v^9+192*u^8*v^7+960*u^8*v^5-8*u^7*v^8-96*u^7*v^6+4*u^6*v^7);

g=(226492416*u^22*v^6-603979776*u^21*v^7+226492416*u^21*v^6-796917760*u^21*v^5+717225984*u^20*v^8-723517440*u^20*v^7+2032140288*u^20*v^6-268435456*u^20*v^5+419430400*u^20*v^4-500170752*u^19*v^9+994050048*u^19*v^8-2407530496*u^19*v^7+1113587712*u^19*v^6-656408576*u^19*v^5-268435456*u^19*v^4+251658240*u^19*v^3+227082240*u^18*v^10-786432000*u^18*v^9+1780482048*u^18*v^8-1749024768*u^18*v^7+392167424*u^18*v^6+281018368*u^18*v^5-1170210816*u^18*v^4+545259520*u^18*v^3-75497472*u^18*v^2-70189056*u^17*v^11+400883712*u^17*v^10-930152448*u^17*v^9+1500512256*u^17*v^8-181403648*u^17*v^7+104857600*u^17*v^6+2017460224*u^17*v^5-1388314624*u^17*v^4+113246208*u^17*v^3-75497472*u^17*v^2-25165824*u^17*v+14966784*u^16*v^12-138657792*u^16*v^11+365150208*u^16*v^10-809238528*u^16*v^9+171048960*u^16*v^8-344457216*u^16*v^7-1778384896*u^16*v^6+1673003008*u^16*v^5-356515840*u^16*v^4+253755392*u^16*v^3+555745280*u^16*v^2-159383552*u^16*v-2174976*u^15*v^13+33202176*u^15*v^12-110272512*u^15*v^11+293879808*u^15*v^10-147505152*u^15*v^9+278396928*u^15*v^8+899284992*u^15*v^7-1270349824*u^15*v^6+497025024*u^15*v^5-433061888*u^15*v^4-847249408*u^15*v^3+501219328*u^15*v^2-270532608*u^15*v+206208*u^14*v^14-5486592*u^14*v^13+25491456*u^14*v^12-74661888*u^14*v^11+76726272*u^14*v^10-133005312*u^14*v^9-266108928*u^14*v^8+669843456*u^14*v^7-322633728*u^14*v^6+477626368*u^14*v^5+580386816*u^14*v^4-684195840*u^14*v^3+427819008*u^14*v^2-37748736*u^14*v-11520*u^13*v^15+608640*u^13*v^14-4397952*u^13*v^13+13621248*u^13*v^12-24619008*u^13*v^11+45416448*u^13*v^10+42319872*u^13*v^9-250380288*u^13*v^8+107839488*u^13*v^7-357236736*u^13*v^6-257753088*u^13*v^5+526909440*u^13*v^4-284688384*u^13*v^3+94371840*u^13*v^2+56623104*u^13*v+288*u^12*v^16-42528*u^12*v^15+542752*u^12*v^14-1833984*u^12*v^13+5006592*u^12*v^12-12140544*u^12*v^11-2445312*u^12*v^10+64253952*u^12*v^9-18063360*u^12*v^8+183091200*u^12*v^7+101302272*u^12*v^6-248709120*u^12*v^5+114032640*u^12*v^4-103809024*u^12*v^3-113246208*u^12*v^2+1632*u^11*v^16-44832*u^11*v^15+188512*u^11*v^14-635680*u^11*v^13+2586624*u^11*v^12+71424*u^11*v^11-10100736*u^11*v^10+1843200*u^11*v^9-64339968*u^11*v^8-38019072*u^11*v^7+71909376*u^11*v^6-40943616*u^11*v^5+66060288*u^11*v^4+99090432*u^11*v^3-24*u^10*v^17+2200*u^10*v^16-14976*u^10*v^15+46688*u^10*v^14-418112*u^10*v^13-136128*u^10*v^12+537216*u^10*v^11-713856*u^10*v^10+15304704*u^10*v^9+10979328*u^10*v^8-11096064*u^10*v^7+16859136*u^10*v^6-26836992*u^10*v^5-49545216*u^10*v^4-48*u^9*v^17+840*u^9*v^16-1592*u^9*v^15+46784*u^9*v^14+39552*u^9*v^13+132416*u^9*v^12+303552*u^9*v^11-2366592*u^9*v^10-1981824*u^9*v^9+92160*u^9*v^8-5978112*u^9*v^7+7225344*u^9*v^6+15482880*u^9*v^5-24*u^8*v^17+8*u^8*v^16-3160*u^8*v^15-4432*u^8*v^14-32168*u^8*v^13-61920*u^8*v^12+213024*u^8*v^11+171552*u^8*v^10+320640*u^8*v^9+1422336*u^8*v^8-1290240*u^8*v^7-3096576*u^8*v^6+96*u^7*v^16+184*u^7*v^15+2936*u^7*v^14+6112*u^7*v^13-7088*u^7*v^12+2656*u^7*v^11-63520*u^7*v^10-206880*u^7*v^9+147456*u^7*v^8+387072*u^7*v^7-104*u^6*v^15-240*u^6*v^14-400*u^6*v^13-1712*u^6*v^12+5528*u^6*v^11+16704*u^6*v^10-9792*u^6*v^9-27648*u^6*v^8+32*u^5*v^14+96*u^5*v^13-192*u^5*v^12-576*u^5*v^11+288*u^5*v^10+864*u^5*v^9);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(52848230400*u^30*v^10-338228674560*u^30*v^9-216426086400*u^29*v^11+1453879984128*u^29*v^10-1318991167488*u^29*v^9+377229410304*u^28*v^12-2876042641408*u^28*v^11+5403127578624*u^28*v^10-1913240158208*u^28*v^9-514389442560*u^28*v^8+2480343613440*u^28*v^7-372268597248*u^27*v^13+3452153364480*u^27*v^12-9774806597632*u^27*v^11+7477110243328*u^27*v^10-2700922060800*u^27*v^9-8007094108160*u^27*v^8+10522871201792*u^27*v^7-2705829396480*u^27*v^6+233646981120*u^26*v^14-2772906278912*u^26*v^13+10476387303424*u^26*v^12-13422064304128*u^26*v^11+11034154762240*u^26*v^10+8590437908480*u^26*v^9-29618362908672*u^26*v^8+17962694082560*u^26*v^7-9466779009024*u^26*v^6-1803886264320*u^26*v^5-98829729792*u^25*v^15+1561023086592*u^25*v^14-7519372181504*u^25*v^13+14305345404928*u^25*v^12-17063328874496*u^25*v^11+1819898019840*u^25*v^10+36069321998336*u^25*v^9-44961126940672*u^25*v^8+36497289904128*u^25*v^7+119051124736*u^25*v^6-11520847118336*u^25*v^5+3607772528640*u^25*v^4+28950552576*u^24*v^16-631083663360*u^24*v^15+3859091062784*u^24*v^14-10072857116672*u^24*v^13+15700472496128*u^24*v^12-12920068505600*u^24*v^11-23603843694592*u^24*v^10+53928643264512*u^24*v^9-61918236639232*u^24*v^8+29128887631872*u^24*v^7+22640567779328*u^24*v^6-29600511950848*u^24*v^5+17721639043072*u^24*v^4-676457349120*u^24*v^3-5904101376*u^23*v^17+185241772032*u^23*v^16-1469308772352*u^23*v^15+4978579046400*u^23*v^14-9877888925696*u^23*v^13+14380155666432*u^23*v^12+6464711557120*u^23*v^11-36189369794560*u^23*v^10+62948141170688*u^23*v^9-62490356482048*u^23*v^8-12181491941376*u^23*v^7+47472894279680*u^23*v^6-51076338286592*u^23*v^5+23221478883328*u^23*v^4-1383717666816*u^23*v^3-901943132160*u^23*v^2+824758272*u^22*v^18-39464896512*u^22*v^17+422569936896*u^22*v^16-1796062814208*u^22*v^15+4509725040640*u^22*v^14-9080870502400*u^22*v^13+2733823262720*u^22*v^12+14101569732608*u^22*v^11-40999690698752*u^22*v^10+63269440061440*u^22*v^9-14597500174336*u^22*v^8-31434462986240*u^22*v^7+71501541801984*u^22*v^6-61401389334528*u^22*v^5+7956628242432*u^22*v^4+6687733841920*u^22*v^3-6440404123648*u^22*v^2+338228674560*u^22*v-75386880*u^21*v^19+6025079808*u^21*v^18-92087110656*u^21*v^17+485806970880*u^21*v^16-1531491809280*u^21*v^15+3877819244544*u^21*v^14-3774626979840*u^21*v^13-2561536065536*u^21*v^12+16691685785600*u^21*v^11-39923396902912*u^21*v^10+27843125575680*u^21*v^9+6489709215744*u^21*v^8-51723503665152*u^21*v^7+73756810674176*u^21*v^6-30743568842752*u^21*v^5-2078361518080*u^21*v^4+21561138479104*u^21*v^3-14738616483840*u^21*v^2+2347770052608*u^21*v+4067328*u^20*v^20-640017408*u^20*v^19+15042928128*u^20*v^18-100344188928*u^20*v^17+389414721024*u^20*v^16-1204456802304*u^20*v^15+2009514743808*u^20*v^14-449156210688*u^20*v^13-3575313842176*u^20*v^12+17530730840064*u^20*v^11-20602415939584*u^20*v^10+5484122996736*u^20*v^9+16772287954944*u^20*v^8-55137857961984*u^20*v^7+41002875224064*u^20*v^6-6733032325120*u^20*v^5-17290114367488*u^20*v^4+26878517706752*u^20*v^3-12401357357056*u^20*v^2+4814624784384*u^20*v-98304*u^19*v^21+44680192*u^19*v^20-1794271488*u^19*v^19+15976027136*u^19*v^18-73879631616*u^19*v^17+282466226688*u^19*v^16-670269934080*u^19*v^15+501136386048*u^19*v^14-88733079552*u^19*v^13-5525972041728*u^19*v^12+8941929414656*u^19*v^11-6059940184064*u^19*v^10+1357380911104*u^19*v^9+28208144318464*u^19*v^8-28015198994432*u^19*v^7+10793201434624*u^19*v^6+1344068911104*u^19*v^5-26617285967872*u^19*v^4+16269778616320*u^19*v^3-6583371169792*u^19*v^2+1954654715904*u^19*v-1827840*u^18*v^21+148966144*u^18*v^20-1951864192*u^18*v^19+10370889600*u^18*v^18-50646474880*u^18*v^17+154417168768*u^18*v^16-196831087104*u^18*v^15+317034307584*u^18*v^14+1183627739136*u^18*v^13-2580689104896*u^18*v^12+3091185352704*u^18*v^11-3580512780288*u^18*v^10-9592794185728*u^18*v^9+12127749865472*u^18*v^8-8605532946432*u^18*v^7+5454661550080*u^18*v^6+16748781240320*u^18*v^5-11500832423936*u^18*v^4+5102494547968*u^18*v^3-2949466030080*u^18*v^2-1647556165632*u^18*v+32768*u^17*v^22-7896832*u^17*v^21+178037824*u^17*v^20-1069773760*u^17*v^19+6841130560*u^17*v^18-25614060480*u^17*v^17+49462372480*u^17*v^16-108141835392*u^17*v^15-130867418112*u^17*v^14+556734987264*u^17*v^13-916313051136*u^17*v^12+1744219656192*u^17*v^11+1881126027264*u^17*v^10-4061011460096*u^17*v^9+3724796952576*u^17*v^8-4456313585664*u^17*v^7-6450705727488*u^17*v^6+6562090188800*u^17*v^5-2425773096960*u^17*v^4+2218035511296*u^17*v^3+2272945766400*u^17*v^2-394342170624*u^17*v+224000*u^16*v^22-11369152*u^16*v^21+81546560*u^16*v^20-662447616*u^16*v^19+3165997312*u^16*v^18-8379438656*u^16*v^17+21660646080*u^16*v^16-8789692672*u^16*v^15-104723894272*u^16*v^14+127784961024*u^16*v^13-580595865600*u^16*v^12-128372477952*u^16*v^11+1208934445056*u^16*v^10-594241142784*u^16*v^9+2488695742464*u^16*v^8+1576154136576*u^16*v^7-3551103123456*u^16*v^6-93004627968*u^16*v^5-1666593718272*u^16*v^4-1469515825152*u^16*v^3+909013155840*u^16*v^2+364256428032*u^16*v-2048*u^15*v^23+446144*u^15*v^22-4704320*u^15*v^21+41351936*u^15*v^20-303202688*u^15*v^19+903657984*u^15*v^18-3183874304*u^15*v^17+5797531968*u^15*v^16+17934835648*u^15*v^15+10147173376*u^15*v^14+163962882560*u^15*v^13+1476974592*u^15*v^12-280649263104*u^15*v^11-186861858816*u^15*v^10-1193155633152*u^15*v^9-464472563712*u^15*v^8+1483761868800*u^15*v^7+926630117376*u^15*v^6+1396055900160*u^15*v^5+821045624832*u^15*v^4-911996485632*u^15*v^3-680029323264*u^15*v^2-37243846656*u^15*v-7872*u^14*v^23+201536*u^14*v^22-1263552*u^14*v^21+22764992*u^14*v^20-50363264*u^14*v^19+391002880*u^14*v^18-892049600*u^14*v^17-2235016512*u^14*v^16-7800489536*u^14*v^15-38187017152*u^14*v^14-15902543104*u^14*v^13+28600385280*u^14*v^12+115222081536*u^14*v^11+438972324864*u^14*v^10+254589499392*u^14*v^9-353183127552*u^14*v^8-571285020672*u^14*v^7-886835109888*u^14*v^6-510446370816*u^14*v^5+497850679296*u^14*v^4+570325598208*u^14*v^3+82237980672*u^14*v^2-10956570624*u^14*v-4864*u^13*v^23-5312*u^13*v^22-1212992*u^13*v^21-71744*u^13*v^20-39517504*u^13*v^19+49957184*u^13*v^18+104653120*u^13*v^17+1423405184*u^13*v^16+6398062464*u^13*v^15+7460222784*u^13*v^14+6636401088*u^13*v^13-22754256640*u^13*v^12-109114461440*u^13*v^11-108234356736*u^13*v^10+8686848000*u^13*v^9+169000433664*u^13*v^8+367646681088*u^13*v^7+263791632384*u^13*v^6-146235580416*u^13*v^5-285935173632*u^13*v^4-77659471872*u^13*v^3+19110297600*u^13*v^2-382205952*u^13*v+960*u^12*v^23+32832*u^12*v^22+161792*u^12*v^21+2700160*u^12*v^20+2098048*u^12*v^19+15104640*u^12*v^18-115166016*u^12*v^17-661111872*u^12*v^16-1507243328*u^12*v^15-3005409728*u^12*v^14+1019880256*u^12*v^13+16404099008*u^12*v^12+27610529280*u^12*v^11+21493252608*u^12*v^10-23583372288*u^12*v^9-96424607232*u^12*v^8-94389184512*u^12*v^7+13561509888*u^12*v^6+96093609984*u^12*v^5+41140224000*u^12*v^4-14284947456*u^12*v^3+573308928*u^12*v^2-5760*u^11*v^22-86144*u^11*v^21-391680*u^11*v^20-2538752*u^11*v^19+1696320*u^11*v^18+31017792*u^11*v^17+155736192*u^11*v^16+487861248*u^11*v^15+368073856*u^11*v^14-1118403200*u^11*v^13-4139854784*u^11*v^12-6721273664*u^11*v^11-279917568*u^11*v^10+15110684928*u^11*v^9+22798407168*u^11*v^8+5622428160*u^11*v^7-22824695808*u^11*v^6-13409556480*u^11*v^5+5932154880*u^11*v^4-358318080*u^11*v^3+13440*u^10*v^21+113536*u^10*v^20+330560*u^10*v^19+474176*u^10*v^18-7090624*u^10*v^17-36916288*u^10*v^16-72345856*u^10*v^15-41430144*u^10*v^14+331577536*u^10*v^13+960289856*u^10*v^12+676633792*u^10*v^11-1116438720*u^10*v^10-3716339328*u^10*v^9-2344090752*u^10*v^8+3865729536*u^10*v^7+2758800384*u^10*v^6-1478062080*u^10*v^5+119439360*u^10*v^4-15360*u^9*v^20-79104*u^9*v^19-14528*u^9*v^18+828352*u^9*v^17+5232192*u^9*v^16+11950400*u^9*v^15-7487936*u^9*v^14-63259072*u^9*v^13-114258880*u^9*v^12-26196672*u^9*v^11+399022464*u^9*v^10+397115136*u^9*v^9-448509312*u^9*v^8-350241408*u^9*v^7+220962816*u^9*v^6-22394880*u^9*v^5+8640*u^8*v^19+27200*u^8*v^18-117888*u^8*v^17-541440*u^8*v^16-761856*u^8*v^15+622336*u^8*v^14+8877696*u^8*v^13+10654848*u^8*v^12-25884864*u^8*v^11-33765696*u^8*v^10+31891968*u^8*v^9+25100928*u^8*v^8-18351360*u^8*v^7+2239488*u^8*v^6-1920*u^7*v^18-3456*u^7*v^17+44928*u^7*v^16+91008*u^7*v^15-284928*u^7*v^14-546048*u^7*v^13+776448*u^7*v^12+1181952*u^7*v^11-1040256*u^7*v^10-777600*u^7*v^9+653184*u^7*v^8-93312*u^7*v^7);

g=(-253671505920*u^31*v^9+988110913536*u^30*v^10-1229702823936*u^30*v^9+338228674560*u^30*v^8-1692351332352*u^29*v^11+4942366507008*u^29*v^10-3377253580800*u^29*v^9+1075889307648*u^29*v^8+1691143372800*u^29*v^7+1701713018880*u^28*v^12-8772202266624*u^28*v^11+10278662045696*u^28*v^10-8363844829184*u^28*v^9-3435705401344*u^28*v^8+8620804669440*u^28*v^7-4171486986240*u^28*v^6-1126176915456*u^27*v^13+9178781319168*u^27*v^12-16639659606016*u^27*v^11+20678287818752*u^27*v^10-2997132197888*u^27*v^9-21107885211648*u^27*v^8+21996138135552*u^27*v^7-16952235917312*u^27*v^6+2423972167680*u^27*v^5+519120617472*u^26*v^14-6351457615872*u^26*v^13+17080430624768*u^26*v^12-27565771194368*u^26*v^11+18641919672320*u^26*v^10+19548375875584*u^26*v^9-47679035932672*u^26*v^8+54750900912128*u^26*v^7-17818477133824*u^26*v^6+4563134316544*u^26*v^5+1014686023680*u^26*v^4-171475992576*u^25*v^15+3080226078720*u^25*v^14-12063912493056*u^25*v^13+23857490558976*u^25*v^12-29753910231040*u^25*v^11-3264221282304*u^25*v^10+51781975408640*u^25*v^9-86221065814016*u^25*v^8+63292114468864*u^25*v^7-15700521385984*u^25*v^6-17395557072896*u^25*v^5+10668698763264*u^25*v^4-1240171806720*u^25*v^3+40998666240*u^24*v^16-1079403872256*u^24*v^15+6126577385472*u^24*v^14-14707249905664*u^24*v^13+26979508158464*u^24*v^12-11707793539072*u^24*v^11-29275033960448*u^24*v^10+84905971154944*u^24*v^9-103700928397312*u^24*v^8+40014834565120*u^24*v^7+18741156904960*u^24*v^6-45301838643200*u^24*v^5+31040533954560*u^24*v^4-7336609447936*u^24*v^3+112742891520*u^24*v^2-7055216640*u^23*v^17+277017329664*u^23*v^16-2291566313472*u^23*v^15+6802082365440*u^23*v^14-16245052276736*u^23*v^13+15324776759296*u^23*v^12+5448763703296*u^23*v^11-54599025164288*u^23*v^10+98241966243840*u^23*v^9-67989550399488*u^23*v^8+8133762088960*u^23*v^7+73949337616384*u^23*v^6-73100041388032*u^23*v^5+32643362062336*u^23*v^4-9364639318016*u^23*v^3-242665652224*u^23*v^2+84557168640*u^23*v+853438464*u^22*v^18-52060409856*u^22*v^17+638197776384*u^22*v^16-2426871939072*u^22*v^15+6958816428032*u^22*v^14-10731389452288*u^22*v^13+4354935357440*u^22*v^12+21615135948800*u^22*v^11-61258497785856*u^22*v^10+70588520464384*u^22*v^9-32228578951168*u^22*v^8-54489713213440*u^22*v^7+88471913889792*u^22*v^6-73203321929728*u^22*v^5+24484333486080*u^22*v^4+9150696259584*u^22*v^3-5519569846272*u^22*v^2+832686784512*u^22*v-68963328*u^21*v^19+7066672128*u^21*v^18-132350333952*u^21*v^17+675040002048*u^21*v^16-2207895158784*u^21*v^15+5061152440320*u^21*v^14-4344942329856*u^21*v^13-3642917126144*u^21*v^12+26773613445120*u^21*v^11-46431755304960*u^21*v^10+35059732054016*u^21*v^9+12827213430784*u^21*v^8-69999666397184*u^21*v^7+83485112926208*u^21*v^6-38915616538624*u^21*v^5-3227667922944*u^21*v^4+19657394225152*u^21*v^3-14842266124288*u^21*v^2+2886419349504*u^21*v+3345408*u^20*v^20-671468544*u^20*v^19+20216690688*u^20*v^18-145924807680*u^20*v^17+533867704320*u^20*v^16-1708719132672*u^20*v^15+2140940419072*u^20*v^14-1127017512960*u^20*v^13-8153365610496*u^20*v^12+20264335441920*u^20*v^11-23897640534016*u^20*v^10+8610170011648*u^20*v^9+36593328979968*u^20*v^8-55726780186624*u^20*v^7+45158829654016*u^20*v^6-10062496006144*u^20*v^5-26779406303232*u^20*v^4+22805638807552*u^20*v^3-11680230670336*u^20*v^2+3829030453248*u^20*v-73728*u^19*v^21+42068736*u^19*v^20-2219130368*u^19*v^19+24152580608*u^19*v^18-100680704768*u^19*v^17+420908654592*u^19*v^16-736732581888*u^19*v^15+953287802880*u^19*v^14+1470982512640*u^19*v^13-6090643472384*u^19*v^12+11361477328896*u^19*v^11-8894275387392*u^19*v^10-10836084260864*u^19*v^9+24784345759744*u^19*v^8-35343216672768*u^19*v^7+12390125010944*u^19*v^6+16437437530112*u^19*v^5-18558167810048*u^19*v^4+19011890839552*u^19*v^3-4172795609088*u^19*v^2+695130390528*u^19*v-1542912*u^18*v^21+167203072*u^18*v^20-2979105536*u^18*v^19+15068172032*u^18*v^18-75695678976*u^18*v^17+191857910784*u^18*v^16-320857096192*u^18*v^15+15209435136*u^18*v^14+1311573430272*u^18*v^13-3752527970304*u^18*v^12+4156001746944*u^18*v^11+409935937536*u^18*v^10-8292870651904*u^18*v^9+17752187731968*u^18*v^8-8344514330624*u^18*v^7-3500872302592*u^18*v^6+12071054868480*u^18*v^5-15703105077248*u^18*v^4+2096111812608*u^18*v^3-1634067283968*u^18*v^2-1399421140992*u^18*v+24576*u^17*v^22-7941440*u^17*v^21+262223936*u^17*v^20-1795433600*u^17*v^19+9832186688*u^17*v^18-38195000768*u^17*v^17+67642249216*u^17*v^16-103341989888*u^17*v^15-212809252864*u^17*v^14+813404645376*u^17*v^13-1367608983552*u^17*v^12+1012488028160*u^17*v^11+2152465367040*u^17*v^10-5628109848576*u^17*v^9+4727728766976*u^17*v^8-826894712832*u^17*v^7-6136376852480*u^17*v^6+7532487114752*u^17*v^5-2053820645376*u^17*v^4+647667646464*u^17*v^3+1993171009536*u^17*v^2-73496788992*u^17*v+198720*u^16*v^22-15332544*u^16*v^21+166033216*u^16*v^20-907202304*u^16*v^19+5664061696*u^16*v^18-10051504576*u^16*v^17+34244757248*u^16*v^16+25293858304*u^16*v^15-99014192128*u^16*v^14+361348970496*u^16*v^13-407182233600*u^16*v^12-305932111872*u^16*v^11+1154293514240*u^16*v^10-2201592070144*u^16*v^9+399013052416*u^16*v^8+1659945091072*u^16*v^7-2709385641984*u^16*v^6+2038996402176*u^16*v^5+943435284480*u^16*v^4-664632557568*u^16*v^3+576196706304*u^16*v^2+270771683328*u^16*v-1536*u^15*v^23+521104*u^15*v^22-11122160*u^15*v^21+59050672*u^15*v^20-593645968*u^15*v^19+1177031936*u^15*v^18-6109288640*u^15*v^17-704543488*u^15*v^16+2844790784*u^15*v^15-74031232000*u^15*v^14+73062756864*u^15*v^13-56133091328*u^15*v^12-208986144768*u^15*v^11+684103335936*u^15*v^10+63825752064*u^15*v^9+166163054592*u^15*v^8+1205092810752*u^15*v^7-943857598464*u^15*v^6-1096474558464*u^15*v^5-499217596416*u^15*v^4-1035240210432*u^15*v^3-627836977152*u^15*v^2-56056872960*u^15*v-7440*u^14*v^23+471488*u^14*v^22-2830576*u^14*v^21+40134560*u^14*v^20-122636944*u^14*v^19+625169952*u^14*v^18-688839024*u^14*v^17+480807296*u^14*v^16+9443703296*u^14*v^15-6656759552*u^14*v^14+43620437504*u^14*v^13+60743914496*u^14*v^12-101678772224*u^14*v^11-35855253504*u^14*v^10-295650459648*u^14*v^9-610879242240*u^14*v^8+75507499008*u^14*v^7+427335745536*u^14*v^6+549732483072*u^14*v^5+900293197824*u^14*v^4+659347734528*u^14*v^3+125363552256*u^14*v^2-3057647616*u^14*v-9296*u^13*v^23+108808*u^13*v^22-1427552*u^13*v^21+11111776*u^13*v^20-28586304*u^13*v^19+198803480*u^13*v^18+122299696*u^13*v^17-130232960*u^13*v^16+953500608*u^13*v^15-10611005312*u^13*v^14-17988958080*u^13*v^13-9145614336*u^13*v^12-14115142656*u^13*v^11+97731572736*u^13*v^10+224249392128*u^13*v^9+121934020608*u^13*v^8-18801672192*u^13*v^7-216996544512*u^13*v^6-456922791936*u^13*v^5-413759176704*u^13*v^4-124599140352*u^13*v^3+6115295232*u^13*v^2-2712*u^12*v^23+7944*u^12*v^22-695776*u^12*v^21-700752*u^12*v^20-27386568*u^12*v^19-52964216*u^12*v^18-195089392*u^12*v^17-372789952*u^12*v^16+1099665328*u^12*v^15+3155557504*u^12*v^14+7282699392*u^12*v^13+11267258624*u^12*v^12-12175540736*u^12*v^11-49717386240*u^12*v^10-63962127360*u^12*v^9-46115758080*u^12*v^8+34568626176*u^12*v^7+143352889344*u^12*v^6+172138659840*u^12*v^5+72236924928*u^12*v^4-5350883328*u^12*v^3+680*u^11*v^23+20376*u^11*v^22+131904*u^11*v^21+1972128*u^11*v^20+6950296*u^11*v^19+35601992*u^11*v^18+82202304*u^11*v^17+28797760*u^11*v^16-220245376*u^11*v^15-1409603840*u^11*v^14-2974720896*u^11*v^13-1054870528*u^11*v^12+5452555264*u^11*v^11+15640398336*u^11*v^10+19716786432*u^11*v^9+4041805824*u^11*v^8-27050913792*u^11*v^7-49700044800*u^11*v^6-26921631744*u^11*v^5+2675441664*u^11*v^4-3880*u^10*v^22-59512*u^10*v^21-405456*u^10*v^20-2820864*u^10*v^19-9100744*u^10*v^18-20325544*u^10*v^17-16338144*u^10*v^16+117633520*u^10*v^15+394945696*u^10*v^14+586858160*u^10*v^13+67887488*u^10*v^12-2053784832*u^10*v^11-4030393344*u^10*v^10-3180957696*u^10*v^9+2448119808*u^10*v^8+10100256768*u^10*v^7+6688604160*u^10*v^6-836075520*u^10*v^5+8520*u^9*v^21+88968*u^9*v^20+483792*u^9*v^19+2059864*u^9*v^18+4121544*u^9*v^17-429208*u^9*v^16-24145616*u^9*v^15-84219720*u^9*v^14-96475792*u^9*v^13+106727616*u^9*v^12+446695488*u^9*v^11+718143552*u^9*v^10+91416384*u^9*v^9-1428129792*u^9*v^8-1107800064*u^9*v^7+167215104*u^9*v^6-9080*u^8*v^20-72912*u^8*v^19-261624*u^8*v^18-615696*u^8*v^17+80376*u^8*v^16+5168576*u^8*v^15+10905976*u^8*v^14+6971280*u^8*v^13-22456704*u^8*v^12-87418800*u^8*v^11-48871296*u^8*v^10+134519616*u^8*v^9+117946368*u^8*v^8-20901888*u^8*v^7+4720*u^7*v^19+31360*u^7*v^18+51584*u^7*v^17-52864*u^7*v^16-434592*u^7*v^15-1265664*u^7*v^14-108864*u^7*v^13+5800320*u^7*v^12+4904496*u^7*v^11-7620480*u^7*v^10-7324992*u^7*v^9+1492992*u^7*v^8-960*u^6*v^18-5568*u^6*v^17+1152*u^6*v^16+51840*u^6*v^15+41472*u^6*v^14-165888*u^6*v^13-176256*u^6*v^12+196992*u^6*v^11+202176*u^6*v^10-46656*u^6*v^9);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(1321205760*u^19*v^6-2503999488*u^18*v^7+1560281088*u^18*v^6-3963617280*u^18*v^5+2072248320*u^17*v^8-3530555392*u^17*v^7+7234125824*u^17*v^6-4680843264*u^17*v^5+3523215360*u^17*v^4-977928192*u^16*v^9+3512729600*u^16*v^8-6074138624*u^16*v^7+10594811904*u^16*v^6-5917114368*u^16*v^5+2986344448*u^16*v^4+287784960*u^15*v^10-2017263616*u^15*v^9+3279355904*u^15*v^8-10300686336*u^15*v^7+5712904192*u^15*v^6-7529824256*u^15*v^5-1516240896*u^15*v^4+3523215360*u^15*v^3-1321205760*u^15*v^2-54067200*u^14*v^11+736722944*u^14*v^10-1357594624*u^14*v^9+5635571712*u^14*v^8-4694540288*u^14*v^7+7224164352*u^14*v^6+610009088*u^14*v^5-4949278720*u^14*v^4+5270142976*u^14*v^3-5083496448*u^14*v^2+440401920*u^14*v+6331392*u^13*v^12-177344512*u^13*v^11+463032320*u^13*v^10-1904050176*u^13*v^9+3089055744*u^13*v^8-3478781952*u^13*v^7+2128543744*u^13*v^6+3823632384*u^13*v^5-6292242432*u^13*v^4+7036993536*u^13*v^3-3469737984*u^13*v^2+1694498816*u^13*v-422400*u^12*v^13+28110848*u^12*v^12-125731840*u^12*v^11+410664960*u^12*v^10-1423110144*u^12*v^9+895352832*u^12*v^8-2709307392*u^12*v^7-2362703872*u^12*v^6+3254976512*u^12*v^5-4677697536*u^12*v^4+5682495488*u^12*v^3-897581056*u^12*v^2+902823936*u^12*v+12288*u^11*v^14-2824960*u^11*v^13+25154816*u^11*v^12-57538560*u^11*v^11+434789376*u^11*v^10-132808704*u^11*v^9+1455697920*u^11*v^8+1008828416*u^11*v^7-726188032*u^11*v^6+2192572416*u^11*v^5-4213374976*u^11*v^4-407371776*u^11*v^3-1553727488*u^11*v^2-724566016*u^11*v+162944*u^10*v^14-3438976*u^10*v^13+5781504*u^10*v^12-85494528*u^10*v^11+28557312*u^10*v^10-416338944*u^10*v^9-175243264*u^10*v^8+112013312*u^10*v^7-674758656*u^10*v^6+1809727488*u^10*v^5+217055232*u^10*v^4+758448128*u^10*v^3+647495680*u^10*v^2-157548544*u^10*v-4096*u^9*v^15+295616*u^9*v^14-597888*u^9*v^13+10172352*u^9*v^12-12615168*u^9*v^11+57808128*u^9*v^10-55207936*u^9*v^9-115440640*u^9*v^8-860160*u^9*v^7-608391168*u^9*v^6+104693760*u^9*v^5+136691712*u^9*v^4+138543104*u^9*v^3+495779840*u^9*v^2+177733632*u^9*v-13920*u^8*v^15+72384*u^8*v^14-603936*u^8*v^13+3583488*u^8*v^12+153024*u^8*v^11+39947264*u^8*v^10+77412608*u^8*v^9+112336896*u^8*v^8+232522752*u^8*v^7-51953664*u^8*v^6-267030528*u^8*v^5-427294720*u^8*v^4-584728576*u^8*v^3-323223552*u^8*v^2-31260672*u^8*v+256*u^7*v^16-6096*u^7*v^15+1296*u^7*v^14-547888*u^7*v^13-1335312*u^7*v^12-10429312*u^7*v^11-25314688*u^7*v^10-52955136*u^7*v^9-88365312*u^7*v^8-19138560*u^7*v^7+99714048*u^7*v^6+247267328*u^7*v^5+362663936*u^7*v^4+257851392*u^7*v^3+54558720*u^7*v^2-1769472*u^7*v+216*u^6*v^16+1544*u^6*v^15+43208*u^6*v^14+196200*u^6*v^13+1456256*u^6*v^12+4579568*u^6*v^11+12546816*u^6*v^10+23996544*u^6*v^9+18038784*u^6*v^8-11467008*u^6*v^7-71680000*u^6*v^6-132803584*u^6*v^5-118063104*u^6*v^4-40808448*u^6*v^3+2654208*u^6*v^2-40*u^5*v^16-1392*u^5*v^15-11408*u^5*v^14-107904*u^5*v^13-460328*u^5*v^12-1691856*u^5*v^11-4069152*u^5*v^10-5363328*u^5*v^9-2342592*u^5*v^8+11056640*u^5*v^7+29601536*u^5*v^6+34007040*u^5*v^5+16957440*u^5*v^4-1658880*u^5*v^3+200*u^4*v^15+3344*u^4*v^14+22784*u^4*v^13+123888*u^4*v^12+397752*u^4*v^11+817600*u^4*v^10+934272*u^4*v^9-656896*u^4*v^8-3870400*u^4*v^7-6325248*u^4*v^6-4227840*u^4*v^5+552960*u^4*v^4-360*u^3*v^14-3840*u^3*v^13-19184*u^3*v^12-64880*u^3*v^11-120408*u^3*v^10-51280*u^3*v^9+251504*u^3*v^8+743808*u^3*v^7+632448*u^3*v^6-103680*u^3*v^5+280*u^2*v^13+2136*u^2*v^12+6392*u^2*v^11+10248*u^2*v^10-2464*u^2*v^9-50688*u^2*v^8-52560*u^2*v^7+10368*u^2*v^6-80*u*v^12-464*u*v^11-384*u*v^10+1536*u*v^9+1872*u*v^8-432*u*v^7);

g=(253671505920*u^31*v^9-338228674560*u^31*v^8-861275160576*u^30*v^10+1532498018304*u^30*v^9-568546295808*u^30*v^8+1261713752064*u^29*v^11-2927489974272*u^29*v^10+2631003013120*u^29*v^9+801548271616*u^29*v^8-1691143372800*u^29*v^7+2142114938880*u^29*v^6-1070856142848*u^28*v^12+3133950394368*u^28*v^11-4012740968448*u^28*v^10-3320680808448*u^28*v^9+2971312062464*u^28*v^8-7221987508224*u^28*v^7+5930812964864*u^28*v^6-2705829396480*u^28*v^5+590748844032*u^27*v^13-2102478766080*u^27*v^12+2528527777792*u^27*v^11+6821179817984*u^27*v^10-4586035216384*u^27*v^9+13282186362880*u^27*v^8-13315472359424*u^27*v^7-1543503872000*u^27*v^6-4266513137664*u^27*v^5+338228674560*u^27*v^4-223746195456*u^26*v^14+925504634880*u^26*v^13+48003809280*u^26*v^12-8958798462976*u^26*v^11+9658114768896*u^26*v^10-15985247518720*u^26*v^9+14931453804544*u^26*v^8+10694602784768*u^26*v^7+1615444574208*u^26*v^6+16551730216960*u^26*v^5-2588254666752*u^26*v^4+901943132160*u^26*v^3+59602894848*u^25*v^15-266463608832*u^25*v^14-1254630096896*u^25*v^13+8266654416896*u^25*v^12-14141959962624*u^25*v^11+14901485502464*u^25*v^10-16381261119488*u^25*v^9-18976876789760*u^25*v^8+19459288858624*u^25*v^7-32444317171712*u^25*v^6+17556349911040*u^25*v^5-11800959516672*u^25*v^4+4259533815808*u^25*v^3-338228674560*u^25*v^2-11197218816*u^24*v^16+45878870016*u^24*v^15+1038155513856*u^24*v^14-5606149718016*u^24*v^13+13022525390848*u^24*v^12-12564123615232*u^24*v^11+18729175875584*u^24*v^10+21587193495552*u^24*v^9-37290063691776*u^24*v^8+35466799742976*u^24*v^7-49655660412928*u^24*v^6+10283628101632*u^24*v^5-3762659786752*u^24*v^4+114890375168*u^24*v^3-1245003644928*u^24*v^2+1456607232*u^23*v^17-2571485184*u^23*v^16-482377924608*u^23*v^15+2857950248960*u^23*v^14-8084003880960*u^23*v^13+9491619774464*u^23*v^12-16591715565568*u^23*v^11-14587562819584*u^23*v^10+35418321977344*u^23*v^9-35507832619008*u^23*v^8+68323366666240*u^23*v^7+2263011557376*u^23*v^6+3273939484672*u^23*v^5+9721121603584*u^23*v^4-15532212355072*u^23*v^3+2144799293440*u^23*v^2-84557168640*u^23*v-125134848*u^22*v^18-803450880*u^22*v^17+149620826112*u^22*v^16-1106198790144*u^22*v^15+3599219359744*u^22*v^14-5772367495168*u^22*v^13+10523813347328*u^22*v^12+4199753449472*u^22*v^11-22942362632192*u^22*v^10+29339768848384*u^22*v^9-58374911688704*u^22*v^8+2141267689472*u^22*v^7+3504693313536*u^22*v^6-23256107057152*u^22*v^5+32341640609792*u^22*v^4-7398215385088*u^22*v^3+9846883614720*u^22*v^2-579015278592*u^22*v+6395904*u^21*v^19+230691840*u^21*v^18-32547154944*u^21*v^17+325562966016*u^21*v^16-1202181439488*u^21*v^15+2640436019200*u^21*v^14-4961491714048*u^21*v^13+1381394284544*u^21*v^12+11404009013248*u^21*v^11-16157114368000*u^21*v^10+37376779878400*u^21*v^9-13971897712640*u^21*v^8-14474253697024*u^21*v^7+17548720472064*u^21*v^6-37081380290560*u^21*v^5+17993731932160*u^21*v^4-9471275302912*u^21*v^3+2490074398720*u^21*v^2-1149373513728*u^21*v-147456*u^20*v^20-28417536*u^20*v^19+5008082432*u^20*v^18-72423565312*u^20*v^17+311174369280*u^20*v^16-889128222720*u^20*v^15+1832530288640*u^20*v^14-1908387217408*u^20*v^13-4317298950144*u^20*v^12+5319698415616*u^20*v^11-19873274527744*u^20*v^10+14574605565952*u^20*v^9+15227116584960*u^20*v^8-1876189773824*u^20*v^7+35112114716672*u^20*v^6-19847287144448*u^20*v^5-2829561364480*u^20*v^4-9565563256832*u^20*v^3-3989923954688*u^20*v^2-380909912064*u^20*v+1817088*u^19*v^20-535229184*u^19*v^19+12005168640*u^19*v^18-63701669120*u^19*v^17+219559084032*u^19*v^16-548150816768*u^19*v^15+923002773504*u^19*v^14+1108497735680*u^19*v^13-860145106944*u^19*v^12+8556362727424*u^19*v^11-8101146394624*u^19*v^10-7806878744576*u^19*v^9-4443040907264*u^19*v^8-25165933051904*u^19*v^7+12283438694400*u^19*v^6+8036317921280*u^19*v^5+11991636770816*u^19*v^4+10267387756544*u^19*v^3+2048498073600*u^19*v^2+447599345664*u^19*v-49152*u^18*v^21+37804160*u^18*v^20-1445184512*u^18*v^19+10356483712*u^18*v^18-39749042944*u^18*v^17+132599011328*u^18*v^16-274704332800*u^18*v^15-131639844864*u^18*v^14-17530994688*u^18*v^13-2700723314688*u^18*v^12+3186834341888*u^18*v^11+2237214490624*u^18*v^10+2941250437120*u^18*v^9+11755556175872*u^18*v^8-6597653823488*u^18*v^7-6067799982080*u^18*v^6-7047028408320*u^18*v^5-8158934204416*u^18*v^4-945555505152*u^18*v^3+467404849152*u^18*v^2+56623104000*u^18*v-1584000*u^17*v^21+120889792*u^17*v^20-1313927232*u^17*v^19+5288992576*u^17*v^18-25087129408*u^17*v^17+57181577728*u^17*v^16-21073244160*u^17*v^15+34646571008*u^17*v^14+547575441408*u^17*v^13-1098580992000*u^17*v^12-510853529600*u^17*v^11-1097798008832*u^17*v^10-3266753003520*u^17*v^9+4348878520320*u^17*v^8+4234422255616*u^17*v^7+2881837596672*u^17*v^6+2589304815616*u^17*v^5-2496323911680*u^17*v^4-3080082948096*u^17*v^3-826697318400*u^17*v^2-96372523008*u^17*v+29696*u^16*v^22-6496928*u^16*v^21+124577376*u^16*v^20-525110240*u^16*v^19+3515682848*u^16*v^18-9087123712*u^16*v^17+12035075840*u^16*v^16-7994265088*u^16*v^15-50847689728*u^16*v^14+352647739392*u^16*v^13+221298569216*u^16*v^12+462694711296*u^16*v^11+515652935680*u^16*v^10-2545278320640*u^16*v^9-2990229291008*u^16*v^8-1795846045696*u^16*v^7-192462716928*u^16*v^6+3691964792832*u^16*v^5+4425265446912*u^16*v^4+1764451418112*u^16*v^3+294440140800*u^16*v^2+18345885696*u^16*v+191712*u^15*v^22-8186656*u^15*v^21+40617376*u^15*v^20-338000672*u^15*v^19+1205289792*u^15*v^18-2199298368*u^15*v^17+2193622464*u^15*v^16-4015640576*u^15*v^15-92496171520*u^15*v^14-108106856960*u^15*v^13-225411792896*u^15*v^12-99435282432*u^15*v^11+993772265472*u^15*v^10+1571929411584*u^15*v^9+1334236053504*u^15*v^8+190514528256*u^15*v^7-2319617359872*u^15*v^6-3364463443968*u^15*v^5-1801464053760*u^15*v^4-392766160896*u^15*v^3-36691771392*u^15*v^2+1019215872*u^15*v-2048*u^14*v^23+326592*u^14*v^22-2568416*u^14*v^21+19416448*u^14*v^20-138032288*u^14*v^19+163189856*u^14*v^18-735953280*u^14*v^17+1467549152*u^14*v^16+16933117824*u^14*v^15+33462290432*u^14*v^14+82863021056*u^14*v^13+57205792768*u^14*v^12-231932717056*u^14*v^11-542974654464*u^14*v^10-679286427648*u^14*v^9-314418806784*u^14*v^8+806996606976*u^14*v^7+1598530977792*u^14*v^6+1109979168768*u^14*v^5+303740485632*u^14*v^4+32105299968*u^14*v^3-2038431744*u^14*v^2-5824*u^13*v^23+123328*u^13*v^22-417440*u^13*v^21+12437344*u^13*v^20+6077792*u^13*v^19+165699680*u^13*v^18-44296768*u^13*v^17-1824198848*u^13*v^16-6131525568*u^13*v^15-19812292160*u^13*v^14-23387143808*u^13*v^13+24815584768*u^13*v^12+118191550464*u^13*v^11+219971392512*u^13*v^10+180860789760*u^13*v^9-146460966912*u^13*v^8-503000580096*u^13*v^7-453140545536*u^13*v^6-151602167808*u^13*v^5-16052649984*u^13*v^4+1783627776*u^13*v^3-3136*u^12*v^23-13760*u^12*v^22-725984*u^12*v^21-2091232*u^12*v^20-21642176*u^12*v^19-28243648*u^12*v^18+58777088*u^12*v^17+616818304*u^12*v^16+2952887520*u^12*v^15+5376193888*u^12*v^14+1847080832*u^12*v^13-14664695552*u^12*v^12-45487442944*u^12*v^11-56722045440*u^12*v^10+2472652800*u^12*v^9+105906438144*u^12*v^8+127761629184*u^12*v^7+51211173888*u^12*v^6+5016453120*u^12*v^5-891813888*u^12*v^4+640*u^11*v^23+19552*u^11*v^22+144000*u^11*v^21+1521632*u^11*v^20+4535680*u^11*v^19+10509632*u^11*v^18-21165600*u^11*v^17-250519168*u^11*v^16-715251680*u^11*v^15-1005672640*u^11*v^14+562511104*u^11*v^13+5779394624*u^11*v^12+10892192000*u^11*v^11+5472494592*u^11*v^10-14441879808*u^11*v^9-25181134848*u^11*v^8-11886981120*u^11*v^7-1003290624*u^11*v^6+278691840*u^11*v^5-3200*u^10*v^22-45024*u^10*v^21-276352*u^10*v^20-1335584*u^10*v^19-1804672*u^10*v^18+8135168*u^10*v^17+51881216*u^10*v^16+141735360*u^10*v^15+107152864*u^10*v^14-376839104*u^10*v^13-1296354656*u^10*v^12-1391491968*u^10*v^11+1137236352*u^10*v^10+3426451200*u^10*v^9+1875585024*u^10*v^8+125411328*u^10*v^7-55738368*u^10*v^6+5760*u^9*v^21+49120*u^9*v^20+190016*u^9*v^19+329888*u^9*v^18-1484576*u^9*v^17-9032896*u^9*v^16-16968544*u^9*v^15-76224*u^9*v^14+89846272*u^9*v^13+172196736*u^9*v^12-30321792*u^9*v^11-308212992*u^9*v^10-192794688*u^9*v^9-8957952*u^9*v^8+6967296*u^9*v^7-4480*u^8*v^20-25696*u^8*v^19-23232*u^8*v^18+164736*u^8*v^17+915104*u^8*v^16+1653792*u^8*v^15-2981824*u^8*v^14-11301120*u^8*v^13-2135328*u^8*v^12+16559424*u^8*v^11+11670912*u^8*v^10+279936*u^8*v^9-497664*u^8*v^8+1280*u^7*v^19+5184*u^7*v^18-14848*u^7*v^17-75968*u^7*v^16+20544*u^7*v^15+315840*u^7*v^14+141120*u^7*v^13-403776*u^7*v^12-316224*u^7*v^11+15552*u^7*v^9);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

//
// - ring r3=(0,u),v,dp.
//

tst_ignore( "ring r3=(0,u),v,dp;" );
ring r3=(0,u),v,dp;

poly f;
poly g;
poly gg;

f=(573440*u^11*v^2-1421312*u^10*v^3+294912*u^10*v^2+1720320*u^10*v+1370112*u^9*v^4-868352*u^9*v^3-2781184*u^9*v^2+884736*u^9*v-693760*u^8*v^5+1046528*u^8*v^4+2174976*u^8*v^3-1662976*u^8*v^2-712704*u^8*v+203200*u^7*v^6-688128*u^7*v^5-1131008*u^7*v^4+1275904*u^7*v^3+1115136*u^7*v^2+172032*u^7*v-34800*u^6*v^7+273280*u^6*v^6+430400*u^6*v^5-505344*u^6*v^4-744192*u^6*v^3-258048*u^6*v^2+9216*u^6*v+3248*u^5*v^8-67648*u^5*v^7-118320*u^5*v^6+103040*u^5*v^5+274560*u^5*v^4+161280*u^5*v^3-11520*u^5*v^2-128*u^4*v^9+10248*u^4*v^8+22216*u^4*v^7-6944*u^4*v^6-60480*u^4*v^5-53760*u^4*v^4+5760*u^4*v^3-872*u^3*v^9-2644*u^3*v^8-1176*u^3*v^7+7956*u^3*v^6+10080*u^3*v^5-1440*u^3*v^4+32*u^2*v^10+177*u^2*v^9+254*u^2*v^8-579*u^2*v^7-1008*u^2*v^6+180*u^2*v^5-5*u*v^10-14*u*v^9+18*u*v^8+42*u*v^7-9*u*v^6);

g=(65536*u^11*v^3-147456*u^10*v^4+196608*u^10*v^2+122880*u^9*v^5+16384*u^9*v^4-262144*u^9*v^3-65536*u^9*v^2-51200*u^8*v^6-36864*u^8*v^5+159744*u^8*v^4+196608*u^8*v^3-49152*u^8*v^2-196608*u^8*v+11520*u^7*v^7+30720*u^7*v^6-61440*u^7*v^5-184320*u^7*v^4+61440*u^7*v^3+245760*u^7*v^2-1344*u^6*v^8-12800*u^6*v^7+16640*u^6*v^6+81920*u^6*v^5-30720*u^6*v^4-122880*u^6*v^3+64*u^5*v^9+2880*u^5*v^8-3072*u^5*v^7-19200*u^5*v^6+7680*u^5*v^5+30720*u^5*v^4-336*u^4*v^9+336*u^4*v^8+2304*u^4*v^7-960*u^4*v^6-3840*u^4*v^5+16*u^3*v^10-16*u^3*v^9-112*u^3*v^8+48*u^3*v^7+192*u^3*v^6);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(-587202560*u^22*v^6+1308622848*u^21*v^7-301989888*u^21*v^6+1174405120*u^21*v^5-1296039936*u^20*v^8+666894336*u^20*v^7-2227175424*u^20*v^6+1191182336*u^20*v^5-587202560*u^20*v^4+748683264*u^19*v^9-654311424*u^19*v^8+1627389952*u^19*v^7-2625634304*u^19*v^6+830472192*u^19*v^5-1476395008*u^19*v^4-278003712*u^18*v^10+374341632*u^18*v^9-387973120*u^18*v^8+2594177024*u^18*v^7-244318208*u^18*v^6+3007315968*u^18*v^5-213909504*u^18*v^4+587202560*u^18*v^3+68812800*u^17*v^11-137625600*u^17*v^10-231997440*u^17*v^9-1524629504*u^17*v^8-356515840*u^17*v^7-2648702976*u^17*v^6+849346560*u^17*v^5-805306368*u^17*v^4+301989888*u^17*v^3-11354112*u^16*v^12+33718272*u^16*v^11+248217600*u^16*v^10+601227264*u^16*v^9+481689600*u^16*v^8+1310457856*u^16*v^7-1249116160*u^16*v^6+135266304*u^16*v^5-995098624*u^16*v^4-243269632*u^16*v^3+1204224*u^15*v^13-5505024*u^15*v^12-114229248*u^15*v^11-172818432*u^15*v^10-319488000*u^15*v^9-399507456*u^15*v^8+975175680*u^15*v^7+449314816*u^15*v^6+1376256000*u^15*v^5+570425344*u^15*v^4+58720256*u^15*v^3-74496*u^14*v^14+577536*u^14*v^13+33460224*u^14*v^12+39223296*u^14*v^11+142270464*u^14*v^10+82083840*u^14*v^9-456622080*u^14*v^8-448659456*u^14*v^7-1077411840*u^14*v^6-603193344*u^14*v^5-131334144*u^14*v^4+3145728*u^14*v^3+2048*u^13*v^15-35328*u^13*v^14-6750720*u^13*v^13-7520256*u^13*v^12-45244416*u^13*v^11-15482880*u^13*v^10+131776512*u^13*v^9+216662016*u^13*v^8+534773760*u^13*v^7+379060224*u^13*v^6+130547712*u^13*v^5-6291456*u^13*v^4+960*u^12*v^15+944960*u^12*v^14+1226496*u^12*v^13+10287360*u^12*v^12+4061184*u^12*v^11-21719040*u^12*v^10-63823872*u^12*v^9-176676864*u^12*v^8-156893184*u^12*v^7-75694080*u^12*v^6+5505024*u^12*v^5-88320*u^11*v^15-158336*u^11*v^14-1628800*u^11*v^13-1081344*u^11*v^12+1136640*u^11*v^11+11956224*u^11*v^10+39309312*u^11*v^9+44728320*u^11*v^8+28213248*u^11*v^7-2752512*u^11*v^6+4976*u^10*v^16+14432*u^10*v^15+170160*u^10*v^14+199744*u^10*v^13+290880*u^10*v^12-1353984*u^10*v^11-5760000*u^10*v^10-8902656*u^10*v^9-7010304*u^10*v^8+860160*u^10*v^7-128*u^9*v^17-800*u^9*v^16-10528*u^9*v^15-22752*u^9*v^14-67680*u^9*v^13+70144*u^9*v^12+514560*u^9*v^11+1222656*u^9*v^10+1161216*u^9*v^9-172032*u^9*v^8+20*u^8*v^17+292*u^8*v^16+1452*u^8*v^15+5916*u^8*v^14+2256*u^8*v^13-21840*u^8*v^12-110976*u^8*v^11-123648*u^8*v^10+21504*u^8*v^9-40*u^7*v^16-200*u^7*v^15-504*u^7*v^14-152*u^7*v^13+6016*u^7*v^12+7680*u^7*v^11-1536*u^7*v^10+20*u^6*v^15+36*u^6*v^14-148*u^6*v^13-212*u^6*v^12+48*u^6*v^11);

g=(-47185920*u^21*v^7+301989888*u^21*v^6+135266304*u^20*v^8-761266176*u^20*v^7+163577856*u^20*v^6-301989888*u^20*v^5-159842304*u^19*v^9+873201664*u^19*v^8-570163200*u^19*v^7+813694976*u^19*v^6+59768832*u^19*v^5-402653184*u^19*v^4+105086976*u^18*v^10-605421568*u^18*v^9+767819776*u^18*v^8-1006895104*u^18*v^7+294125568*u^18*v^6+912261120*u^18*v^5-713031680*u^18*v^4+402653184*u^18*v^3-42971136*u^17*v^11+283197440*u^17*v^10-566050816*u^17*v^9+780664832*u^17*v^8-733544448*u^17*v^7-944504832*u^17*v^6+1355546624*u^17*v^5-973078528*u^17*v^4+483393536*u^17*v^3+100663296*u^17*v^2+11427840*u^16*v^12-93995008*u^16*v^11+261398528*u^16*v^10-424591360*u^16*v^9+700252160*u^16*v^8+504627200*u^16*v^7-1089601536*u^16*v^6+1263796224*u^16*v^5-1270874112*u^16*v^4-346030080*u^16*v^3+398458880*u^16*v^2-100663296*u^16*v-1986816*u^15*v^13+22541312*u^15*v^12-80757760*u^15*v^11+167518208*u^15*v^10-378572800*u^15*v^9-99500032*u^15*v^8+484917248*u^15*v^7-954859520*u^15*v^6+1386676224*u^15*v^5+139722752*u^15*v^4-593756160*u^15*v^3+461373440*u^15*v^2-344981504*u^15*v+218496*u^14*v^14-3882496*u^14*v^13+17297408*u^14*v^12-47684608*u^14*v^11+131680256*u^14*v^10-37199872*u^14*v^9-133611520*u^14*v^8+413188096*u^14*v^7-874545152*u^14*v^6+178388992*u^14*v^5+430440448*u^14*v^4-490471424*u^14*v^3+581435392*u^14*v^2-106954752*u^14*v-13824*u^13*v^15+466112*u^13*v^14-2624704*u^13*v^13+9552896*u^13*v^12-31446784*u^13*v^11+30632960*u^13*v^10+24998912*u^13*v^9-91848704*u^13*v^8+374026240*u^13*v^7-195117056*u^13*v^6-218021888*u^13*v^5+207880192*u^13*v^4-482803712*u^13*v^3+158072832*u^13*v^2+68419584*u^13*v+384*u^12*v^16-36640*u^12*v^15+286304*u^12*v^14-1292608*u^12*v^13+5391872*u^12*v^12-9428992*u^12*v^11-3314176*u^12*v^10+2993152*u^12*v^9-119730176*u^12*v^8+81559552*u^12*v^7+81043456*u^12*v^6-20922368*u^12*v^5+279445504*u^12*v^4-100663296*u^12*v^3-119144448*u^12*v^2+7077888*u^12*v+1664*u^11*v^16-22432*u^11*v^15+110240*u^11*v^14-686080*u^11*v^13+1616960*u^11*v^12+115904*u^11*v^11+3771904*u^11*v^10+29638912*u^11*v^9-17306624*u^11*v^8-17865728*u^11*v^7-14606336*u^11*v^6-124448768*u^11*v^5+37109760*u^11*v^4+88915968*u^11*v^3-10616832*u^11*v^2-32*u^10*v^17+1184*u^10*v^16-5184*u^10*v^15+64640*u^10*v^14-159232*u^10*v^13+103808*u^10*v^12-1016000*u^10*v^11-5419136*u^10*v^10+1618432*u^10*v^9+517120*u^10*v^8+6691840*u^10*v^7+41076736*u^10*v^6-9216000*u^10*v^5-36864000*u^10*v^4+6635520*u^10*v^3-32*u^9*v^17+96*u^9*v^16-4096*u^9*v^15+8192*u^9*v^14-30080*u^9*v^13+122176*u^9*v^12+654208*u^9*v^11+46912*u^9*v^10+849088*u^9*v^9-1347584*u^9*v^8-9337088*u^9*v^7+1717248*u^9*v^6+9169920*u^9*v^5-2211840*u^9*v^4+128*u^8*v^16-160*u^8*v^15+3552*u^8*v^14-7168*u^8*v^13-41920*u^8*v^12-25376*u^8*v^11-228128*u^8*v^10+154432*u^8*v^9+1355008*u^8*v^8-242688*u^8*v^7-1368576*u^8*v^6+414720*u^8*v^5-160*u^7*v^15+160*u^7*v^14+448*u^7*v^13+2176*u^7*v^12+25376*u^7*v^11-10208*u^7*v^10-112256*u^7*v^9+22464*u^7*v^8+113472*u^7*v^7-41472*u^7*v^6+64*u^6*v^14-64*u^6*v^13-1088*u^6*v^12+320*u^6*v^11+4032*u^6*v^10-960*u^6*v^9-4032*u^6*v^8+1728*u^6*v^7);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(16384*u^14*v^3-24576*u^13*v^4-32768*u^13*v^2+15360*u^12*v^5+49152*u^12*v^3+16384*u^12*v-5120*u^11*v^6-30720*u^11*v^4-24576*u^11*v^2+960*u^10*v^7+10240*u^10*v^5+15360*u^10*v^3-96*u^9*v^8-1920*u^9*v^6-5120*u^9*v^4+4*u^8*v^9+192*u^8*v^7+960*u^8*v^5-8*u^7*v^8-96*u^7*v^6+4*u^6*v^7);

g=(226492416*u^22*v^6-603979776*u^21*v^7+226492416*u^21*v^6-796917760*u^21*v^5+717225984*u^20*v^8-723517440*u^20*v^7+2032140288*u^20*v^6-268435456*u^20*v^5+419430400*u^20*v^4-500170752*u^19*v^9+994050048*u^19*v^8-2407530496*u^19*v^7+1113587712*u^19*v^6-656408576*u^19*v^5-268435456*u^19*v^4+251658240*u^19*v^3+227082240*u^18*v^10-786432000*u^18*v^9+1780482048*u^18*v^8-1749024768*u^18*v^7+392167424*u^18*v^6+281018368*u^18*v^5-1170210816*u^18*v^4+545259520*u^18*v^3-75497472*u^18*v^2-70189056*u^17*v^11+400883712*u^17*v^10-930152448*u^17*v^9+1500512256*u^17*v^8-181403648*u^17*v^7+104857600*u^17*v^6+2017460224*u^17*v^5-1388314624*u^17*v^4+113246208*u^17*v^3-75497472*u^17*v^2-25165824*u^17*v+14966784*u^16*v^12-138657792*u^16*v^11+365150208*u^16*v^10-809238528*u^16*v^9+171048960*u^16*v^8-344457216*u^16*v^7-1778384896*u^16*v^6+1673003008*u^16*v^5-356515840*u^16*v^4+253755392*u^16*v^3+555745280*u^16*v^2-159383552*u^16*v-2174976*u^15*v^13+33202176*u^15*v^12-110272512*u^15*v^11+293879808*u^15*v^10-147505152*u^15*v^9+278396928*u^15*v^8+899284992*u^15*v^7-1270349824*u^15*v^6+497025024*u^15*v^5-433061888*u^15*v^4-847249408*u^15*v^3+501219328*u^15*v^2-270532608*u^15*v+206208*u^14*v^14-5486592*u^14*v^13+25491456*u^14*v^12-74661888*u^14*v^11+76726272*u^14*v^10-133005312*u^14*v^9-266108928*u^14*v^8+669843456*u^14*v^7-322633728*u^14*v^6+477626368*u^14*v^5+580386816*u^14*v^4-684195840*u^14*v^3+427819008*u^14*v^2-37748736*u^14*v-11520*u^13*v^15+608640*u^13*v^14-4397952*u^13*v^13+13621248*u^13*v^12-24619008*u^13*v^11+45416448*u^13*v^10+42319872*u^13*v^9-250380288*u^13*v^8+107839488*u^13*v^7-357236736*u^13*v^6-257753088*u^13*v^5+526909440*u^13*v^4-284688384*u^13*v^3+94371840*u^13*v^2+56623104*u^13*v+288*u^12*v^16-42528*u^12*v^15+542752*u^12*v^14-1833984*u^12*v^13+5006592*u^12*v^12-12140544*u^12*v^11-2445312*u^12*v^10+64253952*u^12*v^9-18063360*u^12*v^8+183091200*u^12*v^7+101302272*u^12*v^6-248709120*u^12*v^5+114032640*u^12*v^4-103809024*u^12*v^3-113246208*u^12*v^2+1632*u^11*v^16-44832*u^11*v^15+188512*u^11*v^14-635680*u^11*v^13+2586624*u^11*v^12+71424*u^11*v^11-10100736*u^11*v^10+1843200*u^11*v^9-64339968*u^11*v^8-38019072*u^11*v^7+71909376*u^11*v^6-40943616*u^11*v^5+66060288*u^11*v^4+99090432*u^11*v^3-24*u^10*v^17+2200*u^10*v^16-14976*u^10*v^15+46688*u^10*v^14-418112*u^10*v^13-136128*u^10*v^12+537216*u^10*v^11-713856*u^10*v^10+15304704*u^10*v^9+10979328*u^10*v^8-11096064*u^10*v^7+16859136*u^10*v^6-26836992*u^10*v^5-49545216*u^10*v^4-48*u^9*v^17+840*u^9*v^16-1592*u^9*v^15+46784*u^9*v^14+39552*u^9*v^13+132416*u^9*v^12+303552*u^9*v^11-2366592*u^9*v^10-1981824*u^9*v^9+92160*u^9*v^8-5978112*u^9*v^7+7225344*u^9*v^6+15482880*u^9*v^5-24*u^8*v^17+8*u^8*v^16-3160*u^8*v^15-4432*u^8*v^14-32168*u^8*v^13-61920*u^8*v^12+213024*u^8*v^11+171552*u^8*v^10+320640*u^8*v^9+1422336*u^8*v^8-1290240*u^8*v^7-3096576*u^8*v^6+96*u^7*v^16+184*u^7*v^15+2936*u^7*v^14+6112*u^7*v^13-7088*u^7*v^12+2656*u^7*v^11-63520*u^7*v^10-206880*u^7*v^9+147456*u^7*v^8+387072*u^7*v^7-104*u^6*v^15-240*u^6*v^14-400*u^6*v^13-1712*u^6*v^12+5528*u^6*v^11+16704*u^6*v^10-9792*u^6*v^9-27648*u^6*v^8+32*u^5*v^14+96*u^5*v^13-192*u^5*v^12-576*u^5*v^11+288*u^5*v^10+864*u^5*v^9);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(52848230400*u^30*v^10-338228674560*u^30*v^9-216426086400*u^29*v^11+1453879984128*u^29*v^10-1318991167488*u^29*v^9+377229410304*u^28*v^12-2876042641408*u^28*v^11+5403127578624*u^28*v^10-1913240158208*u^28*v^9-514389442560*u^28*v^8+2480343613440*u^28*v^7-372268597248*u^27*v^13+3452153364480*u^27*v^12-9774806597632*u^27*v^11+7477110243328*u^27*v^10-2700922060800*u^27*v^9-8007094108160*u^27*v^8+10522871201792*u^27*v^7-2705829396480*u^27*v^6+233646981120*u^26*v^14-2772906278912*u^26*v^13+10476387303424*u^26*v^12-13422064304128*u^26*v^11+11034154762240*u^26*v^10+8590437908480*u^26*v^9-29618362908672*u^26*v^8+17962694082560*u^26*v^7-9466779009024*u^26*v^6-1803886264320*u^26*v^5-98829729792*u^25*v^15+1561023086592*u^25*v^14-7519372181504*u^25*v^13+14305345404928*u^25*v^12-17063328874496*u^25*v^11+1819898019840*u^25*v^10+36069321998336*u^25*v^9-44961126940672*u^25*v^8+36497289904128*u^25*v^7+119051124736*u^25*v^6-11520847118336*u^25*v^5+3607772528640*u^25*v^4+28950552576*u^24*v^16-631083663360*u^24*v^15+3859091062784*u^24*v^14-10072857116672*u^24*v^13+15700472496128*u^24*v^12-12920068505600*u^24*v^11-23603843694592*u^24*v^10+53928643264512*u^24*v^9-61918236639232*u^24*v^8+29128887631872*u^24*v^7+22640567779328*u^24*v^6-29600511950848*u^24*v^5+17721639043072*u^24*v^4-676457349120*u^24*v^3-5904101376*u^23*v^17+185241772032*u^23*v^16-1469308772352*u^23*v^15+4978579046400*u^23*v^14-9877888925696*u^23*v^13+14380155666432*u^23*v^12+6464711557120*u^23*v^11-36189369794560*u^23*v^10+62948141170688*u^23*v^9-62490356482048*u^23*v^8-12181491941376*u^23*v^7+47472894279680*u^23*v^6-51076338286592*u^23*v^5+23221478883328*u^23*v^4-1383717666816*u^23*v^3-901943132160*u^23*v^2+824758272*u^22*v^18-39464896512*u^22*v^17+422569936896*u^22*v^16-1796062814208*u^22*v^15+4509725040640*u^22*v^14-9080870502400*u^22*v^13+2733823262720*u^22*v^12+14101569732608*u^22*v^11-40999690698752*u^22*v^10+63269440061440*u^22*v^9-14597500174336*u^22*v^8-31434462986240*u^22*v^7+71501541801984*u^22*v^6-61401389334528*u^22*v^5+7956628242432*u^22*v^4+6687733841920*u^22*v^3-6440404123648*u^22*v^2+338228674560*u^22*v-75386880*u^21*v^19+6025079808*u^21*v^18-92087110656*u^21*v^17+485806970880*u^21*v^16-1531491809280*u^21*v^15+3877819244544*u^21*v^14-3774626979840*u^21*v^13-2561536065536*u^21*v^12+16691685785600*u^21*v^11-39923396902912*u^21*v^10+27843125575680*u^21*v^9+6489709215744*u^21*v^8-51723503665152*u^21*v^7+73756810674176*u^21*v^6-30743568842752*u^21*v^5-2078361518080*u^21*v^4+21561138479104*u^21*v^3-14738616483840*u^21*v^2+2347770052608*u^21*v+4067328*u^20*v^20-640017408*u^20*v^19+15042928128*u^20*v^18-100344188928*u^20*v^17+389414721024*u^20*v^16-1204456802304*u^20*v^15+2009514743808*u^20*v^14-449156210688*u^20*v^13-3575313842176*u^20*v^12+17530730840064*u^20*v^11-20602415939584*u^20*v^10+5484122996736*u^20*v^9+16772287954944*u^20*v^8-55137857961984*u^20*v^7+41002875224064*u^20*v^6-6733032325120*u^20*v^5-17290114367488*u^20*v^4+26878517706752*u^20*v^3-12401357357056*u^20*v^2+4814624784384*u^20*v-98304*u^19*v^21+44680192*u^19*v^20-1794271488*u^19*v^19+15976027136*u^19*v^18-73879631616*u^19*v^17+282466226688*u^19*v^16-670269934080*u^19*v^15+501136386048*u^19*v^14-88733079552*u^19*v^13-5525972041728*u^19*v^12+8941929414656*u^19*v^11-6059940184064*u^19*v^10+1357380911104*u^19*v^9+28208144318464*u^19*v^8-28015198994432*u^19*v^7+10793201434624*u^19*v^6+1344068911104*u^19*v^5-26617285967872*u^19*v^4+16269778616320*u^19*v^3-6583371169792*u^19*v^2+1954654715904*u^19*v-1827840*u^18*v^21+148966144*u^18*v^20-1951864192*u^18*v^19+10370889600*u^18*v^18-50646474880*u^18*v^17+154417168768*u^18*v^16-196831087104*u^18*v^15+317034307584*u^18*v^14+1183627739136*u^18*v^13-2580689104896*u^18*v^12+3091185352704*u^18*v^11-3580512780288*u^18*v^10-9592794185728*u^18*v^9+12127749865472*u^18*v^8-8605532946432*u^18*v^7+5454661550080*u^18*v^6+16748781240320*u^18*v^5-11500832423936*u^18*v^4+5102494547968*u^18*v^3-2949466030080*u^18*v^2-1647556165632*u^18*v+32768*u^17*v^22-7896832*u^17*v^21+178037824*u^17*v^20-1069773760*u^17*v^19+6841130560*u^17*v^18-25614060480*u^17*v^17+49462372480*u^17*v^16-108141835392*u^17*v^15-130867418112*u^17*v^14+556734987264*u^17*v^13-916313051136*u^17*v^12+1744219656192*u^17*v^11+1881126027264*u^17*v^10-4061011460096*u^17*v^9+3724796952576*u^17*v^8-4456313585664*u^17*v^7-6450705727488*u^17*v^6+6562090188800*u^17*v^5-2425773096960*u^17*v^4+2218035511296*u^17*v^3+2272945766400*u^17*v^2-394342170624*u^17*v+224000*u^16*v^22-11369152*u^16*v^21+81546560*u^16*v^20-662447616*u^16*v^19+3165997312*u^16*v^18-8379438656*u^16*v^17+21660646080*u^16*v^16-8789692672*u^16*v^15-104723894272*u^16*v^14+127784961024*u^16*v^13-580595865600*u^16*v^12-128372477952*u^16*v^11+1208934445056*u^16*v^10-594241142784*u^16*v^9+2488695742464*u^16*v^8+1576154136576*u^16*v^7-3551103123456*u^16*v^6-93004627968*u^16*v^5-1666593718272*u^16*v^4-1469515825152*u^16*v^3+909013155840*u^16*v^2+364256428032*u^16*v-2048*u^15*v^23+446144*u^15*v^22-4704320*u^15*v^21+41351936*u^15*v^20-303202688*u^15*v^19+903657984*u^15*v^18-3183874304*u^15*v^17+5797531968*u^15*v^16+17934835648*u^15*v^15+10147173376*u^15*v^14+163962882560*u^15*v^13+1476974592*u^15*v^12-280649263104*u^15*v^11-186861858816*u^15*v^10-1193155633152*u^15*v^9-464472563712*u^15*v^8+1483761868800*u^15*v^7+926630117376*u^15*v^6+1396055900160*u^15*v^5+821045624832*u^15*v^4-911996485632*u^15*v^3-680029323264*u^15*v^2-37243846656*u^15*v-7872*u^14*v^23+201536*u^14*v^22-1263552*u^14*v^21+22764992*u^14*v^20-50363264*u^14*v^19+391002880*u^14*v^18-892049600*u^14*v^17-2235016512*u^14*v^16-7800489536*u^14*v^15-38187017152*u^14*v^14-15902543104*u^14*v^13+28600385280*u^14*v^12+115222081536*u^14*v^11+438972324864*u^14*v^10+254589499392*u^14*v^9-353183127552*u^14*v^8-571285020672*u^14*v^7-886835109888*u^14*v^6-510446370816*u^14*v^5+497850679296*u^14*v^4+570325598208*u^14*v^3+82237980672*u^14*v^2-10956570624*u^14*v-4864*u^13*v^23-5312*u^13*v^22-1212992*u^13*v^21-71744*u^13*v^20-39517504*u^13*v^19+49957184*u^13*v^18+104653120*u^13*v^17+1423405184*u^13*v^16+6398062464*u^13*v^15+7460222784*u^13*v^14+6636401088*u^13*v^13-22754256640*u^13*v^12-109114461440*u^13*v^11-108234356736*u^13*v^10+8686848000*u^13*v^9+169000433664*u^13*v^8+367646681088*u^13*v^7+263791632384*u^13*v^6-146235580416*u^13*v^5-285935173632*u^13*v^4-77659471872*u^13*v^3+19110297600*u^13*v^2-382205952*u^13*v+960*u^12*v^23+32832*u^12*v^22+161792*u^12*v^21+2700160*u^12*v^20+2098048*u^12*v^19+15104640*u^12*v^18-115166016*u^12*v^17-661111872*u^12*v^16-1507243328*u^12*v^15-3005409728*u^12*v^14+1019880256*u^12*v^13+16404099008*u^12*v^12+27610529280*u^12*v^11+21493252608*u^12*v^10-23583372288*u^12*v^9-96424607232*u^12*v^8-94389184512*u^12*v^7+13561509888*u^12*v^6+96093609984*u^12*v^5+41140224000*u^12*v^4-14284947456*u^12*v^3+573308928*u^12*v^2-5760*u^11*v^22-86144*u^11*v^21-391680*u^11*v^20-2538752*u^11*v^19+1696320*u^11*v^18+31017792*u^11*v^17+155736192*u^11*v^16+487861248*u^11*v^15+368073856*u^11*v^14-1118403200*u^11*v^13-4139854784*u^11*v^12-6721273664*u^11*v^11-279917568*u^11*v^10+15110684928*u^11*v^9+22798407168*u^11*v^8+5622428160*u^11*v^7-22824695808*u^11*v^6-13409556480*u^11*v^5+5932154880*u^11*v^4-358318080*u^11*v^3+13440*u^10*v^21+113536*u^10*v^20+330560*u^10*v^19+474176*u^10*v^18-7090624*u^10*v^17-36916288*u^10*v^16-72345856*u^10*v^15-41430144*u^10*v^14+331577536*u^10*v^13+960289856*u^10*v^12+676633792*u^10*v^11-1116438720*u^10*v^10-3716339328*u^10*v^9-2344090752*u^10*v^8+3865729536*u^10*v^7+2758800384*u^10*v^6-1478062080*u^10*v^5+119439360*u^10*v^4-15360*u^9*v^20-79104*u^9*v^19-14528*u^9*v^18+828352*u^9*v^17+5232192*u^9*v^16+11950400*u^9*v^15-7487936*u^9*v^14-63259072*u^9*v^13-114258880*u^9*v^12-26196672*u^9*v^11+399022464*u^9*v^10+397115136*u^9*v^9-448509312*u^9*v^8-350241408*u^9*v^7+220962816*u^9*v^6-22394880*u^9*v^5+8640*u^8*v^19+27200*u^8*v^18-117888*u^8*v^17-541440*u^8*v^16-761856*u^8*v^15+622336*u^8*v^14+8877696*u^8*v^13+10654848*u^8*v^12-25884864*u^8*v^11-33765696*u^8*v^10+31891968*u^8*v^9+25100928*u^8*v^8-18351360*u^8*v^7+2239488*u^8*v^6-1920*u^7*v^18-3456*u^7*v^17+44928*u^7*v^16+91008*u^7*v^15-284928*u^7*v^14-546048*u^7*v^13+776448*u^7*v^12+1181952*u^7*v^11-1040256*u^7*v^10-777600*u^7*v^9+653184*u^7*v^8-93312*u^7*v^7);

g=(-253671505920*u^31*v^9+988110913536*u^30*v^10-1229702823936*u^30*v^9+338228674560*u^30*v^8-1692351332352*u^29*v^11+4942366507008*u^29*v^10-3377253580800*u^29*v^9+1075889307648*u^29*v^8+1691143372800*u^29*v^7+1701713018880*u^28*v^12-8772202266624*u^28*v^11+10278662045696*u^28*v^10-8363844829184*u^28*v^9-3435705401344*u^28*v^8+8620804669440*u^28*v^7-4171486986240*u^28*v^6-1126176915456*u^27*v^13+9178781319168*u^27*v^12-16639659606016*u^27*v^11+20678287818752*u^27*v^10-2997132197888*u^27*v^9-21107885211648*u^27*v^8+21996138135552*u^27*v^7-16952235917312*u^27*v^6+2423972167680*u^27*v^5+519120617472*u^26*v^14-6351457615872*u^26*v^13+17080430624768*u^26*v^12-27565771194368*u^26*v^11+18641919672320*u^26*v^10+19548375875584*u^26*v^9-47679035932672*u^26*v^8+54750900912128*u^26*v^7-17818477133824*u^26*v^6+4563134316544*u^26*v^5+1014686023680*u^26*v^4-171475992576*u^25*v^15+3080226078720*u^25*v^14-12063912493056*u^25*v^13+23857490558976*u^25*v^12-29753910231040*u^25*v^11-3264221282304*u^25*v^10+51781975408640*u^25*v^9-86221065814016*u^25*v^8+63292114468864*u^25*v^7-15700521385984*u^25*v^6-17395557072896*u^25*v^5+10668698763264*u^25*v^4-1240171806720*u^25*v^3+40998666240*u^24*v^16-1079403872256*u^24*v^15+6126577385472*u^24*v^14-14707249905664*u^24*v^13+26979508158464*u^24*v^12-11707793539072*u^24*v^11-29275033960448*u^24*v^10+84905971154944*u^24*v^9-103700928397312*u^24*v^8+40014834565120*u^24*v^7+18741156904960*u^24*v^6-45301838643200*u^24*v^5+31040533954560*u^24*v^4-7336609447936*u^24*v^3+112742891520*u^24*v^2-7055216640*u^23*v^17+277017329664*u^23*v^16-2291566313472*u^23*v^15+6802082365440*u^23*v^14-16245052276736*u^23*v^13+15324776759296*u^23*v^12+5448763703296*u^23*v^11-54599025164288*u^23*v^10+98241966243840*u^23*v^9-67989550399488*u^23*v^8+8133762088960*u^23*v^7+73949337616384*u^23*v^6-73100041388032*u^23*v^5+32643362062336*u^23*v^4-9364639318016*u^23*v^3-242665652224*u^23*v^2+84557168640*u^23*v+853438464*u^22*v^18-52060409856*u^22*v^17+638197776384*u^22*v^16-2426871939072*u^22*v^15+6958816428032*u^22*v^14-10731389452288*u^22*v^13+4354935357440*u^22*v^12+21615135948800*u^22*v^11-61258497785856*u^22*v^10+70588520464384*u^22*v^9-32228578951168*u^22*v^8-54489713213440*u^22*v^7+88471913889792*u^22*v^6-73203321929728*u^22*v^5+24484333486080*u^22*v^4+9150696259584*u^22*v^3-5519569846272*u^22*v^2+832686784512*u^22*v-68963328*u^21*v^19+7066672128*u^21*v^18-132350333952*u^21*v^17+675040002048*u^21*v^16-2207895158784*u^21*v^15+5061152440320*u^21*v^14-4344942329856*u^21*v^13-3642917126144*u^21*v^12+26773613445120*u^21*v^11-46431755304960*u^21*v^10+35059732054016*u^21*v^9+12827213430784*u^21*v^8-69999666397184*u^21*v^7+83485112926208*u^21*v^6-38915616538624*u^21*v^5-3227667922944*u^21*v^4+19657394225152*u^21*v^3-14842266124288*u^21*v^2+2886419349504*u^21*v+3345408*u^20*v^20-671468544*u^20*v^19+20216690688*u^20*v^18-145924807680*u^20*v^17+533867704320*u^20*v^16-1708719132672*u^20*v^15+2140940419072*u^20*v^14-1127017512960*u^20*v^13-8153365610496*u^20*v^12+20264335441920*u^20*v^11-23897640534016*u^20*v^10+8610170011648*u^20*v^9+36593328979968*u^20*v^8-55726780186624*u^20*v^7+45158829654016*u^20*v^6-10062496006144*u^20*v^5-26779406303232*u^20*v^4+22805638807552*u^20*v^3-11680230670336*u^20*v^2+3829030453248*u^20*v-73728*u^19*v^21+42068736*u^19*v^20-2219130368*u^19*v^19+24152580608*u^19*v^18-100680704768*u^19*v^17+420908654592*u^19*v^16-736732581888*u^19*v^15+953287802880*u^19*v^14+1470982512640*u^19*v^13-6090643472384*u^19*v^12+11361477328896*u^19*v^11-8894275387392*u^19*v^10-10836084260864*u^19*v^9+24784345759744*u^19*v^8-35343216672768*u^19*v^7+12390125010944*u^19*v^6+16437437530112*u^19*v^5-18558167810048*u^19*v^4+19011890839552*u^19*v^3-4172795609088*u^19*v^2+695130390528*u^19*v-1542912*u^18*v^21+167203072*u^18*v^20-2979105536*u^18*v^19+15068172032*u^18*v^18-75695678976*u^18*v^17+191857910784*u^18*v^16-320857096192*u^18*v^15+15209435136*u^18*v^14+1311573430272*u^18*v^13-3752527970304*u^18*v^12+4156001746944*u^18*v^11+409935937536*u^18*v^10-8292870651904*u^18*v^9+17752187731968*u^18*v^8-8344514330624*u^18*v^7-3500872302592*u^18*v^6+12071054868480*u^18*v^5-15703105077248*u^18*v^4+2096111812608*u^18*v^3-1634067283968*u^18*v^2-1399421140992*u^18*v+24576*u^17*v^22-7941440*u^17*v^21+262223936*u^17*v^20-1795433600*u^17*v^19+9832186688*u^17*v^18-38195000768*u^17*v^17+67642249216*u^17*v^16-103341989888*u^17*v^15-212809252864*u^17*v^14+813404645376*u^17*v^13-1367608983552*u^17*v^12+1012488028160*u^17*v^11+2152465367040*u^17*v^10-5628109848576*u^17*v^9+4727728766976*u^17*v^8-826894712832*u^17*v^7-6136376852480*u^17*v^6+7532487114752*u^17*v^5-2053820645376*u^17*v^4+647667646464*u^17*v^3+1993171009536*u^17*v^2-73496788992*u^17*v+198720*u^16*v^22-15332544*u^16*v^21+166033216*u^16*v^20-907202304*u^16*v^19+5664061696*u^16*v^18-10051504576*u^16*v^17+34244757248*u^16*v^16+25293858304*u^16*v^15-99014192128*u^16*v^14+361348970496*u^16*v^13-407182233600*u^16*v^12-305932111872*u^16*v^11+1154293514240*u^16*v^10-2201592070144*u^16*v^9+399013052416*u^16*v^8+1659945091072*u^16*v^7-2709385641984*u^16*v^6+2038996402176*u^16*v^5+943435284480*u^16*v^4-664632557568*u^16*v^3+576196706304*u^16*v^2+270771683328*u^16*v-1536*u^15*v^23+521104*u^15*v^22-11122160*u^15*v^21+59050672*u^15*v^20-593645968*u^15*v^19+1177031936*u^15*v^18-6109288640*u^15*v^17-704543488*u^15*v^16+2844790784*u^15*v^15-74031232000*u^15*v^14+73062756864*u^15*v^13-56133091328*u^15*v^12-208986144768*u^15*v^11+684103335936*u^15*v^10+63825752064*u^15*v^9+166163054592*u^15*v^8+1205092810752*u^15*v^7-943857598464*u^15*v^6-1096474558464*u^15*v^5-499217596416*u^15*v^4-1035240210432*u^15*v^3-627836977152*u^15*v^2-56056872960*u^15*v-7440*u^14*v^23+471488*u^14*v^22-2830576*u^14*v^21+40134560*u^14*v^20-122636944*u^14*v^19+625169952*u^14*v^18-688839024*u^14*v^17+480807296*u^14*v^16+9443703296*u^14*v^15-6656759552*u^14*v^14+43620437504*u^14*v^13+60743914496*u^14*v^12-101678772224*u^14*v^11-35855253504*u^14*v^10-295650459648*u^14*v^9-610879242240*u^14*v^8+75507499008*u^14*v^7+427335745536*u^14*v^6+549732483072*u^14*v^5+900293197824*u^14*v^4+659347734528*u^14*v^3+125363552256*u^14*v^2-3057647616*u^14*v-9296*u^13*v^23+108808*u^13*v^22-1427552*u^13*v^21+11111776*u^13*v^20-28586304*u^13*v^19+198803480*u^13*v^18+122299696*u^13*v^17-130232960*u^13*v^16+953500608*u^13*v^15-10611005312*u^13*v^14-17988958080*u^13*v^13-9145614336*u^13*v^12-14115142656*u^13*v^11+97731572736*u^13*v^10+224249392128*u^13*v^9+121934020608*u^13*v^8-18801672192*u^13*v^7-216996544512*u^13*v^6-456922791936*u^13*v^5-413759176704*u^13*v^4-124599140352*u^13*v^3+6115295232*u^13*v^2-2712*u^12*v^23+7944*u^12*v^22-695776*u^12*v^21-700752*u^12*v^20-27386568*u^12*v^19-52964216*u^12*v^18-195089392*u^12*v^17-372789952*u^12*v^16+1099665328*u^12*v^15+3155557504*u^12*v^14+7282699392*u^12*v^13+11267258624*u^12*v^12-12175540736*u^12*v^11-49717386240*u^12*v^10-63962127360*u^12*v^9-46115758080*u^12*v^8+34568626176*u^12*v^7+143352889344*u^12*v^6+172138659840*u^12*v^5+72236924928*u^12*v^4-5350883328*u^12*v^3+680*u^11*v^23+20376*u^11*v^22+131904*u^11*v^21+1972128*u^11*v^20+6950296*u^11*v^19+35601992*u^11*v^18+82202304*u^11*v^17+28797760*u^11*v^16-220245376*u^11*v^15-1409603840*u^11*v^14-2974720896*u^11*v^13-1054870528*u^11*v^12+5452555264*u^11*v^11+15640398336*u^11*v^10+19716786432*u^11*v^9+4041805824*u^11*v^8-27050913792*u^11*v^7-49700044800*u^11*v^6-26921631744*u^11*v^5+2675441664*u^11*v^4-3880*u^10*v^22-59512*u^10*v^21-405456*u^10*v^20-2820864*u^10*v^19-9100744*u^10*v^18-20325544*u^10*v^17-16338144*u^10*v^16+117633520*u^10*v^15+394945696*u^10*v^14+586858160*u^10*v^13+67887488*u^10*v^12-2053784832*u^10*v^11-4030393344*u^10*v^10-3180957696*u^10*v^9+2448119808*u^10*v^8+10100256768*u^10*v^7+6688604160*u^10*v^6-836075520*u^10*v^5+8520*u^9*v^21+88968*u^9*v^20+483792*u^9*v^19+2059864*u^9*v^18+4121544*u^9*v^17-429208*u^9*v^16-24145616*u^9*v^15-84219720*u^9*v^14-96475792*u^9*v^13+106727616*u^9*v^12+446695488*u^9*v^11+718143552*u^9*v^10+91416384*u^9*v^9-1428129792*u^9*v^8-1107800064*u^9*v^7+167215104*u^9*v^6-9080*u^8*v^20-72912*u^8*v^19-261624*u^8*v^18-615696*u^8*v^17+80376*u^8*v^16+5168576*u^8*v^15+10905976*u^8*v^14+6971280*u^8*v^13-22456704*u^8*v^12-87418800*u^8*v^11-48871296*u^8*v^10+134519616*u^8*v^9+117946368*u^8*v^8-20901888*u^8*v^7+4720*u^7*v^19+31360*u^7*v^18+51584*u^7*v^17-52864*u^7*v^16-434592*u^7*v^15-1265664*u^7*v^14-108864*u^7*v^13+5800320*u^7*v^12+4904496*u^7*v^11-7620480*u^7*v^10-7324992*u^7*v^9+1492992*u^7*v^8-960*u^6*v^18-5568*u^6*v^17+1152*u^6*v^16+51840*u^6*v^15+41472*u^6*v^14-165888*u^6*v^13-176256*u^6*v^12+196992*u^6*v^11+202176*u^6*v^10-46656*u^6*v^9);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(1321205760*u^19*v^6-2503999488*u^18*v^7+1560281088*u^18*v^6-3963617280*u^18*v^5+2072248320*u^17*v^8-3530555392*u^17*v^7+7234125824*u^17*v^6-4680843264*u^17*v^5+3523215360*u^17*v^4-977928192*u^16*v^9+3512729600*u^16*v^8-6074138624*u^16*v^7+10594811904*u^16*v^6-5917114368*u^16*v^5+2986344448*u^16*v^4+287784960*u^15*v^10-2017263616*u^15*v^9+3279355904*u^15*v^8-10300686336*u^15*v^7+5712904192*u^15*v^6-7529824256*u^15*v^5-1516240896*u^15*v^4+3523215360*u^15*v^3-1321205760*u^15*v^2-54067200*u^14*v^11+736722944*u^14*v^10-1357594624*u^14*v^9+5635571712*u^14*v^8-4694540288*u^14*v^7+7224164352*u^14*v^6+610009088*u^14*v^5-4949278720*u^14*v^4+5270142976*u^14*v^3-5083496448*u^14*v^2+440401920*u^14*v+6331392*u^13*v^12-177344512*u^13*v^11+463032320*u^13*v^10-1904050176*u^13*v^9+3089055744*u^13*v^8-3478781952*u^13*v^7+2128543744*u^13*v^6+3823632384*u^13*v^5-6292242432*u^13*v^4+7036993536*u^13*v^3-3469737984*u^13*v^2+1694498816*u^13*v-422400*u^12*v^13+28110848*u^12*v^12-125731840*u^12*v^11+410664960*u^12*v^10-1423110144*u^12*v^9+895352832*u^12*v^8-2709307392*u^12*v^7-2362703872*u^12*v^6+3254976512*u^12*v^5-4677697536*u^12*v^4+5682495488*u^12*v^3-897581056*u^12*v^2+902823936*u^12*v+12288*u^11*v^14-2824960*u^11*v^13+25154816*u^11*v^12-57538560*u^11*v^11+434789376*u^11*v^10-132808704*u^11*v^9+1455697920*u^11*v^8+1008828416*u^11*v^7-726188032*u^11*v^6+2192572416*u^11*v^5-4213374976*u^11*v^4-407371776*u^11*v^3-1553727488*u^11*v^2-724566016*u^11*v+162944*u^10*v^14-3438976*u^10*v^13+5781504*u^10*v^12-85494528*u^10*v^11+28557312*u^10*v^10-416338944*u^10*v^9-175243264*u^10*v^8+112013312*u^10*v^7-674758656*u^10*v^6+1809727488*u^10*v^5+217055232*u^10*v^4+758448128*u^10*v^3+647495680*u^10*v^2-157548544*u^10*v-4096*u^9*v^15+295616*u^9*v^14-597888*u^9*v^13+10172352*u^9*v^12-12615168*u^9*v^11+57808128*u^9*v^10-55207936*u^9*v^9-115440640*u^9*v^8-860160*u^9*v^7-608391168*u^9*v^6+104693760*u^9*v^5+136691712*u^9*v^4+138543104*u^9*v^3+495779840*u^9*v^2+177733632*u^9*v-13920*u^8*v^15+72384*u^8*v^14-603936*u^8*v^13+3583488*u^8*v^12+153024*u^8*v^11+39947264*u^8*v^10+77412608*u^8*v^9+112336896*u^8*v^8+232522752*u^8*v^7-51953664*u^8*v^6-267030528*u^8*v^5-427294720*u^8*v^4-584728576*u^8*v^3-323223552*u^8*v^2-31260672*u^8*v+256*u^7*v^16-6096*u^7*v^15+1296*u^7*v^14-547888*u^7*v^13-1335312*u^7*v^12-10429312*u^7*v^11-25314688*u^7*v^10-52955136*u^7*v^9-88365312*u^7*v^8-19138560*u^7*v^7+99714048*u^7*v^6+247267328*u^7*v^5+362663936*u^7*v^4+257851392*u^7*v^3+54558720*u^7*v^2-1769472*u^7*v+216*u^6*v^16+1544*u^6*v^15+43208*u^6*v^14+196200*u^6*v^13+1456256*u^6*v^12+4579568*u^6*v^11+12546816*u^6*v^10+23996544*u^6*v^9+18038784*u^6*v^8-11467008*u^6*v^7-71680000*u^6*v^6-132803584*u^6*v^5-118063104*u^6*v^4-40808448*u^6*v^3+2654208*u^6*v^2-40*u^5*v^16-1392*u^5*v^15-11408*u^5*v^14-107904*u^5*v^13-460328*u^5*v^12-1691856*u^5*v^11-4069152*u^5*v^10-5363328*u^5*v^9-2342592*u^5*v^8+11056640*u^5*v^7+29601536*u^5*v^6+34007040*u^5*v^5+16957440*u^5*v^4-1658880*u^5*v^3+200*u^4*v^15+3344*u^4*v^14+22784*u^4*v^13+123888*u^4*v^12+397752*u^4*v^11+817600*u^4*v^10+934272*u^4*v^9-656896*u^4*v^8-3870400*u^4*v^7-6325248*u^4*v^6-4227840*u^4*v^5+552960*u^4*v^4-360*u^3*v^14-3840*u^3*v^13-19184*u^3*v^12-64880*u^3*v^11-120408*u^3*v^10-51280*u^3*v^9+251504*u^3*v^8+743808*u^3*v^7+632448*u^3*v^6-103680*u^3*v^5+280*u^2*v^13+2136*u^2*v^12+6392*u^2*v^11+10248*u^2*v^10-2464*u^2*v^9-50688*u^2*v^8-52560*u^2*v^7+10368*u^2*v^6-80*u*v^12-464*u*v^11-384*u*v^10+1536*u*v^9+1872*u*v^8-432*u*v^7);

g=(253671505920*u^31*v^9-338228674560*u^31*v^8-861275160576*u^30*v^10+1532498018304*u^30*v^9-568546295808*u^30*v^8+1261713752064*u^29*v^11-2927489974272*u^29*v^10+2631003013120*u^29*v^9+801548271616*u^29*v^8-1691143372800*u^29*v^7+2142114938880*u^29*v^6-1070856142848*u^28*v^12+3133950394368*u^28*v^11-4012740968448*u^28*v^10-3320680808448*u^28*v^9+2971312062464*u^28*v^8-7221987508224*u^28*v^7+5930812964864*u^28*v^6-2705829396480*u^28*v^5+590748844032*u^27*v^13-2102478766080*u^27*v^12+2528527777792*u^27*v^11+6821179817984*u^27*v^10-4586035216384*u^27*v^9+13282186362880*u^27*v^8-13315472359424*u^27*v^7-1543503872000*u^27*v^6-4266513137664*u^27*v^5+338228674560*u^27*v^4-223746195456*u^26*v^14+925504634880*u^26*v^13+48003809280*u^26*v^12-8958798462976*u^26*v^11+9658114768896*u^26*v^10-15985247518720*u^26*v^9+14931453804544*u^26*v^8+10694602784768*u^26*v^7+1615444574208*u^26*v^6+16551730216960*u^26*v^5-2588254666752*u^26*v^4+901943132160*u^26*v^3+59602894848*u^25*v^15-266463608832*u^25*v^14-1254630096896*u^25*v^13+8266654416896*u^25*v^12-14141959962624*u^25*v^11+14901485502464*u^25*v^10-16381261119488*u^25*v^9-18976876789760*u^25*v^8+19459288858624*u^25*v^7-32444317171712*u^25*v^6+17556349911040*u^25*v^5-11800959516672*u^25*v^4+4259533815808*u^25*v^3-338228674560*u^25*v^2-11197218816*u^24*v^16+45878870016*u^24*v^15+1038155513856*u^24*v^14-5606149718016*u^24*v^13+13022525390848*u^24*v^12-12564123615232*u^24*v^11+18729175875584*u^24*v^10+21587193495552*u^24*v^9-37290063691776*u^24*v^8+35466799742976*u^24*v^7-49655660412928*u^24*v^6+10283628101632*u^24*v^5-3762659786752*u^24*v^4+114890375168*u^24*v^3-1245003644928*u^24*v^2+1456607232*u^23*v^17-2571485184*u^23*v^16-482377924608*u^23*v^15+2857950248960*u^23*v^14-8084003880960*u^23*v^13+9491619774464*u^23*v^12-16591715565568*u^23*v^11-14587562819584*u^23*v^10+35418321977344*u^23*v^9-35507832619008*u^23*v^8+68323366666240*u^23*v^7+2263011557376*u^23*v^6+3273939484672*u^23*v^5+9721121603584*u^23*v^4-15532212355072*u^23*v^3+2144799293440*u^23*v^2-84557168640*u^23*v-125134848*u^22*v^18-803450880*u^22*v^17+149620826112*u^22*v^16-1106198790144*u^22*v^15+3599219359744*u^22*v^14-5772367495168*u^22*v^13+10523813347328*u^22*v^12+4199753449472*u^22*v^11-22942362632192*u^22*v^10+29339768848384*u^22*v^9-58374911688704*u^22*v^8+2141267689472*u^22*v^7+3504693313536*u^22*v^6-23256107057152*u^22*v^5+32341640609792*u^22*v^4-7398215385088*u^22*v^3+9846883614720*u^22*v^2-579015278592*u^22*v+6395904*u^21*v^19+230691840*u^21*v^18-32547154944*u^21*v^17+325562966016*u^21*v^16-1202181439488*u^21*v^15+2640436019200*u^21*v^14-4961491714048*u^21*v^13+1381394284544*u^21*v^12+11404009013248*u^21*v^11-16157114368000*u^21*v^10+37376779878400*u^21*v^9-13971897712640*u^21*v^8-14474253697024*u^21*v^7+17548720472064*u^21*v^6-37081380290560*u^21*v^5+17993731932160*u^21*v^4-9471275302912*u^21*v^3+2490074398720*u^21*v^2-1149373513728*u^21*v-147456*u^20*v^20-28417536*u^20*v^19+5008082432*u^20*v^18-72423565312*u^20*v^17+311174369280*u^20*v^16-889128222720*u^20*v^15+1832530288640*u^20*v^14-1908387217408*u^20*v^13-4317298950144*u^20*v^12+5319698415616*u^20*v^11-19873274527744*u^20*v^10+14574605565952*u^20*v^9+15227116584960*u^20*v^8-1876189773824*u^20*v^7+35112114716672*u^20*v^6-19847287144448*u^20*v^5-2829561364480*u^20*v^4-9565563256832*u^20*v^3-3989923954688*u^20*v^2-380909912064*u^20*v+1817088*u^19*v^20-535229184*u^19*v^19+12005168640*u^19*v^18-63701669120*u^19*v^17+219559084032*u^19*v^16-548150816768*u^19*v^15+923002773504*u^19*v^14+1108497735680*u^19*v^13-860145106944*u^19*v^12+8556362727424*u^19*v^11-8101146394624*u^19*v^10-7806878744576*u^19*v^9-4443040907264*u^19*v^8-25165933051904*u^19*v^7+12283438694400*u^19*v^6+8036317921280*u^19*v^5+11991636770816*u^19*v^4+10267387756544*u^19*v^3+2048498073600*u^19*v^2+447599345664*u^19*v-49152*u^18*v^21+37804160*u^18*v^20-1445184512*u^18*v^19+10356483712*u^18*v^18-39749042944*u^18*v^17+132599011328*u^18*v^16-274704332800*u^18*v^15-131639844864*u^18*v^14-17530994688*u^18*v^13-2700723314688*u^18*v^12+3186834341888*u^18*v^11+2237214490624*u^18*v^10+2941250437120*u^18*v^9+11755556175872*u^18*v^8-6597653823488*u^18*v^7-6067799982080*u^18*v^6-7047028408320*u^18*v^5-8158934204416*u^18*v^4-945555505152*u^18*v^3+467404849152*u^18*v^2+56623104000*u^18*v-1584000*u^17*v^21+120889792*u^17*v^20-1313927232*u^17*v^19+5288992576*u^17*v^18-25087129408*u^17*v^17+57181577728*u^17*v^16-21073244160*u^17*v^15+34646571008*u^17*v^14+547575441408*u^17*v^13-1098580992000*u^17*v^12-510853529600*u^17*v^11-1097798008832*u^17*v^10-3266753003520*u^17*v^9+4348878520320*u^17*v^8+4234422255616*u^17*v^7+2881837596672*u^17*v^6+2589304815616*u^17*v^5-2496323911680*u^17*v^4-3080082948096*u^17*v^3-826697318400*u^17*v^2-96372523008*u^17*v+29696*u^16*v^22-6496928*u^16*v^21+124577376*u^16*v^20-525110240*u^16*v^19+3515682848*u^16*v^18-9087123712*u^16*v^17+12035075840*u^16*v^16-7994265088*u^16*v^15-50847689728*u^16*v^14+352647739392*u^16*v^13+221298569216*u^16*v^12+462694711296*u^16*v^11+515652935680*u^16*v^10-2545278320640*u^16*v^9-2990229291008*u^16*v^8-1795846045696*u^16*v^7-192462716928*u^16*v^6+3691964792832*u^16*v^5+4425265446912*u^16*v^4+1764451418112*u^16*v^3+294440140800*u^16*v^2+18345885696*u^16*v+191712*u^15*v^22-8186656*u^15*v^21+40617376*u^15*v^20-338000672*u^15*v^19+1205289792*u^15*v^18-2199298368*u^15*v^17+2193622464*u^15*v^16-4015640576*u^15*v^15-92496171520*u^15*v^14-108106856960*u^15*v^13-225411792896*u^15*v^12-99435282432*u^15*v^11+993772265472*u^15*v^10+1571929411584*u^15*v^9+1334236053504*u^15*v^8+190514528256*u^15*v^7-2319617359872*u^15*v^6-3364463443968*u^15*v^5-1801464053760*u^15*v^4-392766160896*u^15*v^3-36691771392*u^15*v^2+1019215872*u^15*v-2048*u^14*v^23+326592*u^14*v^22-2568416*u^14*v^21+19416448*u^14*v^20-138032288*u^14*v^19+163189856*u^14*v^18-735953280*u^14*v^17+1467549152*u^14*v^16+16933117824*u^14*v^15+33462290432*u^14*v^14+82863021056*u^14*v^13+57205792768*u^14*v^12-231932717056*u^14*v^11-542974654464*u^14*v^10-679286427648*u^14*v^9-314418806784*u^14*v^8+806996606976*u^14*v^7+1598530977792*u^14*v^6+1109979168768*u^14*v^5+303740485632*u^14*v^4+32105299968*u^14*v^3-2038431744*u^14*v^2-5824*u^13*v^23+123328*u^13*v^22-417440*u^13*v^21+12437344*u^13*v^20+6077792*u^13*v^19+165699680*u^13*v^18-44296768*u^13*v^17-1824198848*u^13*v^16-6131525568*u^13*v^15-19812292160*u^13*v^14-23387143808*u^13*v^13+24815584768*u^13*v^12+118191550464*u^13*v^11+219971392512*u^13*v^10+180860789760*u^13*v^9-146460966912*u^13*v^8-503000580096*u^13*v^7-453140545536*u^13*v^6-151602167808*u^13*v^5-16052649984*u^13*v^4+1783627776*u^13*v^3-3136*u^12*v^23-13760*u^12*v^22-725984*u^12*v^21-2091232*u^12*v^20-21642176*u^12*v^19-28243648*u^12*v^18+58777088*u^12*v^17+616818304*u^12*v^16+2952887520*u^12*v^15+5376193888*u^12*v^14+1847080832*u^12*v^13-14664695552*u^12*v^12-45487442944*u^12*v^11-56722045440*u^12*v^10+2472652800*u^12*v^9+105906438144*u^12*v^8+127761629184*u^12*v^7+51211173888*u^12*v^6+5016453120*u^12*v^5-891813888*u^12*v^4+640*u^11*v^23+19552*u^11*v^22+144000*u^11*v^21+1521632*u^11*v^20+4535680*u^11*v^19+10509632*u^11*v^18-21165600*u^11*v^17-250519168*u^11*v^16-715251680*u^11*v^15-1005672640*u^11*v^14+562511104*u^11*v^13+5779394624*u^11*v^12+10892192000*u^11*v^11+5472494592*u^11*v^10-14441879808*u^11*v^9-25181134848*u^11*v^8-11886981120*u^11*v^7-1003290624*u^11*v^6+278691840*u^11*v^5-3200*u^10*v^22-45024*u^10*v^21-276352*u^10*v^20-1335584*u^10*v^19-1804672*u^10*v^18+8135168*u^10*v^17+51881216*u^10*v^16+141735360*u^10*v^15+107152864*u^10*v^14-376839104*u^10*v^13-1296354656*u^10*v^12-1391491968*u^10*v^11+1137236352*u^10*v^10+3426451200*u^10*v^9+1875585024*u^10*v^8+125411328*u^10*v^7-55738368*u^10*v^6+5760*u^9*v^21+49120*u^9*v^20+190016*u^9*v^19+329888*u^9*v^18-1484576*u^9*v^17-9032896*u^9*v^16-16968544*u^9*v^15-76224*u^9*v^14+89846272*u^9*v^13+172196736*u^9*v^12-30321792*u^9*v^11-308212992*u^9*v^10-192794688*u^9*v^9-8957952*u^9*v^8+6967296*u^9*v^7-4480*u^8*v^20-25696*u^8*v^19-23232*u^8*v^18+164736*u^8*v^17+915104*u^8*v^16+1653792*u^8*v^15-2981824*u^8*v^14-11301120*u^8*v^13-2135328*u^8*v^12+16559424*u^8*v^11+11670912*u^8*v^10+279936*u^8*v^9-497664*u^8*v^8+1280*u^7*v^19+5184*u^7*v^18-14848*u^7*v^17-75968*u^7*v^16+20544*u^7*v^15+315840*u^7*v^14+141120*u^7*v^13-403776*u^7*v^12-316224*u^7*v^11+15552*u^7*v^9);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

//
// - ring r4=0,(u,v),dp.
//
// The examples from r4 are those from r3 with parameters
// changed to ring variables.
//

tst_ignore( "ring r4=0,(u,v),dp;" );
ring r4=0,(u,v),dp;

poly f;
poly g;
poly gg;

f=(573440*u^11*v^2-1421312*u^10*v^3+294912*u^10*v^2+1720320*u^10*v+1370112*u^9*v^4-868352*u^9*v^3-2781184*u^9*v^2+884736*u^9*v-693760*u^8*v^5+1046528*u^8*v^4+2174976*u^8*v^3-1662976*u^8*v^2-712704*u^8*v+203200*u^7*v^6-688128*u^7*v^5-1131008*u^7*v^4+1275904*u^7*v^3+1115136*u^7*v^2+172032*u^7*v-34800*u^6*v^7+273280*u^6*v^6+430400*u^6*v^5-505344*u^6*v^4-744192*u^6*v^3-258048*u^6*v^2+9216*u^6*v+3248*u^5*v^8-67648*u^5*v^7-118320*u^5*v^6+103040*u^5*v^5+274560*u^5*v^4+161280*u^5*v^3-11520*u^5*v^2-128*u^4*v^9+10248*u^4*v^8+22216*u^4*v^7-6944*u^4*v^6-60480*u^4*v^5-53760*u^4*v^4+5760*u^4*v^3-872*u^3*v^9-2644*u^3*v^8-1176*u^3*v^7+7956*u^3*v^6+10080*u^3*v^5-1440*u^3*v^4+32*u^2*v^10+177*u^2*v^9+254*u^2*v^8-579*u^2*v^7-1008*u^2*v^6+180*u^2*v^5-5*u*v^10-14*u*v^9+18*u*v^8+42*u*v^7-9*u*v^6);

g=(65536*u^11*v^3-147456*u^10*v^4+196608*u^10*v^2+122880*u^9*v^5+16384*u^9*v^4-262144*u^9*v^3-65536*u^9*v^2-51200*u^8*v^6-36864*u^8*v^5+159744*u^8*v^4+196608*u^8*v^3-49152*u^8*v^2-196608*u^8*v+11520*u^7*v^7+30720*u^7*v^6-61440*u^7*v^5-184320*u^7*v^4+61440*u^7*v^3+245760*u^7*v^2-1344*u^6*v^8-12800*u^6*v^7+16640*u^6*v^6+81920*u^6*v^5-30720*u^6*v^4-122880*u^6*v^3+64*u^5*v^9+2880*u^5*v^8-3072*u^5*v^7-19200*u^5*v^6+7680*u^5*v^5+30720*u^5*v^4-336*u^4*v^9+336*u^4*v^8+2304*u^4*v^7-960*u^4*v^6-3840*u^4*v^5+16*u^3*v^10-16*u^3*v^9-112*u^3*v^8+48*u^3*v^7+192*u^3*v^6);

// EZGCD fails on this example with the given seed and variable ordering!
gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(-587202560*u^22*v^6+1308622848*u^21*v^7-301989888*u^21*v^6+1174405120*u^21*v^5-1296039936*u^20*v^8+666894336*u^20*v^7-2227175424*u^20*v^6+1191182336*u^20*v^5-587202560*u^20*v^4+748683264*u^19*v^9-654311424*u^19*v^8+1627389952*u^19*v^7-2625634304*u^19*v^6+830472192*u^19*v^5-1476395008*u^19*v^4-278003712*u^18*v^10+374341632*u^18*v^9-387973120*u^18*v^8+2594177024*u^18*v^7-244318208*u^18*v^6+3007315968*u^18*v^5-213909504*u^18*v^4+587202560*u^18*v^3+68812800*u^17*v^11-137625600*u^17*v^10-231997440*u^17*v^9-1524629504*u^17*v^8-356515840*u^17*v^7-2648702976*u^17*v^6+849346560*u^17*v^5-805306368*u^17*v^4+301989888*u^17*v^3-11354112*u^16*v^12+33718272*u^16*v^11+248217600*u^16*v^10+601227264*u^16*v^9+481689600*u^16*v^8+1310457856*u^16*v^7-1249116160*u^16*v^6+135266304*u^16*v^5-995098624*u^16*v^4-243269632*u^16*v^3+1204224*u^15*v^13-5505024*u^15*v^12-114229248*u^15*v^11-172818432*u^15*v^10-319488000*u^15*v^9-399507456*u^15*v^8+975175680*u^15*v^7+449314816*u^15*v^6+1376256000*u^15*v^5+570425344*u^15*v^4+58720256*u^15*v^3-74496*u^14*v^14+577536*u^14*v^13+33460224*u^14*v^12+39223296*u^14*v^11+142270464*u^14*v^10+82083840*u^14*v^9-456622080*u^14*v^8-448659456*u^14*v^7-1077411840*u^14*v^6-603193344*u^14*v^5-131334144*u^14*v^4+3145728*u^14*v^3+2048*u^13*v^15-35328*u^13*v^14-6750720*u^13*v^13-7520256*u^13*v^12-45244416*u^13*v^11-15482880*u^13*v^10+131776512*u^13*v^9+216662016*u^13*v^8+534773760*u^13*v^7+379060224*u^13*v^6+130547712*u^13*v^5-6291456*u^13*v^4+960*u^12*v^15+944960*u^12*v^14+1226496*u^12*v^13+10287360*u^12*v^12+4061184*u^12*v^11-21719040*u^12*v^10-63823872*u^12*v^9-176676864*u^12*v^8-156893184*u^12*v^7-75694080*u^12*v^6+5505024*u^12*v^5-88320*u^11*v^15-158336*u^11*v^14-1628800*u^11*v^13-1081344*u^11*v^12+1136640*u^11*v^11+11956224*u^11*v^10+39309312*u^11*v^9+44728320*u^11*v^8+28213248*u^11*v^7-2752512*u^11*v^6+4976*u^10*v^16+14432*u^10*v^15+170160*u^10*v^14+199744*u^10*v^13+290880*u^10*v^12-1353984*u^10*v^11-5760000*u^10*v^10-8902656*u^10*v^9-7010304*u^10*v^8+860160*u^10*v^7-128*u^9*v^17-800*u^9*v^16-10528*u^9*v^15-22752*u^9*v^14-67680*u^9*v^13+70144*u^9*v^12+514560*u^9*v^11+1222656*u^9*v^10+1161216*u^9*v^9-172032*u^9*v^8+20*u^8*v^17+292*u^8*v^16+1452*u^8*v^15+5916*u^8*v^14+2256*u^8*v^13-21840*u^8*v^12-110976*u^8*v^11-123648*u^8*v^10+21504*u^8*v^9-40*u^7*v^16-200*u^7*v^15-504*u^7*v^14-152*u^7*v^13+6016*u^7*v^12+7680*u^7*v^11-1536*u^7*v^10+20*u^6*v^15+36*u^6*v^14-148*u^6*v^13-212*u^6*v^12+48*u^6*v^11);

g=(-47185920*u^21*v^7+301989888*u^21*v^6+135266304*u^20*v^8-761266176*u^20*v^7+163577856*u^20*v^6-301989888*u^20*v^5-159842304*u^19*v^9+873201664*u^19*v^8-570163200*u^19*v^7+813694976*u^19*v^6+59768832*u^19*v^5-402653184*u^19*v^4+105086976*u^18*v^10-605421568*u^18*v^9+767819776*u^18*v^8-1006895104*u^18*v^7+294125568*u^18*v^6+912261120*u^18*v^5-713031680*u^18*v^4+402653184*u^18*v^3-42971136*u^17*v^11+283197440*u^17*v^10-566050816*u^17*v^9+780664832*u^17*v^8-733544448*u^17*v^7-944504832*u^17*v^6+1355546624*u^17*v^5-973078528*u^17*v^4+483393536*u^17*v^3+100663296*u^17*v^2+11427840*u^16*v^12-93995008*u^16*v^11+261398528*u^16*v^10-424591360*u^16*v^9+700252160*u^16*v^8+504627200*u^16*v^7-1089601536*u^16*v^6+1263796224*u^16*v^5-1270874112*u^16*v^4-346030080*u^16*v^3+398458880*u^16*v^2-100663296*u^16*v-1986816*u^15*v^13+22541312*u^15*v^12-80757760*u^15*v^11+167518208*u^15*v^10-378572800*u^15*v^9-99500032*u^15*v^8+484917248*u^15*v^7-954859520*u^15*v^6+1386676224*u^15*v^5+139722752*u^15*v^4-593756160*u^15*v^3+461373440*u^15*v^2-344981504*u^15*v+218496*u^14*v^14-3882496*u^14*v^13+17297408*u^14*v^12-47684608*u^14*v^11+131680256*u^14*v^10-37199872*u^14*v^9-133611520*u^14*v^8+413188096*u^14*v^7-874545152*u^14*v^6+178388992*u^14*v^5+430440448*u^14*v^4-490471424*u^14*v^3+581435392*u^14*v^2-106954752*u^14*v-13824*u^13*v^15+466112*u^13*v^14-2624704*u^13*v^13+9552896*u^13*v^12-31446784*u^13*v^11+30632960*u^13*v^10+24998912*u^13*v^9-91848704*u^13*v^8+374026240*u^13*v^7-195117056*u^13*v^6-218021888*u^13*v^5+207880192*u^13*v^4-482803712*u^13*v^3+158072832*u^13*v^2+68419584*u^13*v+384*u^12*v^16-36640*u^12*v^15+286304*u^12*v^14-1292608*u^12*v^13+5391872*u^12*v^12-9428992*u^12*v^11-3314176*u^12*v^10+2993152*u^12*v^9-119730176*u^12*v^8+81559552*u^12*v^7+81043456*u^12*v^6-20922368*u^12*v^5+279445504*u^12*v^4-100663296*u^12*v^3-119144448*u^12*v^2+7077888*u^12*v+1664*u^11*v^16-22432*u^11*v^15+110240*u^11*v^14-686080*u^11*v^13+1616960*u^11*v^12+115904*u^11*v^11+3771904*u^11*v^10+29638912*u^11*v^9-17306624*u^11*v^8-17865728*u^11*v^7-14606336*u^11*v^6-124448768*u^11*v^5+37109760*u^11*v^4+88915968*u^11*v^3-10616832*u^11*v^2-32*u^10*v^17+1184*u^10*v^16-5184*u^10*v^15+64640*u^10*v^14-159232*u^10*v^13+103808*u^10*v^12-1016000*u^10*v^11-5419136*u^10*v^10+1618432*u^10*v^9+517120*u^10*v^8+6691840*u^10*v^7+41076736*u^10*v^6-9216000*u^10*v^5-36864000*u^10*v^4+6635520*u^10*v^3-32*u^9*v^17+96*u^9*v^16-4096*u^9*v^15+8192*u^9*v^14-30080*u^9*v^13+122176*u^9*v^12+654208*u^9*v^11+46912*u^9*v^10+849088*u^9*v^9-1347584*u^9*v^8-9337088*u^9*v^7+1717248*u^9*v^6+9169920*u^9*v^5-2211840*u^9*v^4+128*u^8*v^16-160*u^8*v^15+3552*u^8*v^14-7168*u^8*v^13-41920*u^8*v^12-25376*u^8*v^11-228128*u^8*v^10+154432*u^8*v^9+1355008*u^8*v^8-242688*u^8*v^7-1368576*u^8*v^6+414720*u^8*v^5-160*u^7*v^15+160*u^7*v^14+448*u^7*v^13+2176*u^7*v^12+25376*u^7*v^11-10208*u^7*v^10-112256*u^7*v^9+22464*u^7*v^8+113472*u^7*v^7-41472*u^7*v^6+64*u^6*v^14-64*u^6*v^13-1088*u^6*v^12+320*u^6*v^11+4032*u^6*v^10-960*u^6*v^9-4032*u^6*v^8+1728*u^6*v^7);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(16384*u^14*v^3-24576*u^13*v^4-32768*u^13*v^2+15360*u^12*v^5+49152*u^12*v^3+16384*u^12*v-5120*u^11*v^6-30720*u^11*v^4-24576*u^11*v^2+960*u^10*v^7+10240*u^10*v^5+15360*u^10*v^3-96*u^9*v^8-1920*u^9*v^6-5120*u^9*v^4+4*u^8*v^9+192*u^8*v^7+960*u^8*v^5-8*u^7*v^8-96*u^7*v^6+4*u^6*v^7);

g=(226492416*u^22*v^6-603979776*u^21*v^7+226492416*u^21*v^6-796917760*u^21*v^5+717225984*u^20*v^8-723517440*u^20*v^7+2032140288*u^20*v^6-268435456*u^20*v^5+419430400*u^20*v^4-500170752*u^19*v^9+994050048*u^19*v^8-2407530496*u^19*v^7+1113587712*u^19*v^6-656408576*u^19*v^5-268435456*u^19*v^4+251658240*u^19*v^3+227082240*u^18*v^10-786432000*u^18*v^9+1780482048*u^18*v^8-1749024768*u^18*v^7+392167424*u^18*v^6+281018368*u^18*v^5-1170210816*u^18*v^4+545259520*u^18*v^3-75497472*u^18*v^2-70189056*u^17*v^11+400883712*u^17*v^10-930152448*u^17*v^9+1500512256*u^17*v^8-181403648*u^17*v^7+104857600*u^17*v^6+2017460224*u^17*v^5-1388314624*u^17*v^4+113246208*u^17*v^3-75497472*u^17*v^2-25165824*u^17*v+14966784*u^16*v^12-138657792*u^16*v^11+365150208*u^16*v^10-809238528*u^16*v^9+171048960*u^16*v^8-344457216*u^16*v^7-1778384896*u^16*v^6+1673003008*u^16*v^5-356515840*u^16*v^4+253755392*u^16*v^3+555745280*u^16*v^2-159383552*u^16*v-2174976*u^15*v^13+33202176*u^15*v^12-110272512*u^15*v^11+293879808*u^15*v^10-147505152*u^15*v^9+278396928*u^15*v^8+899284992*u^15*v^7-1270349824*u^15*v^6+497025024*u^15*v^5-433061888*u^15*v^4-847249408*u^15*v^3+501219328*u^15*v^2-270532608*u^15*v+206208*u^14*v^14-5486592*u^14*v^13+25491456*u^14*v^12-74661888*u^14*v^11+76726272*u^14*v^10-133005312*u^14*v^9-266108928*u^14*v^8+669843456*u^14*v^7-322633728*u^14*v^6+477626368*u^14*v^5+580386816*u^14*v^4-684195840*u^14*v^3+427819008*u^14*v^2-37748736*u^14*v-11520*u^13*v^15+608640*u^13*v^14-4397952*u^13*v^13+13621248*u^13*v^12-24619008*u^13*v^11+45416448*u^13*v^10+42319872*u^13*v^9-250380288*u^13*v^8+107839488*u^13*v^7-357236736*u^13*v^6-257753088*u^13*v^5+526909440*u^13*v^4-284688384*u^13*v^3+94371840*u^13*v^2+56623104*u^13*v+288*u^12*v^16-42528*u^12*v^15+542752*u^12*v^14-1833984*u^12*v^13+5006592*u^12*v^12-12140544*u^12*v^11-2445312*u^12*v^10+64253952*u^12*v^9-18063360*u^12*v^8+183091200*u^12*v^7+101302272*u^12*v^6-248709120*u^12*v^5+114032640*u^12*v^4-103809024*u^12*v^3-113246208*u^12*v^2+1632*u^11*v^16-44832*u^11*v^15+188512*u^11*v^14-635680*u^11*v^13+2586624*u^11*v^12+71424*u^11*v^11-10100736*u^11*v^10+1843200*u^11*v^9-64339968*u^11*v^8-38019072*u^11*v^7+71909376*u^11*v^6-40943616*u^11*v^5+66060288*u^11*v^4+99090432*u^11*v^3-24*u^10*v^17+2200*u^10*v^16-14976*u^10*v^15+46688*u^10*v^14-418112*u^10*v^13-136128*u^10*v^12+537216*u^10*v^11-713856*u^10*v^10+15304704*u^10*v^9+10979328*u^10*v^8-11096064*u^10*v^7+16859136*u^10*v^6-26836992*u^10*v^5-49545216*u^10*v^4-48*u^9*v^17+840*u^9*v^16-1592*u^9*v^15+46784*u^9*v^14+39552*u^9*v^13+132416*u^9*v^12+303552*u^9*v^11-2366592*u^9*v^10-1981824*u^9*v^9+92160*u^9*v^8-5978112*u^9*v^7+7225344*u^9*v^6+15482880*u^9*v^5-24*u^8*v^17+8*u^8*v^16-3160*u^8*v^15-4432*u^8*v^14-32168*u^8*v^13-61920*u^8*v^12+213024*u^8*v^11+171552*u^8*v^10+320640*u^8*v^9+1422336*u^8*v^8-1290240*u^8*v^7-3096576*u^8*v^6+96*u^7*v^16+184*u^7*v^15+2936*u^7*v^14+6112*u^7*v^13-7088*u^7*v^12+2656*u^7*v^11-63520*u^7*v^10-206880*u^7*v^9+147456*u^7*v^8+387072*u^7*v^7-104*u^6*v^15-240*u^6*v^14-400*u^6*v^13-1712*u^6*v^12+5528*u^6*v^11+16704*u^6*v^10-9792*u^6*v^9-27648*u^6*v^8+32*u^5*v^14+96*u^5*v^13-192*u^5*v^12-576*u^5*v^11+288*u^5*v^10+864*u^5*v^9);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(52848230400*u^30*v^10-338228674560*u^30*v^9-216426086400*u^29*v^11+1453879984128*u^29*v^10-1318991167488*u^29*v^9+377229410304*u^28*v^12-2876042641408*u^28*v^11+5403127578624*u^28*v^10-1913240158208*u^28*v^9-514389442560*u^28*v^8+2480343613440*u^28*v^7-372268597248*u^27*v^13+3452153364480*u^27*v^12-9774806597632*u^27*v^11+7477110243328*u^27*v^10-2700922060800*u^27*v^9-8007094108160*u^27*v^8+10522871201792*u^27*v^7-2705829396480*u^27*v^6+233646981120*u^26*v^14-2772906278912*u^26*v^13+10476387303424*u^26*v^12-13422064304128*u^26*v^11+11034154762240*u^26*v^10+8590437908480*u^26*v^9-29618362908672*u^26*v^8+17962694082560*u^26*v^7-9466779009024*u^26*v^6-1803886264320*u^26*v^5-98829729792*u^25*v^15+1561023086592*u^25*v^14-7519372181504*u^25*v^13+14305345404928*u^25*v^12-17063328874496*u^25*v^11+1819898019840*u^25*v^10+36069321998336*u^25*v^9-44961126940672*u^25*v^8+36497289904128*u^25*v^7+119051124736*u^25*v^6-11520847118336*u^25*v^5+3607772528640*u^25*v^4+28950552576*u^24*v^16-631083663360*u^24*v^15+3859091062784*u^24*v^14-10072857116672*u^24*v^13+15700472496128*u^24*v^12-12920068505600*u^24*v^11-23603843694592*u^24*v^10+53928643264512*u^24*v^9-61918236639232*u^24*v^8+29128887631872*u^24*v^7+22640567779328*u^24*v^6-29600511950848*u^24*v^5+17721639043072*u^24*v^4-676457349120*u^24*v^3-5904101376*u^23*v^17+185241772032*u^23*v^16-1469308772352*u^23*v^15+4978579046400*u^23*v^14-9877888925696*u^23*v^13+14380155666432*u^23*v^12+6464711557120*u^23*v^11-36189369794560*u^23*v^10+62948141170688*u^23*v^9-62490356482048*u^23*v^8-12181491941376*u^23*v^7+47472894279680*u^23*v^6-51076338286592*u^23*v^5+23221478883328*u^23*v^4-1383717666816*u^23*v^3-901943132160*u^23*v^2+824758272*u^22*v^18-39464896512*u^22*v^17+422569936896*u^22*v^16-1796062814208*u^22*v^15+4509725040640*u^22*v^14-9080870502400*u^22*v^13+2733823262720*u^22*v^12+14101569732608*u^22*v^11-40999690698752*u^22*v^10+63269440061440*u^22*v^9-14597500174336*u^22*v^8-31434462986240*u^22*v^7+71501541801984*u^22*v^6-61401389334528*u^22*v^5+7956628242432*u^22*v^4+6687733841920*u^22*v^3-6440404123648*u^22*v^2+338228674560*u^22*v-75386880*u^21*v^19+6025079808*u^21*v^18-92087110656*u^21*v^17+485806970880*u^21*v^16-1531491809280*u^21*v^15+3877819244544*u^21*v^14-3774626979840*u^21*v^13-2561536065536*u^21*v^12+16691685785600*u^21*v^11-39923396902912*u^21*v^10+27843125575680*u^21*v^9+6489709215744*u^21*v^8-51723503665152*u^21*v^7+73756810674176*u^21*v^6-30743568842752*u^21*v^5-2078361518080*u^21*v^4+21561138479104*u^21*v^3-14738616483840*u^21*v^2+2347770052608*u^21*v+4067328*u^20*v^20-640017408*u^20*v^19+15042928128*u^20*v^18-100344188928*u^20*v^17+389414721024*u^20*v^16-1204456802304*u^20*v^15+2009514743808*u^20*v^14-449156210688*u^20*v^13-3575313842176*u^20*v^12+17530730840064*u^20*v^11-20602415939584*u^20*v^10+5484122996736*u^20*v^9+16772287954944*u^20*v^8-55137857961984*u^20*v^7+41002875224064*u^20*v^6-6733032325120*u^20*v^5-17290114367488*u^20*v^4+26878517706752*u^20*v^3-12401357357056*u^20*v^2+4814624784384*u^20*v-98304*u^19*v^21+44680192*u^19*v^20-1794271488*u^19*v^19+15976027136*u^19*v^18-73879631616*u^19*v^17+282466226688*u^19*v^16-670269934080*u^19*v^15+501136386048*u^19*v^14-88733079552*u^19*v^13-5525972041728*u^19*v^12+8941929414656*u^19*v^11-6059940184064*u^19*v^10+1357380911104*u^19*v^9+28208144318464*u^19*v^8-28015198994432*u^19*v^7+10793201434624*u^19*v^6+1344068911104*u^19*v^5-26617285967872*u^19*v^4+16269778616320*u^19*v^3-6583371169792*u^19*v^2+1954654715904*u^19*v-1827840*u^18*v^21+148966144*u^18*v^20-1951864192*u^18*v^19+10370889600*u^18*v^18-50646474880*u^18*v^17+154417168768*u^18*v^16-196831087104*u^18*v^15+317034307584*u^18*v^14+1183627739136*u^18*v^13-2580689104896*u^18*v^12+3091185352704*u^18*v^11-3580512780288*u^18*v^10-9592794185728*u^18*v^9+12127749865472*u^18*v^8-8605532946432*u^18*v^7+5454661550080*u^18*v^6+16748781240320*u^18*v^5-11500832423936*u^18*v^4+5102494547968*u^18*v^3-2949466030080*u^18*v^2-1647556165632*u^18*v+32768*u^17*v^22-7896832*u^17*v^21+178037824*u^17*v^20-1069773760*u^17*v^19+6841130560*u^17*v^18-25614060480*u^17*v^17+49462372480*u^17*v^16-108141835392*u^17*v^15-130867418112*u^17*v^14+556734987264*u^17*v^13-916313051136*u^17*v^12+1744219656192*u^17*v^11+1881126027264*u^17*v^10-4061011460096*u^17*v^9+3724796952576*u^17*v^8-4456313585664*u^17*v^7-6450705727488*u^17*v^6+6562090188800*u^17*v^5-2425773096960*u^17*v^4+2218035511296*u^17*v^3+2272945766400*u^17*v^2-394342170624*u^17*v+224000*u^16*v^22-11369152*u^16*v^21+81546560*u^16*v^20-662447616*u^16*v^19+3165997312*u^16*v^18-8379438656*u^16*v^17+21660646080*u^16*v^16-8789692672*u^16*v^15-104723894272*u^16*v^14+127784961024*u^16*v^13-580595865600*u^16*v^12-128372477952*u^16*v^11+1208934445056*u^16*v^10-594241142784*u^16*v^9+2488695742464*u^16*v^8+1576154136576*u^16*v^7-3551103123456*u^16*v^6-93004627968*u^16*v^5-1666593718272*u^16*v^4-1469515825152*u^16*v^3+909013155840*u^16*v^2+364256428032*u^16*v-2048*u^15*v^23+446144*u^15*v^22-4704320*u^15*v^21+41351936*u^15*v^20-303202688*u^15*v^19+903657984*u^15*v^18-3183874304*u^15*v^17+5797531968*u^15*v^16+17934835648*u^15*v^15+10147173376*u^15*v^14+163962882560*u^15*v^13+1476974592*u^15*v^12-280649263104*u^15*v^11-186861858816*u^15*v^10-1193155633152*u^15*v^9-464472563712*u^15*v^8+1483761868800*u^15*v^7+926630117376*u^15*v^6+1396055900160*u^15*v^5+821045624832*u^15*v^4-911996485632*u^15*v^3-680029323264*u^15*v^2-37243846656*u^15*v-7872*u^14*v^23+201536*u^14*v^22-1263552*u^14*v^21+22764992*u^14*v^20-50363264*u^14*v^19+391002880*u^14*v^18-892049600*u^14*v^17-2235016512*u^14*v^16-7800489536*u^14*v^15-38187017152*u^14*v^14-15902543104*u^14*v^13+28600385280*u^14*v^12+115222081536*u^14*v^11+438972324864*u^14*v^10+254589499392*u^14*v^9-353183127552*u^14*v^8-571285020672*u^14*v^7-886835109888*u^14*v^6-510446370816*u^14*v^5+497850679296*u^14*v^4+570325598208*u^14*v^3+82237980672*u^14*v^2-10956570624*u^14*v-4864*u^13*v^23-5312*u^13*v^22-1212992*u^13*v^21-71744*u^13*v^20-39517504*u^13*v^19+49957184*u^13*v^18+104653120*u^13*v^17+1423405184*u^13*v^16+6398062464*u^13*v^15+7460222784*u^13*v^14+6636401088*u^13*v^13-22754256640*u^13*v^12-109114461440*u^13*v^11-108234356736*u^13*v^10+8686848000*u^13*v^9+169000433664*u^13*v^8+367646681088*u^13*v^7+263791632384*u^13*v^6-146235580416*u^13*v^5-285935173632*u^13*v^4-77659471872*u^13*v^3+19110297600*u^13*v^2-382205952*u^13*v+960*u^12*v^23+32832*u^12*v^22+161792*u^12*v^21+2700160*u^12*v^20+2098048*u^12*v^19+15104640*u^12*v^18-115166016*u^12*v^17-661111872*u^12*v^16-1507243328*u^12*v^15-3005409728*u^12*v^14+1019880256*u^12*v^13+16404099008*u^12*v^12+27610529280*u^12*v^11+21493252608*u^12*v^10-23583372288*u^12*v^9-96424607232*u^12*v^8-94389184512*u^12*v^7+13561509888*u^12*v^6+96093609984*u^12*v^5+41140224000*u^12*v^4-14284947456*u^12*v^3+573308928*u^12*v^2-5760*u^11*v^22-86144*u^11*v^21-391680*u^11*v^20-2538752*u^11*v^19+1696320*u^11*v^18+31017792*u^11*v^17+155736192*u^11*v^16+487861248*u^11*v^15+368073856*u^11*v^14-1118403200*u^11*v^13-4139854784*u^11*v^12-6721273664*u^11*v^11-279917568*u^11*v^10+15110684928*u^11*v^9+22798407168*u^11*v^8+5622428160*u^11*v^7-22824695808*u^11*v^6-13409556480*u^11*v^5+5932154880*u^11*v^4-358318080*u^11*v^3+13440*u^10*v^21+113536*u^10*v^20+330560*u^10*v^19+474176*u^10*v^18-7090624*u^10*v^17-36916288*u^10*v^16-72345856*u^10*v^15-41430144*u^10*v^14+331577536*u^10*v^13+960289856*u^10*v^12+676633792*u^10*v^11-1116438720*u^10*v^10-3716339328*u^10*v^9-2344090752*u^10*v^8+3865729536*u^10*v^7+2758800384*u^10*v^6-1478062080*u^10*v^5+119439360*u^10*v^4-15360*u^9*v^20-79104*u^9*v^19-14528*u^9*v^18+828352*u^9*v^17+5232192*u^9*v^16+11950400*u^9*v^15-7487936*u^9*v^14-63259072*u^9*v^13-114258880*u^9*v^12-26196672*u^9*v^11+399022464*u^9*v^10+397115136*u^9*v^9-448509312*u^9*v^8-350241408*u^9*v^7+220962816*u^9*v^6-22394880*u^9*v^5+8640*u^8*v^19+27200*u^8*v^18-117888*u^8*v^17-541440*u^8*v^16-761856*u^8*v^15+622336*u^8*v^14+8877696*u^8*v^13+10654848*u^8*v^12-25884864*u^8*v^11-33765696*u^8*v^10+31891968*u^8*v^9+25100928*u^8*v^8-18351360*u^8*v^7+2239488*u^8*v^6-1920*u^7*v^18-3456*u^7*v^17+44928*u^7*v^16+91008*u^7*v^15-284928*u^7*v^14-546048*u^7*v^13+776448*u^7*v^12+1181952*u^7*v^11-1040256*u^7*v^10-777600*u^7*v^9+653184*u^7*v^8-93312*u^7*v^7);

g=(-253671505920*u^31*v^9+988110913536*u^30*v^10-1229702823936*u^30*v^9+338228674560*u^30*v^8-1692351332352*u^29*v^11+4942366507008*u^29*v^10-3377253580800*u^29*v^9+1075889307648*u^29*v^8+1691143372800*u^29*v^7+1701713018880*u^28*v^12-8772202266624*u^28*v^11+10278662045696*u^28*v^10-8363844829184*u^28*v^9-3435705401344*u^28*v^8+8620804669440*u^28*v^7-4171486986240*u^28*v^6-1126176915456*u^27*v^13+9178781319168*u^27*v^12-16639659606016*u^27*v^11+20678287818752*u^27*v^10-2997132197888*u^27*v^9-21107885211648*u^27*v^8+21996138135552*u^27*v^7-16952235917312*u^27*v^6+2423972167680*u^27*v^5+519120617472*u^26*v^14-6351457615872*u^26*v^13+17080430624768*u^26*v^12-27565771194368*u^26*v^11+18641919672320*u^26*v^10+19548375875584*u^26*v^9-47679035932672*u^26*v^8+54750900912128*u^26*v^7-17818477133824*u^26*v^6+4563134316544*u^26*v^5+1014686023680*u^26*v^4-171475992576*u^25*v^15+3080226078720*u^25*v^14-12063912493056*u^25*v^13+23857490558976*u^25*v^12-29753910231040*u^25*v^11-3264221282304*u^25*v^10+51781975408640*u^25*v^9-86221065814016*u^25*v^8+63292114468864*u^25*v^7-15700521385984*u^25*v^6-17395557072896*u^25*v^5+10668698763264*u^25*v^4-1240171806720*u^25*v^3+40998666240*u^24*v^16-1079403872256*u^24*v^15+6126577385472*u^24*v^14-14707249905664*u^24*v^13+26979508158464*u^24*v^12-11707793539072*u^24*v^11-29275033960448*u^24*v^10+84905971154944*u^24*v^9-103700928397312*u^24*v^8+40014834565120*u^24*v^7+18741156904960*u^24*v^6-45301838643200*u^24*v^5+31040533954560*u^24*v^4-7336609447936*u^24*v^3+112742891520*u^24*v^2-7055216640*u^23*v^17+277017329664*u^23*v^16-2291566313472*u^23*v^15+6802082365440*u^23*v^14-16245052276736*u^23*v^13+15324776759296*u^23*v^12+5448763703296*u^23*v^11-54599025164288*u^23*v^10+98241966243840*u^23*v^9-67989550399488*u^23*v^8+8133762088960*u^23*v^7+73949337616384*u^23*v^6-73100041388032*u^23*v^5+32643362062336*u^23*v^4-9364639318016*u^23*v^3-242665652224*u^23*v^2+84557168640*u^23*v+853438464*u^22*v^18-52060409856*u^22*v^17+638197776384*u^22*v^16-2426871939072*u^22*v^15+6958816428032*u^22*v^14-10731389452288*u^22*v^13+4354935357440*u^22*v^12+21615135948800*u^22*v^11-61258497785856*u^22*v^10+70588520464384*u^22*v^9-32228578951168*u^22*v^8-54489713213440*u^22*v^7+88471913889792*u^22*v^6-73203321929728*u^22*v^5+24484333486080*u^22*v^4+9150696259584*u^22*v^3-5519569846272*u^22*v^2+832686784512*u^22*v-68963328*u^21*v^19+7066672128*u^21*v^18-132350333952*u^21*v^17+675040002048*u^21*v^16-2207895158784*u^21*v^15+5061152440320*u^21*v^14-4344942329856*u^21*v^13-3642917126144*u^21*v^12+26773613445120*u^21*v^11-46431755304960*u^21*v^10+35059732054016*u^21*v^9+12827213430784*u^21*v^8-69999666397184*u^21*v^7+83485112926208*u^21*v^6-38915616538624*u^21*v^5-3227667922944*u^21*v^4+19657394225152*u^21*v^3-14842266124288*u^21*v^2+2886419349504*u^21*v+3345408*u^20*v^20-671468544*u^20*v^19+20216690688*u^20*v^18-145924807680*u^20*v^17+533867704320*u^20*v^16-1708719132672*u^20*v^15+2140940419072*u^20*v^14-1127017512960*u^20*v^13-8153365610496*u^20*v^12+20264335441920*u^20*v^11-23897640534016*u^20*v^10+8610170011648*u^20*v^9+36593328979968*u^20*v^8-55726780186624*u^20*v^7+45158829654016*u^20*v^6-10062496006144*u^20*v^5-26779406303232*u^20*v^4+22805638807552*u^20*v^3-11680230670336*u^20*v^2+3829030453248*u^20*v-73728*u^19*v^21+42068736*u^19*v^20-2219130368*u^19*v^19+24152580608*u^19*v^18-100680704768*u^19*v^17+420908654592*u^19*v^16-736732581888*u^19*v^15+953287802880*u^19*v^14+1470982512640*u^19*v^13-6090643472384*u^19*v^12+11361477328896*u^19*v^11-8894275387392*u^19*v^10-10836084260864*u^19*v^9+24784345759744*u^19*v^8-35343216672768*u^19*v^7+12390125010944*u^19*v^6+16437437530112*u^19*v^5-18558167810048*u^19*v^4+19011890839552*u^19*v^3-4172795609088*u^19*v^2+695130390528*u^19*v-1542912*u^18*v^21+167203072*u^18*v^20-2979105536*u^18*v^19+15068172032*u^18*v^18-75695678976*u^18*v^17+191857910784*u^18*v^16-320857096192*u^18*v^15+15209435136*u^18*v^14+1311573430272*u^18*v^13-3752527970304*u^18*v^12+4156001746944*u^18*v^11+409935937536*u^18*v^10-8292870651904*u^18*v^9+17752187731968*u^18*v^8-8344514330624*u^18*v^7-3500872302592*u^18*v^6+12071054868480*u^18*v^5-15703105077248*u^18*v^4+2096111812608*u^18*v^3-1634067283968*u^18*v^2-1399421140992*u^18*v+24576*u^17*v^22-7941440*u^17*v^21+262223936*u^17*v^20-1795433600*u^17*v^19+9832186688*u^17*v^18-38195000768*u^17*v^17+67642249216*u^17*v^16-103341989888*u^17*v^15-212809252864*u^17*v^14+813404645376*u^17*v^13-1367608983552*u^17*v^12+1012488028160*u^17*v^11+2152465367040*u^17*v^10-5628109848576*u^17*v^9+4727728766976*u^17*v^8-826894712832*u^17*v^7-6136376852480*u^17*v^6+7532487114752*u^17*v^5-2053820645376*u^17*v^4+647667646464*u^17*v^3+1993171009536*u^17*v^2-73496788992*u^17*v+198720*u^16*v^22-15332544*u^16*v^21+166033216*u^16*v^20-907202304*u^16*v^19+5664061696*u^16*v^18-10051504576*u^16*v^17+34244757248*u^16*v^16+25293858304*u^16*v^15-99014192128*u^16*v^14+361348970496*u^16*v^13-407182233600*u^16*v^12-305932111872*u^16*v^11+1154293514240*u^16*v^10-2201592070144*u^16*v^9+399013052416*u^16*v^8+1659945091072*u^16*v^7-2709385641984*u^16*v^6+2038996402176*u^16*v^5+943435284480*u^16*v^4-664632557568*u^16*v^3+576196706304*u^16*v^2+270771683328*u^16*v-1536*u^15*v^23+521104*u^15*v^22-11122160*u^15*v^21+59050672*u^15*v^20-593645968*u^15*v^19+1177031936*u^15*v^18-6109288640*u^15*v^17-704543488*u^15*v^16+2844790784*u^15*v^15-74031232000*u^15*v^14+73062756864*u^15*v^13-56133091328*u^15*v^12-208986144768*u^15*v^11+684103335936*u^15*v^10+63825752064*u^15*v^9+166163054592*u^15*v^8+1205092810752*u^15*v^7-943857598464*u^15*v^6-1096474558464*u^15*v^5-499217596416*u^15*v^4-1035240210432*u^15*v^3-627836977152*u^15*v^2-56056872960*u^15*v-7440*u^14*v^23+471488*u^14*v^22-2830576*u^14*v^21+40134560*u^14*v^20-122636944*u^14*v^19+625169952*u^14*v^18-688839024*u^14*v^17+480807296*u^14*v^16+9443703296*u^14*v^15-6656759552*u^14*v^14+43620437504*u^14*v^13+60743914496*u^14*v^12-101678772224*u^14*v^11-35855253504*u^14*v^10-295650459648*u^14*v^9-610879242240*u^14*v^8+75507499008*u^14*v^7+427335745536*u^14*v^6+549732483072*u^14*v^5+900293197824*u^14*v^4+659347734528*u^14*v^3+125363552256*u^14*v^2-3057647616*u^14*v-9296*u^13*v^23+108808*u^13*v^22-1427552*u^13*v^21+11111776*u^13*v^20-28586304*u^13*v^19+198803480*u^13*v^18+122299696*u^13*v^17-130232960*u^13*v^16+953500608*u^13*v^15-10611005312*u^13*v^14-17988958080*u^13*v^13-9145614336*u^13*v^12-14115142656*u^13*v^11+97731572736*u^13*v^10+224249392128*u^13*v^9+121934020608*u^13*v^8-18801672192*u^13*v^7-216996544512*u^13*v^6-456922791936*u^13*v^5-413759176704*u^13*v^4-124599140352*u^13*v^3+6115295232*u^13*v^2-2712*u^12*v^23+7944*u^12*v^22-695776*u^12*v^21-700752*u^12*v^20-27386568*u^12*v^19-52964216*u^12*v^18-195089392*u^12*v^17-372789952*u^12*v^16+1099665328*u^12*v^15+3155557504*u^12*v^14+7282699392*u^12*v^13+11267258624*u^12*v^12-12175540736*u^12*v^11-49717386240*u^12*v^10-63962127360*u^12*v^9-46115758080*u^12*v^8+34568626176*u^12*v^7+143352889344*u^12*v^6+172138659840*u^12*v^5+72236924928*u^12*v^4-5350883328*u^12*v^3+680*u^11*v^23+20376*u^11*v^22+131904*u^11*v^21+1972128*u^11*v^20+6950296*u^11*v^19+35601992*u^11*v^18+82202304*u^11*v^17+28797760*u^11*v^16-220245376*u^11*v^15-1409603840*u^11*v^14-2974720896*u^11*v^13-1054870528*u^11*v^12+5452555264*u^11*v^11+15640398336*u^11*v^10+19716786432*u^11*v^9+4041805824*u^11*v^8-27050913792*u^11*v^7-49700044800*u^11*v^6-26921631744*u^11*v^5+2675441664*u^11*v^4-3880*u^10*v^22-59512*u^10*v^21-405456*u^10*v^20-2820864*u^10*v^19-9100744*u^10*v^18-20325544*u^10*v^17-16338144*u^10*v^16+117633520*u^10*v^15+394945696*u^10*v^14+586858160*u^10*v^13+67887488*u^10*v^12-2053784832*u^10*v^11-4030393344*u^10*v^10-3180957696*u^10*v^9+2448119808*u^10*v^8+10100256768*u^10*v^7+6688604160*u^10*v^6-836075520*u^10*v^5+8520*u^9*v^21+88968*u^9*v^20+483792*u^9*v^19+2059864*u^9*v^18+4121544*u^9*v^17-429208*u^9*v^16-24145616*u^9*v^15-84219720*u^9*v^14-96475792*u^9*v^13+106727616*u^9*v^12+446695488*u^9*v^11+718143552*u^9*v^10+91416384*u^9*v^9-1428129792*u^9*v^8-1107800064*u^9*v^7+167215104*u^9*v^6-9080*u^8*v^20-72912*u^8*v^19-261624*u^8*v^18-615696*u^8*v^17+80376*u^8*v^16+5168576*u^8*v^15+10905976*u^8*v^14+6971280*u^8*v^13-22456704*u^8*v^12-87418800*u^8*v^11-48871296*u^8*v^10+134519616*u^8*v^9+117946368*u^8*v^8-20901888*u^8*v^7+4720*u^7*v^19+31360*u^7*v^18+51584*u^7*v^17-52864*u^7*v^16-434592*u^7*v^15-1265664*u^7*v^14-108864*u^7*v^13+5800320*u^7*v^12+4904496*u^7*v^11-7620480*u^7*v^10-7324992*u^7*v^9+1492992*u^7*v^8-960*u^6*v^18-5568*u^6*v^17+1152*u^6*v^16+51840*u^6*v^15+41472*u^6*v^14-165888*u^6*v^13-176256*u^6*v^12+196992*u^6*v^11+202176*u^6*v^10-46656*u^6*v^9);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);

f=(1321205760*u^19*v^6-2503999488*u^18*v^7+1560281088*u^18*v^6-3963617280*u^18*v^5+2072248320*u^17*v^8-3530555392*u^17*v^7+7234125824*u^17*v^6-4680843264*u^17*v^5+3523215360*u^17*v^4-977928192*u^16*v^9+3512729600*u^16*v^8-6074138624*u^16*v^7+10594811904*u^16*v^6-5917114368*u^16*v^5+2986344448*u^16*v^4+287784960*u^15*v^10-2017263616*u^15*v^9+3279355904*u^15*v^8-10300686336*u^15*v^7+5712904192*u^15*v^6-7529824256*u^15*v^5-1516240896*u^15*v^4+3523215360*u^15*v^3-1321205760*u^15*v^2-54067200*u^14*v^11+736722944*u^14*v^10-1357594624*u^14*v^9+5635571712*u^14*v^8-4694540288*u^14*v^7+7224164352*u^14*v^6+610009088*u^14*v^5-4949278720*u^14*v^4+5270142976*u^14*v^3-5083496448*u^14*v^2+440401920*u^14*v+6331392*u^13*v^12-177344512*u^13*v^11+463032320*u^13*v^10-1904050176*u^13*v^9+3089055744*u^13*v^8-3478781952*u^13*v^7+2128543744*u^13*v^6+3823632384*u^13*v^5-6292242432*u^13*v^4+7036993536*u^13*v^3-3469737984*u^13*v^2+1694498816*u^13*v-422400*u^12*v^13+28110848*u^12*v^12-125731840*u^12*v^11+410664960*u^12*v^10-1423110144*u^12*v^9+895352832*u^12*v^8-2709307392*u^12*v^7-2362703872*u^12*v^6+3254976512*u^12*v^5-4677697536*u^12*v^4+5682495488*u^12*v^3-897581056*u^12*v^2+902823936*u^12*v+12288*u^11*v^14-2824960*u^11*v^13+25154816*u^11*v^12-57538560*u^11*v^11+434789376*u^11*v^10-132808704*u^11*v^9+1455697920*u^11*v^8+1008828416*u^11*v^7-726188032*u^11*v^6+2192572416*u^11*v^5-4213374976*u^11*v^4-407371776*u^11*v^3-1553727488*u^11*v^2-724566016*u^11*v+162944*u^10*v^14-3438976*u^10*v^13+5781504*u^10*v^12-85494528*u^10*v^11+28557312*u^10*v^10-416338944*u^10*v^9-175243264*u^10*v^8+112013312*u^10*v^7-674758656*u^10*v^6+1809727488*u^10*v^5+217055232*u^10*v^4+758448128*u^10*v^3+647495680*u^10*v^2-157548544*u^10*v-4096*u^9*v^15+295616*u^9*v^14-597888*u^9*v^13+10172352*u^9*v^12-12615168*u^9*v^11+57808128*u^9*v^10-55207936*u^9*v^9-115440640*u^9*v^8-860160*u^9*v^7-608391168*u^9*v^6+104693760*u^9*v^5+136691712*u^9*v^4+138543104*u^9*v^3+495779840*u^9*v^2+177733632*u^9*v-13920*u^8*v^15+72384*u^8*v^14-603936*u^8*v^13+3583488*u^8*v^12+153024*u^8*v^11+39947264*u^8*v^10+77412608*u^8*v^9+112336896*u^8*v^8+232522752*u^8*v^7-51953664*u^8*v^6-267030528*u^8*v^5-427294720*u^8*v^4-584728576*u^8*v^3-323223552*u^8*v^2-31260672*u^8*v+256*u^7*v^16-6096*u^7*v^15+1296*u^7*v^14-547888*u^7*v^13-1335312*u^7*v^12-10429312*u^7*v^11-25314688*u^7*v^10-52955136*u^7*v^9-88365312*u^7*v^8-19138560*u^7*v^7+99714048*u^7*v^6+247267328*u^7*v^5+362663936*u^7*v^4+257851392*u^7*v^3+54558720*u^7*v^2-1769472*u^7*v+216*u^6*v^16+1544*u^6*v^15+43208*u^6*v^14+196200*u^6*v^13+1456256*u^6*v^12+4579568*u^6*v^11+12546816*u^6*v^10+23996544*u^6*v^9+18038784*u^6*v^8-11467008*u^6*v^7-71680000*u^6*v^6-132803584*u^6*v^5-118063104*u^6*v^4-40808448*u^6*v^3+2654208*u^6*v^2-40*u^5*v^16-1392*u^5*v^15-11408*u^5*v^14-107904*u^5*v^13-460328*u^5*v^12-1691856*u^5*v^11-4069152*u^5*v^10-5363328*u^5*v^9-2342592*u^5*v^8+11056640*u^5*v^7+29601536*u^5*v^6+34007040*u^5*v^5+16957440*u^5*v^4-1658880*u^5*v^3+200*u^4*v^15+3344*u^4*v^14+22784*u^4*v^13+123888*u^4*v^12+397752*u^4*v^11+817600*u^4*v^10+934272*u^4*v^9-656896*u^4*v^8-3870400*u^4*v^7-6325248*u^4*v^6-4227840*u^4*v^5+552960*u^4*v^4-360*u^3*v^14-3840*u^3*v^13-19184*u^3*v^12-64880*u^3*v^11-120408*u^3*v^10-51280*u^3*v^9+251504*u^3*v^8+743808*u^3*v^7+632448*u^3*v^6-103680*u^3*v^5+280*u^2*v^13+2136*u^2*v^12+6392*u^2*v^11+10248*u^2*v^10-2464*u^2*v^9-50688*u^2*v^8-52560*u^2*v^7+10368*u^2*v^6-80*u*v^12-464*u*v^11-384*u*v^10+1536*u*v^9+1872*u*v^8-432*u*v^7);

g=(253671505920*u^31*v^9-338228674560*u^31*v^8-861275160576*u^30*v^10+1532498018304*u^30*v^9-568546295808*u^30*v^8+1261713752064*u^29*v^11-2927489974272*u^29*v^10+2631003013120*u^29*v^9+801548271616*u^29*v^8-1691143372800*u^29*v^7+2142114938880*u^29*v^6-1070856142848*u^28*v^12+3133950394368*u^28*v^11-4012740968448*u^28*v^10-3320680808448*u^28*v^9+2971312062464*u^28*v^8-7221987508224*u^28*v^7+5930812964864*u^28*v^6-2705829396480*u^28*v^5+590748844032*u^27*v^13-2102478766080*u^27*v^12+2528527777792*u^27*v^11+6821179817984*u^27*v^10-4586035216384*u^27*v^9+13282186362880*u^27*v^8-13315472359424*u^27*v^7-1543503872000*u^27*v^6-4266513137664*u^27*v^5+338228674560*u^27*v^4-223746195456*u^26*v^14+925504634880*u^26*v^13+48003809280*u^26*v^12-8958798462976*u^26*v^11+9658114768896*u^26*v^10-15985247518720*u^26*v^9+14931453804544*u^26*v^8+10694602784768*u^26*v^7+1615444574208*u^26*v^6+16551730216960*u^26*v^5-2588254666752*u^26*v^4+901943132160*u^26*v^3+59602894848*u^25*v^15-266463608832*u^25*v^14-1254630096896*u^25*v^13+8266654416896*u^25*v^12-14141959962624*u^25*v^11+14901485502464*u^25*v^10-16381261119488*u^25*v^9-18976876789760*u^25*v^8+19459288858624*u^25*v^7-32444317171712*u^25*v^6+17556349911040*u^25*v^5-11800959516672*u^25*v^4+4259533815808*u^25*v^3-338228674560*u^25*v^2-11197218816*u^24*v^16+45878870016*u^24*v^15+1038155513856*u^24*v^14-5606149718016*u^24*v^13+13022525390848*u^24*v^12-12564123615232*u^24*v^11+18729175875584*u^24*v^10+21587193495552*u^24*v^9-37290063691776*u^24*v^8+35466799742976*u^24*v^7-49655660412928*u^24*v^6+10283628101632*u^24*v^5-3762659786752*u^24*v^4+114890375168*u^24*v^3-1245003644928*u^24*v^2+1456607232*u^23*v^17-2571485184*u^23*v^16-482377924608*u^23*v^15+2857950248960*u^23*v^14-8084003880960*u^23*v^13+9491619774464*u^23*v^12-16591715565568*u^23*v^11-14587562819584*u^23*v^10+35418321977344*u^23*v^9-35507832619008*u^23*v^8+68323366666240*u^23*v^7+2263011557376*u^23*v^6+3273939484672*u^23*v^5+9721121603584*u^23*v^4-15532212355072*u^23*v^3+2144799293440*u^23*v^2-84557168640*u^23*v-125134848*u^22*v^18-803450880*u^22*v^17+149620826112*u^22*v^16-1106198790144*u^22*v^15+3599219359744*u^22*v^14-5772367495168*u^22*v^13+10523813347328*u^22*v^12+4199753449472*u^22*v^11-22942362632192*u^22*v^10+29339768848384*u^22*v^9-58374911688704*u^22*v^8+2141267689472*u^22*v^7+3504693313536*u^22*v^6-23256107057152*u^22*v^5+32341640609792*u^22*v^4-7398215385088*u^22*v^3+9846883614720*u^22*v^2-579015278592*u^22*v+6395904*u^21*v^19+230691840*u^21*v^18-32547154944*u^21*v^17+325562966016*u^21*v^16-1202181439488*u^21*v^15+2640436019200*u^21*v^14-4961491714048*u^21*v^13+1381394284544*u^21*v^12+11404009013248*u^21*v^11-16157114368000*u^21*v^10+37376779878400*u^21*v^9-13971897712640*u^21*v^8-14474253697024*u^21*v^7+17548720472064*u^21*v^6-37081380290560*u^21*v^5+17993731932160*u^21*v^4-9471275302912*u^21*v^3+2490074398720*u^21*v^2-1149373513728*u^21*v-147456*u^20*v^20-28417536*u^20*v^19+5008082432*u^20*v^18-72423565312*u^20*v^17+311174369280*u^20*v^16-889128222720*u^20*v^15+1832530288640*u^20*v^14-1908387217408*u^20*v^13-4317298950144*u^20*v^12+5319698415616*u^20*v^11-19873274527744*u^20*v^10+14574605565952*u^20*v^9+15227116584960*u^20*v^8-1876189773824*u^20*v^7+35112114716672*u^20*v^6-19847287144448*u^20*v^5-2829561364480*u^20*v^4-9565563256832*u^20*v^3-3989923954688*u^20*v^2-380909912064*u^20*v+1817088*u^19*v^20-535229184*u^19*v^19+12005168640*u^19*v^18-63701669120*u^19*v^17+219559084032*u^19*v^16-548150816768*u^19*v^15+923002773504*u^19*v^14+1108497735680*u^19*v^13-860145106944*u^19*v^12+8556362727424*u^19*v^11-8101146394624*u^19*v^10-7806878744576*u^19*v^9-4443040907264*u^19*v^8-25165933051904*u^19*v^7+12283438694400*u^19*v^6+8036317921280*u^19*v^5+11991636770816*u^19*v^4+10267387756544*u^19*v^3+2048498073600*u^19*v^2+447599345664*u^19*v-49152*u^18*v^21+37804160*u^18*v^20-1445184512*u^18*v^19+10356483712*u^18*v^18-39749042944*u^18*v^17+132599011328*u^18*v^16-274704332800*u^18*v^15-131639844864*u^18*v^14-17530994688*u^18*v^13-2700723314688*u^18*v^12+3186834341888*u^18*v^11+2237214490624*u^18*v^10+2941250437120*u^18*v^9+11755556175872*u^18*v^8-6597653823488*u^18*v^7-6067799982080*u^18*v^6-7047028408320*u^18*v^5-8158934204416*u^18*v^4-945555505152*u^18*v^3+467404849152*u^18*v^2+56623104000*u^18*v-1584000*u^17*v^21+120889792*u^17*v^20-1313927232*u^17*v^19+5288992576*u^17*v^18-25087129408*u^17*v^17+57181577728*u^17*v^16-21073244160*u^17*v^15+34646571008*u^17*v^14+547575441408*u^17*v^13-1098580992000*u^17*v^12-510853529600*u^17*v^11-1097798008832*u^17*v^10-3266753003520*u^17*v^9+4348878520320*u^17*v^8+4234422255616*u^17*v^7+2881837596672*u^17*v^6+2589304815616*u^17*v^5-2496323911680*u^17*v^4-3080082948096*u^17*v^3-826697318400*u^17*v^2-96372523008*u^17*v+29696*u^16*v^22-6496928*u^16*v^21+124577376*u^16*v^20-525110240*u^16*v^19+3515682848*u^16*v^18-9087123712*u^16*v^17+12035075840*u^16*v^16-7994265088*u^16*v^15-50847689728*u^16*v^14+352647739392*u^16*v^13+221298569216*u^16*v^12+462694711296*u^16*v^11+515652935680*u^16*v^10-2545278320640*u^16*v^9-2990229291008*u^16*v^8-1795846045696*u^16*v^7-192462716928*u^16*v^6+3691964792832*u^16*v^5+4425265446912*u^16*v^4+1764451418112*u^16*v^3+294440140800*u^16*v^2+18345885696*u^16*v+191712*u^15*v^22-8186656*u^15*v^21+40617376*u^15*v^20-338000672*u^15*v^19+1205289792*u^15*v^18-2199298368*u^15*v^17+2193622464*u^15*v^16-4015640576*u^15*v^15-92496171520*u^15*v^14-108106856960*u^15*v^13-225411792896*u^15*v^12-99435282432*u^15*v^11+993772265472*u^15*v^10+1571929411584*u^15*v^9+1334236053504*u^15*v^8+190514528256*u^15*v^7-2319617359872*u^15*v^6-3364463443968*u^15*v^5-1801464053760*u^15*v^4-392766160896*u^15*v^3-36691771392*u^15*v^2+1019215872*u^15*v-2048*u^14*v^23+326592*u^14*v^22-2568416*u^14*v^21+19416448*u^14*v^20-138032288*u^14*v^19+163189856*u^14*v^18-735953280*u^14*v^17+1467549152*u^14*v^16+16933117824*u^14*v^15+33462290432*u^14*v^14+82863021056*u^14*v^13+57205792768*u^14*v^12-231932717056*u^14*v^11-542974654464*u^14*v^10-679286427648*u^14*v^9-314418806784*u^14*v^8+806996606976*u^14*v^7+1598530977792*u^14*v^6+1109979168768*u^14*v^5+303740485632*u^14*v^4+32105299968*u^14*v^3-2038431744*u^14*v^2-5824*u^13*v^23+123328*u^13*v^22-417440*u^13*v^21+12437344*u^13*v^20+6077792*u^13*v^19+165699680*u^13*v^18-44296768*u^13*v^17-1824198848*u^13*v^16-6131525568*u^13*v^15-19812292160*u^13*v^14-23387143808*u^13*v^13+24815584768*u^13*v^12+118191550464*u^13*v^11+219971392512*u^13*v^10+180860789760*u^13*v^9-146460966912*u^13*v^8-503000580096*u^13*v^7-453140545536*u^13*v^6-151602167808*u^13*v^5-16052649984*u^13*v^4+1783627776*u^13*v^3-3136*u^12*v^23-13760*u^12*v^22-725984*u^12*v^21-2091232*u^12*v^20-21642176*u^12*v^19-28243648*u^12*v^18+58777088*u^12*v^17+616818304*u^12*v^16+2952887520*u^12*v^15+5376193888*u^12*v^14+1847080832*u^12*v^13-14664695552*u^12*v^12-45487442944*u^12*v^11-56722045440*u^12*v^10+2472652800*u^12*v^9+105906438144*u^12*v^8+127761629184*u^12*v^7+51211173888*u^12*v^6+5016453120*u^12*v^5-891813888*u^12*v^4+640*u^11*v^23+19552*u^11*v^22+144000*u^11*v^21+1521632*u^11*v^20+4535680*u^11*v^19+10509632*u^11*v^18-21165600*u^11*v^17-250519168*u^11*v^16-715251680*u^11*v^15-1005672640*u^11*v^14+562511104*u^11*v^13+5779394624*u^11*v^12+10892192000*u^11*v^11+5472494592*u^11*v^10-14441879808*u^11*v^9-25181134848*u^11*v^8-11886981120*u^11*v^7-1003290624*u^11*v^6+278691840*u^11*v^5-3200*u^10*v^22-45024*u^10*v^21-276352*u^10*v^20-1335584*u^10*v^19-1804672*u^10*v^18+8135168*u^10*v^17+51881216*u^10*v^16+141735360*u^10*v^15+107152864*u^10*v^14-376839104*u^10*v^13-1296354656*u^10*v^12-1391491968*u^10*v^11+1137236352*u^10*v^10+3426451200*u^10*v^9+1875585024*u^10*v^8+125411328*u^10*v^7-55738368*u^10*v^6+5760*u^9*v^21+49120*u^9*v^20+190016*u^9*v^19+329888*u^9*v^18-1484576*u^9*v^17-9032896*u^9*v^16-16968544*u^9*v^15-76224*u^9*v^14+89846272*u^9*v^13+172196736*u^9*v^12-30321792*u^9*v^11-308212992*u^9*v^10-192794688*u^9*v^9-8957952*u^9*v^8+6967296*u^9*v^7-4480*u^8*v^20-25696*u^8*v^19-23232*u^8*v^18+164736*u^8*v^17+915104*u^8*v^16+1653792*u^8*v^15-2981824*u^8*v^14-11301120*u^8*v^13-2135328*u^8*v^12+16559424*u^8*v^11+11670912*u^8*v^10+279936*u^8*v^9-497664*u^8*v^8+1280*u^7*v^19+5184*u^7*v^18-14848*u^7*v^17-75968*u^7*v^16+20544*u^7*v^15+315840*u^7*v^14+141120*u^7*v^13-403776*u^7*v^12-316224*u^7*v^11+15552*u^7*v^9);

gcd(f, g);
gg=_;
"teilt gcd f ?",f-(f/gg)*gg;
"teilt gcd g ?",g-(g/gg)*gg;
"gcd(f/gg,g/gg)=",gcd(f/gg,g/gg);
tst_status(1);$
