%define name shorewall-init
%define version 4.4.26
%define release 0base

Summary: Shorewall-init adds functionality to Shoreline Firewall (Shorewall).
Name: %{name}
Version: %{version}
Release: %{release}
License: GPLv2
Packager: Tom Eastep <teastep@shorewall.net>
Group: Networking/Utilities
Source: %{name}-%{version}.tgz
URL: http://www.shorewall.net/
BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: shoreline_firewall >= 4.4.10

%description

The Shoreline Firewall, more commonly known as "Shorewall", is a Netfilter
(iptables) based firewall that can be used on a dedicated firewall system,
a multi-function gateway/ router/server or on a standalone GNU/Linux system.

Shorewall Init is a companion product to Shorewall that allows for tigher
control of connections during boot and that integrates Shorewall with
ifup/ifdown and NetworkManager.

%prep

%setup

%build

%install
export DESTDIR=$RPM_BUILD_ROOT ; \
export OWNER=`id -n -u` ; \
export GROUP=`id -n -g` ;\
./install.sh

%clean
rm -rf $RPM_BUILD_ROOT

%post

if [ $1 -eq 1 ]; then
    if [ -x /sbin/insserv ]; then
	/sbin/insserv /etc/rc.d/shorewall-init
    elif [ -x /sbin/chkconfig ]; then
	/sbin/chkconfig --add shorewall-init;
    fi
fi

if [ -f /etc/SuSE-release ]; then
    cp -pf /usr/share/shorewall-init/ifupdown /etc/sysconfig/network/if-up.d/shorewall
    cp -pf /usr/share/shorewall-init/ifupdown /etc/sysconfig/network/if-down.d/shorewall
    if [ -d /etc/ppp ]; then
	for directory in ip-up.d ip-down.d ipv6-up.d ipv6-down.d; do
	    mkdir -p /etc/ppp/$directory
	    cp -pf /usr/share/shorewall-init/ifupdown /etc/ppp/$directory/shorewall
	done
    fi
else
    if [ -f /sbin/ifup-local -o -f /sbin/ifdown-local ]; then
	if ! grep -q Shorewall /sbin/ifup-local || ! grep -q Shorewall /sbin/ifdown-local; then
	    echo "WARNING: /sbin/ifup-local and/or /sbin/ifdown-local already exist; ifup/ifdown events will not be handled" >&2
	else
	    cp -pf /usr/share/shorewall-init/ifupdown /sbin/ifup-local
	    cp -pf /usr/share/shorewall-init/ifupdown /sbin/ifdown-local
	fi
    else
	cp -pf /usr/share/shorewall-init/ifupdown /sbin/ifup-local
	cp -pf /usr/share/shorewall-init/ifupdown /sbin/ifdown-local
    fi

    if [ -d /etc/ppp ]; then
	if [ -f /etc/ppp/ip-up.local -o -f /etc/ppp/ip-down.local ]; then
	    if ! grep -q Shorewall-based /etc/ppp/ip-up.local || ! grep -q Shorewall-based /etc/ppp//ip-down.local; then
		echo "WARNING: /etc/ppp/ip-up.local and/or /etc/ppp/ip-down.local already exist; ppp devices will not be handled" >&2
	    fi
	else
	    cp -pf /usr/share/shorewall-init/ifupdown /etc/ppp/ip-up.local
	    cp -pf /usr/share/shorewall-init/ifupdown /etc/ppp/ip-down.local
	fi
    fi

    if [ -d /etc/NetworkManager/dispatcher.d/ ]; then
	cp -pf /usr/share/shorewall-init/ifupdown /etc/NetworkManager/dispatcher.d/01-shorewall
    fi
fi

%preun

if [ $1 -eq 0 ]; then
    if [ -x /sbin/insserv ]; then
	/sbin/insserv -r /etc/init.d/shorewall-init
    elif [ -x /sbin/chkconfig ]; then
	/sbin/chkconfig --del shorewall-init
    fi

    [ -f /sbin/ifup-local ]   && grep -q Shorewall /sbin/ifup-local   && rm -f /sbin/ifup-local
    [ -f /sbin/ifdown-local ] && grep -q Shorewall /sbin/ifdown-local && rm -f /sbin/ifdown-local

    [ -f /etc/ppp/ip-up.local ]   && grep -q Shorewall-based /etc/ppp/ip-up.local   && rm -f /etc/ppp/ip-up.local
    [ -f /etc/ppp/ip-down.local ] && grep -q Shorewall-based /etc/ppp/ip-down.local && rm -f /etc/ppp/ip-down.local

    rm -f /etc/NetworkManager/dispatcher.d/01-shorewall
fi

%files
%defattr(0644,root,root,0755)
%attr(0644,root,root) %config(noreplace) /etc/sysconfig/shorewall-init

%attr(0544,root,root) /etc/init.d/shorewall-init
%attr(0755,root,root) %dir /usr/share/shorewall-init

%attr(0644,root,root) /usr/share/shorewall-init/version
%attr(0544,root,root) /usr/share/shorewall-init/ifupdown

%doc COPYING changelog.txt releasenotes.txt

%changelog
* Tue Nov 29 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.26-0base
* Sun Nov 20 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.26-0RC1
* Sat Nov 19 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.26-0Beta4
* Thu Nov 17 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.26-0Beta3
* Sat Nov 12 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.26-0Beta2
* Wed Nov 02 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.26-0Beta1
* Sun Oct 30 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.25-1
* Thu Oct 27 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.25-0base
* Sun Oct 23 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.25-0RC1
* Sat Oct 22 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.25-0Beta4
* Tue Oct 18 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.25-0Beta3
* Tue Oct 11 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.25-0Beta2
* Tue Oct 04 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.25-0Beta1
* Sat Oct 01 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.24-0RC1
* Mon Sep 26 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.24-0Beta4
* Wed Sep 21 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.24-0Beta3
* Sun Sep 18 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.24-0Beta2
* Thu Sep 15 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.24-0Beta1
* Tue Sep 13 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.23-3
* Fri Sep 09 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.23-2
* Wed Sep 07 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.23-1
* Sat Sep 03 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.23-0base
* Fri Sep 02 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.23-0RC2
* Mon Aug 29 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.23-0RC1
* Sat Aug 27 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.23-0Beta4
* Sun Aug 21 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.23-0Beta3
* Wed Aug 17 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.23-0Beta2
* Fri Aug 05 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.23-0Beta1
* Wed Aug 03 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.22-2
* Tue Aug 02 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.22-1
* Sat Jul 30 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.22-0base
* Sat Jul 30 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.22-0RC2
* Fri Jul 22 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.22-0RC1
* Thu Jul 21 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.22-0Beta3
* Mon Jul 18 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.22-0Beta2
* Mon Jul 04 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.22-0Beta1
* Wed Jun 29 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.21-0base
* Thu Jun 23 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.21-0RC1
* Sun Jun 19 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.21-0Beta3
* Sat Jun 18 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.21-0Beta2
* Tue Jun 07 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.21-0Beta1
* Mon Jun 06 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.20-1
* Tue May 31 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.20-0base
* Fri May 27 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.20-0RC1
* Tue May 24 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.20-0Beta5
* Sun May 22 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.20-0Beta4
* Wed May 18 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.20-0Beta3
* Wed May 18 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.20-0Beta2
* Sat Apr 16 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.19-1
* Sat Apr 09 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.19-0base
* Sun Apr 03 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.19-0RC1
* Sun Apr 03 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.19-0Beta5
* Sat Apr 02 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.19-0Beta4
* Sat Mar 26 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.19-0Beta3
* Sat Mar 05 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.19-0Beta1
* Wed Mar 02 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.18-0base
* Mon Feb 28 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.18-0RC1
* Sun Feb 20 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.18-0Beta4
* Sat Feb 19 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.18-0Beta3
* Sun Feb 13 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.18-0Beta2
* Sat Feb 05 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.18-0Beta1
* Fri Feb 04 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.17-0base
* Sun Jan 30 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.17-0RC1
* Fri Jan 28 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.17-0Beta3
* Wed Jan 19 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.17-0Beta2
* Sat Jan 08 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.17-0Beta1
* Mon Jan 03 2011 Tom Eastep tom@shorewall.net
- Updated to 4.4.16-0base
* Thu Dec 30 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.16-0RC1
* Thu Dec 30 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.16-0Beta8
* Sun Dec 26 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.16-0Beta7
* Mon Dec 20 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.16-0Beta6
* Fri Dec 10 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.16-0Beta5
* Sat Dec 04 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.16-0Beta4
* Fri Dec 03 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.16-0Beta3
* Fri Dec 03 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.16-0Beta2
* Tue Nov 30 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.16-0Beta1
* Fri Nov 26 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.15-0base
* Mon Nov 22 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.15-0RC1
* Mon Nov 15 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.15-0Beta2
* Sat Oct 30 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.15-0Beta1
* Sat Oct 23 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.14-0base
* Wed Oct 06 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.14-0RC1
* Fri Oct 01 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.14-0Beta4
* Sun Sep 26 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.14-0Beta3
* Thu Sep 23 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.14-0Beta2
* Tue Sep 21 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.14-0Beta1
* Fri Sep 17 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.13-0RC1
* Fri Sep 17 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.13-0Beta6
* Mon Sep 13 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.13-0Beta5
* Sat Sep 04 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.13-0Beta4
* Mon Aug 30 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.13-0Beta3
* Wed Aug 25 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.13-0Beta2
* Wed Aug 18 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.13-0Beta1
* Sun Aug 15 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.12-0base
* Fri Aug 06 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.12-0RC1
* Sun Aug 01 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.12-0Beta4
* Sat Jul 31 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.12-0Beta3
* Sun Jul 25 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.12-0Beta2
* Wed Jul 21 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.12-0Beta1
* Fri Jul 09 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.11-0base
* Mon Jul 05 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.11-0RC1
* Sat Jul 03 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.11-0Beta3
* Thu Jul 01 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.11-0Beta2
* Sun Jun 06 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.11-0Beta1
* Sat Jun 05 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.10-0base
* Fri Jun 04 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.10-0RC2
* Thu May 27 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.10-0RC1
* Wed May 26 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.10-0Beta4
* Tue May 25 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.10-0Beta3
* Thu May 20 2010 Tom Eastep tom@shorewall.net
- Updated to 4.4.10-0Beta2
* Tue May 18 2010 Tom Eastep tom@shorewall.net
- Initial version



