
/****************************************************************************
**
** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
** All rights reserved.
** Contact: chuebsch@moliso.de
**
** This file is part of the ShelXle
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file COPYING included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**
****************************************************************************/
#ifndef WINDOW_H
#define WINDOW_H
#include <QtGui>
#include <QtNetwork>
#include <QtWebKit>
#include "chgl.h"
#include "highlighter.h"
#include "codeeditor.h"
#include "eacDlg.h"
#include "qpeakview.h"
#include "psewidget.h"
#include "dragdropatomsdlg.h"
#define PROGRAM_NAME "shelXle"
#include "historywidget.h"
#include "savehistorywidget.h"
#include "fourxle.h"

//struct Node {
//  int index;
//  unsigned char flag;
//  inline operator unsigned char (){return flag;}
//};
//

struct Node
{
  V3 vertex;
  char flag;

  inline operator char (){
    return flag;
  }
  inline operator V3(){
    return vertex;
  }
  friend inline double Distance( const Node& n1, const Node& n2 ){
    return Norm(n1.vertex-n2.vertex);
  }
};
//
class MyDockWidget;

class Window : public QMainWindow {
Q_OBJECT
public:
  Window();
  bool scroller;
  double map_radius; 
  FourXle *fxle;
//  QList<V3> orte;
//  QList<V3> normalen,nnn;
  QList<QColor> farben;
  int zoff,yoff,xoff;
  QList<int> sfac;
  QList<double> fvar;
  QMap<int,int> fvarCntr;
  bool isLabelInUse();
  private slots:
  void about();
  void addNewScatteringFactor(int oz);
  void addDissorderedMethyl();
  void addMethyl();
  void addMoreQPeaks();
  void autoHFix();
  void changeEditorFont();
  void changeElemetofLabel(const QString &pse);
  void changeElement();
  void changeIconSize();
  void changeIndexofLabel(const int i);
  void changeLabelFont();
//  void changeRange();
  void changeScalefactor();
  void changeSortierWeise(QAction* action);
  void changeSuffixofLabel(const QString &fix);
  void checkForUpdates();
//  void changeWeight();
  void clipboardDataChanged();
  void closeEvent(QCloseEvent *event);
  void controlMap();
  void complete();
  void configureBottomToolbar();
  void copySymmMate();
  void createCentroid();
  void decreaseEdtiorFont();
  void deleteAllH();
  void deleteAllQ();
  void deleteSelectedAtoms();
  void dispFromWave();
  void doMapsNow(bool b);
  int duplicates();
  void effuenf();
  void expandAll();
  void extraSettings();
  void exportCoordinates();
  bool fileSave();
  bool fileSaveAs();
  void fillCell();
  void findInStructure(const QString &info);
  void findNext();
  void findNext2();
  void findPrev();
  void findPrev2();
  void findResi(QString);
  void findText();
  void findText2();
  void fuse();
  void grossRC(const QString &text);
  void grow();
  void growQPeaks(bool qpg);
  void hideSearch();
  void hideSearch2();
  void hideToolz(bool b);
  void hintLhide();
  void increaseEdtiorFont();
  void infoKanalNews(const QString& s);
  void inheritLabels();
  bool insertAnis();
  void insertBind();
  void insertFree();
  void insertList6();
  void invert();
  inline int Intersect( double& vm, double& vp ){ return vm*vp <= 0.0 && (vm<0.0 || vp<0.0); }
  void isUpToDate(QNetworkReply* antwort);
  void jumpToAtom(int index);
  void jumpToError();
  void loadAFile();
  void loadFile(QString fileName);
  void loadLst();
  void loadrefres();
  void mapDefault();
  void moveSymmMate();
  void moveSymmMateSel();
  void openFile();
  void openMapControl();
  void openRecentFile();
  void openSaveHistory();
//  bool peakcomp(MyAtom &a1,MyAtom &a2);
  void redoRename();
  void removeExtra(QAbstractButton *button);
  void renameRNchanged(int ii);
  void renameThisAtom();
  void renameThisAtom(int index);
  void renamUpdate(bool vis);
  void replaceAll();
  void replaceNext();
  void replacePrev();
  void replyFinished(QNetworkReply* antwort);
  void resiSelectorCheck();
  void rotd(); 
  void rotl();   
  void rotr();   
  void rotu();   
  void rufmode();
  void runShelXL();
  void runExtra();
  void saveScene();
  void schnittart(int truc);
  void selectInStructure(const QString &info);
  void selectParts();
  void setShelxlPath();
  void setExtraPath();
  void showSearch();
  void showSearch2();
  void shxActUpdate(bool vis);
  void shxOPTUpdate(bool vis);
  void sina();
  void sortAtoms();
//  void springSlider();
  void  spellCheck();
  QString strippedName(const QString &fullFileName);
  void styleDialog();
  void symmetryManager();
  void toggDocWid(bool weg);
  void toggleOrtho(bool ov);
  void undoRename();
  void uniq();
  void updateLabel();
  void updateLC();
  void updateRecentFileActions();
  void updateScaleDlg();
  void updateSelectResi();
  void updateSM1();
  void updateSM2();
  void updateSM3(const QUrl link);
  void updateSM4(QString s);
  void updateStatusBar(const QString& s) ;  
  void updateTieFreeVar();
  void updateUnit();
  void updateWght();
  void updateXLput();
  void updateExtraOutput();
  void updateExtraSettings(int index);
  void wasDelete();
  void wasRename();
  void withdrawres();
  void zoomin(); 
  void zoomout();
protected:
  void paintEvent(QPaintEvent *event);
  void moveEvent(QMoveEvent *event);
  void dragEnterEvent(QDragEnterEvent *event);
  void dropEvent(QDropEvent *event);
private:
  int sortierWeise;
  QNetworkAccessManager *net;
  QNetworkReply *reply;
  V3 urs;
  QString altText;
  PSEWidget *psew;  
  QSpinBox *symmIntBx;
  QSpinBox *symmXBx;
  QSpinBox *symmYBx;
  QSpinBox *symmZBx;
  QSpinBox *symmFrgBx;
  QLineEdit *prosaSymm;
  QTimer prosaTimer;
  QTextBrowser *OrtepCodesbrowser;
  QLabel *shortestDistanceLabel;
  QPushButton *willpse;
  bool machPlatz,FehlerTeufel;
  int hhh;
//  QSlider *zoomer;
//  QTimer *sliderTimer;
  QSignalMapper *dsm;
  QProgressBar *balken;
  historyWidget *hw;
  double range,weight;
  int maptrunc,tbiconSize;
  QCompleter *completer;
  QString labelPSE,labelSuffix,nextLabel,title;
  int labelIndex;
  QLabel *nextNameL, *replacementInfo, *hintL;
  QCheckBox *rufModeBox;
  QSpinBox *resiNrSpin;
  QSpinBox *indexSpin;
  QSpinBox *partSpin;
  QSpinBox *spinSelectPart;
  QCheckBox *inculdePartNull, *wholeLine;
  QCheckBox *selectPart;
  QLabel *tieOccL;
  QComboBox *tieType;
  QLabel *tieFVNrL;
  QSpinBox *tieFVNr;
  QLabel *tieUsedL;
  QString FFTErrorString;
  QComboBox *sufixBox;
  QLineEdit *resiResiClass;
  QAction *enterRenameMode,*showQPeakLegend;
  QPeakView *qpv;
  CEnvironment undoAtom,redoAtom,deletedAtom,restoredAtom;
  QList<int> undoAtomIndex,redoAtomIndex,gehtMichAn,gehtMichAn2;
  int balkenstep,altursize;
  int mode;
  QMenu *recentFilesMenu,*stereoMenu,*moveMenu,*helpMenu,*sortMenu;
  QActionGroup *stereoGroup,*tubeGroup,*sortGroup;
  enum { MaxRecentFiles = 10 };
  QAction *recentFileActs[MaxRecentFiles];
  bool otherOpenFiles,doNotAnnoyMe;
  Molecule mole;
  QDockWidget *dock, *renamDock, *qPeakDock, *histDock;
  QComboBox *mapSchnitt;
  QDoubleSpinBox *maprad,*fomaps,*difmaps,*weak,*mapprec,*lineTrans,*lineWidth;
  QDialog *md;
  QSpinBox *widthBox;       
  QSpinBox *heightBox;      
  QDoubleSpinBox *scalefBox;
  QDialog *scalDlg;
  QTextBrowser *infoKanal;
  MyDockWidget *shxEditorDock,*shxOutputDock;
  chGL *chgl;
  QRadioButton *pserbt[110];
  QGroupBox *sfacBox;
  double scalePic;
  QString saveName,dirName,fvarinfo;
  QProcess *shelxl,*extraProc;
  QDialog *extraOutput;
  QTextEdit *extraOutPut;
  CodeEditor *editor , *xlPutor;
  QLineEdit *search2, *search, *replace;
  QString unitAlt,unitNeu,shelxlPath;
  QStringList extraProgramNames,extraProgramPaths,extraOptions,extraExt2;
  QList<Qt::CheckState>  extraArguments,extraExtensions, extraDetach;
  QLineEdit *extraPath,*extraName,*extraAltExtEdit,*extraArgumentsEdit;
  QDockWidget *helpDock;
  QWebView *hilfe;
  QWidget *shx_group;
  QVBoxLayout *sss;
  QHBoxLayout *nlt;
  QGroupBox *renameBox ;
  QVBoxLayout *rnla;    
  QLabel *nliL,*resiResiClassL,*resiNrSpinL,*partSpinL;         
  QHBoxLayout *sfacla;
  QScrollArea *qsa,*qsa2;
  QMenu *fileMenu, *editMenu, *dialogMenu, *viewMenu, *runMenu, *packMenu, *extraMenu;         
  QAction *zm_stereo, *pe_stereo, *xe_stereo, *an_stereo, *no_stereo; 




  QAction *soact;
  QAction *backColor,*labelColor;
  QVBoxLayout *lt;
  QToolButton  *zoomIn,*zoomOut;
  QLabel *sLabel;
  QCheckBox *qGrowPeak;
  QTimer *hidwillpse;
  QLabel *indexL,*sufixL;
  QLabel *scalwla, *scalhla, *scalsla, *header;
  QDialogButtonBox *buttonBoxMC; 
  QPushButton *applyMC;          
  QPushButton *applyDF;          
  QLabel *wl, *pl, *dl, *ol, *rl, *sl, *lw, *ltz;




  QHBoxLayout *indexla;
  QStringList alpha;
  QGridLayout *slt,*scalla,*mdl;
  QHBoxLayout *slt2;       
  QVBoxLayout *vlt;
  QGroupBox *gp;QHBoxLayout *rhla,*rhla2; 
  QHBoxLayout *buttomLt;
  QPushButton *showLst;
  QToolButton *hidesearch2,*hidesearch;
  QToolButton *prev,*next,*prev2,*next2,*replaceButton,*replacePButton,*replaceAButton; 
  QIcon extraIcon;
  QCheckBox *useArgument;
  QCheckBox *omitExtension;
  QCheckBox *detach;
  QSize ediSize;
  QPoint ediPos;
  QComboBox *resiFinder;
  QLabel *lineColumn;
  QGroupBox *suchbox2,*suchbox,*navibox,*refineButtonBox;
  QPushButton *stoppRefinement;
  QPushButton *loadRes;
  QPushButton *withdraw;
  QToolButton *spellCheckact,*spellCheckact2;
  QToolBar *editToolBar,*bottomToolBar,*fito,*vito,*extraTB;
  QAction
	  *tubeStyle,
	  *ballStyle,
      *toggleOrthoView,
      *actionUniq,
      *actionSearch,
      *actionNext,
      *actionPrev,
      *actionSave,
      *actionSaveAs,
      *actionUndo,
      *actionRedo,
      *actionCut,
      *actionCopy,
      *actionPaste,
      *actionHFix,
      *actionEP,
      *actionEM,
      *togAtom,
      *togBond,
      *togLabel,
      *togUnit,
      *togElli,
      *togHBond,
      *togDepthCueing,
      *togXRayView,
      *togBackGr,
      *killQs,
      *killHs,
      *astdlg,
      *mapcontrol,
      *refineAct,
      *refineActAnis,
      *wghtAct,
      *sinaAct;
  void searchchanged(bool current,bool back);
  void searchchanged2(bool current,bool back);
  void shx_editor(QString filename,QString title);
  int isacommand(QString command);
  double getNumber(double v,const QList<double> fv,double uiso);//to be changed!
  double getNumber(double v,const QList<double> fv);//to be changed!
  double ueq(Matrix m);
  MyAtom findOH(V3 donor, V3 acceptor,int dindex,QStringList alab);
  QString load_sheldrick(QString fileName);
  bool maybeSave();  
  bool maybeSave2();

};
class MyDockWidget:public QDockWidget{
Q_OBJECT
public:
MyDockWidget(const QString & title, QWidget * parent = 0, Qt::WindowFlags flags = 0):
QDockWidget(title, parent, flags){}
};

#endif

