#ifndef _TIME_HPP_
#define _TIME_HPP_

extern "C" {
	#include <sys/time.h>
	#include <sys/types.h>
	#include <unistd.h>
}

static inline u_int64_t ck(void);
static inline int to_usec(u_int64_t t);

u_int64_t ck(void)
{
        u_int64_t s, u;
        struct timeval tv;

        ::gettimeofday(&tv, 0);

        s = tv.tv_sec;
        s <<= 32;

        u = tv.tv_usec;
        u <<= 32;
        u /= 1000*1000;

        return s + u;
}


int to_usec(u_int64_t t)
{
        int s, u;

        s = (int)(t>>32);

        t &= (1LL<<32) - 1;
        t *= 1000*1000;
        u = (int)(t>>32);

        return s * 1000*1000 + u;
}

#endif
