#ifndef _BWADM_HPP_
#define _BWADM_HPP_

#include "time.hpp"
#include <list.h>

struct classinfo {
	public:
		int id;
		int cbw;
		int eff_bw;
		int borrowed;
		u_int64_t t_lend_exp;
		u_int64_t t_borrow_exp;
		u_int64_t t_lasttx;
		list<int> lenders;
};

class bwadm {
	int n_classes;
	classinfo **v_classes;

	void update_classinfo(classinfo*);
	public:
		bwadm();
		~bwadm();
		int add_class(int id, int bw=0);
		int add_lender(int, int);
		int getbw(int classid, int bytes, u_int64_t *t);
};

#endif
