/*
 * Sentinella
 * http://sourceforge.net/projects/sentinella/
 * Copyright (c) 2009 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef PROCESSDIES_H_
#define PROCESSDIES_H_

#include <libsysactivity/libsysactivity.h>
#ifndef SA_PROCESS
#error libsysactivity not installed or wrong version
#endif

#include <sys/types.h>
#include <errno.h>
#include "AbstractLoopCondition.h"

class ProcessDies : public AbstractLoopCondition {

public:
	ProcessDies(const int secondsLimit, const short resolution, const pid_t pid);

protected:
	void open();
	bool evaluate();
	void close();

private:
	struct sa_process dst;
	pid_t pid;
};

#endif /* PROCESSDIES_H_ */
