/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://scummvm.svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-0-11-1/engines/igor/staticres.cpp $
 * $Id: staticres.cpp 30944 2008-02-23 22:50:18Z sev $
 *
 */

#include "igor/igor.h"

namespace Igor {

const uint8 IgorEngine::_dialogueColor[] = { 0x3F, 0x3F, 0x3F };

const uint8 IgorEngine::_sentenceColorIndex[]= { 0xFD, 0xFB, 0xF1 };

const uint8 IgorEngine::_fontCharIndex[] = {
	0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
	0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
	0x5F, 0x53, 0x51, 0x59, 0x5D, 0x5A, 0x5C, 0x63, 0x44, 0x45, 0x63, 0x47, 0x4D, 0x46, 0x4F, 0x4B,
	0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x40, 0x41, 0x42, 0x43, 0x50, 0x4E, 0x49, 0x48, 0x4A, 0x55,
	0x5B, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
	0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x57, 0x4C, 0x58, 0x63, 0x63,
	0x63, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x29,
	0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x63, 0x63, 0x63, 0x63, 0x63,
	0x63, 0x63, 0x36, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
	0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
	0x35, 0x37, 0x38, 0x39, 0x28, 0x56, 0x63, 0x63, 0x54, 0x63, 0x63, 0x63, 0x63, 0x52, 0x63, 0x63,
	0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
	0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
	0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
	0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
	0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x5E, 0x63, 0x63, 0x63, 0x63, 0x63
};

const uint8 IgorEngine::_fontCharWidth[] = {
	0x07, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x07, 0x07, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x07, 0x08, 0x07, 0x07, 0x07, 0x07, 0x08, 0x08, 0x07, 0x08, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x05, 0x06, 0x07, 0x05, 0x08, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x08, 0x08, 0x06, 0x07, 0x06, 0x06, 0x05, 0x06, 0x06, 0x08, 0x07, 0x07, 0x07, 0x08, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x06, 0x06, 0x07, 0x07, 0x04, 0x04, 0x03,
	0x03, 0x06, 0x03, 0x03, 0x07, 0x07, 0x08, 0x05, 0x05, 0x08, 0x04, 0x06, 0x08, 0x07, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x00
};

const uint32 IgorEngine::_fontData[] = {
	0x000000, 0x000AA0, 0x002968, 0x00A55A, 0x0097D6, 0x00D6D6, 0x00D556, 0x00D7D6, 0x00D6D6, 0x00FAFA,
	0x000000, 0x000000, 0x00AAAA, 0x029556, 0x025F5A, 0x035B58, 0x03D558, 0x025F58, 0x035B5A, 0x03D556,
	0x00FFFA, 0x000000, 0x000000, 0x00AAA8, 0x02955A, 0x025FD6, 0x03E8D6, 0x0000D6, 0x02A8D6, 0x025AD6,
	0x03D55A, 0x00FFE8, 0x000000, 0x000000, 0x002AAA, 0x00A556, 0x02975A, 0x025B58, 0x035B58, 0x035B58,
	0x03D75A, 0x00F556, 0x003FFA, 0x000000, 0x000000, 0x02AAAA, 0x025556, 0x037F5A, 0x03A758, 0x003558,
	0x02B758, 0x027B5A, 0x035556, 0x03FFFA, 0x000000, 0x000000, 0x02AAAA, 0x025556, 0x037F5A, 0x03A758,
	0x003558, 0x003758, 0x003B5A, 0x000956, 0x000FFA, 0x000000, 0x000000, 0x00AAA0, 0x029568, 0x025F5A,
	0x03EBD6, 0x02AAD6, 0x0256D6, 0x035A5A, 0x035568, 0x03FFA0, 0x000000, 0x000000, 0x00AAAA, 0x009696,
	0x00D6D6, 0x00D6D6, 0x00D556, 0x00D7D6, 0x00D6D6, 0x00D6D6, 0x00FAFA, 0x000000, 0x000000, 0x00AAAA,
	0x009556, 0x00FD7A, 0x000D60, 0x000D60, 0x000D60, 0x00AD6A, 0x009556, 0x00FFFA, 0x000000, 0x000000,
	0x02AA80, 0x025580, 0x03D680, 0x00D600, 0x00D6AA, 0x00D696, 0x00D6D6, 0x00F55A, 0x003FE8, 0x000000,
	0x000000, 0x02AAAA, 0x025A56, 0x035B5A, 0x03D758, 0x00F558, 0x029758, 0x025B5A, 0x035B56, 0x03EBFA,
	0x000000, 0x000000, 0x000AAA, 0x000956, 0x000F5A, 0x000358, 0x02A358, 0x026B58, 0x035B5A, 0x035556,
	0x03FFFA, 0x000000, 0x000000, 0x02A8AA, 0x025A96, 0x035656, 0x035556, 0x035556, 0x035DD6, 0x035ED6,
	0x0358D6, 0x03E8FA, 0x000000, 0x000000, 0x02A8AA, 0x025A96, 0x035A56, 0x035956, 0x0355D6, 0x0356D6,
	0x035AD6, 0x0358D6, 0x03E8FA, 0x000000, 0x000000, 0x002AA0, 0x00A568, 0x02975A, 0x025BD6, 0x0358D6,
	0x035AD6, 0x03D65A, 0x00F568, 0x003FA0, 0x000000, 0x000000, 0x00AAAA, 0x029556, 0x025F5A, 0x035B58,
	0x03D558, 0x00FF58, 0x000B5A, 0x000956, 0x000FFA, 0x000000, 0x000000, 0x002AA8, 0x00A55A, 0x0097D6,
	0x00D6D6, 0x00D6D6, 0x00D6D6, 0x00D5D6, 0x00F55A, 0x0095E8, 0x00FE80, 0x000000, 0x00AAAA, 0x029556,
	0x025F5A, 0x035B58, 0x03D558, 0x025F58, 0x035B5A, 0x035B56, 0x03EBFA, 0x000000, 0x000000, 0x002AA8,
	0x00A55A, 0x0097D6, 0x00FAD6, 0x00A55A, 0x0097EA, 0x00D696, 0x00F55A, 0x003FE8, 0x000000, 0x000000,
	0x00AAAA, 0x009556, 0x00DD76, 0x00ED7A, 0x000D60, 0x000D60, 0x002D68, 0x002558, 0x003FE8, 0x000000,
	0x000000, 0x00AAAA, 0x009696, 0x00D6D6, 0x00D6D6, 0x00D6D6, 0x00D6D6, 0x00D6D6, 0x00F55A, 0x003FE8,
	0x000000, 0x000000, 0x00AAAA, 0x009696, 0x00D6D6, 0x00D6D6, 0x00D6D6, 0x00D6D6, 0x00F55A, 0x003D68,
	0x000FA0, 0x000000, 0x000000, 0x02A8AA, 0x025896, 0x0358D6, 0x035AD6, 0x0359D6, 0x035556, 0x035756,
	0x03DBDA, 0x00E8E8, 0x000000, 0x000000, 0x02A8AA, 0x025896, 0x035AD6, 0x03D65A, 0x00F568, 0x02975A,
	0x025BD6, 0x0358D6, 0x03E8FA, 0x000000, 0x000000, 0x00AAAA, 0x009696, 0x00D6D6, 0x00D6D6, 0x00F55A,
	0x003D68, 0x002D68, 0x002558, 0x003FE8, 0x000000, 0x000000, 0x02AAAA, 0x025556, 0x0357D6, 0x03D5F6,
	0x02F57A, 0x027D5A, 0x035F56, 0x035556, 0x03FFFA, 0x000000, 0x000000, 0x000000, 0x000000, 0x000AA8,
	0x002958, 0x0025E8, 0x00355A, 0x0035D6, 0x00355A, 0x003FE8, 0x000000, 0x000000, 0x0000AA, 0x000096,
	0x000AD6, 0x002956, 0x0025D6, 0x0035D6, 0x0035D6, 0x003D56, 0x000FFA, 0x000000, 0x000000, 0x000000,
	0x000000, 0x000AA8, 0x00295A, 0x0025D6, 0x003ED6, 0x0025D6, 0x003D5A, 0x000FE8, 0x000000, 0x000000,
	0x002A80, 0x002580, 0x0035A8, 0x00355A, 0x0035D6, 0x0035D6, 0x0035D6, 0x00355A, 0x003FE8, 0x000000,
	0x000000, 0x000000, 0x000000, 0x000AA8, 0x00295A, 0x0025D6, 0x003556, 0x003FD6, 0x00255A, 0x003FE8,
	0x000000, 0x000000, 0x002AA0, 0x002568, 0x003F58, 0x000B5A, 0x000956, 0x000F5A, 0x000B5A, 0x000956,
	0x000FFA, 0x000000, 0x000000, 0x000000, 0x000000, 0x002AA8, 0x00255A, 0x0035D6, 0x0035D6, 0x00355A,
	0x0035EA, 0x003D56, 0x000FFA, 0x000000, 0x0000AA, 0x000096, 0x000AD6, 0x002956, 0x0025D6, 0x0035D6,
	0x0035D6, 0x0035D6, 0x003EFA, 0x000000, 0x000000, 0x0002A8, 0x000258, 0x0003EA, 0x000256, 0x00035A,
	0x000358, 0x000B5A, 0x000956, 0x000FFA, 0x000000, 0x000000, 0x002A80, 0x002580, 0x003E80, 0x002580,
	0x003580, 0x0035AA, 0x003596, 0x0035D6, 0x003D5A, 0x000FE8, 0x000000, 0x0000AA, 0x000096, 0x00AAD6,
	0x0096D6, 0x00F5D6, 0x003D56, 0x00A5D6, 0x0096D6, 0x00FAFA, 0x000000, 0x000000, 0x0002AA, 0x000256,
	0x00035A, 0x000358, 0x000358, 0x000358, 0x000B5A, 0x000956, 0x000FFA, 0x000000, 0x000000, 0x000000,
	0x000000, 0x00AAAA, 0x029656, 0x025556, 0x035DD6, 0x035DD6, 0x035ED6, 0x03E8FA, 0x000000, 0x000000,
	0x000000, 0x000000, 0x000AAA, 0x002956, 0x0025D6, 0x0035D6, 0x0035D6, 0x0035D6, 0x003EFA, 0x000000,
	0x000000, 0x000AAA, 0x000956, 0x000FFA, 0x002956, 0x0025D6, 0x0035D6, 0x0035D6, 0x0035D6, 0x003EFA,
	0x000000, 0x000000, 0x000000, 0x000000, 0x000AA8, 0x00295A, 0x0025D6, 0x0035D6, 0x0035D6, 0x003D5A,
	0x000FE8, 0x000000, 0x000000, 0x000000, 0x000000, 0x000AAA, 0x002956, 0x0025D6, 0x0035D6, 0x003D56,
	0x000FD6, 0x0000D6, 0x0000FA, 0x000000, 0x000000, 0x000000, 0x002AA8, 0x00255A, 0x0035D6, 0x0035D6,
	0x00355A, 0x0035E8, 0x003580, 0x003E80, 0x000000, 0x000000, 0x000000, 0x002AAA, 0x002596, 0x003D5A,
	0x000F58, 0x000B5A, 0x000956, 0x000FFA, 0x000000, 0x000000, 0x000000, 0x000000, 0x002AA8, 0x00255A,
	0x003FD6, 0x00295A, 0x0025EA, 0x003D56, 0x000FFA, 0x000000, 0x000000, 0x0002A0, 0x000268, 0x002B5A,
	0x002556, 0x003F5A, 0x000358, 0x002B58, 0x002568, 0x003FA0, 0x000000, 0x000000, 0x000000, 0x000000,
	0x002AAA, 0x002596, 0x0035D6, 0x0035D6, 0x0035D6, 0x003D5A, 0x000FE8, 0x000000, 0x000000, 0x000000,
	0x000000, 0x002AAA, 0x002596, 0x0035D6, 0x0035D6, 0x003D5A, 0x000F68, 0x0003A0, 0x000000, 0x000000,
	0x000000, 0x000000, 0x02A8AA, 0x025A96, 0x0359D6, 0x035DD6, 0x035556, 0x03D75A, 0x00FBE8, 0x000000,
	0x000000, 0x000000, 0x000000, 0x02A8AA, 0x025A96, 0x03D65A, 0x00F568, 0x02975A, 0x025BD6, 0x03E8FA,
	0x000000, 0x000000, 0x000000, 0x000000, 0x002AAA, 0x002596, 0x0035D6, 0x0035D6, 0x00355A, 0x0035EA,
	0x003D56, 0x000FFA, 0x000000, 0x000000, 0x000000, 0x00AAAA, 0x009556, 0x00F5F6, 0x00BD7A, 0x009F5A,
	0x00D556, 0x00FFFA, 0x000000, 0x002A80, 0x0025A0, 0x003D60, 0x000FA8, 0x002958, 0x0025E8, 0x00355A,
	0x0035D6, 0x00355A, 0x003FE8, 0x000000, 0x002A80, 0x0025A0, 0x003D60, 0x000FA8, 0x00295A, 0x0025D6,
	0x003556, 0x003FD6, 0x00255A, 0x003FE8, 0x000000, 0x000AA0, 0x000968, 0x000F58, 0x0003EA, 0x000256,
	0x00035A, 0x000358, 0x000B5A, 0x000956, 0x000FFA, 0x000000, 0x002A80, 0x0025A0, 0x003D60, 0x000FA8,
	0x00295A, 0x0025D6, 0x0035D6, 0x0035D6, 0x003D5A, 0x000FE8, 0x000000, 0x002A80, 0x0025A0, 0x003D60,
	0x002FAA, 0x002596, 0x0035D6, 0x0035D6, 0x0035D6, 0x003D5A, 0x000FE8, 0x000000, 0x000000, 0x00AAA8,
	0x02955A, 0x025FD6, 0x0358D6, 0x0358D6, 0x0358D6, 0x035AD6, 0x03D55A, 0x00FFE8, 0x000000, 0x000000,
	0x000AA0, 0x000968, 0x000D58, 0x000D68, 0x000D60, 0x000D60, 0x00AD6A, 0x009556, 0x00FFFA, 0x000000,
	0x000000, 0x002AA8, 0x00A55A, 0x0097D6, 0x00D6FA, 0x00F568, 0x00BF5A, 0x0097D6, 0x00D556, 0x00FFFA,
	0x000000, 0x000000, 0x002AA8, 0x00A55A, 0x0097D6, 0x00D6FA, 0x00F560, 0x0097AA, 0x00D696, 0x00F55A,
	0x003FE8, 0x000000, 0x000000, 0x00AA80, 0x0095A0, 0x00D568, 0x00D75A, 0x02D7D6, 0x025556, 0x03D7FA,
	0x025580, 0x03FE80, 0x000000, 0x000000, 0x00AAAA, 0x009556, 0x00FFD6, 0x00A556, 0x0097FA, 0x00D6AA,
	0x00D696, 0x00F55A, 0x003FE8, 0x000000, 0x000000, 0x002AA0, 0x002568, 0x003F5A, 0x002BD6, 0x00A556,
	0x0097D6, 0x00D6D6, 0x00F55A, 0x003FE8, 0x000000, 0x000000, 0x00AAAA, 0x009556, 0x00D7D6, 0x00D6FA,
	0x00F5A0, 0x003D60, 0x000D60, 0x000D60, 0x000FA0, 0x000000, 0x000000, 0x002AA8, 0x00A55A, 0x0097D6,
	0x00D6D6, 0x00F55A, 0x0097D6, 0x00D6D6, 0x00F55A, 0x003FE8, 0x000000, 0x000000, 0x002AA8, 0x00A55A,
	0x0097D6, 0x00D6D6, 0x00D55A, 0x00D7E8, 0x00F5A8, 0x003D58, 0x000FE8, 0x000000, 0x000AA0, 0x000968,
	0x000F5A, 0x0003D6, 0x0000D6, 0x0000D6, 0x0000D6, 0x0002D6, 0x000A5A, 0x000968, 0x000FA0, 0x0000AA,
	0x000296, 0x000A5A, 0x000968, 0x000D60, 0x000D60, 0x000D60, 0x000D68, 0x000F5A, 0x0003D6, 0x0000FA,
	0x000000, 0x000000, 0x000000, 0x000000, 0x00AAAA, 0x009556, 0x00FFFA, 0x000000, 0x000000, 0x000000,
	0x000000, 0x000000, 0x000000, 0x000AA0, 0x000960, 0x00AD6A, 0x009556, 0x00FD7A, 0x000D60, 0x000FA0,
	0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x00AAAA, 0x009556, 0x00FFFA, 0x009556, 0x00FFFA,
	0x000000, 0x000000, 0x000000, 0x000000, 0x002A80, 0x0025A0, 0x003D68, 0x000F5A, 0x0003D6, 0x000A5A,
	0x002968, 0x0025A0, 0x003E80, 0x000000, 0x000000, 0x0000AA, 0x000296, 0x000A5A, 0x002968, 0x0025A0,
	0x003D68, 0x000F5A, 0x0003D6, 0x0000FA, 0x000000, 0x000000, 0x00A800, 0x009A00, 0x00D680, 0x00F5A0,
	0x003D68, 0x000F5A, 0x0003D6, 0x0000F6, 0x00003A, 0x000000, 0x000000, 0x00002A, 0x0000A6, 0x000296,
	0x000A5A, 0x002968, 0x00A5A0, 0x009680, 0x00DA00, 0x00E800, 0x000000, 0x000000, 0x000000, 0x000000,
	0x000000, 0x000000, 0x000000, 0x0002A8, 0x000258, 0x00035A, 0x0003D6, 0x0000FA, 0x000000, 0x000000,
	0x000000, 0x0002A8, 0x000258, 0x000358, 0x0003E8, 0x000258, 0x00035A, 0x0003D6, 0x0000FA, 0x000000,
	0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x0000AA, 0x000096, 0x0000D6, 0x0000FA, 0x000000,
	0x000000, 0x000000, 0x000000, 0x0000AA, 0x000096, 0x0000D6, 0x0000FA, 0x000096, 0x0000D6, 0x0000FA,
	0x000000, 0x002AAA, 0x002596, 0x0035D6, 0x0035D6, 0x003EFA, 0x000000, 0x000000, 0x000000, 0x000000,
	0x000000, 0x000000, 0x000000, 0x0000AA, 0x000096, 0x0000FA, 0x000096, 0x0000D6, 0x0000D6, 0x0000D6,
	0x0000D6, 0x0000FA, 0x000000, 0x000000, 0x0000AA, 0x000096, 0x0000D6, 0x0000D6, 0x0000D6, 0x0000D6,
	0x0000FA, 0x000096, 0x0000FA, 0x000000, 0x000000, 0x000AA0, 0x000960, 0x000FA0, 0x000968, 0x000F5A,
	0x00ABD6, 0x0096D6, 0x00F55A, 0x003FE8, 0x000000, 0x000000, 0x002AA8, 0x00A55A, 0x0097D6, 0x00D6FA,
	0x00F5A0, 0x003D60, 0x000FA0, 0x000960, 0x000FA0, 0x000000, 0x02AAAA, 0x025556, 0x03FFFA, 0x025A96,
	0x035A56, 0x035956, 0x0355D6, 0x0356D6, 0x035AD6, 0x03E8FA, 0x000000, 0x000AAA, 0x000956, 0x000FD6,
	0x0000D6, 0x0000D6, 0x0000D6, 0x0000D6, 0x0000D6, 0x000AD6, 0x000956, 0x000FFA, 0x000AAA, 0x000956,
	0x000D7A, 0x000D60, 0x000D60, 0x000D60, 0x000D60, 0x000D60, 0x000D6A, 0x000D56, 0x000FFA, 0x000000,
	0x000000, 0x02AAAA, 0x02965A, 0x025556, 0x03D75A, 0x025556, 0x03D75A, 0x02FBEA, 0x000000, 0x000000,
	0x0002A8, 0x000258, 0x00035A, 0x0003D6, 0x0000FA, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000,
	0x000000, 0x000000, 0x000000, 0x000000, 0x0002AA, 0x000256, 0x000356, 0x000356, 0x0003FA, 0x000000,
	0x000000, 0x000000, 0x000000, 0x002AA0, 0x00A568, 0x009758, 0x02F568, 0x025D5A, 0x03D5D6, 0x02D6D6,
	0x02595A, 0x03EFE8, 0x000000, 0x000A80, 0x0029A8, 0x00A55A, 0x0097D6, 0x00FAD6, 0x00A55A, 0x0097EA,
	0x00D696, 0x00F55A, 0x003DE8, 0x000E80, 0x000000, 0x00AAA8, 0x02955A, 0x025FD6, 0x0355D6, 0x0355D6,
	0x0355D6, 0x03FED6, 0x00A55A, 0x003FE8, 0x000000
};

const uint8 IgorEngine::_talkDelays[] = { 0, 27, 22, 17, 12, 7, 0 };

const uint8 IgorEngine::_inventoryOffsetTable[] = { 1, 8, 15, 22, 29, 36, 42, 0 };

const uint8 IgorEngine::_inventoryActionsTable[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x16, 0x00, 0x01, 0x00, 0x09, 0x00,
	0x0C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x17, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x18, 0x00, 0x6A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x19, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x1A, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x1B, 0x00,
	0x01, 0x00, 0x09, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x1C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x1D, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x1F, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x21, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x24, 0x00, 0x01, 0x00, 0x3D, 0x01,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x25, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x26, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x27, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x28, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x00, 0x08, 0x00, 0x2A, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x2B, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x2C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x2D, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x2E, 0x00,
	0x01, 0x00, 0x2E, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x30, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x32, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x33, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x34, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x35, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x36, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x37, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x38, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x3A, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x3B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x41, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x40, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x42, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x45, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00
};

const uint8 IgorEngine::_walkWidthScaleTable[] = {
	0x01, 0x01, 0x02, 0x02, 0x03, 0x04, 0x04, 0x05, 0x05, 0x06, 0x07, 0x07, 0x08, 0x08, 0x09, 0x0A,
	0x0A, 0x0B, 0x0B, 0x0C, 0x0D, 0x0D, 0x0E, 0x0E, 0x0F, 0x10, 0x10, 0x11, 0x11, 0x12, 0x13, 0x13,
	0x14, 0x14, 0x15, 0x16, 0x16, 0x17, 0x17, 0x18, 0x19, 0x19, 0x1A, 0x1A, 0x1B, 0x1C, 0x1C, 0x1D,
	0x1D, 0x1E
};

const float IgorEngine::_walkScaleSpeedTable[] = {
	0.6250, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.1250, 1.3750, 1.6250,	1.6250,
	1.6250, 1.6250, 2.0000, 2.1250, 2.3750, 2.3750, 2.6250, 2.6250, 2.7500,	2.7500,
	2.7500, 3.0000, 3.0000, 3.0000, 3.0000, 3.6250, 3.6250, 3.6250, 3.8750,	3.8750,
	3.8750, 4.0000, 4.0000, 4.3750, 4.3750, 4.6250, 4.6250, 5.0000, 5.0000,	5.0000,
	5.0000, 5.2500, 5.5000, 5.6250, 5.6250, 5.6250, 5.6250, 5.6250, 5.6250,	5.6250
};

const uint8 IgorEngine::_walkScaleTable[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D,
	0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D,
	0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D,
	0x2E, 0x2F, 0x30, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C,
	0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D,
	0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D,
	0x2E, 0x2F, 0x30, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C,
	0x0D, 0x0E, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D,
	0x1E, 0x1F, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E,
	0x2F, 0x30, 0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0D, 0x0E, 0x0F,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20,
	0x21, 0x22, 0x23, 0x24, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10,
	0x11, 0x12, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1E, 0x1F, 0x20, 0x21, 0x22,
	0x23, 0x24, 0x25, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x31, 0x00, 0x01, 0x02,
	0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x10, 0x11, 0x12, 0x13, 0x14,
	0x15, 0x16, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26,
	0x27, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x07,
	0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x15, 0x16, 0x17, 0x18, 0x19,
	0x1A, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x2A, 0x2B, 0x2C,
	0x2D, 0x2E, 0x2F, 0x30, 0x00, 0x01, 0x02, 0x03, 0x04, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D,
	0x0E, 0x0F, 0x10, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1F, 0x20,
	0x21, 0x22, 0x23, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x00, 0x01,
	0x02, 0x03, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0B, 0x0C, 0x0D, 0x0E, 0x10, 0x11, 0x12, 0x13, 0x14,
	0x16, 0x17, 0x18, 0x19, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x21, 0x22, 0x23, 0x24, 0x26, 0x27, 0x28,
	0x29, 0x2A, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x09, 0x0A,
	0x0B, 0x0C, 0x0E, 0x0F, 0x10, 0x11, 0x13, 0x14, 0x15, 0x16, 0x18, 0x19, 0x1A, 0x1B, 0x1D, 0x1E,
	0x1F, 0x20, 0x22, 0x23, 0x24, 0x25, 0x27, 0x28, 0x29, 0x2A, 0x2C, 0x2D, 0x2E, 0x2F, 0x31, 0x00,
	0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x09, 0x0A, 0x0B, 0x0D, 0x0E, 0x0F, 0x10, 0x12, 0x13, 0x14,
	0x16, 0x17, 0x18, 0x19, 0x1B, 0x1C, 0x1D, 0x1F, 0x20, 0x21, 0x22, 0x24, 0x25, 0x26, 0x28, 0x29,
	0x2A, 0x2B, 0x2D, 0x2E, 0x2F, 0x31, 0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C,
	0x0D, 0x0E, 0x10, 0x11, 0x12, 0x14, 0x15, 0x16, 0x18, 0x19, 0x1A, 0x1B, 0x1D, 0x1E, 0x1F, 0x21,
	0x22, 0x23, 0x25, 0x26, 0x27, 0x29, 0x2A, 0x2B, 0x2D, 0x2E, 0x2F, 0x31, 0x00, 0x01, 0x03, 0x04,
	0x05, 0x07, 0x08, 0x09, 0x0B, 0x0C, 0x0D, 0x0F, 0x10, 0x11, 0x13, 0x14, 0x15, 0x17, 0x18, 0x1A,
	0x1B, 0x1C, 0x1E, 0x1F, 0x20, 0x22, 0x23, 0x24, 0x26, 0x27, 0x28, 0x2A, 0x2B, 0x2C, 0x2E, 0x2F,
	0x31, 0x00, 0x01, 0x03, 0x04, 0x05, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0x11, 0x12, 0x13,
	0x15, 0x16, 0x18, 0x19, 0x1A, 0x1C, 0x1D, 0x1E, 0x20, 0x21, 0x23, 0x24, 0x25, 0x27, 0x28, 0x2A,
	0x2B, 0x2C, 0x2E, 0x2F, 0x30, 0x00, 0x01, 0x03, 0x04, 0x06, 0x07, 0x09, 0x0A, 0x0B, 0x0D, 0x0E,
	0x10, 0x11, 0x12, 0x14, 0x15, 0x17, 0x18, 0x1A, 0x1B, 0x1C, 0x1E, 0x1F, 0x21, 0x22, 0x24, 0x25,
	0x26, 0x28, 0x29, 0x2B, 0x2C, 0x2E, 0x2F, 0x31, 0x00, 0x01, 0x03, 0x04, 0x06, 0x07, 0x09, 0x0A,
	0x0C, 0x0D, 0x0F, 0x10, 0x12, 0x13, 0x15, 0x16, 0x17, 0x19, 0x1A, 0x1C, 0x1D, 0x1F, 0x20, 0x22,
	0x23, 0x25, 0x26, 0x28, 0x29, 0x2B, 0x2C, 0x2E, 0x2F, 0x30, 0x00, 0x02, 0x03, 0x05, 0x06, 0x08,
	0x09, 0x0B, 0x0C, 0x0E, 0x0F, 0x11, 0x12, 0x14, 0x15, 0x17, 0x18, 0x1A, 0x1B, 0x1D, 0x1E, 0x20,
	0x21, 0x23, 0x24, 0x26, 0x27, 0x29, 0x2A, 0x2C, 0x2D, 0x2F, 0x31, 0x00, 0x02, 0x03, 0x05, 0x06,
	0x08, 0x09, 0x0B, 0x0D, 0x0E, 0x10, 0x11, 0x13, 0x14, 0x16, 0x18, 0x19, 0x1B, 0x1C, 0x1E, 0x1F,
	0x21, 0x22, 0x24, 0x26, 0x27, 0x29, 0x2A, 0x2C, 0x2D, 0x2F, 0x31, 0x00, 0x02, 0x03, 0x05, 0x07,
	0x08, 0x0A, 0x0B, 0x0D, 0x0F, 0x10, 0x12, 0x13, 0x15, 0x17, 0x18, 0x1A, 0x1C, 0x1D, 0x1F, 0x20,
	0x22, 0x24, 0x25, 0x27, 0x28, 0x2A, 0x2C, 0x2D, 0x2F, 0x30, 0x00, 0x02, 0x04, 0x05, 0x07, 0x09,
	0x0A, 0x0C, 0x0D, 0x0F, 0x11, 0x13, 0x14, 0x16, 0x18, 0x19, 0x1B, 0x1D, 0x1E, 0x20, 0x22, 0x23,
	0x25, 0x27, 0x28, 0x2A, 0x2B, 0x2D, 0x2F, 0x30, 0x00, 0x02, 0x04, 0x05, 0x07, 0x09, 0x0B, 0x0C,
	0x0E, 0x10, 0x11, 0x13, 0x15, 0x17, 0x18, 0x1A, 0x1C, 0x1E, 0x1F, 0x21, 0x23, 0x24, 0x26, 0x28,
	0x2A, 0x2B, 0x2D, 0x2F, 0x31, 0x00, 0x02, 0x04, 0x06, 0x07, 0x09, 0x0B, 0x0D, 0x0F, 0x10, 0x12,
	0x14, 0x16, 0x17, 0x19, 0x1B, 0x1D, 0x1F, 0x20, 0x22, 0x24, 0x26, 0x28, 0x29, 0x2B, 0x2D, 0x2F,
	0x30, 0x00, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0B, 0x0D, 0x0F, 0x11, 0x13, 0x15, 0x17, 0x18, 0x1A,
	0x1C, 0x1E, 0x20, 0x22, 0x24, 0x25, 0x27, 0x29, 0x2B, 0x2D, 0x2F, 0x31, 0x00, 0x02, 0x04, 0x06,
	0x08, 0x0A, 0x0C, 0x0E, 0x10, 0x12, 0x14, 0x16, 0x18, 0x19, 0x1B, 0x1D, 0x1F, 0x21, 0x23, 0x25,
	0x27, 0x29, 0x2B, 0x2D, 0x2F, 0x30, 0x01, 0x03, 0x05, 0x07, 0x09, 0x0B, 0x0D, 0x0F, 0x11, 0x13,
	0x15, 0x17, 0x19, 0x1B, 0x1D, 0x1F, 0x21, 0x23, 0x25, 0x27, 0x29, 0x2B, 0x2D, 0x2F, 0x31, 0x01,
	0x03, 0x05, 0x07, 0x09, 0x0B, 0x0D, 0x0F, 0x11, 0x13, 0x15, 0x18, 0x1A, 0x1C, 0x1E, 0x20, 0x22,
	0x24, 0x26, 0x28, 0x2A, 0x2C, 0x2E, 0x31, 0x01, 0x03, 0x05, 0x07, 0x09, 0x0C, 0x0E, 0x10, 0x12,
	0x14, 0x16, 0x19, 0x1B, 0x1D, 0x1F, 0x21, 0x23, 0x26, 0x28, 0x2A, 0x2C, 0x2E, 0x31, 0x01, 0x03,
	0x05, 0x08, 0x0A, 0x0C, 0x0E, 0x11, 0x13, 0x15, 0x18, 0x1A, 0x1C, 0x1E, 0x21, 0x23, 0x25, 0x27,
	0x2A, 0x2C, 0x2E, 0x31, 0x01, 0x03, 0x06, 0x08, 0x0A, 0x0D, 0x0F, 0x12, 0x14, 0x16, 0x19, 0x1B,
	0x1D, 0x20, 0x22, 0x25, 0x27, 0x29, 0x2C, 0x2E, 0x31, 0x01, 0x04, 0x06, 0x09, 0x0B, 0x0E, 0x10,
	0x13, 0x15, 0x18, 0x1A, 0x1D, 0x1F, 0x22, 0x24, 0x27, 0x29, 0x2C, 0x2E, 0x31, 0x01, 0x04, 0x06,
	0x09, 0x0C, 0x0E, 0x11, 0x14, 0x16, 0x19, 0x1B, 0x1E, 0x21, 0x23, 0x26, 0x29, 0x2B, 0x2E, 0x31,
	0x01, 0x04, 0x07, 0x0A, 0x0C, 0x0F, 0x12, 0x15, 0x18, 0x1A, 0x1D, 0x20, 0x23, 0x25, 0x28, 0x2B,
	0x2E, 0x31, 0x01, 0x04, 0x07, 0x0A, 0x0D, 0x10, 0x13, 0x16, 0x19, 0x1C, 0x1F, 0x22, 0x25, 0x28,
	0x2B, 0x2E, 0x31, 0x02, 0x05, 0x08, 0x0B, 0x0E, 0x11, 0x14, 0x18, 0x1B, 0x1E, 0x21, 0x24, 0x27,
	0x2A, 0x2D, 0x31, 0x02, 0x05, 0x09, 0x0C, 0x0F, 0x13, 0x16, 0x19, 0x1D, 0x20, 0x23, 0x27, 0x2A,
	0x2D, 0x31, 0x02, 0x06, 0x09, 0x0D, 0x10, 0x14, 0x18, 0x1B, 0x1F, 0x22, 0x26, 0x29, 0x2D, 0x31,
	0x02, 0x06, 0x0A, 0x0E, 0x12, 0x16, 0x19, 0x1D, 0x21, 0x25, 0x29, 0x2D, 0x31, 0x03, 0x07, 0x0B,
	0x0F, 0x13, 0x18, 0x1C, 0x20, 0x24, 0x28, 0x2C, 0x31, 0x03, 0x08, 0x0C, 0x11, 0x15, 0x1A, 0x1E,
	0x23, 0x27, 0x2C, 0x31, 0x04, 0x09, 0x0E, 0x13, 0x18, 0x1D, 0x22, 0x27, 0x2C, 0x31, 0x04, 0x0A,
	0x0F, 0x15, 0x1A, 0x20, 0x25, 0x2B, 0x31, 0x05, 0x0B, 0x11, 0x18, 0x1E, 0x24, 0x2A, 0x31, 0x06,
	0x0D, 0x14, 0x1B, 0x22, 0x29, 0x31, 0x07, 0x0F, 0x18, 0x20, 0x28, 0x31, 0x09, 0x13, 0x1D, 0x27,
	0x31, 0x0B, 0x18, 0x24, 0x31, 0x0F, 0x20, 0x31, 0x18, 0x31, 0x31, 0x00, 0x00, 0x01, 0x02, 0x03,
	0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13,
	0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05,
	0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
	0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1D, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
	0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19,
	0x1A, 0x1B, 0x1D, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0B, 0x0C, 0x0D,
	0x0E, 0x0F, 0x10, 0x11, 0x12, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x00, 0x01,
	0x02, 0x03, 0x04, 0x05, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0F, 0x10, 0x11, 0x12, 0x13,
	0x14, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x00, 0x01, 0x02, 0x03, 0x05, 0x06, 0x07, 0x08,
	0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x12, 0x13, 0x14, 0x15, 0x16, 0x18, 0x19, 0x1A, 0x1B,
	0x1C, 0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0x10, 0x11,
	0x13, 0x14, 0x15, 0x16, 0x18, 0x19, 0x1A, 0x1B, 0x1D, 0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08,
	0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0x11, 0x12, 0x13, 0x15, 0x16, 0x17, 0x19, 0x1A, 0x1B, 0x1D,
	0x00, 0x01, 0x03, 0x04, 0x05, 0x07, 0x08, 0x09, 0x0B, 0x0C, 0x0D, 0x0F, 0x10, 0x12, 0x13, 0x14,
	0x16, 0x17, 0x18, 0x1A, 0x1B, 0x1C, 0x00, 0x01, 0x03, 0x04, 0x06, 0x07, 0x09, 0x0A, 0x0B, 0x0D,
	0x0E, 0x10, 0x11, 0x12, 0x14, 0x15, 0x17, 0x18, 0x1A, 0x1B, 0x1C, 0x00, 0x02, 0x03, 0x05, 0x06,
	0x08, 0x09, 0x0B, 0x0C, 0x0E, 0x0F, 0x11, 0x12, 0x14, 0x15, 0x17, 0x18, 0x1A, 0x1B, 0x1D, 0x00,
	0x02, 0x03, 0x05, 0x06, 0x08, 0x0A, 0x0B, 0x0D, 0x0E, 0x10, 0x11, 0x13, 0x15, 0x16, 0x18, 0x19,
	0x1B, 0x1C, 0x00, 0x02, 0x04, 0x05, 0x07, 0x09, 0x0A, 0x0C, 0x0D, 0x0F, 0x11, 0x13, 0x14, 0x16,
	0x18, 0x19, 0x1B, 0x1D, 0x00, 0x02, 0x04, 0x06, 0x07, 0x09, 0x0B, 0x0D, 0x0E, 0x10, 0x12, 0x14,
	0x15, 0x17, 0x19, 0x1B, 0x1D, 0x00, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0C, 0x0E, 0x0F, 0x11, 0x13,
	0x15, 0x17, 0x19, 0x1B, 0x1D, 0x00, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0C, 0x0E, 0x10, 0x12, 0x14,
	0x16, 0x18, 0x1A, 0x1C, 0x01, 0x03, 0x05, 0x07, 0x09, 0x0B, 0x0E, 0x10, 0x12, 0x14, 0x16, 0x18,
	0x1A, 0x1D, 0x01, 0x03, 0x05, 0x08, 0x0A, 0x0C, 0x0F, 0x11, 0x13, 0x16, 0x18, 0x1A, 0x1D, 0x01,
	0x04, 0x06, 0x09, 0x0B, 0x0E, 0x10, 0x13, 0x15, 0x18, 0x1A, 0x1D, 0x01, 0x04, 0x07, 0x09, 0x0C,
	0x0F, 0x12, 0x14, 0x17, 0x1A, 0x1D, 0x02, 0x05, 0x08, 0x0B, 0x0E, 0x11, 0x14, 0x17, 0x1A, 0x1D,
	0x02, 0x05, 0x09, 0x0C, 0x0F, 0x13, 0x16, 0x19, 0x1D, 0x02, 0x06, 0x0A, 0x0E, 0x11, 0x15, 0x19,
	0x1D, 0x03, 0x07, 0x0B, 0x10, 0x14, 0x18, 0x1D, 0x04, 0x09, 0x0E, 0x13, 0x18, 0x1D, 0x05, 0x0B,
	0x11, 0x17, 0x1D, 0x06, 0x0E, 0x15, 0x1D, 0x09, 0x13, 0x1D, 0x0E, 0x1D, 0x1D, 0x00, 0xFB, 0x04,
	0xFA, 0x04, 0xF8, 0x04, 0xF5, 0x04, 0xF1, 0x04, 0xEC, 0x04, 0xE6, 0x04, 0xDF, 0x04, 0xD7, 0x04,
	0xCE, 0x04, 0xC4, 0x04, 0xB9, 0x04, 0xAD, 0x04, 0xA0, 0x04, 0x92, 0x04, 0x83, 0x04, 0x73, 0x04,
	0x62, 0x04, 0x50, 0x04, 0x3D, 0x04, 0x29, 0x04, 0x14, 0x04, 0xFE, 0x03, 0xE7, 0x03, 0xCF, 0x03,
	0xB6, 0x03, 0x9C, 0x03, 0x81, 0x03, 0x65, 0x03, 0x48, 0x03, 0x2A, 0x03, 0x0B, 0x03, 0xEB, 0x02,
	0xCA, 0x02, 0xA8, 0x02, 0x85, 0x02, 0x61, 0x02, 0x3C, 0x02, 0x16, 0x02, 0xEF, 0x01, 0xC7, 0x01,
	0x9E, 0x01, 0x74, 0x01, 0x49, 0x01, 0x1D, 0x01, 0xF0, 0x00, 0xC2, 0x00, 0x93, 0x00, 0x63, 0x00,
	0x32, 0x00, 0x00, 0x00, 0xD1, 0x01, 0xD0, 0x01, 0xCE, 0x01, 0xCB, 0x01, 0xC7, 0x01, 0xC2, 0x01,
	0xBC, 0x01, 0xB5, 0x01, 0xAD, 0x01, 0xA4, 0x01, 0x9A, 0x01, 0x8F, 0x01, 0x83, 0x01, 0x76, 0x01,
	0x68, 0x01, 0x59, 0x01, 0x49, 0x01, 0x38, 0x01, 0x26, 0x01, 0x13, 0x01, 0xFF, 0x00, 0xEA, 0x00,
	0xD4, 0x00, 0xBD, 0x00, 0xA5, 0x00, 0x8C, 0x00, 0x72, 0x00, 0x57, 0x00, 0x3B, 0x00, 0x1E, 0x00,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x02,
	0x01, 0x01, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02,
	0x01, 0x01, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02,
	0x01, 0x01, 0x02, 0x02, 0x02, 0x01, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x03, 0x02, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x03, 0x02, 0x03, 0x03,
	0x02, 0x02, 0x03, 0x03, 0x03, 0x02, 0x03, 0x03, 0x02, 0x02, 0x03, 0x03, 0x03, 0x02, 0x03, 0x03,
	0x02, 0x02, 0x03, 0x03, 0x03, 0x02, 0x04, 0x03, 0x02, 0x02, 0x03, 0x03, 0x03, 0x02, 0x04, 0x03,
	0x02, 0x02, 0x03, 0x03, 0x03, 0x02, 0x04, 0x03, 0x02, 0x02, 0x03, 0x03, 0x04, 0x02, 0x04, 0x04,
	0x02, 0x02, 0x03, 0x03, 0x04, 0x02, 0x04, 0x04, 0x02, 0x02, 0x03, 0x03, 0x04, 0x02, 0x04, 0x04,
	0x02, 0x02, 0x04, 0x04, 0x05, 0x03, 0x05, 0x05, 0x03, 0x03, 0x04, 0x04, 0x04, 0x02, 0x05, 0x04,
	0x03, 0x03, 0x04, 0x04, 0x04, 0x02, 0x05, 0x04, 0x03, 0x03, 0x04, 0x04, 0x04, 0x02, 0x05, 0x04,
	0x03, 0x03, 0x04, 0x04, 0x05, 0x02, 0x05, 0x05, 0x03, 0x03, 0x04, 0x04, 0x05, 0x02, 0x05, 0x05,
	0x03, 0x03, 0x04, 0x04, 0x05, 0x02, 0x05, 0x05, 0x03, 0x03, 0x04, 0x04, 0x05, 0x02, 0x06, 0x05,
	0x03, 0x03, 0x04, 0x04, 0x05, 0x02, 0x06, 0x05, 0x03, 0x03, 0x05, 0x05, 0x05, 0x03, 0x06, 0x05,
	0x03, 0x03, 0x05, 0x05, 0x05, 0x03, 0x06, 0x05, 0x03, 0x03, 0x05, 0x05, 0x06, 0x03, 0x06, 0x06,
	0x03, 0x03, 0x05, 0x05, 0x06, 0x03, 0x06, 0x06, 0x03, 0x03, 0x05, 0x05, 0x06, 0x03, 0x07, 0x06,
	0x04, 0x04, 0x05, 0x05, 0x06, 0x03, 0x07, 0x06, 0x04, 0x04, 0x06, 0x06, 0x07, 0x04, 0x08, 0x07,
	0x04, 0x04, 0x07, 0x07, 0x08, 0x05, 0x09, 0x08, 0x05, 0x05, 0x07, 0x07, 0x08, 0x05, 0x09, 0x08,
	0x05, 0x05, 0x07, 0x07, 0x08, 0x05, 0x09, 0x08, 0x05, 0x05, 0x07, 0x07, 0x08, 0x05, 0x09, 0x08,
	0x05, 0x05, 0x07, 0x07, 0x08, 0x05, 0x09, 0x08, 0x05, 0x05, 0x07, 0x07, 0x08, 0x05, 0x09, 0x08,
	0x05, 0x05, 0x08, 0x08, 0x09, 0x05, 0x0A, 0x09, 0x06, 0x06, 0x08, 0x08, 0x09, 0x05, 0x0A, 0x09,
	0x06, 0x06, 0x08, 0x08, 0x09, 0x05, 0x0A, 0x09, 0x06, 0x06, 0x08, 0x08, 0x09, 0x05, 0x0A, 0x09,
	0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03
};

const uint8 IgorEngine::_mouseCursorMask[] = {
	0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00
};

const uint8 IgorEngine::_mouseCursorData[] = {
	0x00, 0xFC, 0x00, 0x04, 0xFD, 0x00, 0x03, 0xFE, 0x02, 0xFB, 0xFC, 0xFD, 0x03, 0x04, 0x05, 0xFE,
	0x02, 0xFD, 0x00, 0x03,	0xFC, 0x00, 0x04, 0x00, 0xFB, 0xFC, 0xFC, 0xFC, 0xFD, 0xFD, 0xFD, 0xFE,
	0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,	0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05
};

const uint8 IgorEngine::PAL_48_1[] = {
	0x2D, 0x16, 0x00, 0x3D, 0x26, 0x01, 0x32, 0x32, 0x24, 0x16, 0x1D, 0x16, 0x12, 0x19, 0x12, 0x0B,
	0x12, 0x0B, 0x32, 0x32, 0x24, 0x16, 0x1D, 0x16, 0x12, 0x19, 0x12, 0x0B, 0x12, 0x0B, 0x3D, 0x3D,
	0x3D, 0x3D, 0x26, 0x01, 0x36, 0x1F, 0x01, 0x2D, 0x16, 0x00, 0x0F, 0x08, 0x00, 0x3F, 0x3F, 0x3F
};

const uint8 IgorEngine::PAL_96_1[] = {
	0x00, 0x00, 0x00, 0x18, 0x00, 0x19, 0x00, 0x00, 0x1D, 0x00, 0x03, 0x21, 0x00, 0x09, 0x26, 0x00,
	0x11, 0x2B, 0x00, 0x00, 0x32, 0x00, 0x16, 0x00, 0x03, 0x1F, 0x00, 0x00, 0x21, 0x0C, 0x14, 0x23,
	0x00, 0x00, 0x27, 0x19, 0x18, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x26, 0x00, 0x00, 0x30, 0x00, 0x00,
	0x32, 0x0D, 0x00, 0x32, 0x19, 0x00, 0x33, 0x21, 0x00, 0x32, 0x28, 0x00, 0x3F, 0x3A, 0x18, 0x3F,
	0x3F, 0x33, 0x38, 0x38, 0x38, 0x2E, 0x2E, 0x2E, 0x1C, 0x1C, 0x1C, 0x12, 0x12, 0x12, 0x06, 0x06,
	0x06, 0x0E, 0x05, 0x00, 0x1D, 0x0D, 0x02, 0x2A, 0x17, 0x00, 0x2A, 0x1E, 0x16, 0x31, 0x27, 0x23
};

const uint8 IgorEngine::PAL_IGOR_1[] = {
	0x35, 0x1F, 0x17, 0x30, 0x19, 0x10, 0x25, 0x13, 0x0B, 0x1D, 0x0E, 0x05, 0x06, 0x06, 0x06, 0x3E,
	0x3E, 0x3E, 0x27, 0x1A, 0x00, 0x35, 0x27, 0x06, 0x2B, 0x26, 0x23, 0x25, 0x20, 0x1D, 0x1D, 0x1A,
	0x17, 0x06, 0x0B, 0x14, 0x04, 0x08, 0x0E, 0x02, 0x05, 0x09, 0x01, 0x02, 0x04, 0x25, 0x05, 0x05
};

const uint8 IgorEngine::PAL_IGOR_2[] = {
	0x34, 0x1F, 0x17, 0x30, 0x19, 0x11, 0x25, 0x13, 0x0B, 0x1D, 0x0E, 0x05, 0x06, 0x06, 0x06, 0x3D,
	0x3D, 0x3D, 0x27, 0x1A, 0x00, 0x1C, 0x0F, 0x00, 0x2B, 0x26, 0x23, 0x25, 0x20, 0x1D, 0x1D, 0x19,
	0x17, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8 IgorEngine::INVENTORY_IMG_INIT[] = {
	1, 2, 40, 4, 5, 6, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 29, 30,
	31, 32, 33, 34, 36, 37, 28, 21, 38, 3
};

const RoomDataOffsets IgorEngine::PART_04_ROOM_DATA_OFFSETS = {
	{ 0, 0, 0, 0 },
	{ 0, 0 },
	{ 23, 231, 3247, 127, 203, 84 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_05_ROOM_DATA_OFFSETS = {
	{ 125, 5, 20, 4 },
	{ 253, 262 },
	{ 265, 437, 3313, 329, 405, 80 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_06_ROOM_DATA_OFFSETS = {
	{ 45, 3, 6, 2 },
	{ 75, 84 },
	{ 87, 259, 3135, 151, 227, 80 },
	{ 135, 30, 5158, 100, 60 }
};

const RoomDataOffsets IgorEngine::PART_12_ROOM_DATA_OFFSETS = {
	{ 45, 3, 6, 2 },
	{ 75, 84 },
	{ 87, 259, 3135, 151, 227, 80 },
	{ -85, 15, 2478, 25, 30 }
};

const RoomDataOffsets IgorEngine::PART_13_ROOM_DATA_OFFSETS = {
	{ 20, 2, 2, 1 },
	{ 31, 40 },
	{ 43, 215, 3091, 107, 183, 80 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_14_ROOM_DATA_OFFSETS = {
	{ 20, 2, 2, 1 },
	{ 32, 43 },
	{ 47, 237, 3183, 131, 207, 82 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_15_ROOM_DATA_OFFSETS = {
	{ 0, 0, 0, 0 },
	{ 3, 12 },
	{ 15, 187, 3063, 79, 155, 80 },
	{ 45, 22, 3756, 66, 60 }
};

const RoomDataOffsets IgorEngine::PART_16_ROOM_DATA_OFFSETS = {
	{ 20, 2, 2, 1 },
	{ 29, 34 },
	{ 35, 171, 2907, 59, 135, 76 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_17_ROOM_DATA_OFFSETS = {
	{ 320, 8, 56, 7 },
	{ 835, 844 },
	{ 847, 1019, 3895, 911, 987, 80 },
	{ -174, 5, 257, 1, 30 }
};

const RoomDataOffsets IgorEngine::PART_18_ROOM_DATA_OFFSETS = {
	{ 20, 2, 2, 1 },
	{ 34, 49 },
	{ 55, 281, 3367, 179, 255, 86 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_19_ROOM_DATA_OFFSETS = {
	{ 20, 2, 2, 1 },
	{ 33, 46 },
	{ 51, 259, 3359, 155, 231, 84 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_21_ROOM_DATA_OFFSETS = {
	{ 0, 0, 0, 0 },
	{ 5, 18 },
	{ 23, 231, 3247, 127, 203, 84 },
	{ -85, 10, 1658, 50, 30 }
};

const RoomDataOffsets IgorEngine::PART_22_ROOM_DATA_OFFSETS = {
	{ 0, 0, 0, 0 },
	{ 1, 6 },
	{ 7, 143, 2879, 31, 107, 76 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_23_ROOM_DATA_OFFSETS = {
	{ 0, 0, 0, 0 },
	{ 4, 15 },
	{ 19, 209, 3155, 103, 179, 82 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_24_ROOM_DATA_OFFSETS = {
	{ 0, 0, 0, 0 },
	{ 5, 18 },
	{ 23, 235, 3111, 127, 203, 80 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_25_ROOM_DATA_OFFSETS = {
	{ 20, 2, 2, 1 },
	{ 31, 40 },
	{ 43, 215, 3091, 107, 183, 80 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_26_ROOM_DATA_OFFSETS = {
	{ 20, 2, 2, 1 },
	{ 32, 43 },
	{ 47, 237, 3183, 131, 207, 82 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_27_ROOM_DATA_OFFSETS = {
	{ 0, 0, 0, 0 },
	{ 6, 21 },
	{ 27, 253, 3339, 151, 227, 86 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_28_ROOM_DATA_OFFSETS = {
	{ 45, 3, 6, 2 },
	{ 78, 93 },
	{ 99, 325, 3411, 223, 299, 86 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_30_ROOM_DATA_OFFSETS = {
	{ 45, 3, 6, 2 },
	{ 75, 84 },
	{ 87, 259, 3135, 151, 227, 80 },
	{ -90, 9, 1489, 11, 30 }
};

const RoomDataOffsets IgorEngine::PART_31_ROOM_DATA_OFFSETS = {
	{ 45, 3, 6, 2 },
	{ 79, 96 },
	{ 103, 351, 3367, 247, 323, 84 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_33_ROOM_DATA_OFFSETS = {
	{ 180, 6, 30, 5 },
	{ 405, 426 },
	{ 435, 715, 4011, 619, 695, 92 },
	{ -46, 9, 1533, 19, 60 }
};

const RoomDataOffsets IgorEngine::PART_36_ROOM_DATA_OFFSETS = {
	{ 45, 3, 6, 2 },
	{ 77, 90 },
	{ 95, 303, 3319, 199, 275, 84 },
	{ 0, 0, 0, 0, 0 }
};

const RoomDataOffsets IgorEngine::PART_37_ROOM_DATA_OFFSETS = {
	{ 45, 3, 6, 2 },
	{ 75, 84 },
	{ 87, 259, 3135, 151, 227, 80 },
	{ 0, 0, 0, 0, 0 }
};

} // namespace Igor
