#include <glib/gi18n.h>

#include <libxml/tree.h>
#include <libxml/parser.h>

#include <gtk/gtk.h>

#include "screem-xml-model.h"

static void set_columns( GtkWidget *widget )
{
	GtkCellRenderer *prend;
	GtkCellRenderer *rend;
	GtkTreeViewColumn *col;

	prend = gtk_cell_renderer_pixbuf_new();
	rend = gtk_cell_renderer_text_new ();
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title( col, _( "Element" ) );
	gtk_tree_view_column_pack_start( col, prend, FALSE );
	gtk_tree_view_column_pack_start( col, rend, TRUE );
	gtk_tree_view_column_set_attributes( col, rend,
			"text", SCREEM_XML_MODEL_NAME, NULL );
	gtk_tree_view_column_set_attributes( col, prend,
			"pixbuf", SCREEM_XML_MODEL_ICON, NULL );
	gtk_tree_view_column_set_resizable( col, TRUE );
	gtk_tree_view_append_column( GTK_TREE_VIEW( widget ), col );

	rend = gtk_cell_renderer_toggle_new();
	col = gtk_tree_view_column_new_with_attributes( _( "Valid" ),
			rend, "active", SCREEM_XML_MODEL_VALID, NULL );
	gtk_tree_view_append_column( GTK_TREE_VIEW( widget ), col );
}

int main( int argc, char *argv[] )
{
	GtkWidget *window;
	GtkWidget *sw;
	GtkWidget *view;
	GtkTreeSelection *selection;
	
	xmlDocPtr doc;
	GtkTreeModel *model;
	
	gtk_init( &argc, &argv );

	if( argc == 1 ) {
		doc = xmlParseFile( "test.xml" );
	} else {
		doc = xmlParseFile( argv[ 1 ] );
	}
	model = screem_xml_model_new_with_doc( doc );

	window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	g_signal_connect( G_OBJECT( window ), "delete_event",
			gtk_main_quit, NULL );
	
	sw = gtk_scrolled_window_new( NULL, NULL );	
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( sw ),
					GTK_POLICY_AUTOMATIC, 
					GTK_POLICY_AUTOMATIC );
	gtk_scrolled_window_set_shadow_type( GTK_SCROLLED_WINDOW( sw ),
						GTK_SHADOW_IN );
	view = gtk_tree_view_new();
	gtk_tree_view_set_rules_hint( GTK_TREE_VIEW( view ), TRUE );
	gtk_tree_view_set_headers_visible( GTK_TREE_VIEW( view ),
					   TRUE );
	selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( view ) );
	gtk_tree_selection_set_mode( GTK_TREE_SELECTION( selection ),
			GTK_SELECTION_SINGLE );
	
	gtk_container_add( GTK_CONTAINER( sw ), view );
	
	gtk_container_add( GTK_CONTAINER( window ), sw );

	set_columns( view );
	
	gtk_tree_view_set_model( GTK_TREE_VIEW( view ), model );
	g_object_unref( model );
	
	gtk_window_set_default_size( GTK_WINDOW( window ), 300, 300 );
	gtk_window_set_title( GTK_WINDOW( window ), "Screem File Browser Test" );
	gtk_widget_show_all( window );

	
	gtk_main();
	
	return 0;

}
