#include <glib/gi18n.h>
#include <libgnomeui/libgnomeui.h>
#include <gtk/gtk.h>

#include <string.h>

#include "screem-file-browser.h"
#include "screem-icon-cache.h"

static void screem_site_view_set_columns( GtkWidget *widget )
{
	GtkCellRenderer *prenderer;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkTooltips *tip;

	/* column 1 */
	prenderer = gtk_cell_renderer_pixbuf_new();
	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new();
	
	gtk_tree_view_column_pack_start( column, prenderer, FALSE );
	gtk_tree_view_column_pack_start( column, renderer, TRUE );
	gtk_tree_view_column_set_resizable( column, TRUE );
	gtk_tree_view_append_column( GTK_TREE_VIEW( widget ), column );
	
	gtk_tree_view_column_set_attributes( column, renderer,
			"text", FILE_BROWSER_NAME_COL, NULL );
	gtk_tree_view_column_set_attributes( column, prenderer,
			"pixbuf", FILE_BROWSER_ICON_COL, NULL );
	
	gtk_tree_view_column_set_sort_column_id( column,
			FILE_BROWSER_NAME_COL );

	tip = gtk_tooltips_new();
	gtk_tooltips_set_tip( tip, column->button, _( "Site name" ),
			"" );
	gtk_tree_view_set_expander_column( GTK_TREE_VIEW( widget ), 
			column );

	/* column 2 */
	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new();
	
	gtk_tree_view_column_set_title( column, "" );
	gtk_tree_view_column_pack_start( column, renderer, TRUE );
	gtk_tree_view_append_column( GTK_TREE_VIEW( widget ), column );
	
	gtk_tree_view_column_set_attributes( column, renderer,
			"text", FILE_BROWSER_USER_COL, NULL );
	
	tip = gtk_tooltips_new();
	gtk_tooltips_set_tip( tip, column->button,
			_( "Site Operation Flags" ), "" );
	
	gtk_tree_view_columns_autosize( GTK_TREE_VIEW( widget ) );

}

static void screem_site_view_fm_expanded( GtkTreeView *view,
		GtkTreeIter *iter, GtkTreePath *path, gpointer data )
{
	ScreemFileBrowser *browser;
	GtkTreeModel *model;
	GtkTreeIter it;

	browser = SCREEM_FILE_BROWSER( data );
	
	model = gtk_tree_view_get_model( view );

	if( ! g_object_get_data( G_OBJECT( view ), "block" ) ) {
        	gtk_tree_model_filter_convert_iter_to_child_iter( GTK_TREE_MODEL_FILTER( model ), &it, iter );
        	screem_file_browser_scan_iter( browser, &it, -1 );

                g_object_set_data( G_OBJECT( view ), "block",
                                   GUINT_TO_POINTER( 1 ) );
                gtk_tree_view_expand_row( view, path, FALSE );
                g_object_set_data( G_OBJECT( view ), "block", NULL );
        }
}

static gboolean screem_site_view_filter_folders( GtkTreeModel *model,
		GtkTreeIter *iter, ScreemFileBrowser *browser )
{
	gboolean ret;
	const gchar *mime;
	
	ret = TRUE;

	mime = NULL;
	gtk_tree_model_get( model, iter, FILE_BROWSER_MIME_COL, &mime,
			-1 );
	if( mime ) {
		ret = ( ! strcmp( "x-directory/normal", mime ) );
	}
return TRUE;	
	return ret;
}


int main( int argc, char *argv[] )
{
        GnomeModuleInfo *libgnomeui;
	ScreemIconCache *cache;
	ScreemFileBrowser *browser;

	GtkWidget *window;
	GtkWidget *sw;
	GtkWidget *view;
	GtkTreeSelection *selection;
	
	GtkTreeModel *model;

	GtkTreeModel *filtered;
	
	libgnomeui = libgnomeui_module_info_get();

	gnome_program_init( "screem-browser-test", "0.0.1",
                            libgnomeui, argc, argv, NULL );

	cache = screem_icon_cache_new();
	browser = screem_file_browser_new( cache );

	screem_file_browser_set_mode( browser, FILE_BROWSE_NORMAL );
	screem_file_browser_scan_directory( browser, "/", -1 );
	
	window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	g_signal_connect( G_OBJECT( window ), "delete_event",
			gtk_main_quit, NULL );
	
	sw = gtk_scrolled_window_new( NULL, NULL );	
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( sw ),
					GTK_POLICY_AUTOMATIC, 
					GTK_POLICY_AUTOMATIC );
	gtk_scrolled_window_set_shadow_type( GTK_SCROLLED_WINDOW( sw ),
						GTK_SHADOW_IN );
	view = gtk_tree_view_new();
	gtk_tree_view_set_rules_hint( GTK_TREE_VIEW( view ), TRUE );
	gtk_tree_view_set_headers_visible( GTK_TREE_VIEW( view ),
					   TRUE );
	selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( view ) );
	gtk_tree_selection_set_mode( GTK_TREE_SELECTION( selection ),
			GTK_SELECTION_SINGLE );
	screem_site_view_set_columns( view );
	g_signal_connect( G_OBJECT( view ), "row_expanded",
			  G_CALLBACK( screem_site_view_fm_expanded ),
			  browser );
	
	gtk_container_add( GTK_CONTAINER( sw ), view );
	
	gtk_container_add( GTK_CONTAINER( window ), sw );
	
	model = screem_file_browser_get_model( browser );

	filtered = gtk_tree_model_filter_new( model, NULL );
	gtk_tree_model_filter_set_visible_func( GTK_TREE_MODEL_FILTER( filtered ),
			(GtkTreeModelFilterVisibleFunc)screem_site_view_filter_folders, browser, NULL );
	
	gtk_tree_view_set_model( GTK_TREE_VIEW( view ), filtered );
	g_object_unref( filtered );
	
	gtk_window_set_default_size( GTK_WINDOW( window ), 300, 300 );
	gtk_window_set_title( GTK_WINDOW( window ), "Screem File Browser Test" );
	gtk_widget_show_all( window );

	
	gtk_main();

	g_object_unref( browser );
	g_object_unref( cache );
	
	return 0;

}
