#ifndef SCREEM_TODO_H
#define SCREEM_TODO_H

#include <glib-object.h>

#include "screem-site.h"

#define SCREEM_TYPE_TODO            (screem_todo_get_type ())
#define SCREEM_TODO(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_TODO, ScreemTodo))
#define SCREEM_TODO_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_TODO, ScreemTodoClass))
#define SCREEM_IS_TODO(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_TODO))

typedef struct ScreemTodoPrivate ScreemTodoPrivate;

typedef struct ScreemTodoItem {
        gchar *task;
        gchar *assigned;
        gchar *priority;
        gchar *linked_to;
        gchar *description;
	gboolean complete;
} ScreemTodoItem;

typedef struct {
	GObject parent;

	ScreemTodoPrivate *private;
} ScreemTodo;

typedef struct {
	GObjectClass parent_class;

} ScreemTodoClass;


GType screem_todo_get_type( void );
ScreemTodo* screem_todo_new( ScreemSite *site );

void screem_todo_clear( ScreemTodo *todo );

/* yuk */
GList* screem_todo_get_tasks( ScreemTodo *todo );

void screem_todo_view( ScreemTodo *todo );

/* item related functions */
ScreemTodoItem* screem_todo_item_new();
ScreemTodoItem* screem_todo_item_new_with_values( const gchar *name, 
						  const gchar *assigned,
						  const gchar *priority, 
						  const gchar *linkedto,
						  const gchar *description,
						  gboolean complete );
void screem_todo_item_free( ScreemTodoItem *item );

void screem_todo_add_todo_item( ScreemTodo *todo, ScreemTodoItem *item );
void screem_todo_add_todo_item_with_values( ScreemTodo *todo,
					    const gchar *name,
					    const gchar *assigned,
					    const gchar *priority, 
					    const gchar *linkedto,
					    const gchar *description,
					    const gboolean complete );
					    
#endif
