#ifndef SCREEM_CTAGS_VIEW_H
#define SCREEM_CTAGS_VIEW_H

#include <gtk/gtktreeview.h>

#define SCREEM_TYPE_CTAGS_VIEW  (screem_ctags_view_get_type())
#define SCREEM_CTAGS_VIEW(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), SCREEM_TYPE_CTAGS_VIEW, \
                                                ScreemCtagsView ) )
#define SCREEM_CTAGS_VIEW_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST( ( klass ), \
                                                             SCREEM_TYPE_CTAGS_VIEW, \
                                                             ScreemCtagsViewClass ) )
#define SCREEM_IS_CTAGS_VIEW(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), SCREEM_TYPE_CTAGS_VIEW ) )

typedef struct ScreemCtagsViewPrivate ScreemCtagsViewPrivate;

typedef struct {
	GtkTreeView parent;
	
	ScreemCtagsViewPrivate *priv;
} ScreemCtagsView;

typedef struct {
	GtkTreeViewClass parent_class;

	void (*jumpto)( ScreemCtagsView *view,
			const gchar *filename,
			const gchar *pattern,
			guint line );

} ScreemCtagsViewClass;

GType screem_ctags_view_get_type( void );
ScreemCtagsView *screem_ctags_view_new( void );

#endif
