////////////////////////////////////////////////////////////////////////////////
//    Scorched3D (c) 2000-2009
//
//    This file is part of Scorched3D.
//
//    Scorched3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    Scorched3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Scorched3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////

#include <wx/defs.h>
#include <SDL/SDL_keysym.h>

struct KeyTranslationWx
{
	const char *keyName;
	unsigned int keySym;
	unsigned int wxKeySym;
} KeyTranslationTableWx [] =
{
    "UNKNOWN", SDLK_UNKNOWN, 0,
    "FIRST", SDLK_FIRST, 0,
    "BACKSPACE", SDLK_BACKSPACE, WXK_BACK,
    "TAB", SDLK_TAB,  WXK_TAB,
    "CLEAR", SDLK_CLEAR, WXK_CLEAR, 
    "RETURN", SDLK_RETURN, WXK_RETURN,
    "PAUSE", SDLK_PAUSE, WXK_PAUSE,
    "ESCAPE", SDLK_ESCAPE, WXK_ESCAPE,
    "SPACE", SDLK_SPACE, WXK_SPACE,
    "EXCLAIM", SDLK_EXCLAIM, '!',
    "QUOTEDBL", SDLK_QUOTEDBL, '"',
	"HASH", SDLK_HASH, '#',
    "DOLLAR", SDLK_DOLLAR, '$',
    "AMPERSAND", SDLK_AMPERSAND, '&',
    "QUOTE", SDLK_QUOTE, '\'',
    "LEFTPAREN", SDLK_LEFTPAREN, '[',
    "RIGHTPAREN", SDLK_RIGHTPAREN, ']',
    "ASTERISK", SDLK_ASTERISK, '*',
    "PLUS", SDLK_PLUS, '+',
    "COMMA", SDLK_COMMA, ',',
    "MINUS", SDLK_MINUS, '-',
    "PERIOD", SDLK_PERIOD, '.',
    "SLASH", SDLK_SLASH, '/',
    "0", SDLK_0, '0',
    "1", SDLK_1, '1',
    "2", SDLK_2, '2',
    "3", SDLK_3, '3',
    "4", SDLK_4, '4',
    "5", SDLK_5, '5',
    "6", SDLK_6, '6',
    "7", SDLK_7, '7',
    "8", SDLK_8, '8',
    "9", SDLK_9, '9',
    "COLON", SDLK_COLON, ':',
    "SEMICOLON", SDLK_SEMICOLON, ';',
    "LESS", SDLK_LESS, '<',
    "EQUALS", SDLK_EQUALS, '=',
    "GREATER", SDLK_GREATER, '>',
    "QUESTION", SDLK_QUESTION, '?',
    "AT", SDLK_AT, '@',
    "LEFTBRACKET", SDLK_LEFTBRACKET, '(',
    "BACKSLASH", SDLK_BACKSLASH, '\\',
    "RIGHTBRACKET", SDLK_RIGHTBRACKET, ')',
    "CARET", SDLK_CARET, '\'',
    "UNDERSCORE", SDLK_UNDERSCORE, '_',
    "BACKQUOTE", SDLK_BACKQUOTE, '`',
    "a", SDLK_a, 'A',
    "b", SDLK_b, 'B',
    "c", SDLK_c, 'C',
    "d", SDLK_d, 'D',
    "e", SDLK_e, 'E',
    "f", SDLK_f, 'F',
    "g", SDLK_g, 'G',
    "h", SDLK_h, 'H',
    "i", SDLK_i, 'I',
    "j", SDLK_j, 'J',
    "k", SDLK_k, 'K',
    "l", SDLK_l, 'L',
    "m", SDLK_m, 'M',
    "n", SDLK_n, 'N',
    "o", SDLK_o, 'O',
    "p", SDLK_p, 'P',
    "q", SDLK_q, 'Q',
    "r", SDLK_r, 'R',
    "s", SDLK_s, 'S',
    "t", SDLK_t, 'T',
    "u", SDLK_u, 'U',
    "v", SDLK_v, 'V',
    "w", SDLK_w, 'W',
    "x", SDLK_x, 'X',
    "y", SDLK_y, 'Y',
    "z", SDLK_z, 'Z',
    "DELETE", SDLK_DELETE, WXK_DELETE,
    "WORLD_0", SDLK_WORLD_0, 0,
    "WORLD_1", SDLK_WORLD_1, 0,
    "WORLD_2", SDLK_WORLD_2, 0,
    "WORLD_3", SDLK_WORLD_3, 0,
    "WORLD_4", SDLK_WORLD_4, 0,
    "WORLD_5", SDLK_WORLD_5, 0,
    "WORLD_6", SDLK_WORLD_6, 0,
    "WORLD_7", SDLK_WORLD_7, 0,
    "WORLD_8", SDLK_WORLD_8, 0,
    "WORLD_9", SDLK_WORLD_9, 0,
    "WORLD_10", SDLK_WORLD_10, 0,
    "WORLD_11", SDLK_WORLD_11, 0,
    "WORLD_12", SDLK_WORLD_12, 0,
    "WORLD_13", SDLK_WORLD_13, 0,
    "WORLD_14", SDLK_WORLD_14, 0,
    "WORLD_15", SDLK_WORLD_15, 0,
    "WORLD_16", SDLK_WORLD_16, 0,
    "WORLD_17", SDLK_WORLD_17, 0,
    "WORLD_18", SDLK_WORLD_18, 0,
    "WORLD_19", SDLK_WORLD_19, 0,
    "WORLD_20", SDLK_WORLD_20, 0,
    "WORLD_21", SDLK_WORLD_21, 0,
    "WORLD_22", SDLK_WORLD_22, 0,
    "WORLD_23", SDLK_WORLD_23, 0,
    "WORLD_24", SDLK_WORLD_24, 0,
    "WORLD_25", SDLK_WORLD_25, 0,
    "WORLD_26", SDLK_WORLD_26, 0,
    "WORLD_27", SDLK_WORLD_27, 0,
    "WORLD_28", SDLK_WORLD_28, 0,
    "WORLD_29", SDLK_WORLD_29, 0,
    "WORLD_30", SDLK_WORLD_30, 0,
    "WORLD_31", SDLK_WORLD_31, 0,
    "WORLD_32", SDLK_WORLD_32, 0,
    "WORLD_33", SDLK_WORLD_33, 0,
    "WORLD_34", SDLK_WORLD_34, 0,
    "WORLD_35", SDLK_WORLD_35, 0,
    "WORLD_36", SDLK_WORLD_36, 0,
    "WORLD_37", SDLK_WORLD_37, 0,
    "WORLD_38", SDLK_WORLD_38, 0,
    "WORLD_39", SDLK_WORLD_39, 0,
    "WORLD_40", SDLK_WORLD_40, 0,
    "WORLD_41", SDLK_WORLD_41, 0,
    "WORLD_42", SDLK_WORLD_42, 0,
    "WORLD_43", SDLK_WORLD_43, 0,
    "WORLD_44", SDLK_WORLD_44, 0,
    "WORLD_45", SDLK_WORLD_45, 0,
    "WORLD_46", SDLK_WORLD_46, 0,
    "WORLD_47", SDLK_WORLD_47, 0,
    "WORLD_48", SDLK_WORLD_48, 0,
    "WORLD_49", SDLK_WORLD_49, 0,
    "WORLD_50", SDLK_WORLD_50, 0,
    "WORLD_51", SDLK_WORLD_51, 0,
    "WORLD_52", SDLK_WORLD_52, 0,
    "WORLD_53", SDLK_WORLD_53, 0,
    "WORLD_54", SDLK_WORLD_54, 0,
    "WORLD_55", SDLK_WORLD_55, 0,
    "WORLD_56", SDLK_WORLD_56, 0,
    "WORLD_57", SDLK_WORLD_57, 0,
    "WORLD_58", SDLK_WORLD_58, 0,
    "WORLD_59", SDLK_WORLD_59, 0,
    "WORLD_60", SDLK_WORLD_60, 0,
    "WORLD_61", SDLK_WORLD_61, 0,
    "WORLD_62", SDLK_WORLD_62, 0,
    "WORLD_63", SDLK_WORLD_63, 0,
    "WORLD_64", SDLK_WORLD_64, 0,
    "WORLD_65", SDLK_WORLD_65, 0,
    "WORLD_66", SDLK_WORLD_66, 0,
    "WORLD_67", SDLK_WORLD_67, 0,
    "WORLD_68", SDLK_WORLD_68, 0,
    "WORLD_69", SDLK_WORLD_69, 0,
    "WORLD_70", SDLK_WORLD_70, 0,
    "WORLD_71", SDLK_WORLD_71, 0,
    "WORLD_72", SDLK_WORLD_72, 0,
    "WORLD_73", SDLK_WORLD_73, 0,
    "WORLD_74", SDLK_WORLD_74, 0,
    "WORLD_75", SDLK_WORLD_75, 0,
    "WORLD_76", SDLK_WORLD_76, 0,
    "WORLD_77", SDLK_WORLD_77, 0,
    "WORLD_78", SDLK_WORLD_78, 0,
    "WORLD_79", SDLK_WORLD_79, 0,
    "WORLD_80", SDLK_WORLD_80, 0,
    "WORLD_81", SDLK_WORLD_81, 0,
    "WORLD_82", SDLK_WORLD_82, 0,
    "WORLD_83", SDLK_WORLD_83, 0,
    "WORLD_84", SDLK_WORLD_84, 0,
    "WORLD_85", SDLK_WORLD_85, 0,
    "WORLD_86", SDLK_WORLD_86, 0,
    "WORLD_87", SDLK_WORLD_87, 0,
    "WORLD_88", SDLK_WORLD_88, 0,
    "WORLD_89", SDLK_WORLD_89, 0,
    "WORLD_90", SDLK_WORLD_90, 0,
    "WORLD_91", SDLK_WORLD_91, 0,
    "WORLD_92", SDLK_WORLD_92, 0,
    "WORLD_93", SDLK_WORLD_93, 0,
    "WORLD_94", SDLK_WORLD_94, 0,
    "WORLD_95", SDLK_WORLD_95, 0,
    "KP0", SDLK_KP0, WXK_NUMPAD0,
    "KP1", SDLK_KP1, WXK_NUMPAD1,
    "KP2", SDLK_KP2, WXK_NUMPAD2,
    "KP3", SDLK_KP3, WXK_NUMPAD3,
    "KP4", SDLK_KP4, WXK_NUMPAD4,
    "KP5", SDLK_KP5, WXK_NUMPAD5,
    "KP6", SDLK_KP6, WXK_NUMPAD6,
    "KP7", SDLK_KP7, WXK_NUMPAD7,
    "KP8", SDLK_KP8, WXK_NUMPAD8,
    "KP9", SDLK_KP9, WXK_NUMPAD9,
    "KP_PERIOD", SDLK_KP_PERIOD, WXK_NUMPAD_DECIMAL,
    "KP_DIVIDE", SDLK_KP_DIVIDE, WXK_NUMPAD_DIVIDE,
    "KP_MULTIPLY", SDLK_KP_MULTIPLY, WXK_NUMPAD_MULTIPLY,
    "KP_MINUS", SDLK_KP_MINUS, WXK_NUMPAD_SUBTRACT,
    "KP_PLUS", SDLK_KP_PLUS, WXK_NUMPAD_ADD,
    "KP_ENTER", SDLK_KP_ENTER, WXK_NUMPAD_ENTER,
    "KP_EQUALS", SDLK_KP_EQUALS, WXK_NUMPAD_EQUAL,
    "UP", SDLK_UP, WXK_UP,
    "DOWN", SDLK_DOWN, WXK_DOWN,
    "RIGHT", SDLK_RIGHT, WXK_RIGHT,
    "LEFT", SDLK_LEFT, WXK_LEFT,
    "INSERT", SDLK_INSERT, WXK_INSERT,
    "HOME", SDLK_HOME, WXK_HOME,
    "END", SDLK_END, WXK_END,
    "PAGEUP", SDLK_PAGEUP, WXK_PAGEUP,
    "PAGEDOWN", SDLK_PAGEDOWN, WXK_PAGEDOWN,
    "F1", SDLK_F1, WXK_F1,
    "F2", SDLK_F2, WXK_F2,
    "F3", SDLK_F3, WXK_F3,
    "F4", SDLK_F4, WXK_F4,
    "F5", SDLK_F5, WXK_F5,
    "F6", SDLK_F6, WXK_F6,
    "F7", SDLK_F7, WXK_F7,
    "F8", SDLK_F8, WXK_F8,
    "F9", SDLK_F9, WXK_F9,
    "F10", SDLK_F10, WXK_F10,
    "F11", SDLK_F11, WXK_F11,
    "F12", SDLK_F12, WXK_F12,
    "F13", SDLK_F13, WXK_F13,
    "F14", SDLK_F14, WXK_F14,
    "F15", SDLK_F15, WXK_F15,
    "NUMLOCK", SDLK_NUMLOCK, WXK_NUMLOCK,
    "CAPSLOCK", SDLK_CAPSLOCK, WXK_CAPITAL,
    "SCROLLOCK", SDLK_SCROLLOCK, WXK_SCROLL,
    "RSHIFT", SDLK_RSHIFT, 0,
    "LSHIFT", SDLK_LSHIFT, WXK_SHIFT,
    "RCTRL", SDLK_RCTRL, 0,
    "LCTRL", SDLK_LCTRL, WXK_CONTROL,
    "RALT", SDLK_RALT, WXK_ALT,
    "LALT", SDLK_LALT, WXK_MENU,
    "RMETA", SDLK_RMETA, 0,
    "LMETA", SDLK_LMETA, 0,
    "LSUPER", SDLK_LSUPER, 0,
    "RSUPER", SDLK_RSUPER, 0,
    "MODE", SDLK_MODE, 0,
    "COMPOSE", SDLK_COMPOSE, 0,
    "HELP", SDLK_HELP, WXK_HELP,
    "PRINT", SDLK_PRINT, WXK_PRINT,
    "SYSREQ", SDLK_SYSREQ, 0,
    "BREAK", SDLK_BREAK, 0,
    "MENU", SDLK_MENU, WXK_MENU,
    "POWER", SDLK_POWER, 0,
    "EURO", SDLK_EURO, 0,
    "UNDO", SDLK_UNDO, 0,
    "LAST", SDLK_LAST, 0
};
