/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.sprite;

/**
 * @author Pierre Lando
 */
public interface Sprite {

    /**
     * Set the sprite drawer and cause this sprite to be redrawn.
     * @param drawer the new sprite drawer.
     */
    void setDrawer(SpriteDrawer drawer);

    /**
     * Return the current sprite drawer.
     * @return the current sprite drawer.
     */
    SpriteDrawer getDrawer();

    /**
     * Cause this sprite to be redrawn.
     */
    void redraw();

    /**
     * Return the sprite width.
     * @return the sprite width.
     */
    int getWidth();

    /**
     * Return the sprite height.
     * @return the sprite height.
     */
    int getHeight();
}
