/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2011 - DIGITEO - Manuel Juliachs
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.implementation.jogl.sprite;

import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvas;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.sprite.SpriteAnchorPosition;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

/**
 * JoGL implementation of a rotatable sprite.
 *
 * @author Manuel Juliachs
 */
class JoGLRotatableSprite extends JoGLSprite {

    /**
     * The sprite renderer.
     */
    private RotatableRenderer spriteRenderer;

    /**
     * Default constructor.
     * The constructor is package: only {@link JoGLSpriteManager} can instantiate this object.
     * @param canvas the current canvas.
     * @param width  sprite width.
     * @param height sprite height.
     */
    JoGLRotatableSprite(JoGLCanvas canvas, int width, int height) {
        super(canvas, width, height);
    }

    /**
     * Draw this sprite with the given drawing tools at the given position with the given rotation angle.
     * @param drawingTools the drawing tools to use.
     * @param anchor anchor position.
     * @param positions the position.
     * @param rotationAngle the rotation angle.
     */
    void draw(JoGLDrawingTools drawingTools, SpriteAnchorPosition anchor, ElementsBuffer positions, double rotationAngle) {
        getRenderer(drawingTools).draw(drawingTools, anchor, positions, rotationAngle);
    }

    /**
     * Draw this sprite with the given drawing tools at the given position with the given rotation angle.
     * @param drawingTools the drawing tools to use.
     * @param anchor anchor position.
     * @param position the position.
     * @param rotationAngle the rotation angle.
     */
    public void draw(JoGLDrawingTools drawingTools, SpriteAnchorPosition anchor, Vector3d position, double rotationAngle) {
        getRenderer(drawingTools).draw(drawingTools, anchor, position, rotationAngle);
    }

    /**
     * Return the sprite implementation.
     * @param drawingTools the drawing tools.
     * @return the sprite implementation.
     */
    private RotatableRenderer getRenderer(JoGLDrawingTools drawingTools) {
        if (spriteRenderer == null) {
            spriteRenderer = new RotatableQuadsTextureRenderer(this);
        }
        return spriteRenderer;
    }
}
