/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 * Copyright (C) 2011 - DIGITEO - Manuel Juliachs
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.implementation.jogl.sprite;

import java.nio.Buffer;
import java.nio.ByteBuffer;

import javax.media.opengl.GL;

import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.implementation.jogl.utils.texture.TextureBufferedImage;
import org.scilab.forge.scirenderer.sprite.SpriteAnchorPosition;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

/**
 * @author Pierre Lando
 * @author Manuel Juliachs
 */
abstract class AbstractRotatableTextureRenderer extends AbstractTextureRenderer implements RotatableRenderer {

    /**
     * Default constructor.
     * @param sprite the sprite this renderer draws.
     * @param squareTexture true if the texture should be a square.
     */
    AbstractRotatableTextureRenderer(JoGLSprite sprite, boolean squareTexture) {
        super(sprite, squareTexture);
    }


    @Override
    public void draw(JoGLDrawingTools drawingTools, SpriteAnchorPosition anchor, Vector3d position) {
        ElementsBuffer positions = drawingTools.getCanvas().getBuffersManager().createElementsBuffer();
        positions.setData(position.getDataAsFloatArray(), 3);
        draw(drawingTools, anchor, positions);
        drawingTools.getCanvas().getBuffersManager().dispose(positions);
    }

    @Override
    public void draw(JoGLDrawingTools drawingTools, SpriteAnchorPosition anchor, Vector3d position, double rotationAngle) {
        ElementsBuffer positions = drawingTools.getCanvas().getBuffersManager().createElementsBuffer();
        positions.setData(position.getDataAsFloatArray(), 3);
        draw(drawingTools, anchor, positions, rotationAngle);
        drawingTools.getCanvas().getBuffersManager().dispose(positions);
    }
}
