/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2012 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */
package org.scilab.forge.scirenderer.examples.textureExample;

import com.sun.opengl.util.Animator;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvasFactory;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;

import javax.media.opengl.GLJPanel;
import javax.swing.JFrame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * @author Pierre Lando
 */
public class TextureExample {

    public static void main(String[] arguments) {
        JFrame frame = new JFrame("JoGLCanvas");
        frame.setSize(800, 600);

        GLJPanel panel = new GLJPanel();
        frame.add(panel);
        final ClickCounter clickCounter = new ClickCounter();
        panel.addMouseListener(clickCounter);

        Canvas canvas = JoGLCanvasFactory.createCanvas(panel);

        final Geometry geometry1 = new SimpleGeometry(canvas);
        final Geometry geometry2 = new LessSimpleGeometry(canvas);

        Texture texture1 = canvas.getTextureManager().createTexture();
        texture1.setDataProvider(new Simple2DTextureDataProvider());
        final Appearance appearance1 = new Appearance();
        appearance1.setTexture(texture1);

        Texture texture2 = canvas.getTextureManager().createTexture();
        texture2.setDataProvider(new Simple1DTextureDataProvider());
        final Appearance appearance2 = new Appearance();
        appearance2.setTexture(texture2);

        canvas.setMainDrawer(new Drawer() {

            int v = 0;

            @Override
            public void draw(DrawingTools dt) {
                dt.clear(new Color(.2f, .3f, .4f));

                try {
                    Transformation projection = TransformationFactory.getPreferredAspectRatioTransformation(dt.getCanvas().getDimension(), 1f);
                    dt.getTransformationManager().getProjectionStack().push(projection);
                    dt.getTransformationManager().getModelViewStack().push(TransformationFactory.getScaleTransformation(Math.sqrt(2) / 2));
                    dt.getTransformationManager().getModelViewStack().pushRightMultiply(TransformationFactory.getRotationTransformation(v, 1, 2, 3));
                    v++;

                    if (clickCounter.getCount() % 2 == 0) {
                        dt.draw(geometry1, appearance1);
                    } else {
                        dt.draw(geometry2, appearance2);
                    }
                } catch (SciRendererException ignored) {
                    // Should not occur.
                }
            }
        });


        Animator animator = new Animator();
        animator.add(panel);
        animator.start();

        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
    
    private static class ClickCounter extends MouseAdapter {
        private int count = 0;
        
        @Override
        public void mousePressed(MouseEvent e) {
            count ++;
        }
        
        public int getCount() {
            return count;
        }
    }
}
