/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2012 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.textureExample;

import org.scilab.forge.scirenderer.texture.AbstractDataProvider;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDataProvider;

import java.awt.Dimension;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Date;

/**
 * @author Pierre Lando
 */
public class Simple1DTextureDataProvider extends AbstractDataProvider<Texture> implements TextureDataProvider {
    private final int size = 16;
    private FloatBuffer buffer;

    public Simple1DTextureDataProvider() {
        this.buffer = FloatBuffer.allocate(4 * size);  // 4 for RGBA.
        buffer.rewind();
        new SimpleThread().start();
    }

    private void fillBuffer() {
        double phi = Math.PI * 2 / 1024;
        long time = new Date().getTime();
        long base = (int) ((time / 4) % 1024);
        FloatBuffer buffer = FloatBuffer.allocate(4 * size);
        buffer.rewind();
        int k = 0;
        for(int i = 0 ; i < size ; i++) {
            buffer.put((float) (Math.sin(base * phi) + 1) / 2);
            buffer.put((float) (Math.sin(2 * base * phi + i) + 1) / 2);
            buffer.put((float) (Math.sin(base * phi + i) + 1) / 2);
            buffer.put(1);
            k++;
        }
        buffer.rewind();
        this.buffer = buffer;
    }

    @Override
    public Dimension getTextureSize() {
        return new Dimension(size, 1);
    }

    @Override
    public Buffer getData() {
        buffer.rewind();
        return buffer;
    }

    @Override
    public Buffer getSubData(int x, int y, final int width, final int height) {
        FloatBuffer buffer = FloatBuffer.allocate(4 * width * height);
        this.buffer.position(x + y * size);
        for (int i = x ; i < x + width ; i++) {
            for (int j = y ; j < y + height ; j++) {
                buffer.put(this.buffer.get(new float[4]));
            }
        }
        buffer.rewind();
        this.buffer.rewind();
        return buffer;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private class SimpleThread extends Thread {
        @Override
        public void run() {
            for (;;) {
                fillBuffer();
                fireUpdate();
                try {
                    synchronized (this) {
                        wait(32);
                    }
                } catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}
