/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2012 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.textureExample;

import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

/**
 * @author Pierre Lando
 */
public class LessSimpleGeometry extends DefaultGeometry implements Geometry {
    private static final int size = 65;
    private static final double halfSize = size / 2.;

    public LessSimpleGeometry(Canvas canvas) {
        int k;
        ElementsBuffer vertices = canvas.getBuffersManager().createElementsBuffer();
        float[] verticesData = new float [size * size * 4];
        k = 0;
        for (int i = 0; i < size ; i ++) {
            for (int j = 0; j < size ; j ++) {
                double x = 2 * (i / (size - 1f) - .5);
                double y = 2 * (j / (size - 1f) - .5);
                double d = Math.max(Math.abs(x), Math.abs(y));
                Vector3d v = new Vector3d(x, y, 0).getNormalized().times(d);
                verticesData[k++] = (float) v.getX();
                verticesData[k++] = (float) v.getY();
                verticesData[k++] = 0;
                verticesData[k++] = 1;
            }
        }

        vertices.setData(verticesData, 4);

        ElementsBuffer textureCoordinates =  canvas.getBuffersManager().createElementsBuffer();
        float[] textureCoordinatesData = new float[size * size];
        k = 0;
        for (int i = 0; i < size ; i ++) {
            for (int j = 0; j < size ; j ++) {
                double v = Math.sqrt(Math.pow(i - halfSize, 2) + Math.pow(j - halfSize, 2));
                v = (Math.sin(4 * Math.PI * v / size) + 1) / 2;
                textureCoordinatesData[k++] = (float) v;
            }
        }
        textureCoordinates.setData(textureCoordinatesData, 1);

        IndicesBuffer indices = canvas.getBuffersManager().createIndicesBuffer();
        int[] indicesData = new int [6 * (size - 1) * (size - 1)];
        k = 0;
        int u = 0;
        for (int i = 0; i < size - 1; i ++) {
            for (int j = 0; j < size - 1; j ++) {
                indicesData[k++] = u;
                indicesData[k++] = u + 1;
                indicesData[k++] = u + size + 1;
                indicesData[k++] = u;
                indicesData[k++] = u + size + 1;
                indicesData[k++] = u + size;
                u++;
            }
            u++;
        }
        indices.setData(indicesData);

        setFillDrawingMode(FillDrawingMode.TRIANGLES);
        setVertices(vertices);
        setIndices(indices);
        setTextureCoordinates(textureCoordinates);
    }
}
