/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */
package org.scilab.forge.scirenderer.examples.simpleRotatingCube;

import com.sun.opengl.util.Animator;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvasFactory;
import org.scilab.forge.scirenderer.renderer.Renderer;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.tranformations.DegenerateMatrixException;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.utils.shapes.geometry.CubeFactory;

import javax.media.opengl.GLJPanel;
import javax.swing.JFrame;
import java.awt.event.MouseListener;

/**
 * @author Pierre Lando
 */
public class SimpleRotatingCube {



    public static void main(String[] arguments) {

        JFrame frame = new JFrame("JoGLCanvas");
        frame.setSize(800, 600);

        GLJPanel panel = new GLJPanel();

        Animator animator = new Animator();
        animator.add(panel);

        animator.start();

        frame.add(panel);


        Canvas canvas = JoGLCanvasFactory.createCanvas(panel);

        /**
         * Add a {@link MouseUnprojectAdapter}
         */
        MouseListener mua = new MouseUnprojectAdapter(canvas);
        panel.addMouseListener(mua);

        final Geometry cube = CubeFactory.createCube(canvas);

        final Renderer myRenderer = canvas.getRendererManager().createRenderer();
        myRenderer.setDrawer(new Drawer() {
            @Override
            public void draw(DrawingTools dt) {
                try {
                    dt.draw(cube);
                } catch (SciRendererException ignored) {
                }
            }
        });

        canvas.setMainDrawer(new Drawer() {

            int v = 0;

            @Override
            public void draw(DrawingTools dt) {
                dt.clear(new Color(.2f, .3f, .4f));

                try {
                    Transformation projection = TransformationFactory.getPreferredAspectRatioTransformation(dt.getCanvas().getDimension(), 1f);
                    dt.getTransformationManager().getProjectionStack().push(projection);
                    dt.getTransformationManager().getModelViewStack().push(TransformationFactory.getScaleTransformation(.1, .1, .1));
                    dt.getTransformationManager().getModelViewStack().pushRightMultiply(TransformationFactory.getRotationTransformation(v, 1, 2, 3));
                } catch (DegenerateMatrixException ignored) {
                    // Should not occur.
                }

                v++;

                dt.draw(myRenderer);
            }
        });

        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
