/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.rulerExample;

import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.ruler.RulerDrawer;
import org.scilab.forge.scirenderer.ruler.RulerModel;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.tranformations.DegenerateMatrixException;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;

import javax.swing.BoundedRangeModel;

/**
 * @author Pierre Lando
 */
public class RulerExampleDrawer implements Drawer {

    private final RulerDrawer rulerDrawer;
    private final RulerModel rulerModel;
    private final BoundedRangeModel zoomLevel;

    public RulerExampleDrawer(Canvas canvas, BoundedRangeModel zoomLevel, RulerModel rulerModel) {
        this.zoomLevel = zoomLevel;
        this.rulerModel = rulerModel;
        this.rulerDrawer = new RulerDrawer(canvas.getSpriteManager());
    }

    @Override
    public void draw(DrawingTools dt) {
        dt.clear(new Color(1f, 1f, 1f));

        try {
            Transformation projection = TransformationFactory.getPreferredAspectRatioTransformation(dt.getCanvas().getDimension(), 1f);
            dt.getTransformationManager().getProjectionStack().push(projection);
            dt.getTransformationManager().getModelViewStack().pushRightMultiply(TransformationFactory.getScaleTransformation(zoomLevel.getValue() / 100.0));

        } catch (DegenerateMatrixException ignored) {
            // Should not occur.
        }

        try {
            rulerDrawer.draw(dt, rulerModel);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}
