/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.milkDrop;

import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.examples.utils.MouseRotationAdapter;
import org.scilab.forge.scirenderer.ruler.DefaultRulerModel;
import org.scilab.forge.scirenderer.ruler.RulerDrawer;
import org.scilab.forge.scirenderer.ruler.RulerModel;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

/**
 * @author Pierre Lando
 */
public class MilkDropDrawer implements Drawer {
    private final RulerDrawer rulerDrawer;
    private final Geometry milkDrop;
    private final MouseRotationAdapter mra;

    private DefaultRulerModel xRulerModel;
    private DefaultRulerModel yRulerModel;
    private DefaultRulerModel zRulerModel;


    public MilkDropDrawer(Canvas canvas, MouseRotationAdapter mra) {
        rulerDrawer = new RulerDrawer(canvas.getSpriteManager());

        milkDrop = MilkDropFactory.createMilkDrop(canvas);
        this.mra = mra;
    }

    @Override
    public void draw(DrawingTools dt) {
        dt.clear(new Color(1f, 1f, 1f));

        try {
            Transformation projection = TransformationFactory.getPreferredAspectRatioTransformation(dt.getCanvas().getDimension(), 1f);
            dt.getTransformationManager().getProjectionStack().push(projection);
            dt.getTransformationManager().getModelViewStack().pushRightMultiply(TransformationFactory.getScaleTransformation(.05, .05, .05));
            dt.getTransformationManager().getModelViewStack().pushRightMultiply(TransformationFactory.getRotationTransformation(mra.getRotation()));
            dt.draw(milkDrop);
        } catch (SciRendererException ignored) {
            // Should not occur.
        }

        rulerDrawer.draw(dt, getXRulerModel());
        rulerDrawer.draw(dt, getYRulerModel());
        rulerDrawer.draw(dt, getZRulerModel());
    }


    public RulerModel getXRulerModel() {
        if (xRulerModel == null) {
            xRulerModel = new DefaultRulerModel();
            xRulerModel.setFirstPoint(new Vector3d(-10, 10, 0));
            xRulerModel.setSecondPoint(new Vector3d(10, 10, 0));
            xRulerModel.setValues(-10, 10);
            xRulerModel.setLineVisible(true);
            xRulerModel.setTicksDirection(new Vector3d(0,1,0));
        }
        return xRulerModel;
    }

    public RulerModel getYRulerModel() {
        if (yRulerModel == null) {
            yRulerModel = new DefaultRulerModel();
            yRulerModel.setFirstPoint(new Vector3d(10, -10, 0));
            yRulerModel.setSecondPoint(new Vector3d(10, 10, 0));
            yRulerModel.setValues(-10, 10);
            yRulerModel.setLineVisible(true);
            yRulerModel.setTicksDirection(new Vector3d(1,0,0));
        }
        return yRulerModel;
    }

    public RulerModel getZRulerModel() {
        if (zRulerModel == null) {
            zRulerModel = new DefaultRulerModel();
            zRulerModel.setFirstPoint(new Vector3d(10, 10, 10));
            zRulerModel.setSecondPoint(new Vector3d(10, 10, -10));
            zRulerModel.setValues(-10, 10);
            zRulerModel.setLineVisible(true);
            zRulerModel.setTicksDirection(new Vector3d(1,1,0));
        }
        return zRulerModel;
    }
}
