/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.jlatex;

import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.sprite.Sprite;
import org.scilab.forge.scirenderer.sprite.SpriteAnchorPosition;
import org.scilab.forge.scirenderer.sprite.SpriteDrawer;
import org.scilab.forge.scirenderer.sprite.SpriteDrawingTools;
import org.scilab.forge.scirenderer.tranformations.DegenerateMatrixException;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

/**
 * @author Pierre Lando
 */
public class LatexDrawer implements Drawer, LatexCompositorListener {


    private final Canvas canvas;
    private Sprite sprite;

    public LatexDrawer(Canvas canvas) {
        this.canvas = canvas;
        sprite =  null;
    }

    @Override
    public void draw(DrawingTools drawingTools) {
        drawingTools.clear(new Color(.2f, .3f, .4f));

        try {
            Transformation projection = TransformationFactory.getPreferredAspectRatioTransformation(drawingTools.getCanvas().getDimension(), 1f);
            drawingTools.getTransformationManager().getProjectionStack().push(projection);
            drawingTools.getTransformationManager().getModelViewStack().push(TransformationFactory.getScaleTransformation(.1, .1, .1));
        } catch (DegenerateMatrixException ignored) {
            // Should not occur.
        }

        if (sprite != null) {
            drawingTools.draw(sprite, SpriteAnchorPosition.CENTER, new Vector3d(0, 0, 0));
        }
    }

    @Override
    public void DataChanged(LatexCompositor compositor) {

        final TeXIcon ti = compositor.getTextIcon();
        canvas.getSpriteManager().dispose(sprite);
        sprite = null;
        if (ti != null) {
            ti.setForeground(java.awt.Color.WHITE);

            sprite = canvas.getSpriteManager().createSprite(ti.getIconWidth(), ti.getIconHeight());
            sprite.setDrawer(new SpriteDrawer() {

                @Override
                public void draw(SpriteDrawingTools drawingTools) {
                    drawingTools.clear(new Color(0, 0, 0));
                    drawingTools.draw(ti, -(ti.getIconWidth() / 2), -(ti.getIconHeight() / 2));
                }

                @Override
                public OriginPosition getOriginPosition() {
                    return OriginPosition.CENTER;
                }
            });
        }
    }
}
