/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.depthtest;

/**
 *
 * Interface for the depth test manager.
 *
 * @author Pierre Lando
 */
public interface DepthTestManager {

    /**
     * The default auto clear depth buffer status.
     */
    boolean DEFAULT_AUTO_CLEAR_DEPTH_BUFFER_STATUS = true;


    /**
     * Return the auto clear depth buffer status.
     * If the auto clear depth buffer is enable, the depth buffer will be clear before all
     * call to the canvas main drawer.
     * @return the auto clear depth buffer status.
     */
    boolean isAutoClearDepthBufferEnable();

    /**
     * Set the auto clear depth buffer status.
     * @param status the new auto clear depth buffer status.
     */
    void setAutoClearDepthBufferEnable(boolean status);
}
