#include "SegsArrowDrawerGL.hxx"
/* Generated by GIWS (version 2.0.0) with command:
giws --disable-return-size-array --output-dir src/jni/ --throws-exception-on-error --description-file src/jni/SegsArrowDrawerGL.giws.xml 
*/
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO
Copyright 2011-2012 Scilab Enterprises

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_renderer_segsDrawing {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * SegsArrowDrawerGL::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

SegsArrowDrawerGL::~SegsArrowDrawerGL() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors
SegsArrowDrawerGL::SegsArrowDrawerGL(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voiddisplayID=NULL;
voidinitializeDrawingjintintID=NULL;
voidendDrawingID=NULL;
voidshowjintintID=NULL;
voiddestroyjintintID=NULL;
voidsetArrowSizejdoubledoubleID=NULL;
voidsetIsSegsjbooleanbooleanID=NULL;
voidsetAxesBoundsjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID=NULL;
voiddrawSegsjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejintArray_intintID=NULL;
voiddrawSegsID=NULL;


}

SegsArrowDrawerGL::SegsArrowDrawerGL(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voiddisplayID=NULL;
voidinitializeDrawingjintintID=NULL;
voidendDrawingID=NULL;
voidshowjintintID=NULL;
voiddestroyjintintID=NULL;
voidsetArrowSizejdoubledoubleID=NULL;
voidsetIsSegsjbooleanbooleanID=NULL;
voidsetAxesBoundsjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID=NULL;
voiddrawSegsjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejintArray_intintID=NULL;
voiddrawSegsID=NULL;


}

// Generic methods

void SegsArrowDrawerGL::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "SegsArrowDrawerGL");
}
}

void SegsArrowDrawerGL::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "SegsArrowDrawerGL");
}
}
// Method(s)

void SegsArrowDrawerGL::display (){

JNIEnv * curEnv = getCurrentEnv();

if (voiddisplayID==NULL) { /* Use the cache */
 voiddisplayID = curEnv->GetMethodID(this->instanceClass, "display", "()V" ) ;
if (voiddisplayID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "display");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddisplayID );
                        
}

void SegsArrowDrawerGL::initializeDrawing (int figureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidinitializeDrawingjintintID==NULL) { /* Use the cache */
 voidinitializeDrawingjintintID = curEnv->GetMethodID(this->instanceClass, "initializeDrawing", "(I)V" ) ;
if (voidinitializeDrawingjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "initializeDrawing");
}
}
                         curEnv->CallVoidMethod( this->instance, voidinitializeDrawingjintintID ,figureIndex);
                        
}

void SegsArrowDrawerGL::endDrawing (){

JNIEnv * curEnv = getCurrentEnv();

if (voidendDrawingID==NULL) { /* Use the cache */
 voidendDrawingID = curEnv->GetMethodID(this->instanceClass, "endDrawing", "()V" ) ;
if (voidendDrawingID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "endDrawing");
}
}
                         curEnv->CallVoidMethod( this->instance, voidendDrawingID );
                        
}

void SegsArrowDrawerGL::show (int figureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidshowjintintID==NULL) { /* Use the cache */
 voidshowjintintID = curEnv->GetMethodID(this->instanceClass, "show", "(I)V" ) ;
if (voidshowjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "show");
}
}
                         curEnv->CallVoidMethod( this->instance, voidshowjintintID ,figureIndex);
                        
}

void SegsArrowDrawerGL::destroy (int parentFigureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voiddestroyjintintID==NULL) { /* Use the cache */
 voiddestroyjintintID = curEnv->GetMethodID(this->instanceClass, "destroy", "(I)V" ) ;
if (voiddestroyjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "destroy");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddestroyjintintID ,parentFigureIndex);
                        
}

void SegsArrowDrawerGL::setArrowSize (double size){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetArrowSizejdoubledoubleID==NULL) { /* Use the cache */
 voidsetArrowSizejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "setArrowSize", "(D)V" ) ;
if (voidsetArrowSizejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setArrowSize");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetArrowSizejdoubledoubleID ,size);
                        
}

void SegsArrowDrawerGL::setIsSegs (bool isSegs){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetIsSegsjbooleanbooleanID==NULL) { /* Use the cache */
 voidsetIsSegsjbooleanbooleanID = curEnv->GetMethodID(this->instanceClass, "setIsSegs", "(Z)V" ) ;
if (voidsetIsSegsjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setIsSegs");
}
}
jboolean isSegs_ = (static_cast<bool>(isSegs) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallVoidMethod( this->instance, voidsetIsSegsjbooleanbooleanID ,isSegs_);
                        
}

void SegsArrowDrawerGL::setAxesBounds (double xMin, double xMax, double yMin, double yMax, double zMin, double zMax){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetAxesBoundsjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID==NULL) { /* Use the cache */
 voidsetAxesBoundsjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID = curEnv->GetMethodID(this->instanceClass, "setAxesBounds", "(DDDDDD)V" ) ;
if (voidsetAxesBoundsjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setAxesBounds");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetAxesBoundsjdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoublejdoubledoubleID ,xMin, xMax, yMin, yMax, zMin, zMax);
                        
}

void SegsArrowDrawerGL::drawSegs (double const* startXCoords, int startXCoordsSize, double const* endXCoords, int endXCoordsSize, double const* startYCoords, int startYCoordsSize, double const* endYCoords, int endYCoordsSize, double const* startZCoords, int startZCoordsSize, double const* endZCoords, int endZCoordsSize, int const* colors, int colorsSize){

JNIEnv * curEnv = getCurrentEnv();

if (voiddrawSegsjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejintArray_intintID==NULL) { /* Use the cache */
 voiddrawSegsjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejintArray_intintID = curEnv->GetMethodID(this->instanceClass, "drawSegs", "([D[D[D[D[D[D[I)V" ) ;
if (voiddrawSegsjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "drawSegs");
}
}
jdoubleArray startXCoords_ = curEnv->NewDoubleArray( startXCoordsSize ) ;

if (startXCoords_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( startXCoords_, 0, startXCoordsSize, (jdouble*)(startXCoords) ) ;


jdoubleArray endXCoords_ = curEnv->NewDoubleArray( endXCoordsSize ) ;

if (endXCoords_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( endXCoords_, 0, endXCoordsSize, (jdouble*)(endXCoords) ) ;


jdoubleArray startYCoords_ = curEnv->NewDoubleArray( startYCoordsSize ) ;

if (startYCoords_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( startYCoords_, 0, startYCoordsSize, (jdouble*)(startYCoords) ) ;


jdoubleArray endYCoords_ = curEnv->NewDoubleArray( endYCoordsSize ) ;

if (endYCoords_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( endYCoords_, 0, endYCoordsSize, (jdouble*)(endYCoords) ) ;


jdoubleArray startZCoords_ = curEnv->NewDoubleArray( startZCoordsSize ) ;

if (startZCoords_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( startZCoords_, 0, startZCoordsSize, (jdouble*)(startZCoords) ) ;


jdoubleArray endZCoords_ = curEnv->NewDoubleArray( endZCoordsSize ) ;

if (endZCoords_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( endZCoords_, 0, endZCoordsSize, (jdouble*)(endZCoords) ) ;


jintArray colors_ = curEnv->NewIntArray( colorsSize ) ;

if (colors_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( colors_, 0, colorsSize, (jint*)(colors) ) ;


                         curEnv->CallVoidMethod( this->instance, voiddrawSegsjdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejdoubleArray_doubledoublejintArray_intintID ,startXCoords_, endXCoords_, startYCoords_, endYCoords_, startZCoords_, endZCoords_, colors_);
                        curEnv->DeleteLocalRef(startXCoords_);
curEnv->DeleteLocalRef(endXCoords_);
curEnv->DeleteLocalRef(startYCoords_);
curEnv->DeleteLocalRef(endYCoords_);
curEnv->DeleteLocalRef(startZCoords_);
curEnv->DeleteLocalRef(endZCoords_);
curEnv->DeleteLocalRef(colors_);

}

void SegsArrowDrawerGL::drawSegs (){

JNIEnv * curEnv = getCurrentEnv();

if (voiddrawSegsID==NULL) { /* Use the cache */
 voiddrawSegsID = curEnv->GetMethodID(this->instanceClass, "drawSegs", "()V" ) ;
if (voiddrawSegsID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "drawSegs");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddrawSegsID );
                        
}

}
