#include "Xcos.hxx"
/* Generated by GIWS (version 1.3.0) */
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_xcos {

// Returns the current env

JNIEnv * Xcos::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

Xcos::~Xcos() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors
Xcos::Xcos(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voidxcosID=NULL;
voidxcosjstringjava_lang_StringID=NULL;
voidwarnCellByUIDjobjectArray_java_lang_Stringjstringjava_lang_StringID=NULL;
voidcloseXcosFromScilabID=NULL;
jintxcosDiagramToHDF5jstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID=NULL;
voidxcosDiagramOpenjobjectArray_java_lang_StringID=NULL;
voidxcosDiagramClosejobjectArray_java_lang_StringID=NULL;


}

Xcos::Xcos(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voidxcosID=NULL;
voidxcosjstringjava_lang_StringID=NULL;
voidwarnCellByUIDjobjectArray_java_lang_Stringjstringjava_lang_StringID=NULL;
voidcloseXcosFromScilabID=NULL;
jintxcosDiagramToHDF5jstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID=NULL;
voidxcosDiagramOpenjobjectArray_java_lang_StringID=NULL;
voidxcosDiagramClosejobjectArray_java_lang_StringID=NULL;


}

// Generic methods

void Xcos::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "Xcos");
}
}

void Xcos::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "Xcos");
}
}
// Method(s)

void Xcos::xcos (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidxcosID = curEnv->GetStaticMethodID(cls, "xcos", "()V" ) ;
if (voidxcosID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcos");
}

                         curEnv->CallStaticVoidMethod(cls, voidxcosID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::xcos (JavaVM * jvm_, char * fileName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidxcosjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "xcos", "(Ljava/lang/String;)V" ) ;
if (voidxcosjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcos");
}

jstring fileName_ = curEnv->NewStringUTF( fileName );
if (fileName != NULL && fileName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidxcosjstringjava_lang_StringID ,fileName_);
                        curEnv->DeleteLocalRef(fileName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::warnCellByUID (JavaVM * jvm_, char ** uids, int uidsSize, char * message){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidwarnCellByUIDjobjectArray_java_lang_Stringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "warnCellByUID", "([Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidwarnCellByUIDjobjectArray_java_lang_Stringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "warnCellByUID");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray uids_ = curEnv->NewObjectArray( uidsSize, stringArrayClass, NULL);
if (uids_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < uidsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( uids[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( uids_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
jstring message_ = curEnv->NewStringUTF( message );
if (message != NULL && message_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidwarnCellByUIDjobjectArray_java_lang_Stringjstringjava_lang_StringID ,uids_, message_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(uids_);
curEnv->DeleteLocalRef(message_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::closeXcosFromScilab (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcloseXcosFromScilabID = curEnv->GetStaticMethodID(cls, "closeXcosFromScilab", "()V" ) ;
if (voidcloseXcosFromScilabID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "closeXcosFromScilab");
}

                         curEnv->CallStaticVoidMethod(cls, voidcloseXcosFromScilabID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int Xcos::xcosDiagramToHDF5 (JavaVM * jvm_, char * xcosFile, char * h5File, bool forceOverwrite){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintxcosDiagramToHDF5jstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "xcosDiagramToHDF5", "(Ljava/lang/String;Ljava/lang/String;Z)I" ) ;
if (jintxcosDiagramToHDF5jstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcosDiagramToHDF5");
}

jstring xcosFile_ = curEnv->NewStringUTF( xcosFile );
if (xcosFile != NULL && xcosFile_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring h5File_ = curEnv->NewStringUTF( h5File );
if (h5File != NULL && h5File_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean forceOverwrite_ = (static_cast<bool>(forceOverwrite) ? JNI_TRUE : JNI_FALSE);

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintxcosDiagramToHDF5jstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID ,xcosFile_, h5File_, forceOverwrite_));
                        curEnv->DeleteLocalRef(xcosFile_);
curEnv->DeleteLocalRef(h5File_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void Xcos::xcosDiagramOpen (JavaVM * jvm_, char ** UID, int UIDSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidxcosDiagramOpenjobjectArray_java_lang_StringID = curEnv->GetStaticMethodID(cls, "xcosDiagramOpen", "([Ljava/lang/String;)V" ) ;
if (voidxcosDiagramOpenjobjectArray_java_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcosDiagramOpen");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray UID_ = curEnv->NewObjectArray( UIDSize, stringArrayClass, NULL);
if (UID_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < UIDSize; i++)
{
jstring TempString = curEnv->NewStringUTF( UID[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( UID_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidxcosDiagramOpenjobjectArray_java_lang_StringID ,UID_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(UID_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::xcosDiagramClose (JavaVM * jvm_, char ** UID, int UIDSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidxcosDiagramClosejobjectArray_java_lang_StringID = curEnv->GetStaticMethodID(cls, "xcosDiagramClose", "([Ljava/lang/String;)V" ) ;
if (voidxcosDiagramClosejobjectArray_java_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcosDiagramClose");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray UID_ = curEnv->NewObjectArray( UIDSize, stringArrayClass, NULL);
if (UID_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < UIDSize; i++)
{
jstring TempString = curEnv->NewStringUTF( UID[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( UID_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidxcosDiagramClosejobjectArray_java_lang_StringID ,UID_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(UID_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
