#include "PolylineLineDrawerGL.hxx"
/* Generated by GIWS (version 1.3.0) */
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_renderer_polylineDrawing {

// Returns the current env

JNIEnv * PolylineLineDrawerGL::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

PolylineLineDrawerGL::~PolylineLineDrawerGL() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors
PolylineLineDrawerGL::PolylineLineDrawerGL(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voiddisplayID=NULL;
voidinitializeDrawingjintintID=NULL;
voidendDrawingID=NULL;
voidshowjintintID=NULL;
voiddestroyjintintID=NULL;
voidsetLineParametersjintintjfloatfloatjintintID=NULL;
voiddrawPolylinejdoubleArray_doublejdoubleArray_doublejdoubleArray_doubleID=NULL;


}

PolylineLineDrawerGL::PolylineLineDrawerGL(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voiddisplayID=NULL;
voidinitializeDrawingjintintID=NULL;
voidendDrawingID=NULL;
voidshowjintintID=NULL;
voiddestroyjintintID=NULL;
voidsetLineParametersjintintjfloatfloatjintintID=NULL;
voiddrawPolylinejdoubleArray_doublejdoubleArray_doublejdoubleArray_doubleID=NULL;


}

// Generic methods

void PolylineLineDrawerGL::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "PolylineLineDrawerGL");
}
}

void PolylineLineDrawerGL::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "PolylineLineDrawerGL");
}
}
// Method(s)

void PolylineLineDrawerGL::display (){

JNIEnv * curEnv = getCurrentEnv();

if (voiddisplayID==NULL) { /* Use the cache */
 voiddisplayID = curEnv->GetMethodID(this->instanceClass, "display", "()V" ) ;
if (voiddisplayID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "display");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddisplayID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void PolylineLineDrawerGL::initializeDrawing (int figureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidinitializeDrawingjintintID==NULL) { /* Use the cache */
 voidinitializeDrawingjintintID = curEnv->GetMethodID(this->instanceClass, "initializeDrawing", "(I)V" ) ;
if (voidinitializeDrawingjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "initializeDrawing");
}
}
                         curEnv->CallVoidMethod( this->instance, voidinitializeDrawingjintintID ,figureIndex);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void PolylineLineDrawerGL::endDrawing (){

JNIEnv * curEnv = getCurrentEnv();

if (voidendDrawingID==NULL) { /* Use the cache */
 voidendDrawingID = curEnv->GetMethodID(this->instanceClass, "endDrawing", "()V" ) ;
if (voidendDrawingID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "endDrawing");
}
}
                         curEnv->CallVoidMethod( this->instance, voidendDrawingID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void PolylineLineDrawerGL::show (int figureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voidshowjintintID==NULL) { /* Use the cache */
 voidshowjintintID = curEnv->GetMethodID(this->instanceClass, "show", "(I)V" ) ;
if (voidshowjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "show");
}
}
                         curEnv->CallVoidMethod( this->instance, voidshowjintintID ,figureIndex);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void PolylineLineDrawerGL::destroy (int parentFigureIndex){

JNIEnv * curEnv = getCurrentEnv();

if (voiddestroyjintintID==NULL) { /* Use the cache */
 voiddestroyjintintID = curEnv->GetMethodID(this->instanceClass, "destroy", "(I)V" ) ;
if (voiddestroyjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "destroy");
}
}
                         curEnv->CallVoidMethod( this->instance, voiddestroyjintintID ,parentFigureIndex);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void PolylineLineDrawerGL::setLineParameters (int lineColor, float thickness, int lineStyle){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetLineParametersjintintjfloatfloatjintintID==NULL) { /* Use the cache */
 voidsetLineParametersjintintjfloatfloatjintintID = curEnv->GetMethodID(this->instanceClass, "setLineParameters", "(IFI)V" ) ;
if (voidsetLineParametersjintintjfloatfloatjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setLineParameters");
}
}
                         curEnv->CallVoidMethod( this->instance, voidsetLineParametersjintintjfloatfloatjintintID ,lineColor, thickness, lineStyle);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void PolylineLineDrawerGL::drawPolyline (double* xCoords, int xCoordsSize, double* yCoords, int yCoordsSize, double* zCoords, int zCoordsSize){

JNIEnv * curEnv = getCurrentEnv();

if (voiddrawPolylinejdoubleArray_doublejdoubleArray_doublejdoubleArray_doubleID==NULL) { /* Use the cache */
 voiddrawPolylinejdoubleArray_doublejdoubleArray_doublejdoubleArray_doubleID = curEnv->GetMethodID(this->instanceClass, "drawPolyline", "([D[D[D)V" ) ;
if (voiddrawPolylinejdoubleArray_doublejdoubleArray_doublejdoubleArray_doubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "drawPolyline");
}
}
jdoubleArray xCoords_ = curEnv->NewDoubleArray( xCoordsSize ) ;

if (xCoords_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( xCoords_, 0, xCoordsSize, (jdouble*)(xCoords) ) ;


jdoubleArray yCoords_ = curEnv->NewDoubleArray( yCoordsSize ) ;

if (yCoords_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( yCoords_, 0, yCoordsSize, (jdouble*)(yCoords) ) ;


jdoubleArray zCoords_ = curEnv->NewDoubleArray( zCoordsSize ) ;

if (zCoords_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( zCoords_, 0, zCoordsSize, (jdouble*)(zCoords) ) ;


                         curEnv->CallVoidMethod( this->instance, voiddrawPolylinejdoubleArray_doublejdoubleArray_doublejdoubleArray_doubleID ,xCoords_, yCoords_, zCoords_);
                        curEnv->DeleteLocalRef(xCoords_);
curEnv->DeleteLocalRef(yCoords_);
curEnv->DeleteLocalRef(zCoords_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
