/*
 * scamper_writebuf.h: use in combination with select to send without blocking
 *
 * $Id: scamper_writebuf.h,v 1.4 2007/03/14 01:12:38 mjl Exp $
 *
 *          Matthew Luckie
 *
 * Copyright (C) 2004 The University of Waikato
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __SCAMPER_WRITEBUF_H
#define __SCAMPER_WRITEBUF_H

typedef struct scamper_writebuf scamper_writebuf_t;

/* flush all the data that can be written out now */
int scamper_writebuf_flush(scamper_writebuf_t *wb);

/* queue something to be sent on the socket */
int scamper_writebuf_send(scamper_writebuf_t *wb, void *data, size_t len);

/* allocate a writebuf for use with this fd */
scamper_writebuf_t *scamper_writebuf_alloc(scamper_fd_t *fdn);

/* free state allocated with the writebuf */
void scamper_writebuf_free(scamper_writebuf_t *wb);


#endif
