/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.scalatest.tools.JvmArg;
import org.scalatest.tools.NameValuePair;
import org.scalatest.tools.PackageElement;
import org.scalatest.tools.ReporterElement;
import org.scalatest.tools.Runner$;
import org.scalatest.tools.RunpathUrl;
import org.scalatest.tools.ScalaTestAntTask$;
import org.scalatest.tools.SuiteElement;
import org.scalatest.tools.TextElement;
import scala.Console$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaTestAntTask
extends Task
implements ScalaObject {
    private final ListBuffer<NameValuePair> properties;
    private final ListBuffer<ReporterElement> reporters;
    private final ListBuffer org$scalatest$tools$ScalaTestAntTask$$testNGSuites;
    private final ListBuffer<String> wildcards;
    private final ListBuffer<String> membersonlys;
    private final ListBuffer<String> suites;
    private final ListBuffer<String> jvmArgs;
    private final ListBuffer org$scalatest$tools$ScalaTestAntTask$$runpath = new ListBuffer();
    private int numthreads = 0;
    private boolean fork = false;
    private boolean haltonfailure = false;
    private boolean parallel = false;
    private String maxMemory = null;
    private String excludes = null;
    private String includes = null;

    public ScalaTestAntTask() {
        this.jvmArgs = new ListBuffer();
        this.suites = new ListBuffer();
        this.membersonlys = new ListBuffer();
        this.wildcards = new ListBuffer();
        this.org$scalatest$tools$ScalaTestAntTask$$testNGSuites = new ListBuffer();
        this.reporters = new ListBuffer();
        this.properties = new ListBuffer();
    }

    private String singleSpace(String str) {
        return str.trim().replaceAll("\\s+", " ");
    }

    private String getSpacedOutPathStr(List<String> path) {
        return ((TraversableLike)path.map((Function1)new $anonfun$getSpacedOutPathStr$1(this), List$.MODULE$.canBuildFrom())).mkString("", " ", "");
    }

    public void addConfiguredExcludes(TextElement excludes) {
        Console$.MODULE$.err().println(new StringBuilder().append((Object)"WARNING: 'excludes' is deprecated - use 'tagsToExclude' instead [excludes: ").append((Object)excludes.getText()).append((Object)"]").toString());
        this.excludes_$eq(excludes.getText());
    }

    public void addConfiguredTagsToExclude(TextElement tagsToExclude) {
        this.excludes_$eq(tagsToExclude.getText());
    }

    public void addConfiguredIncludes(TextElement includes) {
        Console$.MODULE$.err().println(new StringBuilder().append((Object)"WARNING: 'includes' is deprecated - use 'tagsToInclude' instead [includes: ").append((Object)includes.getText()).append((Object)"]").toString());
        this.includes_$eq(includes.getText());
    }

    public void addConfiguredTagsToInclude(TextElement tagsToInclude) {
        this.includes_$eq(tagsToInclude.getText());
    }

    public void addConfiguredReporter(ReporterElement reporter) {
        this.reporters().$plus$eq((Object)reporter);
    }

    public void addConfiguredWildcard(PackageElement wildcard) {
        this.wildcards().$plus$eq((Object)wildcard.getPackage());
    }

    public void addConfiguredMembersOnly(PackageElement membersonly) {
        this.membersonlys().$plus$eq((Object)membersonly.getPackage());
    }

    public void addConfiguredSuite(SuiteElement suite) {
        this.suites().$plus$eq((Object)suite.getClassName());
    }

    public void setWildcard(String packageName) {
        this.wildcards().$plus$eq((Object)packageName);
    }

    public void setMembersonly(String packageName) {
        this.membersonlys().$plus$eq((Object)packageName);
    }

    public void setSuite(String suite) {
        this.suites().$plus$eq((Object)suite);
    }

    public void addConfiguredConfig(NameValuePair config) {
        this.properties().$plus$eq((Object)config);
    }

    public void addConfiguredProperty(NameValuePair property) {
        Console$.MODULE$.err().println(new StringBuilder().append((Object)"WARNING: <property> is deprecated - please use <config> instead [name: ").append((Object)property.getName()).append((Object)"]").toString());
        this.properties().$plus$eq((Object)property);
    }

    public void addConfiguredJvmArg(JvmArg arg) {
        this.jvmArgs().$plus$eq((Object)arg.getValue());
    }

    public void addConfiguredRunpathUrl(RunpathUrl runpathurl) {
        this.org$scalatest$tools$ScalaTestAntTask$$runpath().$plus$eq((Object)runpathurl.getUrl());
    }

    public void addConfiguredTestNGSuites(Path testNGSuitePath) {
        Predef$.MODULE$.refArrayOps((Object[])testNGSuitePath.list()).foreach((Function1)new $anonfun$addConfiguredTestNGSuites$1(this));
    }

    public void addConfiguredRunpath(Path runpath) {
        Predef$.MODULE$.refArrayOps((Object[])runpath.list()).foreach((Function1)new $anonfun$addConfiguredRunpath$1(this));
    }

    public void setParallel(boolean parallel) {
        this.parallel_$eq(parallel);
    }

    public void setNumthreads(int numthreads) {
        this.numthreads_$eq(numthreads);
    }

    public void setConcurrent(boolean concurrent) {
        Console$.MODULE$.err().println("WARNING: 'concurrent' attribute is deprecated - please use 'parallel' instead");
        this.parallel_$eq(concurrent);
    }

    public void setTestNGSuites(Path testNGSuitePath) {
        Predef$.MODULE$.refArrayOps((Object[])testNGSuitePath.list()).foreach((Function1)new $anonfun$setTestNGSuites$1(this));
    }

    public void setMaxmemory(String max) {
        this.maxMemory_$eq(max);
    }

    public void setFork(boolean fork) {
        this.fork_$eq(fork);
    }

    public void setHaltonfailure(boolean haltonfailure) {
        this.haltonfailure_$eq(haltonfailure);
    }

    public void setRunpath(Path runpath) {
        Predef$.MODULE$.refArrayOps((Object[])runpath.list()).foreach((Function1)new $anonfun$setRunpath$1(this));
    }

    public final void org$scalatest$tools$ScalaTestAntTask$$addReporterClass(ListBuffer args, ReporterElement reporter) {
        this.org$scalatest$tools$ScalaTestAntTask$$addReporterOption(args, reporter, "-r");
        String string = reporter.getClassName();
        if (string == null || string.equals(null)) {
            throw new BuildException("reporter type 'reporterclass' requires 'classname' attribute");
        }
        args.$plus$eq((Object)reporter.getClassName());
    }

    public final void org$scalatest$tools$ScalaTestAntTask$$addHtmlReporter(ListBuffer args, ReporterElement reporter) {
        this.org$scalatest$tools$ScalaTestAntTask$$addReporterOption(args, reporter, "-h");
        String string = reporter.getFilename();
        if (string == null || string.equals(null)) {
            throw new BuildException("reporter type 'html' requires 'filename' attribute");
        }
        args.$plus$eq((Object)reporter.getFilename());
    }

    public final void org$scalatest$tools$ScalaTestAntTask$$addXmlReporter(ListBuffer args, ReporterElement reporter) {
        this.org$scalatest$tools$ScalaTestAntTask$$addReporterOption(args, reporter, "-u");
        String string = reporter.getDirectory();
        if (string == null || string.equals(null)) {
            throw new BuildException("reporter type 'xml' requires 'directory' attribute");
        }
        args.$plus$eq((Object)reporter.getDirectory());
        String string2 = reporter.getType();
        String string3 = "xml";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Console$.MODULE$.err().println("WARNING: reporter type 'xml' is deprecated - please use 'junitxml' instead");
        }
    }

    public final void org$scalatest$tools$ScalaTestAntTask$$addFileReporter(ListBuffer args, ReporterElement reporter) {
        this.org$scalatest$tools$ScalaTestAntTask$$addReporterOption(args, reporter, "-f");
        String string = reporter.getFilename();
        if (string == null || string.equals(null)) {
            throw new BuildException("reporter type 'file' requires 'filename' attribute");
        }
        args.$plus$eq((Object)reporter.getFilename());
    }

    public final void org$scalatest$tools$ScalaTestAntTask$$addReporterOption(ListBuffer args, ReporterElement reporter, String option) {
        String config = reporter.getConfig();
        String string = config;
        if (string == null || string.equals(null)) {
            args.$plus$eq((Object)option);
        } else {
            args.$plus$eq((Object)new StringBuilder().append((Object)option).append((Object)config).toString());
        }
    }

    private void addReporterArgs(ListBuffer<String> args$2) {
        Object object = this.reporters().size() == 0 ? args$2.$plus$eq((Object)"-o") : BoxedUnit.UNIT;
        this.reporters().foreach((Function1)new $anonfun$addReporterArgs$1(this, args$2));
    }

    private void addSuiteArgs(ListBuffer<String> args$1) {
        this.suites().foreach((Function1)new $anonfun$addSuiteArgs$1(this, args$1));
        this.membersonlys().foreach((Function1)new $anonfun$addSuiteArgs$2(this, args$1));
        this.wildcards().foreach((Function1)new $anonfun$addSuiteArgs$3(this, args$1));
    }

    private void addPropertyArgs(ListBuffer<String> args$3) {
        this.properties().foreach((Function1)new $anonfun$addPropertyArgs$1(this, args$3));
    }

    private void addExcludesArgs(ListBuffer<String> args) {
        String string = this.excludes();
        if (string != null && !string.equals(null)) {
            args.$plus$eq((Object)"-l");
            args.$plus$eq((Object)this.singleSpace(this.excludes()));
        }
    }

    private void addIncludesArgs(ListBuffer<String> args) {
        String string = this.includes();
        if (string != null && !string.equals(null)) {
            args.$plus$eq((Object)"-n");
            args.$plus$eq((Object)this.singleSpace(this.includes()));
        }
    }

    private void addParallelArg(ListBuffer<String> args) {
        if (this.parallel()) {
            args.$plus$eq((Object)new StringBuilder().append((Object)"-c").append((Object)(this.numthreads() > 0 ? new StringBuilder().append((Object)"").append((Object)BoxesRunTime.boxToInteger((int)this.numthreads())).toString() : "")).toString());
        }
    }

    private void addTestNGSuiteArgs(ListBuffer<String> args) {
        if (this.org$scalatest$tools$ScalaTestAntTask$$testNGSuites().size() > 0) {
            args.$plus$eq((Object)"-t");
            args.$plus$eq((Object)this.getSpacedOutPathStr((List<String>)this.org$scalatest$tools$ScalaTestAntTask$$testNGSuites().toList()));
        }
    }

    private void addRunpathArgs(ListBuffer<String> args) {
        if (this.org$scalatest$tools$ScalaTestAntTask$$runpath().size() > 0) {
            args.$plus$eq((Object)"-p");
            args.$plus$eq((Object)this.getSpacedOutPathStr((List<String>)this.org$scalatest$tools$ScalaTestAntTask$$runpath().toList()));
        }
    }

    private boolean javaTaskRunner(List<String> args) {
        Java java$1 = new Java();
        java$1.bindToOwner((Task)this);
        java$1.init();
        java$1.setFork(true);
        java$1.setClassname("org.scalatest.tools.Runner");
        AntClassLoader classLoader = (AntClassLoader)this.getClass().getClassLoader();
        java$1.setClasspath(new Path(this.getProject(), classLoader.getClasspath()));
        String string = this.maxMemory();
        if (string != null && !string.equals(null)) {
            java$1.createJvmarg().setValue(new StringBuilder().append((Object)"-Xmx").append((Object)this.maxMemory()).toString());
        }
        this.jvmArgs().foreach((Function1)new $anonfun$javaTaskRunner$1(this, java$1));
        args.foreach((Function1)new $anonfun$javaTaskRunner$2(this, java$1));
        int result = java$1.executeJava();
        return result == 0;
    }

    public void execute() {
        boolean success;
        ListBuffer args = new ListBuffer();
        this.addSuiteArgs((ListBuffer<String>)args);
        this.addReporterArgs((ListBuffer<String>)args);
        this.addPropertyArgs((ListBuffer<String>)args);
        this.addIncludesArgs((ListBuffer<String>)args);
        this.addExcludesArgs((ListBuffer<String>)args);
        this.addRunpathArgs((ListBuffer<String>)args);
        this.addTestNGSuiteArgs((ListBuffer<String>)args);
        this.addParallelArg((ListBuffer<String>)args);
        String[] argsArray = (String[])args.toArray(ClassManifest$.MODULE$.classType(String.class));
        boolean bl = success = this.fork() ? this.javaTaskRunner((List<String>)args.toList()) : Runner$.MODULE$.run(argsArray);
        if (!success && this.haltonfailure()) {
            throw new BuildException("ScalaTest run failed.");
        }
    }

    private ListBuffer<NameValuePair> properties() {
        return this.properties;
    }

    private ListBuffer<ReporterElement> reporters() {
        return this.reporters;
    }

    public final ListBuffer org$scalatest$tools$ScalaTestAntTask$$testNGSuites() {
        return this.org$scalatest$tools$ScalaTestAntTask$$testNGSuites;
    }

    private ListBuffer<String> wildcards() {
        return this.wildcards;
    }

    private ListBuffer<String> membersonlys() {
        return this.membersonlys;
    }

    private ListBuffer<String> suites() {
        return this.suites;
    }

    private ListBuffer<String> jvmArgs() {
        return this.jvmArgs;
    }

    public final ListBuffer org$scalatest$tools$ScalaTestAntTask$$runpath() {
        return this.org$scalatest$tools$ScalaTestAntTask$$runpath;
    }

    private void numthreads_$eq(int n) {
        this.numthreads = n;
    }

    private int numthreads() {
        return this.numthreads;
    }

    private void fork_$eq(boolean bl) {
        this.fork = bl;
    }

    private boolean fork() {
        return this.fork;
    }

    private void haltonfailure_$eq(boolean bl) {
        this.haltonfailure = bl;
    }

    private boolean haltonfailure() {
        return this.haltonfailure;
    }

    private void parallel_$eq(boolean bl) {
        this.parallel = bl;
    }

    private boolean parallel() {
        return this.parallel;
    }

    private void maxMemory_$eq(String string) {
        this.maxMemory = string;
    }

    private String maxMemory() {
        return this.maxMemory;
    }

    private void excludes_$eq(String string) {
        this.excludes = string;
    }

    private String excludes() {
        return this.excludes;
    }

    private void includes_$eq(String string) {
        this.includes = string;
    }

    private String includes() {
        return this.includes;
    }
}

