/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Tracker;
import org.scalatest.events.RunAborted$;
import org.scalatest.events.RunCompleted$;
import org.scalatest.events.RunStarting$;
import scala.Function1;
import scala.Function7;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRerunner
implements Rerunner,
ScalaObject {
    private final String testName;
    private final String suiteClassName;

    public TestRerunner(String suiteClassName, String testName) {
        String string;
        this.suiteClassName = suiteClassName;
        this.testName = testName;
        Function7.class.$init$((Function7)this);
        String string2 = suiteClassName;
        if (string2 == null || string2.equals(null) || (string = testName) == null || string.equals(null)) {
            throw new NullPointerException();
        }
    }

    @Override
    public void apply(Reporter report, Stopper stopper, Filter filter2, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker, ClassLoader loader) {
        long runStartTime = System.currentTimeMillis();
        try {
            Class<?> suiteClass = loader.loadClass(this.suiteClassName);
            Suite suite = (Suite)suiteClass.newInstance();
            report.apply(RunStarting$.MODULE$.apply(tracker.nextOrdinal(), 1, configMap));
            suite.run((Option<String>)new Some((Object)this.testName), report, stopper, filter2, configMap, distributor, tracker);
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunCompleted$.MODULE$.apply(tracker.nextOrdinal(), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.bigProblems(throwable), (Option<Throwable>)new Some((Object)throwable), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadClass", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noClassDefFoundError.getMessage()})), (Option<Throwable>)new Some((Object)noClassDefFoundError), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (SecurityException securityException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("securityWhenRerruning", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{securityException.getMessage()})), (Option<Throwable>)new Some((Object)securityException), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotFindMethod", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noSuchMethodException.getMessage()})), (Option<Throwable>)new Some((Object)noSuchMethodException), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (IllegalAccessException illegalAccessException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{illegalAccessException.getMessage()})), (Option<Throwable>)new Some((Object)illegalAccessException), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (InstantiationException instantiationException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{instantiationException.getMessage()})), (Option<Throwable>)new Some((Object)instantiationException), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (ClassNotFoundException classNotFoundException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{classNotFoundException.getMessage()})), (Option<Throwable>)new Some((Object)classNotFoundException), (Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
    }

    public Function1 curry() {
        return Function7.class.curry((Function7)this);
    }

    public String toString() {
        return Function7.class.toString((Function7)this);
    }
}

