/*
 * Decompiled with CFR 0.152.
 */
package jsr166y;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import jsr166y.ForkJoinPool;
import sun.misc.Unsafe;

public class Phaser {
    private volatile long state;
    private static final int ushortMask = 65535;
    private static final int phaseMask = Integer.MAX_VALUE;
    private final Phaser parent;
    private final Phaser root;
    private final AtomicReference<QNode> evenQ = new AtomicReference();
    private final AtomicReference<QNode> oddQ = new AtomicReference();
    private static final Unsafe UNSAFE = Phaser.getUnsafe();
    private static final long stateOffset = Phaser.objectFieldOffset("state", Phaser.class);

    private static int unarrivedOf(long s) {
        return (int)(s & 0xFFFFL);
    }

    private static int partiesOf(long s) {
        return (int)s >>> 16;
    }

    private static int phaseOf(long s) {
        return (int)(s >>> 32);
    }

    private static int arrivedOf(long s) {
        return Phaser.partiesOf(s) - Phaser.unarrivedOf(s);
    }

    private static long stateFor(int phase, int parties, int unarrived) {
        return (long)phase << 32 | (long)parties << 16 | (long)unarrived;
    }

    private static long trippedStateFor(int phase, int parties) {
        long lp = parties;
        return (long)phase << 32 | lp << 16 | lp;
    }

    private static String badBounds(int parties, int unarrived) {
        return "Attempt to set " + unarrived + " unarrived of " + parties + " parties";
    }

    private AtomicReference<QNode> queueFor(int phase) {
        return (phase & 1) == 0 ? this.evenQ : this.oddQ;
    }

    private long getReconciledState() {
        return this.parent == null ? this.state : this.reconcileState();
    }

    private long reconcileState() {
        Phaser p = this.parent;
        long s = this.state;
        if (p != null) {
            while (Phaser.unarrivedOf(s) == 0 && Phaser.phaseOf(s) != Phaser.phaseOf(this.root.state)) {
                long next;
                long parentState = p.getReconciledState();
                int parentPhase = Phaser.phaseOf(parentState);
                s = this.state;
                int phase = Phaser.phaseOf(s);
                if (phase == parentPhase || !this.casState(s, next = Phaser.trippedStateFor(parentPhase, Phaser.partiesOf(s)))) continue;
                this.releaseWaiters(phase);
                s = next;
            }
        }
        return s;
    }

    public Phaser() {
        this(null);
    }

    public Phaser(int parties) {
        this(null, parties);
    }

    public Phaser(Phaser parent) {
        int phase = 0;
        this.parent = parent;
        if (parent != null) {
            this.root = parent.root;
            phase = parent.register();
        } else {
            this.root = this;
        }
        this.state = Phaser.trippedStateFor(phase, 0);
    }

    public Phaser(Phaser parent, int parties) {
        if (parties < 0 || parties > 65535) {
            throw new IllegalArgumentException("Illegal number of parties");
        }
        int phase = 0;
        this.parent = parent;
        if (parent != null) {
            this.root = parent.root;
            phase = parent.register();
        } else {
            this.root = this;
        }
        this.state = Phaser.trippedStateFor(phase, parties);
    }

    public int register() {
        return this.doRegister(1);
    }

    public int bulkRegister(int parties) {
        if (parties < 0) {
            throw new IllegalArgumentException();
        }
        if (parties == 0) {
            return this.getPhase();
        }
        return this.doRegister(parties);
    }

    private int doRegister(int registrations) {
        int unarrived;
        int parties;
        long s;
        int phase;
        do {
            s = this.getReconciledState();
            phase = Phaser.phaseOf(s);
            unarrived = Phaser.unarrivedOf(s) + registrations;
            parties = Phaser.partiesOf(s) + registrations;
            if (phase < 0) break;
            if (parties <= 65535 && unarrived <= 65535) continue;
            throw new IllegalStateException(Phaser.badBounds(parties, unarrived));
        } while (phase != Phaser.phaseOf(this.root.state) || !this.casState(s, Phaser.stateFor(phase, parties, unarrived)));
        return phase;
    }

    public int arrive() {
        long s;
        int phase;
        while ((phase = Phaser.phaseOf(s = this.state)) >= 0) {
            int parties = Phaser.partiesOf(s);
            int unarrived = Phaser.unarrivedOf(s) - 1;
            if (unarrived > 0) {
                if (!this.casState(s, s - 1L)) continue;
                break;
            }
            if (unarrived == 0) {
                Phaser par = this.parent;
                if (par == null) {
                    if (!this.casState(s, Phaser.trippedStateFor(this.onAdvance(phase, parties) ? -1 : phase + 1 & Integer.MAX_VALUE, parties))) continue;
                    this.releaseWaiters(phase);
                    break;
                }
                if (!this.casState(s, s - 1L)) continue;
                par.arrive();
                this.reconcileState();
                break;
            }
            if (phase != Phaser.phaseOf(this.root.state)) {
                this.reconcileState();
                continue;
            }
            throw new IllegalStateException(Phaser.badBounds(parties, unarrived));
        }
        return phase;
    }

    public int arriveAndDeregister() {
        long s;
        int phase;
        Phaser par = this.parent;
        while ((phase = Phaser.phaseOf(s = this.state)) >= 0) {
            int parties = Phaser.partiesOf(s) - 1;
            int unarrived = Phaser.unarrivedOf(s) - 1;
            if (parties >= 0) {
                if (unarrived > 0 || unarrived == 0 && par != null) {
                    if (!this.casState(s, Phaser.stateFor(phase, parties, unarrived))) continue;
                    if (unarrived != 0) break;
                    par.arriveAndDeregister();
                    this.reconcileState();
                    break;
                }
                if (unarrived == 0) {
                    if (!this.casState(s, Phaser.trippedStateFor(this.onAdvance(phase, parties) ? -1 : phase + 1 & Integer.MAX_VALUE, parties))) continue;
                    this.releaseWaiters(phase);
                    break;
                }
                if (par != null && phase != Phaser.phaseOf(this.root.state)) {
                    this.reconcileState();
                    continue;
                }
            }
            throw new IllegalStateException(Phaser.badBounds(parties, unarrived));
        }
        return phase;
    }

    public int arriveAndAwaitAdvance() {
        return this.awaitAdvance(this.arrive());
    }

    public int awaitAdvance(int phase) {
        if (phase < 0) {
            return phase;
        }
        long s = this.getReconciledState();
        int p = Phaser.phaseOf(s);
        if (p != phase) {
            return p;
        }
        if (Phaser.unarrivedOf(s) == 0 && this.parent != null) {
            this.parent.awaitAdvance(phase);
        }
        return this.untimedWait(phase);
    }

    public int awaitAdvanceInterruptibly(int phase) throws InterruptedException {
        if (phase < 0) {
            return phase;
        }
        long s = this.getReconciledState();
        int p = Phaser.phaseOf(s);
        if (p != phase) {
            return p;
        }
        if (Phaser.unarrivedOf(s) == 0 && this.parent != null) {
            this.parent.awaitAdvanceInterruptibly(phase);
        }
        return this.interruptibleWait(phase);
    }

    public int awaitAdvanceInterruptibly(int phase, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (phase < 0) {
            return phase;
        }
        long s = this.getReconciledState();
        int p = Phaser.phaseOf(s);
        if (p != phase) {
            return p;
        }
        if (Phaser.unarrivedOf(s) == 0 && this.parent != null) {
            this.parent.awaitAdvanceInterruptibly(phase, timeout, unit);
        }
        return this.timedWait(phase, unit.toNanos(timeout));
    }

    public void forceTermination() {
        int unarrived;
        int parties;
        long s;
        int phase;
        do {
            s = this.getReconciledState();
            phase = Phaser.phaseOf(s);
            parties = Phaser.partiesOf(s);
            unarrived = Phaser.unarrivedOf(s);
        } while (phase >= 0 && !this.casState(s, Phaser.stateFor(-1, parties, unarrived)));
        this.releaseWaiters(0);
        this.releaseWaiters(1);
        if (this.parent != null) {
            this.parent.forceTermination();
        }
    }

    public final int getPhase() {
        return Phaser.phaseOf(this.getReconciledState());
    }

    public int getRegisteredParties() {
        return Phaser.partiesOf(this.state);
    }

    public int getArrivedParties() {
        return Phaser.arrivedOf(this.state);
    }

    public int getUnarrivedParties() {
        return Phaser.unarrivedOf(this.state);
    }

    public Phaser getParent() {
        return this.parent;
    }

    public Phaser getRoot() {
        return this.root;
    }

    public boolean isTerminated() {
        return this.getPhase() < 0;
    }

    protected boolean onAdvance(int phase, int registeredParties) {
        return registeredParties <= 0;
    }

    public String toString() {
        long s = this.getReconciledState();
        return String.valueOf(super.toString()) + "[phase = " + Phaser.phaseOf(s) + " parties = " + Phaser.partiesOf(s) + " arrived = " + Phaser.arrivedOf(s) + "]";
    }

    private void releaseWaiters(int phase) {
        QNode q;
        AtomicReference<QNode> head = this.queueFor(phase);
        while ((q = head.get()) != null) {
            if (!head.compareAndSet(q, q.next)) continue;
            q.signal();
        }
    }

    private boolean tryEnqueue(QNode node) {
        AtomicReference<QNode> head = this.queueFor(node.phase);
        node.next = head.get();
        return head.compareAndSet(node.next, node);
    }

    private int untimedWait(int phase) {
        int p;
        QNode node = null;
        boolean queued = false;
        boolean interrupted = false;
        while ((p = this.getPhase()) == phase) {
            if (Thread.interrupted()) {
                interrupted = true;
                continue;
            }
            if (node == null) {
                node = new QNode(this, phase, false, false, 0L, 0L);
                continue;
            }
            if (!queued) {
                queued = this.tryEnqueue(node);
                continue;
            }
            interrupted = node.doWait();
        }
        if (node != null) {
            node.thread = null;
        }
        this.releaseWaiters(phase);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return p;
    }

    private int interruptibleWait(int phase) throws InterruptedException {
        int p;
        QNode node = null;
        boolean queued = false;
        boolean interrupted = false;
        while ((p = this.getPhase()) == phase && !interrupted) {
            if (Thread.interrupted()) {
                interrupted = true;
                continue;
            }
            if (node == null) {
                node = new QNode(this, phase, true, false, 0L, 0L);
                continue;
            }
            if (!queued) {
                queued = this.tryEnqueue(node);
                continue;
            }
            interrupted = node.doWait();
        }
        if (node != null) {
            node.thread = null;
        }
        if (p != phase || (p = this.getPhase()) != phase) {
            this.releaseWaiters(phase);
        }
        if (interrupted) {
            throw new InterruptedException();
        }
        return p;
    }

    private int timedWait(int phase, long nanos) throws InterruptedException, TimeoutException {
        int p;
        long startTime = System.nanoTime();
        QNode node = null;
        boolean queued = false;
        boolean interrupted = false;
        while ((p = this.getPhase()) == phase && !interrupted) {
            if (Thread.interrupted()) {
                interrupted = true;
                continue;
            }
            if (nanos - (System.nanoTime() - startTime) <= 0L) break;
            if (node == null) {
                node = new QNode(this, phase, true, true, startTime, nanos);
                continue;
            }
            if (!queued) {
                queued = this.tryEnqueue(node);
                continue;
            }
            interrupted = node.doWait();
        }
        if (node != null) {
            node.thread = null;
        }
        if (p != phase || (p = this.getPhase()) != phase) {
            this.releaseWaiters(phase);
        }
        if (interrupted) {
            throw new InterruptedException();
        }
        if (p == phase) {
            throw new TimeoutException();
        }
        return p;
    }

    private final boolean casState(long cmp, long val) {
        return UNSAFE.compareAndSwapLong(this, stateOffset, cmp, val);
    }

    private static long objectFieldOffset(String field, Class<?> klazz) {
        try {
            return UNSAFE.objectFieldOffset(klazz.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            NoSuchFieldError error = new NoSuchFieldError(field);
            error.initCause(e);
            throw error;
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static final class QNode
    implements ForkJoinPool.ManagedBlocker {
        final Phaser phaser;
        final int phase;
        final long startTime;
        final long nanos;
        final boolean timed;
        final boolean interruptible;
        volatile boolean wasInterrupted = false;
        volatile Thread thread;
        QNode next;

        QNode(Phaser phaser, int phase, boolean interruptible, boolean timed, long startTime, long nanos) {
            this.phaser = phaser;
            this.phase = phase;
            this.timed = timed;
            this.interruptible = interruptible;
            this.startTime = startTime;
            this.nanos = nanos;
            this.thread = Thread.currentThread();
        }

        @Override
        public boolean isReleasable() {
            return this.thread == null || this.phaser.getPhase() != this.phase || this.interruptible && this.wasInterrupted || this.timed && this.nanos - (System.nanoTime() - this.startTime) <= 0L;
        }

        @Override
        public boolean block() {
            if (Thread.interrupted()) {
                this.wasInterrupted = true;
                if (this.interruptible) {
                    return true;
                }
            }
            if (!this.timed) {
                LockSupport.park(this);
            } else {
                long waitTime = this.nanos - (System.nanoTime() - this.startTime);
                if (waitTime <= 0L) {
                    return true;
                }
                LockSupport.parkNanos(this, waitTime);
            }
            return this.isReleasable();
        }

        void signal() {
            Thread t = this.thread;
            if (t != null) {
                this.thread = null;
                LockSupport.unpark(t);
            }
        }

        boolean doWait() {
            if (this.thread != null) {
                try {
                    ForkJoinPool.managedBlock(this, false);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.wasInterrupted;
        }
    }
}

