/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.dev;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

class SuiteDownloadInfo {
    String url;
    String label;

    static Vector getDownloadInfoFromPage(InputStreamReader page) throws IOException {
        Vector<SuiteDownloadInfo> suites = new Vector<SuiteDownloadInfo>();
        SuiteDownloadInfo info = SuiteDownloadInfo.getNextJadLink(page);
        while (info != null) {
            if (info.url.endsWith(".jad")) {
                suites.addElement(info);
            }
            info = SuiteDownloadInfo.getNextJadLink(page);
        }
        return suites;
    }

    private static SuiteDownloadInfo getNextJadLink(InputStreamReader page) throws IOException {
        String url = SuiteDownloadInfo.getNextUrl(page);
        if (url == null) {
            return null;
        }
        String label = SuiteDownloadInfo.getNextLabel(page);
        if (label == null) {
            label = url;
        }
        return new SuiteDownloadInfo(url, label);
    }

    private static String getNextUrl(InputStreamReader page) throws IOException {
        if (!SuiteDownloadInfo.findString(page, "href=\"")) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        int currentChar = page.read();
        while (currentChar != 34) {
            if (currentChar == -1) {
                return null;
            }
            url.append((char)currentChar);
            currentChar = page.read();
        }
        if (url.length() == 0) {
            return null;
        }
        return url.toString();
    }

    private static String getNextLabel(InputStreamReader page) throws IOException {
        if (!SuiteDownloadInfo.findChar(page, '>')) {
            return null;
        }
        StringBuffer label = new StringBuffer();
        int currentChar = page.read();
        while (currentChar != 60) {
            if (currentChar == -1) {
                return null;
            }
            label.append((char)currentChar);
            currentChar = page.read();
        }
        if (label.length() == 0) {
            return null;
        }
        return label.toString();
    }

    private static boolean findString(InputStreamReader page, String targetString) throws IOException {
        int i = 0;
        while (i < targetString.length()) {
            if (!SuiteDownloadInfo.findChar(page, targetString.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean findChar(InputStreamReader page, char targetChar) throws IOException {
        int currentChar = page.read();
        while (Character.toLowerCase((char)currentChar) != targetChar) {
            if (currentChar == -1) {
                return false;
            }
            currentChar = page.read();
        }
        return true;
    }

    SuiteDownloadInfo(String theUrl, String theLabel) {
        this.url = theUrl;
        this.label = theLabel;
    }
}

