/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.dev;

import com.sun.midp.dev.SuiteDownloadInfo;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.lcdui.Resource;
import com.sun.midp.midlet.MIDletInfo;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midletsuite.InstallListener;
import com.sun.midp.midletsuite.InstallState;
import com.sun.midp.midletsuite.Installer;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.security.SecurityDomain;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Manager
extends MIDlet
implements CommandListener {
    private static final int ALERT_TIMEOUT = 1500;
    private static final String SETTINGS_STORE = "settings";
    private static SecurityDomain classSecurityDomain;
    private static Image suiteIcon;
    private static Image emptyIcon;
    private static Image singleSuiteIcon;
    private static boolean colorDisplay;
    private Installer installer;
    private List mlist;
    private static boolean first;
    private Display display;
    private int mcount;
    private MIDletSuiteInfo[] minfo;
    private int selectedSuite;
    private TextBox settingsTextBox;
    private String defaultInstallListUrl = "http://";
    private TextBox urlTextBox;
    private Form passwordForm;
    private TextField usernameField;
    private TextField passwordField;
    private BackgroundInstaller backgroundInstaller;
    private Form conForm;
    private long lastDisplayChange;
    private String cancelledMessage;
    private String finishingMessage;
    private List installListBox;
    private Vector installList;
    private Command launchCmd = new Command(Resource.getString("Launch"), 8, 1);
    private Command infoCmd = new Command(Resource.getString("Info"), 8, 2);
    private Command removeCmd = new Command(Resource.getString("Remove"), 8, 3);
    private Command updateCmd = new Command(Resource.getString("Update"), 8, 4);
    private Command installCmd = new Command(Resource.getString("Install"), 1, 1);
    private Command cancelInstallCmd = new Command(Resource.getString("Cancel"), 3, 1);
    private Command settingsCmd = new Command(Resource.getString("Settings"), 1, 2);
    private Command aboutCmd = new Command(Resource.getString("About"), 1, 3);
    private Command saveSettingsCmd = new Command(Resource.getString("Save"), 1, 1);
    private Command selectSuiteCmd = new Command(Resource.getString("Go"), 1, 1);
    private Command backCmd = new Command(Resource.getString("Back"), 2, 1);
    private Command cancelCmd = new Command(Resource.getString("Cancel"), 3, 1);
    private Command removeOkCmd = new Command(Resource.getString("Remove"), 1, 1);
    private Command stopCmd = new Command(Resource.getString("Stop"), 6, 1);
    private Command nextCmd = new Command(Resource.getString("Next"), 1, 1);
    private Command okCmd = new Command(Resource.getString("OK"), 4, 1);
    private static final String SMALL_COPYRIGHT;
    private static final String COPYRIGHT;

    public static void initSecurityDomain(SecurityDomain theDomain) {
        if (classSecurityDomain != null) {
            return;
        }
        classSecurityDomain = theDomain;
    }

    public static void initialize(boolean logoDisplayed) {
        first = !logoDisplayed;
    }

    private static String translateJadException(InvalidJadException exception, String name, String jadUrl) {
        String key;
        String[] values = new String[]{name, jadUrl, exception.getExtraData()};
        switch (exception.getReason()) {
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 22: {
                key = "%1 cannot be installed because critical information is missing from the application file (.jad).";
                break;
            }
            case 41: 
            case 42: {
                key = "%1 cannot be installed because critical information is missing from the archive file (.jar).";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 31: {
                key = "%1 cannot be installed because critical information between the website and the application file does not match.";
                break;
            }
            case 17: {
                key = "A newer version of %1 is already installed on this device.";
                break;
            }
            case 32: {
                key = "An older version of %1 is already installed on this device. Do you want to update the older version?";
                break;
            }
            case 39: {
                key = "The same version of %1 is already installed on this device. Do you want to update the existing version?";
                break;
            }
            case 1: 
            case 2: {
                key = "%1 cannot be found at this URL. Contact the application provider for more information.";
                break;
            }
            case 19: 
            case 20: {
                key = "The archive file (.jar) for %1 cannot be found at its URL. Contact the application provider for more information.";
                break;
            }
            case 16: 
            case 28: 
            case 29: {
                key = "%1 cannot be installed because critical information is not formatted correctly and is invalid.";
                break;
            }
            case 30: {
                key = "There is not enough room to install %1 (%3K is needed for installation.). Try removing other items to free up space.";
                break;
            }
            case 38: {
                key = "The archive file (.jar) for %1 does not appear to be the correct type. Contact the application provider for more information.";
                break;
            }
            case 37: {
                key = "The application file (.jad) for %1 does not appear to be the correct type. Contact the application provider for more information.";
                break;
            }
            case 36: {
                key = "The archive file (.jar) for %1 appears to be corrupt. Contact the application provider for more information.";
                break;
            }
            case 34: {
                key = "The new version of %1 is not from the same provider as the old version. The download URLs do not match. Do you want to install the new version?\n\nOld URL: %3\nNew URL: %2";
                break;
            }
            case 35: {
                key = "The server has requested an authentication of the user with a scheme that this device does not support.";
                break;
            }
            case 40: {
                key = "%1 is not designed to work with this device and cannot be installed.";
                break;
            }
            default: {
                return exception.getMessage();
            }
        }
        return Resource.getString(key, values);
    }

    private static Image getSuiteIcon() {
        if (suiteIcon != null) {
            return suiteIcon;
        }
        suiteIcon = Manager.getIconFromStorage(colorDisplay ? "_suite_8.png" : "_suite_2.png");
        return suiteIcon;
    }

    private static Image getEmptyIcon() {
        if (emptyIcon != null) {
            return emptyIcon;
        }
        emptyIcon = Manager.getIconFromStorage("_empty.png");
        return emptyIcon;
    }

    private static Image getSingleSuiteIcon() {
        if (singleSuiteIcon != null) {
            return singleSuiteIcon;
        }
        singleSuiteIcon = Manager.getIconFromStorage(colorDisplay ? "_single8.png" : "_single2.png");
        return singleSuiteIcon;
    }

    private static Image getIconFromStorage(String iconName) {
        String iconFilename = File.getStorageRoot() + iconName;
        RandomAccessStream stream = new RandomAccessStream(classSecurityDomain);
        try {
            stream.connect(iconFilename, 1);
            byte[] rawPng = new byte[stream.getSizeOf()];
            stream.readBytes(rawPng, 0, rawPng.length);
            stream.disconnect();
            return Image.createImage(rawPng, 0, rawPng.length);
        }
        catch (IOException noImage) {
            return null;
        }
    }

    public Manager() {
        this.installer = Installer.getInstaller(classSecurityDomain);
        this.display = Display.getDisplay(this);
        colorDisplay = this.display.isColor();
        this.mcount = 0;
        this.minfo = new MIDletSuiteInfo[20];
        this.readMIDletSuiteInfo();
        this.restoreSettings();
    }

    public void startApp() {
        this.setupList();
        if (this.mcount > 0) {
            this.mlist.addCommand(this.launchCmd);
            this.mlist.addCommand(this.infoCmd);
            this.mlist.addCommand(this.removeCmd);
            this.mlist.addCommand(this.updateCmd);
        }
        this.mlist.addCommand(this.installCmd);
        this.mlist.addCommand(this.settingsCmd);
        this.mlist.addCommand(this.aboutCmd);
        this.mlist.setCommandListener(this);
        if (first) {
            first = false;
            Alert splash = new Alert(null);
            if (this.display.numColors() > 2) {
                splash.setImage(Manager.getIconFromStorage(colorDisplay ? "_logo_8.png" : "_logo_2.png"));
            }
            splash.setString(SMALL_COPYRIGHT);
            this.display.setCurrent(splash, this.mlist);
        } else {
            this.display.setCurrent(this.mlist);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.cancelBackgroundInstall();
    }

    public void commandAction(Command c, Displayable s) {
        if (s == this.mlist && c == List.SELECT_COMMAND || c == this.launchCmd) {
            this.launchSuite(this.minfo[this.mlist.getSelectedIndex()]);
        } else if (c == this.infoCmd) {
            this.displaySuiteInfo(this.minfo[this.mlist.getSelectedIndex()]);
        } else if (c == this.removeCmd) {
            this.selectedSuite = this.mlist.getSelectedIndex();
            this.confirmRemove(this.minfo[this.selectedSuite]);
        } else if (c == this.removeOkCmd) {
            this.removeSuite(this.minfo[this.selectedSuite]);
        } else if (c == this.updateCmd) {
            this.updateSuite(this.minfo[this.mlist.getSelectedIndex()]);
        } else if (s == this.mlist && c == this.installCmd) {
            this.getUrl();
        } else if (c == this.selectSuiteCmd) {
            this.selectSuiteToInstall(this.urlTextBox.getString());
        } else if (s == this.installListBox && (c == List.SELECT_COMMAND || c == this.installCmd)) {
            this.installSuite(this.installListBox.getSelectedIndex());
        } else if (c == this.nextCmd) {
            this.resumeInstallWithPassword();
        } else if (c == this.okCmd) {
            this.resumeInstallAfterWarning();
        } else if (c == this.settingsCmd) {
            this.getSettings();
        } else if (c == this.saveSettingsCmd) {
            this.saveSettings();
        } else if (c == this.aboutCmd) {
            Alert a = new Alert(Resource.getString("About Wireless Profile"));
            a.setString(COPYRIGHT);
            this.display.setCurrent(a, this.mlist);
        } else if (c == this.stopCmd) {
            if (this.installer != null) {
                if (this.installer.stopInstalling()) {
                    this.displayCancelledMessage(this.cancelledMessage);
                }
            } else {
                this.display.setCurrent(this.mlist);
            }
        } else if (c == this.cancelInstallCmd) {
            this.cancelBackgroundInstall();
        } else if (c == this.backCmd || c == this.cancelCmd) {
            this.display.setCurrent(this.mlist);
        }
    }

    private void launchSuite(MIDletSuiteInfo suiteInfo) {
        try {
            if (this.installer.execute(suiteInfo.storageName, suiteInfo.displayName)) {
                this.destroyApp(false);
                this.notifyDestroyed();
            } else {
                this.notifyPaused();
                this.resumeRequest();
            }
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer().append(suiteInfo.displayName).append("\n").append(Resource.getString("Error")).append(ex.toString());
            Alert a = new Alert(Resource.getString("Cannot start: "), sb.toString(), null, AlertType.ERROR);
            a.setTimeout(-2);
            this.display.setCurrent(a, this.mlist);
        }
    }

    private void displaySuiteInfo(MIDletSuiteInfo suiteInfo) {
        Form infoForm;
        try {
            Image icon;
            String name;
            infoForm = new Form(null);
            if (suiteInfo.singleMidlet) {
                name = suiteInfo.displayName;
                icon = suiteInfo.icon;
            } else {
                name = suiteInfo.midletSuite.getProperty("MIDlet-Name");
                icon = Manager.getSuiteIcon();
            }
            infoForm.setTitle(Resource.getString("Info") + ": " + name);
            infoForm.append(new ImageItem(null, icon, 771, null));
            infoForm.append(Resource.getString("Size"));
            infoForm.append(": ");
            infoForm.append(Integer.toString((suiteInfo.midletSuite.getStorageUsed() + 1023) / 1024));
            infoForm.append(" K");
            infoForm.append("\n");
            infoForm.append(Resource.getString("Version"));
            infoForm.append(": ");
            infoForm.append(suiteInfo.midletSuite.getProperty("MIDlet-Version"));
            infoForm.append("\n");
            infoForm.append(Resource.getString("Vendor"));
            infoForm.append(": ");
            infoForm.append(suiteInfo.midletSuite.getProperty("MIDlet-Vendor"));
            infoForm.append("\n");
            if (!suiteInfo.singleMidlet) {
                infoForm.append(Resource.getString("Contents"));
                infoForm.append(": ");
                infoForm.append("\n");
                this.appendMIDletsToForm(suiteInfo.midletSuite, infoForm);
            }
            infoForm.append(Resource.getString("Website"));
            infoForm.append(": ");
            infoForm.append(suiteInfo.midletSuite.getJadUrl());
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer().append(suiteInfo.displayName).append("\n").append(Resource.getString("Exception")).append(": ").append(ex.toString());
            Alert a = new Alert(Resource.getString("Cannot access: "), sb.toString(), null, AlertType.ERROR);
            a.setTimeout(-2);
            this.display.setCurrent(a, this.mlist);
            return;
        }
        infoForm.addCommand(this.backCmd);
        infoForm.setCommandListener(this);
        this.display.setCurrent(infoForm);
    }

    private void confirmRemove(MIDletSuiteInfo suiteInfo) {
        Form confirmForm;
        try {
            confirmForm = new Form(null);
            confirmForm.setTitle(Resource.getString("Confirmation"));
            confirmForm.append(Resource.getString("Are you sure you want to remove "));
            confirmForm.append("\"");
            if (suiteInfo.singleMidlet) {
                confirmForm.append(suiteInfo.displayName);
            } else {
                confirmForm.append(suiteInfo.midletSuite.getProperty("MIDlet-Name"));
            }
            confirmForm.append("\"?");
            confirmForm.append("\n");
            confirmForm.append("\n");
            String extraConfirmMsg = suiteInfo.midletSuite.getProperty("MIDlet-delete-confirm");
            if (extraConfirmMsg != null) {
                confirmForm.append(extraConfirmMsg);
                confirmForm.append("\n");
                confirmForm.append("\n");
            }
            if (!suiteInfo.singleMidlet) {
                confirmForm.append(Resource.getString("This suite contains"));
                confirmForm.append(": ");
                confirmForm.append("\n");
                this.appendMIDletsToForm(suiteInfo.midletSuite, confirmForm);
                confirmForm.append("\n");
            }
            confirmForm.append(Resource.getString("Removing will erase all data and cannot be undone."));
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer().append(suiteInfo.displayName).append("\n").append(Resource.getString("Exception")).append(": ").append(ex.toString());
            Alert a = new Alert(Resource.getString("Cannot access: "), sb.toString(), null, AlertType.ERROR);
            a.setTimeout(-2);
            this.display.setCurrent(a, this.mlist);
            return;
        }
        confirmForm.addCommand(this.cancelCmd);
        confirmForm.addCommand(this.removeOkCmd);
        confirmForm.setCommandListener(this);
        this.display.setCurrent(confirmForm);
    }

    private void removeSuite(MIDletSuiteInfo suiteInfo) {
        this.installer.remove(suiteInfo.storageName);
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    private void updateSuite(MIDletSuiteInfo suiteInfo) {
        String name = suiteInfo.singleMidlet ? suiteInfo.displayName : suiteInfo.midletSuite.getProperty("MIDlet-Name");
        this.cancelledMessage = Resource.getString("Update cancelled.");
        this.finishingMessage = Resource.getString("Finishing update.");
        this.installSuiteCommon("Updating", name, suiteInfo.midletSuite.getJadUrl(), name + Resource.getString(" was successfully updated"), true);
    }

    private void getUrl() {
        try {
            if (this.urlTextBox == null) {
                this.urlTextBox = new TextBox(Resource.getString("Enter a website to Install From:"), this.defaultInstallListUrl, 1024, 0);
                this.urlTextBox.addCommand(this.backCmd);
                this.urlTextBox.addCommand(this.selectSuiteCmd);
                this.urlTextBox.setCommandListener(this);
            }
            this.display.setCurrent(this.urlTextBox);
        }
        catch (Exception ex) {
            Alert a = new Alert(Resource.getString("Exception"), ex.toString(), null, AlertType.ERROR);
            a.setTimeout(-2);
            this.display.setCurrent(a, this.mlist);
        }
    }

    private void getSettings() {
        if (this.settingsTextBox == null) {
            this.settingsTextBox = new TextBox(Resource.getString("Set Website URL"), null, 1024, 0);
            this.settingsTextBox.addCommand(this.backCmd);
            this.settingsTextBox.addCommand(this.saveSettingsCmd);
            this.settingsTextBox.setCommandListener(this);
        }
        this.settingsTextBox.setString(this.defaultInstallListUrl);
        this.display.setCurrent(this.settingsTextBox);
    }

    private void saveSettings() {
        String temp = this.settingsTextBox.getString();
        if (temp == null) {
            this.display.setCurrent(this.mlist);
            return;
        }
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bas);
            dos.writeUTF(temp);
            byte[] data = bas.toByteArray();
            RecordStore settings = RecordStore.openRecordStore(SETTINGS_STORE, true);
            RecordEnumeration records = settings.enumerateRecords(null, null, false);
            if (records.numRecords() == 0) {
                settings.addRecord(data, 0, data.length);
            } else {
                settings.setRecord(records.nextRecordId(), data, 0, data.length);
            }
            settings.closeRecordStore();
            this.defaultInstallListUrl = temp;
            if (this.urlTextBox != null) {
                this.urlTextBox.setString(this.defaultInstallListUrl);
            }
            this.displaySuccessMessage(Resource.getString("Saved!"));
        }
        catch (Exception ex) {
            Alert a = new Alert(Resource.getString("Exception"), ex.toString(), null, AlertType.ERROR);
            a.setTimeout(-2);
            this.display.setCurrent(a, this.mlist);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restoreSettings() {
        settings = null;
        try {
            settings = RecordStore.openRecordStore("settings", false);
            records = settings.enumerateRecords(null, null, false);
            if (records.numRecords() == 0) {
                if (settings == null) return;
            }
            ** GOTO lbl36
        }
        catch (RecordStoreException e) {
            if (settings != null) {
                try {
                    settings.closeRecordStore();
                }
                catch (RecordStoreException e) {
                    // empty catch block
                }
            }
            return;
            catch (IOException e) {}
            {
                return;
            }
            finally {
                if (settings != null) {
                    try {
                        settings.closeRecordStore();
                    }
                    catch (RecordStoreException e) {}
                }
            }
        }
        try {
            settings.closeRecordStore();
            return;
        }
        catch (RecordStoreException e) {
            // empty catch block
        }
        {
            return;
lbl36:
            // 1 sources

            data = records.nextRecord();
            bas = new ByteArrayInputStream(data);
            dis = new DataInputStream(bas);
            this.defaultInstallListUrl = dis.readUTF();
            if (settings == null) return;
        }
        try {
            settings.closeRecordStore();
            return;
        }
        catch (RecordStoreException e) {
            // empty catch block
        }
    }

    private void selectSuiteToInstall(String url) {
        new Thread(new BackgroundInstallListGetter(this, url)).start();
    }

    private void installSuite(int selectedSuite) {
        SuiteDownloadInfo suite = (SuiteDownloadInfo)this.installList.elementAt(selectedSuite);
        this.cancelledMessage = Resource.getString("Installation cancelled.");
        this.finishingMessage = Resource.getString("Finishing installation.");
        this.installSuiteCommon("Installing", suite.label, suite.url, suite.label + Resource.getString(" was successfully installed"), false);
    }

    private void installSuiteCommon(String action, String name, String url, String successMessage, boolean overwriteFlag) {
        try {
            Form installForm = this.displayConnectingForm(action, name, url);
            installForm.addCommand(this.stopCmd);
            installForm.setCommandListener(this);
            this.backgroundInstaller = new BackgroundInstaller(this, url, name, successMessage, overwriteFlag);
            new Thread(this.backgroundInstaller).start();
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer().append(name).append("\n").append(Resource.getString("Error")).append(": ").append(ex.toString());
            Alert a = new Alert(Resource.getString("Cannot access: "), sb.toString(), null, AlertType.ERROR);
            a.setTimeout(-2);
            this.display.setCurrent(a, this.mlist);
            return;
        }
    }

    private void getUsernameAndPassword() {
        if (this.passwordForm == null) {
            this.passwordForm = new Form(null);
            this.usernameField = new TextField(Resource.getString("Please Enter ID"), null, 40, 0);
            this.passwordForm.append(this.usernameField);
            this.passwordField = new TextField(Resource.getString("Password"), null, 40, 65536);
            this.passwordForm.append(this.passwordField);
            this.passwordForm.addCommand(this.cancelInstallCmd);
            this.passwordForm.addCommand(this.nextCmd);
            this.passwordForm.setCommandListener(this);
        }
        this.passwordField.setString("");
        this.display.setCurrent(this.passwordForm);
    }

    private void resumeInstallWithPassword() {
        String username = this.usernameField.getString();
        String password = this.passwordField.getString();
        if (username == null || username.length() == 0) {
            Alert a = new Alert(Resource.getString("Error"), Resource.getString("The ID has not been entered."), null, AlertType.ERROR);
            a.setTimeout(1500);
            this.display.setCurrent(a, this.passwordForm);
            return;
        }
        if (password == null || password.length() == 0) {
            Alert a = new Alert(Resource.getString("Error"), Resource.getString("The password has not been entered."), null, AlertType.ERROR);
            a.setTimeout(1500);
            this.display.setCurrent(a, this.passwordForm);
            return;
        }
        this.display.setCurrent(this.conForm);
        this.backgroundInstaller.installState.setUsername(username);
        this.backgroundInstaller.installState.setPassword(password);
        this.backgroundInstaller.continueInstall = true;
        this.backgroundInstaller.installState.notify();
    }

    private void warnUser(String name, String jadUrl, InvalidJadException e) {
        Form warningForm = new Form(null);
        warningForm.setTitle(Resource.getString("Warning"));
        warningForm.append(Manager.translateJadException(e, name, jadUrl));
        warningForm.addCommand(this.cancelInstallCmd);
        warningForm.addCommand(this.okCmd);
        warningForm.setCommandListener(this);
        this.display.setCurrent(warningForm);
    }

    private void updateStatus(int status) {
        if (status != 1) {
            return;
        }
        this.displaySuccessMessage(this.finishingMessage);
    }

    private void resumeInstallAfterWarning() {
        this.display.setCurrent(this.conForm);
        this.backgroundInstaller.continueInstall = true;
        this.backgroundInstaller.installState.notify();
    }

    private void cancelBackgroundInstall() {
        if (this.backgroundInstaller != null && this.backgroundInstaller.installState != null) {
            this.backgroundInstaller.installState.notify();
        }
    }

    private Form displayConnectingForm(String action, String name, String url) {
        this.conForm = new Form(null);
        this.conForm.setTitle(Resource.getString(action) + " " + name);
        Image icon = Manager.getIconFromStorage(colorDisplay ? "_dt_8.png" : "_dt_2.png");
        this.conForm.append(new ImageItem(null, icon, 771, null));
        this.conForm.append(action);
        this.conForm.append(Resource.getString(" from"));
        this.conForm.append(": ");
        this.conForm.append(url);
        this.display.setCurrent(this.conForm);
        return this.conForm;
    }

    private void displaySuccessMessage(String successMessage) {
        Image icon = Manager.getIconFromStorage(colorDisplay ? "_dukeok8.png" : "_dukeok2.png");
        Alert successAlert = new Alert(null, successMessage, icon, null);
        successAlert.setTimeout(1500);
        while (System.currentTimeMillis() - this.lastDisplayChange < 1500L) {
        }
        this.lastDisplayChange = System.currentTimeMillis();
        this.display.setCurrent(successAlert, this.mlist);
    }

    private void displayCancelledMessage(String message) {
        Form form = new Form(null);
        Image icon = Manager.getIconFromStorage(colorDisplay ? "_ack_8.png" : "_ack_2.png");
        form.append(new ImageItem(null, icon, 771, null));
        form.append(message);
        this.display.setCurrent(form);
    }

    private void appendMIDletsToForm(MIDletSuite midletSuite, Form form) {
        int numberOfMidlets = midletSuite.getNumberOfMIDlets();
        int i = 1;
        while (i <= numberOfMidlets) {
            MIDletInfo midletInfo = new MIDletInfo(midletSuite.getProperty("MIDlet-" + i));
            form.append(midletInfo.name);
            form.append("\n");
            ++i;
        }
    }

    private void setupList() {
        if (this.mlist == null) {
            this.mlist = new List(Resource.getString("Main Screen"), 3);
            int i = 0;
            while (i < this.mcount) {
                this.mlist.append(" " + this.minfo[i].displayName, this.minfo[i].icon);
                ++i;
            }
        }
    }

    private void readMIDletSuiteInfo() {
        String[] suiteNames = this.installer.list();
        int i = 0;
        while (i < suiteNames.length) {
            try {
                MIDletSuite midletSuite = this.installer.getMIDletSuite(suiteNames[i]);
                int numberOfMidlets = midletSuite.getNumberOfMIDlets();
                if (numberOfMidlets > 1) {
                    this.addMIDletSuite(new MIDletSuiteInfo(suiteNames[i], midletSuite));
                }
                int j = 1;
                while (j <= numberOfMidlets) {
                    String nth = "MIDlet-" + j;
                    String attr = midletSuite.getProperty(nth);
                    if (attr == null || attr.length() == 0) break;
                    this.addMIDletSuite(new MIDletSuiteInfo(suiteNames[i], midletSuite, attr));
                    ++j;
                }
                if (numberOfMidlets == 1) {
                    this.minfo[this.mcount - 1].singleMidlet = true;
                    this.minfo[this.mcount - 1].icon = Manager.getSingleSuiteIcon();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
    }

    private void addMIDletSuite(MIDletSuiteInfo info) {
        if (this.mcount >= this.minfo.length) {
            MIDletSuiteInfo[] n = new MIDletSuiteInfo[this.mcount + 4];
            System.arraycopy(this.minfo, 0, n, 0, this.mcount);
            this.minfo = n;
        }
        this.minfo[this.mcount++] = info;
    }

    static /* synthetic */ Form access$1300(Manager x0, String x1, String x2, String x3) {
        return x0.displayConnectingForm(x1, x2, x3);
    }

    static /* synthetic */ Vector access$1402(Manager x0, Vector x1) {
        x0.installList = x1;
        return x0.installList;
    }

    static /* synthetic */ Vector access$1400(Manager x0) {
        return x0.installList;
    }

    static /* synthetic */ List access$1502(Manager x0, List x1) {
        x0.installListBox = x1;
        return x0.installListBox;
    }

    static /* synthetic */ List access$1500(Manager x0) {
        return x0.installListBox;
    }

    static /* synthetic */ Command access$1600(Manager x0) {
        return x0.backCmd;
    }

    static /* synthetic */ Command access$1700(Manager x0) {
        return x0.installCmd;
    }

    static {
        first = true;
        SMALL_COPYRIGHT = Resource.getString("Copyright 2000-2001 Sun Microsystems Inc. All Rights Reserved.");
        COPYRIGHT = Resource.getString("Copyright 2000-2001 Sun Microsystems Inc. All Rights Reserved.\nSun, Sun Microsystems, the Sun logo, Java, and all Sun-based and Java-based marks are trademarks or registered trademarks of Sun Microsystems, Inc. in the United States and other countries.\n\nThis product meets the Wireless Profile Compatible designation requirement, containing tested and compatible Wireless Profile software from Sun Microsystems, Inc.\n\nUse is subject to license terms and limited to demonstration only. Sun Microsystems, Inc.  has intellectual property rights relating to the technology embodied in this software.  In particular, and without limitation, these intellectual property rights may include one or more U.S. patents, foreign patents, or pending applications.\nU.S. Government approval required when exporting the product.\n\nFEDERAL ACQUISITIONS\nCommercial Software -- Government Users Subject to Standard License Terms and Conditions.");
    }

    private class BackgroundInstallListGetter
    implements Runnable {
        private Manager parent;
        private String url;

        private BackgroundInstallListGetter(Manager theParent, String theUrl) {
            this.parent = theParent;
            this.url = theUrl;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            conn = null;
            in = null;
            startTime = System.currentTimeMillis();
            try {
                conn = (StreamConnection)Connector.open((String)this.url, (int)1);
                in = new InputStreamReader(conn.openInputStream());
                try {
                    Manager.access$1300(Manager.this, "Getting Install List", "", this.url);
                    Manager.access$1402(this.parent, SuiteDownloadInfo.getDownloadInfoFromPage(in));
                    if (Manager.access$1400(this.parent).size() <= 0) ** GOTO lbl51
                    Manager.access$1502(this.parent, new List(Resource.getString("Select one to install:"), 3));
                    i = 0;
                    while (true) {
                        block19: {
                            if (i < Manager.access$1400(this.parent).size()) break block19;
                            Manager.access$1500(this.parent).addCommand(Manager.access$1600(Manager.this));
                            Manager.access$1500(this.parent).addCommand(Manager.access$1700(Manager.this));
                            Manager.access$1500(this.parent).setCommandListener(this.parent);
                            while (System.currentTimeMillis() - startTime < 1500L) {
                            }
                            Manager.access$800(Manager.this).setCurrent(Manager.access$1500(this.parent));
                            ** GOTO lbl44
                        }
                        suite = (SuiteDownloadInfo)Manager.access$1400(Manager.this).elementAt(i);
                        Manager.access$1500(this.parent).append(suite.label, null);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    errorMessage = ex.getMessage();
                    ** GOTO lbl52
                }
            }
            catch (Exception ex) {
                block20: {
                    break block20;
                    catch (Throwable var8_14) {
                        try {
                            conn.close();
                            in.close();
                            throw var8_14;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw var8_14;
                    }
lbl44:
                    // 1 sources

                    try {
                        conn.close();
                        in.close();
                        return;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    {
                        return;
lbl51:
                        // 1 sources

                        errorMessage = Resource.getString("No MIDlet Suites found. Check the URL to make sure it is correct.");
                    }
lbl52:
                    // 2 sources

                    try {
                        conn.close();
                        in.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                errorMessage = Resource.getString("The connection failed. Please check the website URL and try again.");
                try {
                    conn.close();
                    in.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            a = new Alert(Resource.getString("Error"), errorMessage, null, AlertType.ERROR);
            a.setTimeout(-2);
            Manager.access$800(Manager.this).setCurrent(a, Manager.access$700(this.parent));
        }
    }

    private class BackgroundInstaller
    implements Runnable,
    InstallListener {
        private Manager parent;
        private String jadUrl;
        private String name;
        private String successMessage;
        private boolean overwrite;
        InstallState installState;
        boolean continueInstall;

        private BackgroundInstaller(Manager theParent, String theJadUrl, String theName, String theSuccessMessage, boolean overwriteFlag) {
            this.parent = theParent;
            this.jadUrl = theJadUrl;
            this.name = theName;
            this.successMessage = theSuccessMessage;
            this.overwrite = overwriteFlag;
        }

        public void run() {
            Throwable ex;
            block5: {
                try {
                    this.parent.installer.install(this.jadUrl, this.overwrite, this);
                    this.parent.displaySuccessMessage(this.successMessage);
                    while (System.currentTimeMillis() - this.parent.lastDisplayChange < 1500L) {
                    }
                    this.parent.destroyApp(false);
                    this.parent.notifyDestroyed();
                    return;
                }
                finally {
                    if (!this.parent.installer.wasStopped()) break block5;
                }
                while (System.currentTimeMillis() - this.parent.lastDisplayChange < 1500L) {
                }
                this.parent.display.setCurrent(this.parent.mlist);
                return;
            }
            String msg = ex instanceof InvalidJadException ? Manager.translateJadException((InvalidJadException)ex, this.name, this.jadUrl) : (ex instanceof IOException ? Resource.getString("The connection dropped and the installation did not complete. Please try installing again.") : ex.getMessage());
            Alert a = new Alert(Resource.getString("Install Error"), msg, null, AlertType.ERROR);
            a.setTimeout(-2);
            this.parent.display.setCurrent(a, this.parent.mlist);
        }

        public boolean warnUser(InstallState state) {
            this.installState = state;
            InvalidJadException e = this.installState.getLastException();
            if (e.getReason() == 33) {
                this.parent.getUsernameAndPassword();
            } else {
                this.parent.warnUser(this.name, this.jadUrl, e);
            }
            InstallState installState = this.installState;
            synchronized (installState) {
                try {
                    this.installState.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            this.installState = null;
            boolean temp = this.continueInstall;
            this.continueInstall = false;
            return temp;
        }

        public void updateStatus(int status) {
            this.parent.updateStatus(status);
        }
    }

    private class MIDletSuiteInfo {
        MIDletSuite midletSuite;
        String storageName;
        String displayName;
        String midletToRun;
        Image icon;
        String iconName;
        boolean singleMidlet = false;

        MIDletSuiteInfo(String theStorageName, MIDletSuite theMidletSuite) {
            this.midletSuite = theMidletSuite;
            this.displayName = this.midletSuite.getProperty("MIDlet-Name");
            if (this.displayName == null) {
                this.displayName = theStorageName;
            }
            this.icon = Manager.getSuiteIcon();
            this.storageName = theStorageName;
        }

        MIDletSuiteInfo(String theStorageName, MIDletSuite theMidletSuite, String attr) {
            MIDletInfo midletInfo = new MIDletInfo(attr);
            this.midletSuite = theMidletSuite;
            this.displayName = midletInfo.name;
            this.icon = Manager.getEmptyIcon();
            this.iconName = midletInfo.icon;
            this.storageName = theStorageName;
        }
    }
}

