// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __boxannulus_h__
#define __boxannulus_h__

#include "basebox.h"

class BoxAnnulus : public BaseBox {
public:
  BoxAnnulus(const BoxAnnulus&);
  BoxAnnulus(FrameBase* p, const Vector& ctr,
	     const Vector& s, 
	     double ang,
	     const char* clr, int wth, 
	     const char* fnt, const char* txt, 
	     unsigned short prop, const char* cmt,
	     const List<Tag>& tg, const List<CallBack>& cb);
  BoxAnnulus(FrameBase* p, const Vector& ctr,
	     const Vector& inner, const Vector& outer, int num,
	     double ang,
	     const char* clr, int wth, 
	     const char* fnt, const char* txt, 
	     unsigned short prop, const char* cmt,
	     const List<Tag>& tg, const List<CallBack>& cb);
  BoxAnnulus(FrameBase* p, const Vector& ctr, 
	     int an, Vector* s,
	     double ang, 
	     const char* clr, int wth, 
	     const char* fnt, const char* txt,
	     unsigned short prop, const char* cmt,
	     const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new BoxAnnulus(*this);}
  void editBegin(int);
  void edit(const Vector&, int);
  void editEnd();

  int addAnnuli(const Vector&);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, int);
  void listSAOimage(ostream&, int);
};

#endif
