// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __annulus_h__
#define __annulus_h__

#include "baseellipse.h"

class Annulus : public BaseEllipse {
 public:
  Annulus(const Annulus&);
  Annulus(FrameBase* p, const Vector& ctr, 
	  double inner, double outer, int num,
	  const char* clr, int wth, const char* fnt, const char* txt, 
	  unsigned short prop, const char* cmt, 
	  const List<Tag>& tg, const List<CallBack>& cb);
  Annulus(FrameBase* p, const Vector& ctr, 
	  int rn, double* r,
	  const char* clr, int wth, const char* fnt, const char* txt, 
	  unsigned short prop, const char* cmt, 
	  const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new Annulus(*this);}
  void edit(const Vector&, int);
  void editEnd();

  int addAnnuli(const Vector&);

  void rotateBegin() {}
  void rotate(const Vector& v, int h) {}
  void rotateEnd() {}

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  void listCiao(ostream&, CoordSystem, int, int);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, int);
  void listSAOimage(ostream&, int);

  // special composite funtionality
  void setComposite(const Matrix&, double);
};

#endif
