#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CompositeDialog {frame id} {
    global marker

    # see if we already have a header window visible

    set w ".marker$id"
    set mb ".mb$id"

    if [winfo exist $w] {
	raise $w
	return
    }

    # base
    MarkerBaseCenterDialog $frame $id 275 150

    # init
    MarkerBaseCenterRotateCB $frame $id

   # callbacks
    $frame marker $id callback rotate MarkerBaseCenterRotateCB $frame

    # Angle
    label $w.ref.f.angleTitle -text "Angle"
    entry $w.ref.f.angle -textvariable marker($frame,$id,angle) -width 13 
    label $w.ref.f.angleUnit -relief groove -width 9 -padx 4 \
	-text "degrees"

    grid $w.ref.f.angleTitle $w.ref.f.angle x $w.ref.f.angleUnit \
	-padx 4 -sticky w
}

# actions

proc CompositeClose {frame id} {
    global marker
    set which $marker($frame,$id,which)

    $frame marker $id delete callback rotate MarkerBaseCenterRotateCB
    MarkerBaseCenterClose $frame $id
}

proc CompositeApply {frame id} {
    MarkerBaseCenterRotate $frame $id
    MarkerBaseCenterApply $frame $id
}

# callbacks

proc CompositeCoordCB {frame id} {
    MarkerBaseCoordCB $frame $id
    MarkerBaseCenterMoveCB $frame $id
    MarkerBaseCenterRotateCB $frame $id
}
