#!/bin/bash

if [ -z "$GIT_URL" ]; then
	GIT_URL=git://git.samba.org/jelmer/samba-gtk.git
fi

version=$( dpkg-parsechangelog -l`dirname $0`/changelog | sed -n 's/^Version: \(.*:\|\)//p' | sed 's/-[0-9.]\+$//' )
if [ -d "$GIT_URL/.bzr" ]; then
	bzr export "samba-gtk-$version" "$GIT_URL"
else
	git clone --depth 1 -l "$GIT_URL" "samba-gtk-$version"
	rm -rf "samba-gtk-$version/.git"
fi

pushd "samba-gtk-$version"
echo "Running autogen"
./autogen.sh
rm -rf autom4te.cache
popd
tar cfz "samba-gtk_$version.orig.tar.gz" "samba-gtk-$version"
rm -rf "samba-gtk-$version"
