/* rygel-transcode-manager.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-transcode-manager.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_ENDIANNESS (endianness_get_type ())

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;

#define RYGEL_TYPE_MP3_LAYER (rygel_mp3_layer_get_type ())

#define RYGEL_TYPE_MP3_TRANSCODER (rygel_mp3_transcoder_get_type ())
#define RYGEL_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3Transcoder))
#define RYGEL_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))
#define RYGEL_IS_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_IS_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_MP3_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))

typedef struct _RygelMP3Transcoder RygelMP3Transcoder;
typedef struct _RygelMP3TranscoderClass RygelMP3TranscoderClass;

#define RYGEL_TYPE_MP2_TS_PROFILE (rygel_mp2_ts_profile_get_type ())

#define RYGEL_TYPE_MP2_TS_TRANSCODER (rygel_mp2_ts_transcoder_get_type ())
#define RYGEL_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder))
#define RYGEL_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))
#define RYGEL_IS_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_IS_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_MP2_TS_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))

typedef struct _RygelMP2TSTranscoder RygelMP2TSTranscoder;
typedef struct _RygelMP2TSTranscoderClass RygelMP2TSTranscoderClass;

#define RYGEL_TYPE_WMV_TRANSCODER (rygel_wmv_transcoder_get_type ())
#define RYGEL_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoder))
#define RYGEL_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))
#define RYGEL_IS_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_IS_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_WMV_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))

typedef struct _RygelWMVTranscoder RygelWMVTranscoder;
typedef struct _RygelWMVTranscoderClass RygelWMVTranscoderClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelTranscodeManagerPrivate {
	GeeArrayList* transcoders;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

typedef enum  {
	ENDIANNESS_LITTLE = G_LITTLE_ENDIAN,
	ENDIANNESS_BIG = G_BIG_ENDIAN
} Endianness;

typedef enum  {
	RYGEL_MP3_LAYER_TWO = 1,
	RYGEL_MP3_LAYER_THREE = 2
} RygelMP3Layer;

typedef enum  {
	RYGEL_MP2_TS_PROFILE_SD = 0,
	RYGEL_MP2_TS_PROFILE_HD
} RygelMP2TSProfile;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()

static gpointer rygel_transcode_manager_parent_class = NULL;

GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_TRANSCODE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerPrivate))
enum  {
	RYGEL_TRANSCODE_MANAGER_DUMMY_PROPERTY
};
static gboolean rygel_transcode_manager_protocol_equal_func (void* a, void* b);
RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gboolean rygel_configuration_get_transcoding (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_lpcm_transcoder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_mp3_transcoder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_mp2ts_transcoder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_wmv_transcoder (RygelConfiguration* self, GError** error);
GType endianness_get_type (void) G_GNUC_CONST;
RygelL16Transcoder* rygel_l16_transcoder_new (Endianness endianness);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type, Endianness endianness);
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp3_layer_get_type (void) G_GNUC_CONST;
RygelMP3Transcoder* rygel_mp3_transcoder_new (RygelMP3Layer layer);
RygelMP3Transcoder* rygel_mp3_transcoder_construct (GType object_type, RygelMP3Layer layer);
GType rygel_mp3_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp2_ts_profile_get_type (void) G_GNUC_CONST;
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile);
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile);
GType rygel_mp2_ts_transcoder_get_type (void) G_GNUC_CONST;
RygelWMVTranscoder* rygel_wmv_transcoder_new (void);
RygelWMVTranscoder* rygel_wmv_transcoder_construct (GType object_type);
GType rygel_wmv_transcoder_get_type (void) G_GNUC_CONST;
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
static gchar* rygel_transcode_manager_real_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2);
static gint _rygel_media_item_compare_transcoders_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error);
gboolean rygel_transcoder_can_handle (RygelTranscoder* self, const gchar* target);
GQuark rygel_http_request_error_quark (void);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
static gchar* rygel_transcode_manager_real_get_protocol (RygelTranscodeManager* self);
GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self);
static GeeArrayList* rygel_transcode_manager_real_get_protocol_info (RygelTranscodeManager* self);
static gboolean _rygel_transcode_manager_protocol_equal_func_gequal_func (gconstpointer a, gconstpointer b);
const gchar* rygel_transcoder_get_mime_type (RygelTranscoder* self);
const gchar* rygel_transcoder_get_dlna_profile (RygelTranscoder* self);
static void rygel_transcode_manager_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	return self ? g_object_ref (self) : NULL;
#line 271 "rygel-transcode-manager.c"
}


static gboolean rygel_transcode_manager_protocol_equal_func (void* a, void* b) {
	gboolean result = FALSE;
	void* _tmp0_;
	GUPnPProtocolInfo* _tmp1_;
	GUPnPProtocolInfo* protocol_a;
	void* _tmp2_;
	GUPnPProtocolInfo* _tmp3_;
	GUPnPProtocolInfo* protocol_b;
	gboolean _tmp4_ = FALSE;
	GUPnPProtocolInfo* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GUPnPProtocolInfo* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp17_;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp0_ = a;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp1_ = _g_object_ref0 (GUPNP_IS_PROTOCOL_INFO (_tmp0_) ? ((GUPnPProtocolInfo*) _tmp0_) : NULL);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	protocol_a = _tmp1_;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp2_ = b;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp3_ = _g_object_ref0 (GUPNP_IS_PROTOCOL_INFO (_tmp2_) ? ((GUPnPProtocolInfo*) _tmp2_) : NULL);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	protocol_b = _tmp3_;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp5_ = protocol_a;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp6_ = gupnp_protocol_info_get_dlna_profile (_tmp5_);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp7_ = _tmp6_;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp8_ = protocol_b;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp9_ = gupnp_protocol_info_get_dlna_profile (_tmp8_);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp10_ = _tmp9_;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	if (g_strcmp0 (_tmp7_, _tmp10_) == 0) {
#line 317 "rygel-transcode-manager.c"
		GUPnPProtocolInfo* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		GUPnPProtocolInfo* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp11_ = protocol_a;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp12_ = gupnp_protocol_info_get_mime_type (_tmp11_);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp13_ = _tmp12_;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp14_ = protocol_b;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp15_ = gupnp_protocol_info_get_mime_type (_tmp14_);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp16_ = _tmp15_;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp4_ = g_strcmp0 (_tmp13_, _tmp16_) == 0;
#line 338 "rygel-transcode-manager.c"
	} else {
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp4_ = FALSE;
#line 342 "rygel-transcode-manager.c"
	}
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp17_ = _tmp4_;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	result = _tmp17_;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_g_object_unref0 (protocol_b);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_g_object_unref0 (protocol_a);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	return result;
#line 354 "rygel-transcode-manager.c"
}


RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type) {
	RygelTranscodeManager * self = NULL;
	GeeArrayList* _tmp0_;
	RygelMetaConfig* _tmp1_ = NULL;
	RygelMetaConfig* config;
	gboolean transcoding;
	gboolean lpcm_transcoder;
	gboolean mp3_transcoder;
	gboolean mp2ts_transcoder;
	gboolean wmv_transcoder;
	gboolean _tmp18_;
	GError * _inner_error_ = NULL;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	self = (RygelTranscodeManager*) g_object_new (object_type, NULL);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_TRANSCODER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_g_object_unref0 (self->priv->transcoders);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	self->priv->transcoders = _tmp0_;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp1_ = rygel_meta_config_get_default ();
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	config = _tmp1_;
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	transcoding = TRUE;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	lpcm_transcoder = TRUE;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	mp3_transcoder = TRUE;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	mp2ts_transcoder = TRUE;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	wmv_transcoder = TRUE;
#line 392 "rygel-transcode-manager.c"
	{
		RygelMetaConfig* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		gboolean _tmp5_;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp2_ = config;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp3_ = rygel_configuration_get_transcoding ((RygelConfiguration*) _tmp2_, &_inner_error_);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp4_ = _tmp3_;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		if (_inner_error_ != NULL) {
#line 406 "rygel-transcode-manager.c"
			goto __catch32_g_error;
		}
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		transcoding = _tmp4_;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp5_ = transcoding;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		if (_tmp5_) {
#line 415 "rygel-transcode-manager.c"
			RygelMetaConfig* _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_;
			RygelMetaConfig* _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			RygelMetaConfig* _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			RygelMetaConfig* _tmp15_;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp6_ = config;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp7_ = rygel_configuration_get_lpcm_transcoder ((RygelConfiguration*) _tmp6_, &_inner_error_);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp8_ = _tmp7_;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			if (_inner_error_ != NULL) {
#line 436 "rygel-transcode-manager.c"
				goto __catch32_g_error;
			}
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			lpcm_transcoder = _tmp8_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp9_ = config;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp10_ = rygel_configuration_get_mp3_transcoder ((RygelConfiguration*) _tmp9_, &_inner_error_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp11_ = _tmp10_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			if (_inner_error_ != NULL) {
#line 449 "rygel-transcode-manager.c"
				goto __catch32_g_error;
			}
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			mp3_transcoder = _tmp11_;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp12_ = config;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp13_ = rygel_configuration_get_mp2ts_transcoder ((RygelConfiguration*) _tmp12_, &_inner_error_);
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp14_ = _tmp13_;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			if (_inner_error_ != NULL) {
#line 462 "rygel-transcode-manager.c"
				goto __catch32_g_error;
			}
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			mp2ts_transcoder = _tmp14_;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp15_ = config;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp16_ = rygel_configuration_get_wmv_transcoder ((RygelConfiguration*) _tmp15_, &_inner_error_);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp17_ = _tmp16_;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			if (_inner_error_ != NULL) {
#line 475 "rygel-transcode-manager.c"
				goto __catch32_g_error;
			}
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			wmv_transcoder = _tmp17_;
#line 480 "rygel-transcode-manager.c"
		}
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError* err = NULL;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		err = _inner_error_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_inner_error_ = NULL;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_g_error_free0 (err);
#line 493 "rygel-transcode-manager.c"
	}
	__finally32:
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	if (_inner_error_ != NULL) {
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_g_object_unref0 (config);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		g_clear_error (&_inner_error_);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		return NULL;
#line 506 "rygel-transcode-manager.c"
	}
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp18_ = transcoding;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	if (_tmp18_) {
#line 512 "rygel-transcode-manager.c"
		gboolean _tmp19_;
		gboolean _tmp23_;
		gboolean _tmp27_;
		gboolean _tmp34_;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp19_ = lpcm_transcoder;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		if (_tmp19_) {
#line 521 "rygel-transcode-manager.c"
			GeeArrayList* _tmp20_;
			RygelL16Transcoder* _tmp21_;
			RygelL16Transcoder* _tmp22_;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp20_ = self->priv->transcoders;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp21_ = rygel_l16_transcoder_new (ENDIANNESS_BIG);
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp22_ = _tmp21_;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, (RygelTranscoder*) _tmp22_);
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_g_object_unref0 (_tmp22_);
#line 535 "rygel-transcode-manager.c"
		}
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp23_ = mp3_transcoder;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		if (_tmp23_) {
#line 541 "rygel-transcode-manager.c"
			GeeArrayList* _tmp24_;
			RygelMP3Transcoder* _tmp25_;
			RygelMP3Transcoder* _tmp26_;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp24_ = self->priv->transcoders;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp25_ = rygel_mp3_transcoder_new (RYGEL_MP3_LAYER_THREE);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp26_ = _tmp25_;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, (RygelTranscoder*) _tmp26_);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_g_object_unref0 (_tmp26_);
#line 555 "rygel-transcode-manager.c"
		}
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp27_ = mp2ts_transcoder;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		if (_tmp27_) {
#line 561 "rygel-transcode-manager.c"
			GeeArrayList* _tmp28_;
			RygelMP2TSTranscoder* _tmp29_;
			RygelMP2TSTranscoder* _tmp30_;
			GeeArrayList* _tmp31_;
			RygelMP2TSTranscoder* _tmp32_;
			RygelMP2TSTranscoder* _tmp33_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp28_ = self->priv->transcoders;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp29_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_SD);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp30_ = _tmp29_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, (RygelTranscoder*) _tmp30_);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_g_object_unref0 (_tmp30_);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp31_ = self->priv->transcoders;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp32_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_HD);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp33_ = _tmp32_;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, (RygelTranscoder*) _tmp33_);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_g_object_unref0 (_tmp33_);
#line 588 "rygel-transcode-manager.c"
		}
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp34_ = wmv_transcoder;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		if (_tmp34_) {
#line 594 "rygel-transcode-manager.c"
			GeeArrayList* _tmp35_;
			RygelWMVTranscoder* _tmp36_;
			RygelWMVTranscoder* _tmp37_;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp35_ = self->priv->transcoders;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp36_ = rygel_wmv_transcoder_new ();
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp37_ = _tmp36_;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, (RygelTranscoder*) _tmp37_);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_g_object_unref0 (_tmp37_);
#line 608 "rygel-transcode-manager.c"
		}
	}
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_g_object_unref0 (config);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	return self;
#line 615 "rygel-transcode-manager.c"
}


static gchar* rygel_transcode_manager_real_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_transcode_manager_create_uri_for_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	return NULL;
#line 624 "rygel-transcode-manager.c"
}


gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->create_uri_for_item (self, item, thumbnail_index, subtitle_index, transcode_target);
#line 633 "rygel-transcode-manager.c"
}


static gint _rygel_media_item_compare_transcoders_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = rygel_media_item_compare_transcoders (self, a, b);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	return result;
#line 642 "rygel-transcode-manager.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 649 "rygel-transcode-manager.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_list_free (self);
#line 658 "rygel-transcode-manager.c"
}


void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error) {
	GList* list;
	RygelMediaItem* _tmp17_;
	GList* _tmp18_;
	GError * _inner_error_ = NULL;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_return_if_fail (didl_item != NULL);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_return_if_fail (item != NULL);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	list = NULL;
#line 675 "rygel-transcode-manager.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _transcoder_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _transcoder_size;
		gint _transcoder_index;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp0_ = self->priv->transcoders;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_transcoder_list = _tmp1_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp2_ = _transcoder_list;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp4_ = _tmp3_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_transcoder_size = _tmp4_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_transcoder_index = -1;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		while (TRUE) {
#line 703 "rygel-transcode-manager.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			RygelTranscoder* transcoder;
			RygelTranscoder* _tmp11_;
			RygelMediaItem* _tmp12_;
			guint _tmp13_ = 0U;
			guint _tmp14_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp5_ = _transcoder_index;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_transcoder_index = _tmp5_ + 1;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp6_ = _transcoder_index;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp7_ = _transcoder_size;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				break;
#line 727 "rygel-transcode-manager.c"
			}
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp8_ = _transcoder_list;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp9_ = _transcoder_index;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			transcoder = (RygelTranscoder*) _tmp10_;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp11_ = transcoder;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp12_ = item;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp13_ = rygel_transcoder_get_distance (_tmp11_, _tmp12_);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp14_ = G_MAXUINT;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			if (_tmp13_ != _tmp14_) {
#line 747 "rygel-transcode-manager.c"
				RygelTranscoder* _tmp15_;
				RygelTranscoder* _tmp16_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				_tmp15_ = transcoder;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				_tmp16_ = _g_object_ref0 (_tmp15_);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				list = g_list_append (list, _tmp16_);
#line 756 "rygel-transcode-manager.c"
			}
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_g_object_unref0 (transcoder);
#line 760 "rygel-transcode-manager.c"
		}
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_g_object_unref0 (_transcoder_list);
#line 764 "rygel-transcode-manager.c"
	}
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp17_ = item;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	list = g_list_sort_with_data (list, _rygel_media_item_compare_transcoders_gcompare_data_func, _tmp17_);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp18_ = list;
#line 772 "rygel-transcode-manager.c"
	{
		GList* transcoder_collection = NULL;
		GList* transcoder_it = NULL;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		transcoder_collection = _tmp18_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		for (transcoder_it = transcoder_collection; transcoder_it != NULL; transcoder_it = transcoder_it->next) {
#line 780 "rygel-transcode-manager.c"
			RygelTranscoder* _tmp19_;
			RygelTranscoder* transcoder = NULL;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp19_ = _g_object_ref0 ((RygelTranscoder*) transcoder_it->data);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			transcoder = _tmp19_;
#line 787 "rygel-transcode-manager.c"
			{
				RygelTranscoder* _tmp20_;
				GUPnPDIDLLiteItem* _tmp21_;
				RygelMediaItem* _tmp22_;
				GUPnPDIDLLiteResource* _tmp23_ = NULL;
				GUPnPDIDLLiteResource* _tmp24_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				_tmp20_ = transcoder;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				_tmp21_ = didl_item;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				_tmp22_ = item;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				_tmp23_ = rygel_transcoder_add_resource (_tmp20_, _tmp21_, _tmp22_, self, &_inner_error_);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				_tmp24_ = _tmp23_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				_g_object_unref0 (_tmp24_);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				if (_inner_error_ != NULL) {
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
					g_propagate_error (error, _inner_error_);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
					_g_object_unref0 (transcoder);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
					__g_list_free__g_object_unref0_0 (list);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
					return;
#line 816 "rygel-transcode-manager.c"
				}
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				_g_object_unref0 (transcoder);
#line 820 "rygel-transcode-manager.c"
			}
		}
	}
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	__g_list_free__g_object_unref0_0 (list);
#line 826 "rygel-transcode-manager.c"
}


RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	RygelTranscoder* transcoder;
	RygelTranscoder* _tmp16_;
	GError * _inner_error_ = NULL;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	transcoder = NULL;
#line 841 "rygel-transcode-manager.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _iter_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _iter_size;
		gint _iter_index;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp0_ = self->priv->transcoders;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_iter_list = _tmp1_;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp2_ = _iter_list;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp4_ = _tmp3_;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_iter_size = _tmp4_;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_iter_index = -1;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		while (TRUE) {
#line 869 "rygel-transcode-manager.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			RygelTranscoder* iter;
			RygelTranscoder* _tmp11_;
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp5_ = _iter_index;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_iter_index = _tmp5_ + 1;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp6_ = _iter_index;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp7_ = _iter_size;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				break;
#line 892 "rygel-transcode-manager.c"
			}
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp8_ = _iter_list;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp9_ = _iter_index;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			iter = (RygelTranscoder*) _tmp10_;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp11_ = iter;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp12_ = target;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp13_ = rygel_transcoder_can_handle (_tmp11_, _tmp12_);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			if (_tmp13_) {
#line 910 "rygel-transcode-manager.c"
				RygelTranscoder* _tmp14_;
				RygelTranscoder* _tmp15_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				_tmp14_ = iter;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				_tmp15_ = _g_object_ref0 (_tmp14_);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				_g_object_unref0 (transcoder);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				transcoder = _tmp15_;
#line 921 "rygel-transcode-manager.c"
			}
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_g_object_unref0 (iter);
#line 925 "rygel-transcode-manager.c"
		}
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_g_object_unref0 (_iter_list);
#line 929 "rygel-transcode-manager.c"
	}
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp16_ = transcoder;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	if (_tmp16_ == NULL) {
#line 935 "rygel-transcode-manager.c"
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_;
		GError* _tmp19_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp17_ = _ ("No transcoder available for target format '%s'");
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp18_ = target;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp19_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp17_, _tmp18_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_inner_error_ = _tmp19_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		g_propagate_error (error, _inner_error_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_g_object_unref0 (transcoder);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		return NULL;
#line 953 "rygel-transcode-manager.c"
	}
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	result = transcoder;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	return result;
#line 959 "rygel-transcode-manager.c"
}


static gchar* rygel_transcode_manager_real_get_protocol (RygelTranscodeManager* self) {
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_transcode_manager_get_protocol'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	return NULL;
#line 968 "rygel-transcode-manager.c"
}


gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self) {
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->get_protocol (self);
#line 977 "rygel-transcode-manager.c"
}


static gboolean _rygel_transcode_manager_protocol_equal_func_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = rygel_transcode_manager_protocol_equal_func (a, b);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	return result;
#line 986 "rygel-transcode-manager.c"
}


static GeeArrayList* rygel_transcode_manager_real_get_protocol_info (RygelTranscodeManager* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* protocol_infos;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_tmp0_ = gee_array_list_new (GUPNP_TYPE_PROTOCOL_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, _rygel_transcode_manager_protocol_equal_func_gequal_func);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	protocol_infos = _tmp0_;
#line 998 "rygel-transcode-manager.c"
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _transcoder_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _transcoder_size;
		gint _transcoder_index;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp1_ = self->priv->transcoders;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_transcoder_list = _tmp2_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp3_ = _transcoder_list;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_tmp5_ = _tmp4_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_transcoder_size = _tmp5_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_transcoder_index = -1;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		while (TRUE) {
#line 1026 "rygel-transcode-manager.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			RygelTranscoder* transcoder;
			GUPnPProtocolInfo* _tmp12_;
			GUPnPProtocolInfo* protocol_info;
			GUPnPProtocolInfo* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			GUPnPProtocolInfo* _tmp16_;
			RygelTranscoder* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			GUPnPProtocolInfo* _tmp20_;
			RygelTranscoder* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			GeeArrayList* _tmp24_;
			GUPnPProtocolInfo* _tmp25_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp6_ = _transcoder_index;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_transcoder_index = _tmp6_ + 1;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp7_ = _transcoder_index;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp8_ = _transcoder_size;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
				break;
#line 1061 "rygel-transcode-manager.c"
			}
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp9_ = _transcoder_list;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp10_ = _transcoder_index;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			transcoder = (RygelTranscoder*) _tmp11_;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp12_ = gupnp_protocol_info_new ();
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			protocol_info = _tmp12_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp13_ = protocol_info;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp14_ = rygel_transcode_manager_get_protocol (self);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp15_ = _tmp14_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			gupnp_protocol_info_set_protocol (_tmp13_, _tmp15_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_g_free0 (_tmp15_);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp16_ = protocol_info;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp17_ = transcoder;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp18_ = rygel_transcoder_get_mime_type (_tmp17_);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp19_ = _tmp18_;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			gupnp_protocol_info_set_mime_type (_tmp16_, _tmp19_);
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp20_ = protocol_info;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp21_ = transcoder;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp22_ = rygel_transcoder_get_dlna_profile (_tmp21_);
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp23_ = _tmp22_;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			gupnp_protocol_info_set_dlna_profile (_tmp20_, _tmp23_);
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp24_ = protocol_infos;
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_tmp25_ = protocol_info;
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_g_object_unref0 (protocol_info);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
			_g_object_unref0 (transcoder);
#line 1115 "rygel-transcode-manager.c"
		}
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
		_g_object_unref0 (_transcoder_list);
#line 1119 "rygel-transcode-manager.c"
	}
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	result = protocol_infos;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	return result;
#line 1125 "rygel-transcode-manager.c"
}


GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self) {
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->get_protocol_info (self);
#line 1134 "rygel-transcode-manager.c"
}


static void rygel_transcode_manager_class_init (RygelTranscodeManagerClass * klass) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	rygel_transcode_manager_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	g_type_class_add_private (klass, sizeof (RygelTranscodeManagerPrivate));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->create_uri_for_item = rygel_transcode_manager_real_create_uri_for_item;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol = rygel_transcode_manager_real_get_protocol;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol_info = rygel_transcode_manager_real_get_protocol_info;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_transcode_manager_finalize;
#line 1151 "rygel-transcode-manager.c"
}


static void rygel_transcode_manager_instance_init (RygelTranscodeManager * self) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	self->priv = RYGEL_TRANSCODE_MANAGER_GET_PRIVATE (self);
#line 1158 "rygel-transcode-manager.c"
}


static void rygel_transcode_manager_finalize (GObject* obj) {
	RygelTranscodeManager * self;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	self = RYGEL_TRANSCODE_MANAGER (obj);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	_g_object_unref0 (self->priv->transcoders);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-transcode-manager.vala"
	G_OBJECT_CLASS (rygel_transcode_manager_parent_class)->finalize (obj);
#line 1170 "rygel-transcode-manager.c"
}


/**
 * Responsible for management of all transcoders:
 *    - gets the appropriate transcoder given a transcoding target.
 *    - provide all possible transcoding resources for items.
 */
GType rygel_transcode_manager_get_type (void) {
	static volatile gsize rygel_transcode_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcode_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscodeManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcode_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscodeManager), 0, (GInstanceInitFunc) rygel_transcode_manager_instance_init, NULL };
		GType rygel_transcode_manager_type_id;
		rygel_transcode_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscodeManager", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_transcode_manager_type_id__volatile, rygel_transcode_manager_type_id);
	}
	return rygel_transcode_manager_type_id__volatile;
}



