module GLib
  load_class :PtrArray

  # Overrides for GPtrArray, GLib's automatically growing array of
  # pointers.
  class PtrArray
    include Enumerable

    attr_accessor :element_type

    class << self
      undef :new
      def new type
        wrap(Lib.g_ptr_array_new).tap {|it|
          it.element_type = type}
      end

      # Remove stub generated by builder.
      undef :add if method_defined? :add

      def add array, data
        array.add data
      end
    end

    def add data
      ptr = GirFFI::InPointer.from element_type, data
      Lib.g_ptr_array_add self, ptr
    end

    def each
      prc = Proc.new {|valptr, userdata|
        val = GirFFI::ArgHelper.cast_from_pointer element_type, valptr
        yield val
      }
      Lib.g_ptr_array_foreach self.to_ptr, prc, nil
    end
  end
end
