%define initdir /etc/rc.d/init.d

Summary: Round-Robin Database Collecting Daemon
Name: rrdcollect
Version: 0.2.2
Release: 1
Group: System Environment/Daemons
Copyright: GPL
Source: http://prdownloads.sourceforge.net/prdownloads/%{name}/%{name}-%{version}.tar.gz
Requires: rrdtool
URL: http://rrdcollect.sourceforge.net/
Prereq: /sbin/chkconfig, initscripts >= 5.54
#BuildRequires: rrdtool
BuildRequires: pcre-devel
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description
RRDcollect is a daemon which polls ceratin files in /proc/
directory, gathering data and storing it inside RRDtool's
database files.  Being written in C should be both fast
and resources-friendly.  Supports both scanf(3)-style
pattern matches and perl compatible regular expressions.

%prep
%setup

%build
%configure
make

%install
%makeinstall

mkdir -p $RPM_BUILD_ROOT/%{initdir}
install -m 0755 doc/sample-rrdcollect.init $RPM_BUILD_ROOT/%{initdir}/rrdcollect

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add rrdcollect

%preun
if [ $1 = 0 ]; then
    /sbin/service rrdcollect stop > /dev/null 2>&1
    /sbin/chkconfig --del rrdcollect
fi

%postun
if [ "$1" -ge "1" ]; then
    /sbin/service rrdcollect condrestart > /dev/null 2>&1
fi

%files
%defattr(-,root,root)
%doc AUTHORS NEWS README
%attr(0644,root,root) %config(noreplace) /etc/rrdcollect.conf
%attr(0755,root,root) %{initdir}/rrdcollect
%{_mandir}/man5/rrdcollect.*
%{_mandir}/man8/rrdcollect.*
%{_sbindir}/rrdcollect

%changelog
* Sun Sep  2 2002 Dawid Kuroczko <qnex@knm.org.pl> 0.2
- Initial .spec file for rrdcollect-0.2
